
      subroutine barfit(iz,ia,il,bfis,segs,selmax)
c
c    This subroutine returns the barrier height bfis, the ground-state
c    energy segs, in MeV, and the angular momentum at which the fission
c    barrier disappears,  Lmax,  in units of h-bar,
c    when called with integer arguments iz, the atomic number,
c    ia, the atomic mass number, and il, the angular momentum in units
c    of h-bar, (Planck's constant divided by 2*pi).
c
c         The fission barrier for  il = 0  is calculated from a 7th order
c    fit in two variables to 638 calculated fission barriers for z values
c    from 20 to 110.  These  638 barriers are fit with an rms deviation of
c    0.10 MeV by this 49-parameter function.
c    If  barfit  is called with (iz,ia) values outside the range of the fit
c    the barrier height is set to 0.0, and a message is
c    printed on the default output file.
c
c         For il values not equal to zero, the values of
c    L at which the barrier is  80%  and  20%  of the L=0 value are
c    respectively fit to 20-parameter functions of  Z  and  A, over a more
c    restricted range of  A  values, than is the case for  L = 0.
c    The value of L where the barrier disappears, Lmax, for 61 nuclei,
c    is fit to a 35-parameter function of Z and A,  with the same range of
c    Z  and  A  values as  l-80  and  l-20.
c         Once again, if an  (iz,ia) pair is outside of the range of
c    validity of the fit, the barrier value is set to  0.0  and a message
c    is printed.  These three values  (Bfis(L=0),L-80, and L-20) and the
c    constraints  of  Bfis = 0 and  d(Bfis)/dL = 0 at L = Lmax and L = 0
c    lead to a fifth-order fit to Bfis(L) for L> L-20.  The first three
c    constraints lead to a third-order fit for the region L < L-20.
c
c         The ground-state energies are calculated from a 175-parameter
c    fit in Z, A, and L to 329 ground-state energies for 36 different
c    Z  and  A  values.
c    (The range of Z and A is the same as for L-80, L-20, and L-max)
c
c         The calculated barriers from which the fits were
c    made were calculated in 1983-1985 by A. J. Sierk of Los Alamos
c    National Laboratory   Group T-9, using  Yukawa-plus-exponential double
c    folded nuclear energy, exact Couloub diffuseness corrections,
c    and diffuse-matter moments of inertia. The parameters of the model
c    are those derived by Moller and Nix in 1979:
c    r-0 = 1.16 fm, as = 21.13 MeV, kappa-s = 2.3  a = 0.68 fm.
c    The diffuseness of the matter and charge distributions used
c    corresponds to a surface diffuseness parameter (defined by Myers)
c    of 0.99 fm.  The calculated barriers for L = 0 are
c    accurate to a little less than 0.1 MeV;  the output from this
c    subroutine is a little less accurate.  Worst errors may be as large
c    as 0.5 MeV; characteristic uncertainty is in the range of 0.1-0.2
c    MeV.   The values of egs are generally approximated to within
c    about 0.1-0.2 MeV;  the largest deviation is about 0.5 MeV,
c    near L-I for light nuclei.
c         The rms deviation of Lmax from the 61 input values is 0.31
c    h-bar.  The approximate value is nearly always within
c    0.5 h-bar of the calculated one.
c
c    Below is a table of test values to check implementation
c    of the program.
c    Z, A,  L    Egnd st  Fiss Bar      Moments of inertia     Lmax
c
c   28, 58, 0    0.00     33.14        0.816 3.603 3.608      46.1
c         ,25   21.36     19.50        0.778 3.662 3.662      46.1
c         ,40   49.66      2.97        0.724 3.648 2.650      46.1
c         ,46.1 59.14      0.00        0.746 3.160 3.160      46.1
c   65,153, 0    0.00     28.88        0.621 3.698 3.698      82.3
c         ,50   19.00     16.16        0.615 3.639 3.639      82.3
c         ,80   45.24      0.26        0.616 2.765 2.788      82.3
c         ,82.3 47.04      0.00        0.682 2.231 2.276      82.3
c   93,229, 0    0.00      3.76        0.823 1.747 1.747      68.1
c         ,45    8.21      1.26        0.765 1.578 1.578      68.1
c         ,68.1 17.96      0.00        1.053 1.053 1.236      68.1
c
c    written by A. J. Sierk,  LANL  T-9
c    Version 1.0   February, 1984
c    Version 1.1   January, 1985  Improved coefficients in egs and Lmax
c    Version 1.2   September, 1985  Improved Lmax, egs coefficients
c
c        Copyright, 1985,  The Regents of the University of California.
c        This software was produced under a U. S. Government contract
c        (W-7405-ENG-36) by the Los Alamos National Laboratory, which is
c        operated by the University of California for the U. S. Department
c        of Energy.  The U. S. Government is licensed to use, reproduce,
c        and distribute this software.  Permission is granted to the public
c        to copy and use this software without charge, provided that this
c        notice and any statement of authorship are reproduced on all
c        copies.  Neither the Government nor the University makes any
c        warranty, expressed or implied, or assumes any liability
c        or responsibility for the use of this software.
c
c    the following is NECESSARY for 32-bit machines like DEC VAX, IBM,etc
c
      implicit real*8(a-h,o-z)
      real*8 il,bfis,segs,selmax
      double precision elzcof,pa,pz,aa,zz,el20,el80,bfis0,elmax,pl,ell
      double precision egs,egs1,egs2,egs3,egs4,egs5,egscof
c
      dimension elzcof(7,7),elmcof(5,4),emncof(5,4),pa(7),pz(7),pl(10)
      dimension emxcof(7,5),egs4(5,7),egs1(5,7),egs2(5,7),egs5(5,7),
     1 egs3(5,7),egscof(5,7,5)
c
      equivalence (egs1,egscof),(egs2,egscof(1,1,2)),(egs3,egscof(1,1,3)
     1 ),(egs4,egscof(1,1,4)),(egs5,egscof(1,1,5))
c
      data emncof
     1/-9.01100e+2,-1.40818e+3, 2.77000e+3,-7.06695e+2, 8.89867e+2,
     2  1.35355e+4,-2.03847e+4, 1.09384e+4,-4.86297e+3,-6.18603e+2,
     3 -3.26367e+3, 1.62447e+3, 1.36856e+3, 1.31731e+3, 1.53372e+2,
     4  7.48863e+3,-1.21581e+4, 5.50281e+3,-1.33630e+3, 5.05367e-02/
      data elmcof
     1 /1.84542e+3,-5.64002e+3, 5.66730e+3,-3.15150e+3, 9.54160e+2,
     2 -2.24577e+3, 8.56133e+3,-9.67348e+3, 5.81744e+3,-1.86997e+3,
     3  2.79772e+3,-8.73073e+3, 9.19706e+3,-4.91900e+3, 1.37283e+3,
     4 -3.01866e+1, 1.41161e+3,-2.85919e+3, 2.13016e+3,-6.49072e+2/
      data emxcof /
     1 -4.10652732e6, 1.00064947e7,-1.09533751e7, 7.84797252e6,
     1 -3.78574926e6, 1.12237945e6,-1.77561170e5,
     1  1.08763330e7,-2.63758245e7, 2.85472400e7,-2.01107467e7,
     1  9.48373641e6,-2.73438528e6, 4.13247256e5,
     1 -8.76530903e6, 2.14250513e7,-2.35799595e7, 1.70161347e7,
     1 -8.23738190e6, 2.42447957e6,-3.65427239e5,
     1  6.30258954e6,-1.52999004e7, 1.65640200e7,-1.16695776e7,
     1  5.47369153e6,-1.54986342e6, 2.15409246e5,
     1 -1.45539891e6, 3.64961835e6,-4.21267423e6, 3.24312555e6,
     1 -1.67927904e6, 5.23795062e5,-7.66576599e4/
      data elzcof
     1 /5.11819909e+5,-1.30303186e+6, 1.90119870e+6,-1.20628242e+6,
     2  5.68208488e+5, 5.48346483e+4,-2.45883052e+4,
     3 -1.13269453e+6, 2.97764590e+6,-4.54326326e+6, 3.00464870e+6,
     4 -1.44989274e+6,-1.02026610e+5, 6.27959815e+4,
     5  1.37543304e+6,-3.65808988e+6, 5.47798999e+6,-3.78109283e+6,
     6  1.84131765e+6, 1.53669695e+4,-6.96817834e+4,
     7 -8.56559835e+5, 2.48872266e+6,-4.07349128e+6, 3.12835899e+6,
     8 -1.62394090e+6, 1.19797378e+5, 4.25737058e+4,
     9  3.28723311e+5,-1.09892175e+6, 2.03997269e+6,-1.77185718e+6,
     a  9.96051545e+5,-1.53305699e+5,-1.12982954e+4,
     b  4.15850238e+4, 7.29653408e+4,-4.93776346e+5, 6.01254680e+5,
     c -4.01308292e+5, 9.65968391e+4,-3.49596027e+3,
     d -1.82751044e+5, 3.91386300e+5,-3.03639248e+5, 1.15782417e+5,
     e -4.24399280e+3,-6.11477247e+3, 3.66982647e+2/
      data egs1 /
     1 -1.781665232e6,-2.849020290e6, 9.546305856e5, 2.453904278e5,
     1  3.656148926e5,
     1  4.358113622e6, 6.960182192e6,-2.381941132e6,-6.262569370e5,
     1 -9.026606463e5,
     1 -4.804291019e6,-7.666333374e6, 2.699742775e6, 7.415602390e5,
     1  1.006008724e6,
     1  3.505397297e6, 5.586825123e6,-2.024820713e6,-5.818008462e5,
     1 -7.353683218e5,
     1 -1.740990985e6,-2.759325148e6, 1.036253535e6, 3.035749715e5,
     1  3.606919356e5,
     1  5.492532874e5, 8.598827288e5,-3.399809581e5,-9.852362945e4,
     1 -1.108872347e5,
     1 -9.229576432e4,-1.431344258e5, 5.896521547e4, 1.772385043e4,
     1  1.845424227e4/
      data egs2 /
     1  4.679351387e6, 7.707630513e6,-2.718115276e6,-9.845252314e5,
     1 -1.107173456e6,
     1 -1.137635233e7,-1.870617878e7, 6.669154225e6, 2.413451470e6,
     1  2.691480439e6,
     1  1.237627138e7, 2.030222826e7,-7.334289876e6,-2.656357635e6,
     1 -2.912593917e6,
     1 -8.854155353e6,-1.446966194e7, 5.295832834e6, 1.909275233e6,
     1  2.048899787e6,
     1  4.290642787e6, 6.951223648e6,-2.601557110e6,-9.129731614e5,
     1 -9.627344865e5,
     1 -1.314924218e6,-2.095971932e6, 8.193066795e5, 2.716279969e5,
     1  2.823297853e5,
     1  2.131536582e5, 3.342907992e5,-1.365390745e5,-4.417841315e4,
     1 -4.427025540e4/
      data egs3 /
     1 -3.600471364e6,-5.805932202e6, 1.773029253e6, 4.064280430e5,
     1  7.419581557e5,
     1  8.829126250e6, 1.422377198e7,-4.473342834e6,-1.073350611e6,
     1 -1.845960521e6,
     1 -9.781712604e6,-1.575666314e7, 5.161226883e6, 1.341287330e6,
     1  2.083994843e6,
     1  7.182555931e6, 1.156915972e7,-3.941330542e6,-1.108259560e6,
     1 -1.543982755e6,
     1 -3.579820035e6,-5.740079339e6, 2.041827680e6, 5.981648181e5,
     1  7.629263278e5,
     1  1.122573403e6, 1.777161418e6,-6.714631146e5,-1.952833263e5,
     1 -2.328129775e5,
     1 -1.839672155e5,-2.871137706e5, 1.153532734e5, 3.423868607e4,
     1  3.738902942e4/
      data egs4 /
     1  2.421750735e6, 4.107929841e6,-1.302310290e6,-5.267906237e5,
     1 -6.197966854e5,
     1 -5.883394376e6,-9.964568970e6, 3.198405768e6, 1.293156541e6,
     1  1.506909314e6,
     1  6.387411818e6, 1.079547152e7,-3.517981421e6,-1.424705631e6,
     1 -1.629099740e6,
     1 -4.550695232e6,-7.665548805e6, 2.530844204e6, 1.021187317e6,
     1  1.141553709e6,
     1  2.182540324e6, 3.646532772e6,-1.228378318e6,-4.813626449e5,
     1 -5.299974544e5,
     1 -6.518758807e5,-1.070414288e6, 3.772592079e5, 1.372024952e5,
     1  1.505359294e5,
     1  9.952777968e4, 1.594230613e5,-6.029082719e4,-2.023689807e4,
     1 -2.176008230e4/
      data egs5 /
     1 -4.902668827e5,-8.089034293e5, 1.282510910e5,-1.704435174e4,
     1  8.876109934e4,
     1  1.231673941e6, 2.035989814e6,-3.727491110e5, 4.071377327e3,
     1 -2.375344759e5,
     1 -1.429330809e6,-2.376692769e6, 5.216954243e5, 7.268703575e4,
     1  3.008350125e5,
     1  1.114306796e6, 1.868800148e6,-4.718718351e5,-1.215904582e5,
     1 -2.510379590e5,
     1 -5.873353309e5,-9.903614817e5, 2.742543392e5, 9.055579135e4,
     1  1.364869036e5,
     1  1.895325584e5, 3.184776808e5,-9.500485442e4,-3.406036086e4,
     1 -4.380685984e4,
     1 -2.969272274e4,-4.916872669e4, 1.596305804e4, 5.741228836e3,
     1  6.669912421e3/
c
c    The program starts here
c
      if (iz.lt.19 .or. iz.gt.111) go to 900
      if (iz.gt.102 .and. il.gt.0) go to 910
      z = float(iz)
      a = float(ia)
      el = il
      amin = 1.2*z + 0.01*z*z
      amax = 5.8*z - 0.024*z*z
      if (a.lt.amin .or. a.gt.amax) go to 920
      aa = a/400.
      zz = z/100.
c     aa = dble(2.5d-3*a)
c     zz = dble(1.d-2*z)
c     bfis0 = 0.d0
      bfis0 = 0.0
      call lpoly(zz,7,pz)
      call lpoly(aa,7,pa)
        do 10 i = 1,7
        do 10 j = 1,7
        bfis0 = bfis0 + elzcof(j,i)*pz(j)*pa(i)
 10     continue
      bfis = bfis0
      egs = 0.0
      segs = egs
c     egs = 0.d0
c     segs = sngl(egs)
c     bfis = sngl(bfis0)
      amin2 = 1.4*z + 0.009*z*z
      amax2 = 20. + 3.0*z
      if ((a.lt.amin2-5. .or. a.gt.amax2+10.) .and. il.gt.0) go to 930
      elmax = 0.0
      el80 = 0.0
      el20 = 0.0
c     el80 = 0.d0
c     el20 = 0.d0
c     elmax = 0.d0
        do 20 i = 1,4
        do 20 j = 1,5
        el80 = el80 + elmcof(j,i)*pz(j)*pa(i)
        el20 = el20 + emncof(j,i)*pz(j)*pa(i)
c       el80 = el80 + dble(elmcof(j,i))*pz(j)*pa(i)
c       el20 = el20 + dble(emncof(j,i))*pz(j)*pa(i)
 20     continue
c     sel80 = sngl(el80)
c     sel20 = sngl(el20)
      sel80 = el80
      sel20 = el20
        do 30 i = 1,5
        do 30 j = 1,7
        elmax = elmax + emxcof(j,i)*pz(j)*pa(i)
 30     continue
      selmax = elmax
c     selmax = sngl(elmax)
      if (il.lt.1) return
      x = sel20/selmax
      y = sel80/selmax
      if (el.gt.sel20) go to 40
      q = 0.2/(sel20**2*sel80**2*(sel20-sel80))
      qa =  q*(4.*sel80**3 - sel20**3)
      qb = -q*(4.*sel80**2 - sel20**2)
      bfis = bfis*(1. + qa*el**2 + qb*el**3)
      go to 50
   40 aj = (-20.*x**5 + 25.*x**4 - 4.)*(y-1.)**2*y*y
      ak = (-20.*y**5 + 25.*y**4 - 1.)*(x-1.)**2*x*x
      q = 0.2/((y-x)*((1.-x)*(1.-y)*x*y)**2)
      qa =  q*(aj*y - ak*x)
      qb = -q*(aj*(2.*y+1.) - ak*(2.*x+1.))
      z = el/selmax
      a1 = 4.*z**5 - 5.*z**4 + 1.
      a2 = qa*(2.*z+1.)
      bfis = bfis*(a1 + (z-1.)*(a2 + qb*z)*z*z*(z-1.))
   50 if (bfis.le.0.0) bfis = 0.0
      if (el.gt.selmax) bfis = 0.0
c
c    Now calculate rotating ground-state energy
c
      if (el.gt.selmax .and. il.ne.1000) return
      ell = el/elmax
c     ell = dble(el/elmax)
      if (il.eq.1000) ell = 1.0
c     if (il.eq.1000) ell = 1.d0
      call lpoly(ell,9,pl)
        do 60 k = 1,5
          do 60 l = 1,7
            do 60 m = 1,5
            egs = egs + egscof(m,l,k)*pz(l)*pa(k)*pl(2*m-1)
   60       continue
      segs = egs
c     segs = sngl(egs)
      if (segs.lt.0.0) segs = 0.0
      return
 899  bfis = 0.0
      segs = 0.0
      selmax = 0.0
      return
 900  print 1000
      go to 899
 910  print 1010
      go to 899
 920  print 1020,ia,iz
      go to 899
 930  print 1030,ia,il
      go to 899
c
 1000 format(/10x,'*  *  *  *  barfit called with  z  less than 19 or ',
     1 ' greater than 111.  bfis is set to 0.0.  *  *  *  *')
 1010 format(/10x,'*  *  *  *  barfit called with  z  greater than 102',
     1 ' and  L  not equal to zero.  bfis is set to 0.0.  *  *  *  *')
 1020 format(/10x,'*  *  *  *  barfit called with  a =',i3,', outside ',
     1 'the allowed values for z = ',i3,' *  *  *  *')
 1030 format(/10x,'*  *  *  *  barfit called with  a  =',i3,', outside',
     1 ' the allowed values for z = ',i3/26x,'for nonzero  L =',i3,
     2 '  *  *  *  *')
      end
      subroutine lpoly(x,n,pl)
c
c       this subroutine calculates the ordinary Legendre Polynomials of
c       order 0 to n-1 of argument x and stores them in the vector
c       pl.  They are calculated by recursion relation from the first two
c       polynomials
c
c       written by A. J. Sierk   LANL T-9 February, 1984
c
c       NOTE:    pl and x must be double precision on 32-bit computers!
c
      double precision pl,x
c
CSMS      dimension pl(20)
      dimension pl(n)
      pl(1)=1.0
      pl(2)=x
      do 10 i = 3,n
        pl(i) = ((2*i-3)*x*pl(i-1)-(i-2)*pl(i-2))/(i-1)
 10   continue
      return
      end
