      subroutine cps(z,a,r0ldm,def,defs)
      implicit real*8 (a-h,o-z)
      real*8 x(70), y(70), dy(70), param(10),yfit(70),dparam(10)
      integer fitprm(10)
      real*8 errvectr(10)
      external cpsfunctn
      integer i,ndat,mode

CSMS init
      j = 0

      iz = nint(z)
      ia = nint(a)
      if( iz .lt. 19 ) then
        call cpsold(    z,a,r0ldm,def,defs)
        return
      endif

      cj = j
      call barfit(iz,ia,cj,bfis,segs,selmax)
      npts = selmax-3

      write(6,*) ' --->Find Yrast line for iz,ia=',iz,ia
      write(6,*) '     Max. spin = ', npts
      
      DO j=1,npts
        cj = j
        call barfit(iz,ia,cj,bfis,segs,selmax)
        x(j) = j
        y(j) = segs
        dy(j) = .2
      enddo
      

      do i = 1,3
        fitprm(i) = i
      enddo


      param(1) = 1.33
      param(2) = 3E-5
      param(3) = 5E-8
      nterms = 3

      param(4) = ia
      mode = 1

      call curfit(x,y,dy,npts,nterms,fitprm,param,mode,dparam,
     &     yfit,chisqr,cpsfunctn,
     &     errvectr)

      chisqr = 0
      write(6,*) '.....Fit to SIERK Yrast line.....'
      write(6,*) '    j     y_sierk        yfit'
      do i = 1,npts

        yf=cpsfunctn(x(i),i,param)
        chisqr = chisqr +( (yf-y(i))/dy(i) )**2
        write(6,'(i5,2f12.4)') nint(x(i)),y(i),yf
      enddo
      chisqr = chisqr/(npts-nterms)

      write(6,1230) chisqr, (param(i),i=1,nterms)
 1230 format(//'   Yrast line fit: chisqr = ',f8.3/
     &     '   r0ldm  = ',f12.5/
     &     '   def    = ',e15.5/
     &     '   defs   = ',e15.5)

      r0ldm = param(1)
      def = param(2)
      defs = param(3)

      return
      end
      
      function cpsfunctn(x,i,param)
      implicit real*8(a-h,o-z)
      real*8 param(*)
      integer ndat
      
      r0ldm = param(1)
      def = param(2)
      defs = param(3)   
      a = param(4)
      x2 = x*x
      x4 = x2*x2

      cpsfunctn = 52.2371*x*(x+1)/(r0ldm**2*a**1.6666666*(1+def*x2+defs*x4))
      
      return
      end

      subroutine curfit(x,y,dy,npts,nterms,fitprm,
     &     param,mode,dparam,yfit,chisqr,cpsfunctn,errvectr)
      implicit real*8 (a-h,o-z)
      dimension x518(50), diag518(50),fjac518(50,50),
     &     ipvt518(50), qtf518(50), errvectr(50), wa2518(50),
     &     wa3518(50), wa4518(50)

      real*8 x(*), y(*), dy(*), param(*), dparam(*),yfit(*), chisqr
      integer npts,nterms, itmp,fitprm(*)
      external cpsfunctn                                          
      integer ipvt(100)
      do i=1,nterms
        itmp=fitprm(i)
        x518(i)=param(itmp)
        diag518(i) = dparam(itmp)
      enddo
      ftol=1e-6                                                   
      xtol=1e-7                                                   
      gtol=0
      maxfev=200*(nterms+1)                                       
      epsfcn=1e-7                                                 
c       mode=1                                                      
      factor=100
      nprint=0                                                    
      ldfjac=NPTS
      call lmdif(cpsfunctn,npts,nterms,x518,yfit,ftol,xtol,  gtol,
     &     maxfev,epsfcn,diag518,mode,factor,nprint,  
     &     info,nfev ,fjac518,
     &     ldfjac,ipvt,  qtf518,errvectr,wa2518,wa3518,wa4518,
     &     x,y,dy,npts,nterms,fitprm,param,chisqr)
      write(6,*) 'info=',info
      do i=1,npts                                                      
        yfit(i)=yfit(i)*dy(i)  + y(i)
      enddo
      return                                                            
      end                                                               

      subroutine lmdif(cpsfunctn,m,n,x,fvec,ftol,xtol,
     &     gtol,maxfev,epsfcn, 
     &     diag,mode,factor,nprint,info,nfev,fjac,ldfjac, 
     &     ipvt,qtf,wa1,wa2,wa3,wa4,xxx,y,dy,npts,
     &     nterms,fitprm,param,chisqr)
      implicit real*8(a-h,o-z)
      integer fitprm(*)
      real*8 xxx(*), y(*), dy(*), param(*), fvec(*), chisqr
      integer m,n,maxfev,mode,nprint,info,nfev,ldfjac                   
      integer ipvt(n)                                                   
      real*8  x(*)
      real*8  diag(*),fjac(ldfjac,n),qtf(*),  wa1(*),wa2(*),
     &     wa3(*),wa4(*)
      integer i,iflag,iter,j,l                                          
      external cpsfunctn                                                   
      data one,p1,p5,p25,p75,p0001,zero /1.0d0,1.0d-1,5.0d-1,2.5d-1,
     &     7.5d-1,1.0d-4,0.0d0/

      fvec(2)=34                                                        
      epsmch = dpmpar(1)                                                
      info = 0                                                          
      iflag = 0                                                         
      nfev = 0                                                          
      oldchi=0                                                          
      if (n .le. 0 .or. m .lt. n .or. ldfjac .lt. m .or. ftol .lt. zero 
     *     .or. xtol .lt. zero .or. gtol .lt. zero .or. maxfev .le. 0 .or. 
     &     factor .le. zero) then
        write(6,*) ' kicked immediately out of lmdif'
        go to 300
      endif
      if (mode .ne. 2) go to 20                                         
      do 10 j = 1, n                                                    
        if (diag(j) .le. zero) then
          write(6,*) ' diag(j) <= 0 for n,j,diag(j):',n,j,diag(j)
          go to 300                                  
        endif
 10   continue                                                          
 20   continue                                                          
      iflag = 1   
      call fcn(m,n,x,fvec,iflag,xxx,y,dy,npts,nterms,fitprm,
     &     param,chisqr,cpsfunctn)
      nfev = 1                                                          
      if (iflag .lt. 0) then
        write(6,*) ' iflag set in fcn after statement 20: ',iflag
        go to 300                                       
      endif
      fnorm = enorm(m,fvec)                                             
      par = zero                                                        
      iter = 1                                                          
 30   continue                                                          
      iflag = 2   
      call fdjac2(fcn,m,n,x,fvec,fjac,ldfjac,iflag,epsfcn,wa4,
     &     xxx,y,dy,npts,nterms,fitprm,param,chisqr,
     &     cpsfunctn)
      nfev = nfev + n                                                   
      if (iflag .lt. 0) then
        write(6,*) ' iflag set in fdjac2 after statement 30: ',iflag
        go to 300                                       
      endif
      if (nprint .le. 0) go to 40                                       
      iflag = 0
      if (mod(iter-1,nprint) .eq. 0) call fcn(m,n,x,fvec,iflag,
     &     xxx,y,dy,npts,nterms,fitprm,param,chisqr,
     &     cpsfunctn)
      if (iflag .lt. 0) go to 300                                       
 40   continue                                                          
      CALL QRFAC(M,N,FJAC,LDFJAC,.TRUE.,IPVT,N,WA1,WA2,WA3)             
      if (iter .ne. 1) go to 80                                         
      if (mode .eq. 2) go to 60                                         
      do 50 j = 1, n                                                    
        diag(j) = wa2(j)                                                  
        if (wa2(j) .eq. zero) diag(j) = one                               
 50   continue                                                          
 60   continue                                                          
      do 70 j = 1, n                                                    
        wa3(j) = diag(j)*x(j)                                             
 70   continue                                                          
      xnorm = enorm(n,wa3)                                              
      delta = factor*xnorm                                              
      if (delta .eq. zero) delta = factor                               
 80   continue                                                          
      do 90 i = 1, m                                                    
        wa4(i) = fvec(i)                                                  
 90   continue                                                          
      do 130 j = 1, n                                                   
        if (fjac(j,j) .eq. zero) go to 120                                
        sum = zero                                                        
        do 100 i = j, m                                                   
          sum = sum + fjac(i,j)*wa4(i)                                      
 100    continue                                                          
        temp = -sum/fjac(j,j)                                             
        do 110 i = j, m                                                   
          wa4(i) = wa4(i) + fjac(i,j)*temp                                  
 110    continue                                                          
 120    continue                                                          
        fjac(j,j) = wa1(j)                                                
        qtf(j) = wa4(j)                                                   
 130  continue                                                          
      gnorm = zero                                                      
      if (fnorm .eq. zero) go to 170                                    
      do 160 j = 1, n                                                   
        l = ipvt(j)                                                       
        if (wa2(l) .eq. zero) go to 150                                   
        sum = zero                                                        
        do 140 i = 1, j                                                   
          sum = sum + fjac(i,j)*(qtf(i)/fnorm)                              
 140    continue    
        gnorm = dmax1(gnorm,dabs(sum/wa2(l)))                             
 150    continue                                                          
 160  continue                                                          
 170  continue                                                          
      if (gnorm .le. gtol) info = 4                                     
      if (info .ne. 0) go to 300                                        
      if (mode .eq. 2) go to 190                                        
      do 180 j = 1, n                                                   
        diag(j) = dmax1(diag(j),wa2(j))                                   
 180  continue                                                          
 190  continue                                                          
 200  continue                                                          
      call lmpar(n,fjac,ldfjac,ipvt,diag,qtf,delta,par,wa1,wa2, 
     &     wa3,wa4)
      do 210 j = 1, n                                                   
        wa1(j) = -wa1(j)                                                  
        wa2(j) = x(j) + wa1(j)                                            
        wa3(j) = diag(j)*wa1(j)                                           
 210  continue                                                          
      pnorm = enorm(n,wa3)                                              
      if (iter .eq. 1) delta = dmin1(delta,pnorm)                       
      iflag = 1   
      call fcn(m,n,wa2,wa4,iflag,xxx,y,dy,npts,
     &     nterms,fitprm,param,chisqr,cpsfunctn)
      nfev = nfev + 1                                                   
      if (iflag .lt. 0) go to 300                                       
      fnorm1 = enorm(m,wa4)                                             
      actred = -one                                                     
      if (p1*fnorm1 .lt. fnorm) actred = one - (fnorm1/fnorm)**2        
      do 230 j = 1, n                                                   
        wa3(j) = zero                                                     
        l = ipvt(j)                                                       
        temp = wa1(l)                                                     
        do 220 i = 1, j                                                   
          wa3(i) = wa3(i) + fjac(i,j)*temp                                  
 220    continue                                                          
 230  continue                                                          
      temp1 = enorm(n,wa3)/fnorm                                        
      temp2 = (dsqrt(par)*pnorm)/fnorm                                  
      prered = temp1**2 + temp2**2/p5                                   
      dirder = -(temp1**2 + temp2**2)                                   
      ratio = zero                                                      
      if (prered .ne. zero) ratio = actred/prered                       
      if (ratio .gt. p25) go to 240                                     
      if (actred .ge. zero) temp = p5                                   
      if (actred .lt. zero)  temp = p5*dirder/(dirder + p5*actred)      
      if (p1*fnorm1 .ge. fnorm .or. temp .lt. p1) temp = p1             
      delta = temp*dmin1(delta,pnorm/p1)                                
      par = par/temp                                                    
      go to 260                                                         
 240  continue                                                          
      if (par .ne. zero .and. ratio .lt. p75) go to 250                 
      delta = pnorm/p5                                                  
      par = p5*par                                                      
 250  continue                                                          
 260  continue                                                          
      if (ratio .lt. p0001) go to 290                                   
      do 270 j = 1, n                                                   
        x(j) = wa2(j)                                                     
        wa2(j) = diag(j)*x(j)                                             
 270  continue                                                          
      do 280 i = 1, m                                                   
        fvec(i) = wa4(i)                                                  
 280  continue                                                          
      xnorm = enorm(n,wa2)                                              
      fnorm = fnorm1                                                    
      iter = iter + 1                                                   
 290  continue                                                          
      if (dabs(actred) .le. ftol .and. prered .le. ftol .and. 
     &     p5*ratio .le. one) info = 1
      if (delta .le. xtol*xnorm) info = 2                               
      if (dabs(actred) .le. ftol .and. prered .le. ftol .and. p5*ratio 
     &     .le. one .and. info .eq. 2) info = 3
      if (info .ne. 0) go to 300                                        
      if (nfev .ge. maxfev) info = 5                                    
      if (dabs(actred) .le. epsmch .and. prered .le. epsmch .and. 
     &     p5*ratio .le. one) info = 6
      if (delta .le. epsmch*xnorm) info = 7                             
      if (gnorm .le. epsmch) then
        info = 8                                   
        write(6,*) 'fnorm, gnorm=',fnorm, gnorm
      endif
      if (info .ne. 0) go to 300                                        
      if (ratio .lt. p0001) go to 200                                   

      rchisqr = 0
      do i = 1,m
        yf=cpsfunctn(xxx(i),i,param)
        rchisqr = rchisqr +( (yf-y(i))/dy(i) )**2
      enddo
      RCHISQR=rchisqr/(m-n)

      go to 30                                                          
 300  continue                                                          
      if (iflag .lt. 0) info = iflag                                    
      if(iflag.lt.0) go to 350                                          
      call fcn(m,n,x,fvec,iflag,xxx,y,dy,npts,
     &     nterms,fitprm,param,chisqr,cpsfunctn)
      chisqr=0                                                          
      do 296 i=1,m                                                      
 296  chisqr=chisqr+fvec(i)**2                                          
      RCHISQR=chisqr/(m-n)
      WRITE(6,*) 'FINAL CHIQR = ',RCHISQR
      do 320 j=1,n                                                      
        l=ipvt(j)                                                         
        wa1(l)=enorm(j,fjac(1,j))                                         
        sqrtepsi=dsqrt(1.d0/(m-n))
        wa1(l)=sqrtepsi*chisqr/wa1(l) 
 320  continue                                                          
 350  iflag = 0                                                         
      if (nprint .gt. 0) call fcn(m,n,x,fvec,iflag,
     &     xxx,y,dy,npts,nterms,fitprm,param,chisqr,cpsfunctn)
      return                                                            
      end                                                               


      subroutine fdjac2(fcn,m,n,x,fvec,fjac,ldfjac,iflag,epsfcn,wa,
     &     xxx,y,dy,npts,nterms,fitprm,param,chisqr,cpsfunctn)
      implicit real*8(a-h,o-z)
      real*8 xxx(*), y(*), dy(*), param(*), fvec(*), chisqr
      integer m,n,ldfjac,iflag                                          
      real*8  x(*)                                                    
      real*8  fjac(ldfjac,n),wa(m)
      integer fitprm(*)
      integer i,j                                                       
      external cpsfunctn                                                
      data zero /0.0d0/                                                 
      epsmch = dpmpar(1)                                                
      eps = dsqrt(dmax1(epsfcn,epsmch))                                 
      do 20 j = 1, n                                                    
        temp = x(j)                                                       
        h = eps*dabs(temp)                                                
        if (h .eq. zero) h = eps                                          
        x(j) = temp + h                                                   
        call fcn(m,n,x,wa,iflag,xxx,y,dy,npts,nterms,
     &       fitprm,param,chisqr,cpsfunctn)
        if (iflag .lt. 0) go to 30                                        
        x(j) = temp                                                       
        do 10 i = 1, m                                                    
          fjac(i,j) = (wa(i) - fvec(i))/h                                   
 10     continue                                                          
 20   continue                                                          
 30   continue                                                          
      return                                                            
      end                                                               

      subroutine fcn(m,n,x,fvec,iflag,xxx,y,dy,
     &     npts,nterms,fitprm,param,chisqr,cpsfunctn)
      implicit real*8 (a-h,o-z)                                         
      external cpsfunctn
      integer fitprm(*)
      real*8 x(*)
      REAL*8 xxX(*), Y(*), DY(*), PARAM(*), fvec(*), chisqr
      chisqr=0                                                          
      do 10 i=1,nterms    
        iterm=fitprm(i)
 10   param(iterm)=x(i)
      do 20 i=1,npts
        fit=cpsfunctn(xxx(i),i,param)
        fvec(i)=(fit-y(i))/dy(i)
        chisqr=chisqr+fvec(i)**2                                          
 20   continue   
      RCHISQR=chisqr/(m-n)
      return    
      end

      
      SUBROUTINE CPSOLD(Z,A,R0,DEF,DEFS)
      IMPLICIT REAL*8(A-H,O-Z)
CE    CALCULATES THE DEFORMABILITIES DEF, DEFS
CE    DEFINITION: MOMENT OF INERTIA = SPHERE * DEF*J**2 + DEFS*J**4)
CE    FIT TO THE DEFORMATIONS GIVEN BY COHEN,PLASIL AND SWIATECKI
      C = (A-2.*Z)/A
      C = C*C
      ESO = 17.9439 * (1.-1.7826*C)*A**(2./3.)
      ECO = 0.7053*Z*Z/A**(1./3.)
      X = ECO/(2.*ESO)
      CR = 34.540 * 1.2249*1.2249/R0**2
      CR = CR/A**(5./3.)
      CY = CR/ESO
      IF (X.GT.0.75) GO TO 14
      Y1 = 0.2829 - 0.3475*X - 0.0016*X*X + 0.0501*X*X*X
      GO TO 15
 14   CX = 1. - X
      Y1 = 1.4*CX*CX - 4.566*CX**3 + 6.7443*CX**4
 15   CONTINUE
      IF (X.GT.0.5) GO TO 17
      Y2 = 0.78 - 1.2568*X + 0.1335*X*X
      GO TO 19
 17   IF (X.GT.0.7) GO TO 18
      Y2 = 1.33 - 3.465*X + 2.350*X*X
      GO TO 19
 18   Y2 = Y1
 19   CONTINUE
      ZETA1 = -0.0380 + 0.0648*X - 0.0253*X*X
      IF (ZETA1.GT.0.) ZETA1 = 0.
      IF (X.GT.0.5) GO TO 22
      ZETA2 = -0.3100 + 0.5533*X - 0.0665*X*X
      GO TO 25
 22   IF (X.GT.0.7) GO TO 23
      ZETA2 = -0.6175 + 1.785*X - 1.3*X*X
      GO TO 25
 23   ZETA2 = ZETA1
 25   CONTINUE
      CL12 = Y1/CY
      ETA1 = ZETA1/Y1
      B1 = ETA1/CL12
      B1 = B1/(1.+ETA1)
      IF (X.GT.0.5) GO TO 28
      CL22 = Y2/CY
      ETA2 = ZETA2/Y2
      B2 = ETA2/CL22
      B2 = B2/(1.+ETA2)
      DEFS = (B2-B1)/(CL12-CL22)
      DEF = -B1 - CL12*DEFS
      GO TO 30
 28   DEFS = 0.
      DEF = -B1
 30   CONTINUE
      RETURN
      END
