      DOUBLE PRECISION FUNCTION DPMPAR(I)                               
      INTEGER I                                                         
C     **********                                                        
C                                                                       
C     FUNCTION DPMPAR                                                   
C                                                                       
C     THIS FUNCTION PROVIDES DOUBLE PRECISION MACHINE PARAMETERS        
C     WHEN THE APPROPRIATE SET OF DATA STATEMENTS IS ACTIVATED (BY      
C     REMOVING THE C FROM COLUMN 1) AND ALL OTHER DATA STATEMENTS ARE   
C     RENDERED INACTIVE. MOST OF THE PARAMETER VALUES WERE OBTAINED     
C     FROM THE CORRESPONDING BELL LABORATORIES PORT LIBRARY FUNCTION.   
C                                                                       
C     THE FUNCTION STATEMENT IS                                         
C                                                                       
C       DOUBLE PRECISION FUNCTION DPMPAR(I)                             
C                                                                       
C     WHERE                                                             
C                                                                       
C       I IS AN INTEGER INPUT VARIABLE SET TO 1, 2, OR 3 WHICH          
C         SELECTS THE DESIRED MACHINE PARAMETER. IF THE MACHINE HAS     
C         T BASE B DIGITS AND ITS SMALLEST AND LARGEST EXPONENTS ARE    
C         EMIN AND EMAX, RESPECTIVELY, THEN THESE PARAMETERS ARE        
C                                                                       
C         DPMPAR(1) = B**(1 - T), THE MACHINE PRECISION,                
C                                                                       
C         DPMPAR(2) = B**(EMIN - 1), THE SMALLEST MAGNITUDE,            
C                                                                       
C         DPMPAR(3) = B**EMAX*(1 - B**(-T)), THE LARGEST MAGNITUDE.     
C                                                                       
C     ARGONNE NATIONAL LABORATORY. MINPACK PROJECT. MARCH 1980.         
C     BURTON S. GARBOW, KENNETH E. HILLSTROM, JORGE J. MORE             
C                                                                       
C     **********                                                        
      INTEGER MCHEPS(4)                                                 
      INTEGER MINMAG(4)                                                 
      INTEGER MAXMAG(4)                                                 
      DOUBLE PRECISION DMACH(3)                                         
      EQUIVALENCE (DMACH(1),MCHEPS(1))                                  
      EQUIVALENCE (DMACH(2),MINMAG(1))                                  
      EQUIVALENCE (DMACH(3),MAXMAG(1))                                  
C                                                                       
C     MACHINE CONSTANTS FOR THE IBM 360/370 SERIES,                     
C     THE AMDAHL 470/V6, THE ICL 2900, THE ITEL AS/6,                   
C     THE XEROX SIGMA 5/7/9 AND THE SEL SYSTEMS 85/86.                  
C                                                                       
c      DATA MCHEPS(1),MCHEPS(2) / Z34100000, Z00000000 /                
c      DATA MINMAG(1),MINMAG(2) / Z00100000, Z00000000 /                
c      DATA MAXMAG(1),MAXMAG(2) / Z7FFFFFFF, ZFFFFFFFF /                
C                                                                       
C     MACHINE CONSTANTS FOR THE HONEYWELL 600/6000 SERIES.              
C                                                                       
C     DATA MCHEPS(1),MCHEPS(2) / O606400000000, O000000000000 /         
C     DATA MINMAG(1),MINMAG(2) / O402400000000, O000000000000 /         
C     DATA MAXMAG(1),MAXMAG(2) / O376777777777, O777777777777 /         
C                                                                       
C     MACHINE CONSTANTS FOR THE CDC 6000/7000 SERIES.                   
C                                                                       
C     DATA MCHEPS(1) / 15614000000000000000B /                          
C     DATA MCHEPS(2) / 15010000000000000000B /                          
C                                                                       
C     DATA MINMAG(1) / 00604000000000000000B /                          
C     DATA MINMAG(2) / 00000000000000000000B /                          
C                                                                       
C     DATA MAXMAG(1) / 37767777777777777777B /                          
C     DATA MAXMAG(2) / 37167777777777777777B /                          
C                                                                       
C     MACHINE CONSTANTS FOR THE PDP-10 (KA PROCESSOR).                  
C                                                                       
C     DATA MCHEPS(1),MCHEPS(2) / "114400000000, "000000000000 /         
C     DATA MINMAG(1),MINMAG(2) / "033400000000, "000000000000 /         
C     DATA MAXMAG(1),MAXMAG(2) / "377777777777, "344777777777 /         
C                                                                       
C     MACHINE CONSTANTS FOR THE PDP-10 (KI PROCESSOR).                  
C                                                                       
C     DATA MCHEPS(1),MCHEPS(2) / "104400000000, "000000000000 /         
C     DATA MINMAG(1),MINMAG(2) / "000400000000, "000000000000 /         
C     DATA MAXMAG(1),MAXMAG(2) / "377777777777, "377777777777 /         
C                                                                       
C     MACHINE CONSTANTS FOR THE PDP-11 FORTRAN SUPPORTING               
C     32-BIT INTEGERS (EXPRESSED IN INTEGER AND OCTAL).                 
C                                                                       
C     DATA MCHEPS(1),MCHEPS(2) /  620756992,           0 /              
C     DATA MINMAG(1),MINMAG(2) /    8388608,           0 /              
C     DATA MAXMAG(1),MAXMAG(2) / 2147483647,          -1 /              
C                                                                       
C     DATA MCHEPS(1),MCHEPS(2) / O04500000000, O00000000000 /           
C     DATA MINMAG(1),MINMAG(2) / O00040000000, O00000000000 /           
C     DATA MAXMAG(1),MAXMAG(2) / O17777777777, O37777777777 /           
C	dmach(1)=1e-12
C                                                                       
C     MACHINE CONSTANTS FOR THE PDP-11 FORTRAN SUPPORTING               
C     16-BIT INTEGERS (EXPRESSED IN INTEGER AND OCTAL).                 
C                                                                       
C     DATA MCHEPS(1),MCHEPS(2) /   9472,      0 /                       
C     DATA MCHEPS(3),MCHEPS(4) /      0,      0 /                       
C                                                                       
C     DATA MINMAG(1),MINMAG(2) /    128,      0 /                       
C     DATA MINMAG(3),MINMAG(4) /      0,      0 /                       
C                                                                       
C     DATA MAXMAG(1),MAXMAG(2) /  32767,     -1 /                       
C     DATA MAXMAG(3),MAXMAG(4) /     -1,     -1 /                       
C                                                                       
C     DATA MCHEPS(1),MCHEPS(2) / O022400, O000000 /                     
C     DATA MCHEPS(3),MCHEPS(4) / O000000, O000000 /                     
C                                                                       
C     DATA MINMAG(1),MINMAG(2) / O000200, O000000 /                     
C     DATA MINMAG(3),MINMAG(4) / O000000, O000000 /                     
C                                                                       
C     DATA MAXMAG(1),MAXMAG(2) / O077777, O177777 /                     
C     DATA MAXMAG(3),MAXMAG(4) / O177777, O177777 /                     
C                                                                       
C     MACHINE CONSTANTS FOR THE BURROUGHS 6700/7700 SYSTEMS.            
C                                                                       
C     DATA MCHEPS(1) / O1451000000000000 /                              
C     DATA MCHEPS(2) / O0000000000000000 /                              
C                                                                       
C     DATA MINMAG(1) / O1771000000000000 /                              
C     DATA MINMAG(2) / O7770000000000000 /                              
C                                                                       
C     DATA MAXMAG(1) / O0777777777777777 /                              
C     DATA MAXMAG(2) / O7777777777777777 /                              
C                                                                       
C     MACHINE CONSTANTS FOR THE BURROUGHS 5700 SYSTEM.                  
C                                                                       
C     DATA MCHEPS(1) / O1451000000000000 /                              
C     DATA MCHEPS(2) / O0000000000000000 /                              
C                                                                       
C     DATA MINMAG(1) / O1771000000000000 /                              
C     DATA MINMAG(2) / O0000000000000000 /                              
C                                                                       
C     DATA MAXMAG(1) / O0777777777777777 /                              
C     DATA MAXMAG(2) / O0007777777777777 /                              
C                                                                       
C     MACHINE CONSTANTS FOR THE BURROUGHS 1700 SYSTEM.                  
C                                                                       
C     DATA MCHEPS(1) / ZCC6800000 /                                     
C     DATA MCHEPS(2) / Z000000000 /                                     
C                                                                       
C     DATA MINMAG(1) / ZC00800000 /                                     
C     DATA MINMAG(2) / Z000000000 /                                     
C                                                                       
C     DATA MAXMAG(1) / ZDFFFFFFFF /                                     
C     DATA MAXMAG(2) / ZFFFFFFFFF /                                     
C                                                                       
C     MACHINE CONSTANTS FOR THE UNIVAC 1100 SERIES.                     
C                                                                       
C     DATA MCHEPS(1),MCHEPS(2) / O170640000000, O000000000000 /         
C     DATA MINMAG(1),MINMAG(2) / O000040000000, O000000000000 /         
C     DATA MAXMAG(1),MAXMAG(2) / O377777777777, O777777777777 /         
C                                                                       
C     MACHINE CONSTANTS FOR THE DATA GENERAL ECLIPSE S/200.             
C                                                                       
C     NOTE - IT MAY BE APPROPRIATE TO INCLUDE THE FOLLOWING CARD -      
C     STATIC DMACH(3)                                                   
C                                                                       
C     DATA MINMAG/20K,3*0/,MAXMAG/77777K,3*177777K/                     
C     DATA MCHEPS/32020K,3*0/                                           
C                                                                       
C     MACHINE CONSTANTS FOR THE HARRIS 220.                             
C                                                                       
C     DATA MCHEPS(1),MCHEPS(2) / '20000000, '00000334 /                 
C     DATA MINMAG(1),MINMAG(2) / '20000000, '00000201 /                 
C     DATA MAXMAG(1),MAXMAG(2) / '37777777, '37777577 /                 
C                                                                       
C     MACHINE CONSTANTS FOR THE CRAY-1.                                 
C                                                                       
C     DATA MCHEPS(1) / 0376424000000000000000B /                        
C     DATA MCHEPS(2) / 0000000000000000000000B /                        
C                                                                       
C     DATA MINMAG(1) / 0200034000000000000000B /                        
C     DATA MINMAG(2) / 0000000000000000000000B /                        
C                                                                       
C     DATA MAXMAG(1) / 0577777777777777777777B /                        
C     DATA MAXMAG(2) / 0000007777777777777776B /                        
C                                                                       
C     MACHINE CONSTANTS FOR THE PRIME 400.                              
C                                                                       
C     DATA MCHEPS(1),MCHEPS(2) / :10000000000, :00000000123 /           
C     DATA MINMAG(1),MINMAG(2) / :10000000000, :00000100000 /           
C     DATA MAXMAG(1),MAXMAG(2) / :17777777777, :37777677776 /           
C                                                                       
C     Machine constants for Sun Sparc using IEEE floating point
C
      DATA MCHEPS(1),MCHEPS(2) / 1018167296, 0 /
      DATA MINMAG(1),MINMAG(2) / 1048576,    0 /           
      DATA MAXMAG(1),MAXMAG(2) / 2146435071, -1/           

      DPMPAR = DMACH(I)                                                 
      RETURN                                                            
C                                                                       
C     LAST CARD OF FUNCTION DPMPAR.                                     
C                                                                       
      END                                                               

