C       24-MAY-93       Change code to allow for particle emission after
c                       gamma decay in compound nucleus. Search cgamma
c       change koutw scaling to microbarns, find cscale
c       write out full cross sections, all z for a-102:  Search ctemp
      IMPLICIT REAL*8(A-H,O-Z)
c
c       FISCASCADE  -- This is a specially modified version of cascade
c          which includes fission competition in the decay of the 
c          compound system assuming assymetric fission barriers.
c
CE              PROGRAM CASCADE
CE    PROGRAM CASCADE (INPUT,OUTPUT,TAPE10,TAPE11,TAPE12,TAPE13,TAPE14)
CE
CE    EVAPORATION CODE BASED ON THE STATISTICAL THEORY
CE    FOR COMPOUND-NUCLEUS REACTIONS (HAUSER-FESHBACH THEORY)
CE    A DESCRIPTION OF THE FORMALISM USED IS GIVEN IN
CE    NUCL. PHYS. A280 (1977) 267
CE    F. PUEHLHOFER,  GSI DARMSTADT
CE
CE    THIS IS THE VERSION CASCADE I   (APRIL 1980)
CE
CE
CE    FILE 10: MASS TABLE, GENERATED BY EBTABLE SEPARATELY
CE                          AS A PERMANENT FILE,READ IN MAIN
CE    FILE 11: TABLE OF TRANSMISSION COEFFICIENTS, GENERATED BY TLCALC
CE                          SEPARATELY AS A PERMANENT FILE,
CE                          READ BY SUBROUTINE TSUMME
CE    FILE 13: TEMPORARY STORAGE OF POPULATION MATRICES WT(64,64)
CE                          (GETW, STOREW)
CE                          SPACE: ITMAX * 16 KBYTE MAXIMUM
CE    FILE 14: SCRATCH FILE FOR SUBROUTINE CLEAN, SAME SIZE AS 13
CE
CE
CE
CSJS MODI 13JUN84  ADDITION OF SIERK FISSION BARRIER OPTION
csjs    modified 21-feb-86  corrected fission barrier output
      COMMON EXMIN(500),EXMAX(500),EBE(4),ESEP(4,500)
      COMMON IZFMAX,IZE(4),IAE(4),JE(4),JDE(4),IEXXMX(500),IEXXS(500)
      COMMON IPS1,IPSMAX,IPSZO(4,500),IZ(500),IA(500)
      COMMON IEXXL(500),JMIN(500),JMAX(500),JJMAX(500)
CE
      common/lildeck/elab,excn,cl0,dafis,sigfus,siger,
     &     izt,iat,izp,iap,iafmax, izfindxoff,izfindxmax
      COMMON/C2/ FT(500),DA(500),DELTA(500),CK(500)
      COMMON/C2/ R0LDM,DEF,DEFS,DALDM,DAF,UTR,ULDM,UJTR,UJLDM,DLDM(500)
CE
      COMMON/C3/ EXLVX(100),EXLV(100,100),IPSLVX,IZLV(100),
     &     IALV(100),LVMAX(100), JLV(100,100)
CE
      COMMON/C4/ ITP,ITMAX,INHWT(200),IWL
      COMMON/C5/ WT0(64,64), WT(64,64,4)
CE
c      COMMON/C6/ TSUM(48,1160,4),RHO(64,64,5),W(64,64,4),WF(64,64,40)
      real*8 tsum(48,1200,4),W(64,64,4)
      COMMON/C6/ tsUM,RHO(64,64,5),W,WF(64,64,40,4)
      COMMON/C7/ WG(64,5),WGZ(64,64),LZ(64,64),LZF(64,64)
      COMMON/C7/ SE(100,5),SESUM(100,5)
      common/fislev/rots,rotb
      COMMON/OFFSET/UXOFET,OFFEV,OFFODD,TRAMO
     &     ,CSPLIEV,DSPLIEV,CSPLIOD,DSPLIOD,JNOD
      COMMON/JSPIN/JDIAG(48)
      common/i2dpo/i2dpop
      common/fullres/wwn(64,64),wwp(64,64),wwa(64,64),wwg(64,64),wwf(64,64)
      real*4 EB(128,144)
      EQUIVALENCE (EB(1),TSUM(1))
      DIMENSION WQR(30,40)
      EQUIVALENCE (WQR(1),WGZ(1))
      DIMENSION WQA(30),IPLOT(40),WQ(500),WQT(500),WQF(500)
      DIMENSION MPOL(5),TLG(32,2),ENH(100)
      DIMENSION JJXXXZ(4),JJMINZ(4)
      DIMENSION SUMW(4),ISUMW(4),ZW(4),SCN(2),IEXXXZ(4),ICZF(4)
      DIMENSION EMINT(4),EBC(3)
      DIMENSION CLV(4),EXL(8),JL(8),IPL(8),ITEXT(80)
CSJS BEG
      INTEGER SIERK
CSJS END
CSMS    integer sys$setprn
CE
      CHARACTER*20 XINPNAM,OUTNAM,NSPECNAM,GSPECNAM,EYRASTNAM,lilname,life
     &     ,OYRASTNAM,levname
      CHARACTER*12 PRNAM
CE
      DATA IBLANK,NULL/' ','0'/
      DATA IPLUS,MINUS/'+','-'/
      
CSMS Initialisation of previously uninitialised variables
      ICOUNTEB=0
      
      call init_vasym
CSMS9752        II=SYS$SETPRN('CASC_STAGE1')
CSMS    IF(II.EQ.1)GOTO 9751
CSMS    IF(IZU.NE.1)THEN
CSMS9753                N=N+1
CSMS            ENCODE(12,9754,PRNAM)N
CSMS9754                FORMAT('JOB ',I2,' CWAIT')
CSMS            II=SYS$SETPRN(PRNAM)
CSMS            IF(II.NE.1)THEN
CSMS                    IF(N.LT.20)GOTO 9753
CSMS                    STOP 'TO MANY JOBS !'   
CSMS            ENDIF
CSMS            IZU=1
CSMS    ENDIF
CSMS    CALL SCHLAF(10)
CSMS    GOTO 9752
CSMS9751        II=LIB$GET_FOREIGN(XINPNAM,,ICHANZ)
CSMS    IF(ICHANZ.GT.1)GOTO 7249
      WRITE(6,17249)
17249 FORMAT(' Enter input data file name :'$)
      READ(5,17250,END=8462)XINPNAM
17250 FORMAT(A)
 7249 OPEN(UNIT=5,NAME=XINPNAM,READONLY,TYPE='OLD')
      OUTNAM(1:20)=XINPNAM(1:20)
      DO JIP=1,17
        IF(XINPNAM(JIP:JIP).EQ.'.'.OR.XINPNAM(
     &       JIP:JIP).EQ.' ')THEN
          JIPO=JIP+1
          GOTO 8798
        ENDIF
      ENDDO
 8798 OUTNAM(JIPO:(JIPO+2))='CSO'
      OPEN(UNIT=6,NAME=OUTNAM,TYPE='NEW')
      outnam(jipo:(jipo+2))='fis'
      open(unit=25,file=outnam,type='new',form='unformatted')
      GSPECNAM(1:20)=XINPNAM(1:20)
      GSPECNAM(JIPO:(JIPO+2))='GAM'
      NSPECNAM(1:20)=XINPNAM(1:20)
      NSPECNAM(JIPO:(JIPO+2))='NEU'
      EYRASTNAM(1:20)=XINPNAM(1:20)
      EYRASTNAM(JIPO:(JIPO+2))='YRE'
      OYRASTNAM(1:20)=XINPNAM(1:20)
      OYRASTNAM(JIPO:(JIPO+2))='YRO'
      lilname(1:20)=XINPNAM(1:20)
      lilname(JIPO:(JIPO+2))='PRE'
      open(unit=65,file=lilname,type='new')
      life(1:20)=XINPNAM(1:20)
      life(JIPO:(JIPO+3))='life'
      open(unit=67,file=life,type='new')
      levname(1:20)=XINPNAM(1:20)
      levname(JIPO:(JIPO+2))='den'
      open(unit=42,file=levname,type='new')
      OPEN(UNIT=56,FILE=GSPECNAM,TYPE='NEW')
      OPEN(UNIT=57,FILE=NSPECNAM,TYPE='NEW')
      WRITE(56,*)' SET WINDOW X 1 OF 1'
      WRITE(56,5655)XINPNAM(1:(JIPO-1))
 5655 FORMAT(' TITLE TOP ',1H','GAMMA SPECTRUM CASCADE : ',A,1H')
      WRITE(56,*)' SET SCALE Y LOGARITHMIC'
      WRITE(56,5656)
 5656 FORMAT(' TITLE BOTTOM  ANGLE 0 ',1H','E [MEV]',1H')
      WRITE(56,5657)
 5657 FORMAT(' TITLE  LEFT ANGLE 90 ',1H','YIELD [MB]',1H')
      WRITE(56,*)' SET SYMBOL 4P'
      WRITE(56,*)' SET LIMITS X FROM 0. TO 30.'
      WRITE(56,*)' SET ORDER X Y'
      WRITE(57,*)' SET WINDOW X 1 OF 1'
      WRITE(57,56551)XINPNAM(1:(JIPO-1))
56551 FORMAT(' TITLE TOP ',1H','NEUTRON SPECTRUM CASCADE : ',A,1H')
      WRITE(57,*)' SET SCALE Y LOGARITHMIC'
      WRITE(57,56561)
56561 FORMAT(' TITLE BOTTOM  ANGLE 0 ',1H','E [MEV]',1H')
      WRITE(57,5657)
56571 FORMAT(' TITLE  LEFT ANGLE 90 ',1H','YIELD [MB]',1H')
      WRITE(57,*)' SET SYMBOL 4P'
      WRITE(57,*)' SET LIMITS X FROM 0. TO 30.'
      WRITE(57,*)' SET ORDER X Y'
      WRITE(6,84345)XINPNAM
84345 FORMAT(' ',132('*')//30X,'---> ASYMMETRIC FISSION CASCADE <-----' 
     &     /30X,' INPUT FILE : ',A//' ',132('_')////)
CSMS    OPEN(UNIT=10,NAME='CASCADEDIR:CASMAS',READONLY,TYPE='OLD',FORM='
CSMS    1UNFORMATTED',shared)
CSMS    OPEN(UNIT=11,NAME='CASCADEDIR:CASTRANS',TYPE='OLD',READONLY,FORM='
CSMS    1UNFORMATTED',shared)
CSMS      OPEN(UNIT=10,NAME='casmas.asc',TYPE='OLD')
      include 'fiscascade.casmas'
CSMS    OPEN(UNIT=11,NAME='castrans.asc',TYPE='OLD')
CSMS      OPEN(UNIT=11,NAME='castrans.sun',TYPE='OLD',FORM='unformatted',
CSMS     &     RECL=26644,ACCESS='DIRECT')
      include 'fiscascade.castrans'
CSMS        OPEN(UNIT=11,NAME='tl.dat',TYPE='old',FORM='unformatted',
CSMS     &       access='direct',recl=8192)
      OPEN(UNIT=13,NAME='CASWEIT',TYPE='NEW',FORM='UNFORMATTED'
     &     ,DISPOSE='DELETE',ACCESS='DIRECT',RECL=16384)
      OPEN(UNIT=14,NAME='CASCLEAN',TYPE='NEW',FORM='UNFORMATTED'
     &     ,DISPOSE='DELETE',ACCESS='DIRECT',RECL=16384)
      INRHOP = MINUS
      INLEVL = MINUS
      IZE(1) = 0
      IZE(2) = 1
      IZE(3) = 2
      IAE(1) = 1
      IAE(2) = 1
      IAE(3) = 4
      JE(1) = 1
      JE(2) = 1
      JE(3) = 0
      EBE(1) = 0.
      EBE(2) = 0.
      EBE(3) = 28.297
      MPOL (1) = 2
      MPOL (5) = 2
      MPOL (2) = 1
      MPOL (3) = 1
      MPOL (4) = 1
      JDIAG(1) = 1
      DO 5  JT1=2,48
 5    JDIAG(JT1) = JDIAG(JT1-1) + JT1
CE
CE
CE    INPUT
 19   READ(5,20,END=8462) ITEXT
      READ (5,*,END=8462,ERR=8643) IZP,IAP,IZT,IAT,ELAB,UXOFET
      IF (IAT.EQ.0) GO TO 1000
      
      READ (5,*,END=8462) JP,JT,IP12,JCN
      if(jcn.lt.0)read(5,*)widwid ! gaussian distribution in j
      READ (5,*,END=8462) KOPTK,IPS1,IPSMAX,NNX,NPX,NAX
      READ (5,*,END=8462) IZE(4),IAE(4),JE(4),IZFF,DAF,FFB,SIERK,
     &     VSADOFF
      vsadoff = 0               !force
      if( daf .le. 0 ) then
        daf = 8.0
        write(6,*) ' daf set to ',daf
      endif
      dafis = daf
      iafmax = float(iap+iat)/2.
      izfindxmax = 4
      izfindxoff = -3
      IF(SIERK.NE.0) FFB=1.0
      READ (5,*,END=8462) CL0,DIFF,SIGMCN
      IF( SIGMCN .LT. 0 ) THEN
        SIGMCN = ABS(SIGMCN)
        READ(5,*) TLGAUSSC,TLGAUSSW,tlgaussoff
        WRITE(6,*) 'GAUSSIAN added to Tl with sig,wid,offset=',
     &       tlgaussc,tlgaussw, tlgaussoff
      ENDIF
      write(6,*) '     cl0    diff  sigmcn  dafis  iafmax zxoff zxmax'
      write(6,'(4f8.2,i8,2i6)') cl0,diff,sigmcn,dafis,iafmax,
     &     izfindxoff,izfindxmax
      if( cl0 .le. 0 .and. sigmcn .le. 0.and.jcn.eq.0 ) then
        ACN = IAP + IAT
        ECM = ELAB*IAT/ACN
        
        call fndfusion(izp,iap,izt,iat,ecm,sigmcn,spinfus)
        write(6,*) 'total fusion cross section set to: ',sigmcn
      endif
      sigfus = sigmcn
      READ (5,*,END=8462) FTHETA,KOPTLD
      READ (5,*,END=8462) DALDM,UTR,ULDM,UJTR,UJLDM,KOPTLQ,KOPTEB
      READ (5,*,END=8462) R0LDM,DEF,DEFS
      IF(R0LDM.LT.0.)THEN
        R0LDM=0.
        ISPECOPT=1
        READ(5,*,END=8462)JNOD,OFFEV,OFFODD,TRAMO
        cj = jnod+1
        YRE=YRASTLINE(cj,2)
        YRO=YRASTLINE(cj,1)
        IF(YRE.LT.1..OR.YRE.GT.100.)STOP 'INVALID YRAST LINE OPTION'
        XJNOD=JNOD+1
        XJNODP=(2.*xjNOD+1)/TRAMO
        CSPLIEV=2.*YRE/XJNOD+XJNODP
        CSPLIOD=2.*YRO/XJNOD+XJNODP
        DSPLIEV=(XJNODP-YRE/XJNOD)/XJNOD
        DSPLIOD=(XJNODP-YRO/XJNOD)/XJNOD
        OPEN(UNIT=58,FILE=EYRASTNAM,STATUS='NEW')
        OPEN(UNIT=59,FILE=OYRASTNAM,STATUS='NEW')
        XXCL0=CL0
        IF(XXCL0.LT.1.)XXCL0=50
        DO KYR=1,XXCL0
          fkyr = kyr
          EYE=YRASTLINE(fKYR,2)
          EYO=YRASTLINE(FKYR,1)
          XYKYR=KYR
csilent         WRITE(6,8466)KYR,EYE,EYO
          WRITE(58,*)XYKYR,EYE
          WRITE(59,*)XYKYR,EYO
 8466     FORMAT(' ------------------------------------------------------'/
     &         ' J = ',I3,'   EYRAST (EVEN) = ',F,'  EYRAST (ODD) = ',F,/
     &         ' ------------------------------------------------------')
        ENDDO
        CLOSE(UNIT=58)
        CLOSE(UNIT=59)
      ENDIF
      READ (5,*,END=8462) XYE1,XYM1,XYE2, CJG1,CJG2,XYENH,GMIN
      IF(XYE1.LT.0.)THEN
        XYE1=0.
        IGIANT=1
        READ(5,*)DIPOLE,DIPOLW,DIPOLS
        IF(DIPOLS.EQ.0.)DIPOLS=1.
      ENDIF
      IF(XYENH.LT.0.)THEN
        IF(ISPECOPT.NE.1)STOP 'SPECIAL YRASTLINE UNDEFINED !'
        XYENH=-XYENH
        READ(5,*,END=8462)E2BANDPAR
        IENE2BAND=1
      ENDIF
      READ (5,*,END=8462) WGR,CGR,CVCBE,CVCB,VK,CVK
      READ (5,*,END=8462) EXR0,EXH,CJC,LCO
      READ (5,*,END=8462) KOUTW,KOUTL,KEVAP,KGAMMA,i2dpop
CSILENT      WRITE(6,*)'IZP,IAP,IZT,IAT,ELAB,JP,JT,IP12,JCN'   
CSILENT      WRITE(6,*) IZP,IAP,IZT,IAT,ELAB,JP,JT,IP12,JCN
CSILENT      if(jcn.lt.0)then
CSILENT        write(6,*)' Gaussian distribution in Jcn, width :'
CSILENT        write(6,*)widwid
CSILENT      endif
CSILENT      WRITE(6,*)'KOPTK,IPS1,IPSMAX,NNX,NPX,NAX,IZE,IAE,JE,IZFF,
CSILENT     &     DAF,FFB,SIERK,VSADOFF'
CSILENT      WRITE(6,*)KOPTK,IPS1,IPSMAX,NNX,NPX,NAX,IZE,IAE,JE,IZFF,DAF,FFB,SIERK,
CSILENT     &     VSADOFF
CSILENT      WRITE(6,*)'CL0,DIFF,SIGMCN,FTHETA,KOPTLD,DALDM,UTR,ULDM,UJTR'
CSILENT      WRITE(6,*)CL0,DIFF,SIGMCN,FTHETA,KOPTLD,DALDM,UTR,ULDM,UJTR
CSILENT      WRITE(6,*)'UJLDM,KOPTLQ,KOPTEB,R0LDM,DEF,DEFS,XYE1,XYM1,XYE2'
CSILENT      WRITE(6,*)UJLDM,KOPTLQ,KOPTEB,R0LDM,DEF,DEFS,XYE1,XYM1,XYE2
CSILENT      WRITE(6,*)'CJG1,CJG2,XYENH,GMIN,WGR,CGR,CVCBE,CVCB,VK,CVK,EXR0'
CSILENT      WRITE(6,*)CJG1,CJG2,XYENH,GMIN,WGR,CGR,CVCBE,CVCB,VK,CVK,EXR0
CSILENT      WRITE(6,*)'EXH,CJC,LCO,KOUTW,KOUTL,KEVAP,KGAMMA,i2dpop'
CSILENT      WRITE(6,*)EXH,CJC,LCO,KOUTW,KOUTL,KEVAP,KGAMMA,i2dpop
c
      if(i2dpop.eq.1)open(unit=28,file='i2dpop.dat',status='new',
     &     form='unformatted')
CE    ADDITIONAL INPUT IN KASKAD AND STATEMENTS 47,48,483
 20   FORMAT (80A1)
 21   FORMAT (4I5,2F10.5)
 22   FORMAT (6I5)
 23   FORMAT (5F10.5,2I5,F10.5)
 24   FORMAT (3F10.5,I5)
 25   FORMAT (F10.5,I5)
 26   FORMAT (7F10.5)
CE
CE
CE    DEFAULT VALUES AND DERIVED PARAMETERS
      IZCN = IZP + IZT
      IACN = IAP + IAT
      ACN  = IACN
      EXCN = 0.
      IF (IAP.NE.0 .OR.  JCN.EQ.0) GO TO 28
      EXCN = ELAB
      ELAB = 0.
 28   IF (2*(IAP/2).NE.IAP .AND. 2*(JP/2).EQ.JP) JP = JP + 1
      IF (2*(IAT/2).NE.IAT .AND. 2*(JT/2).EQ.JT) JT = JT + 1
      IF (2*(IAP/2).EQ.IAP) JP = 2*JP
      IF (2*(IAT/2).EQ.IAT) JT = 2*JT
      IF (2*(IAE(4)/2).EQ.IAE(4)) JE(4) = 2 * JE(4)
      IF (IP12.GT.2 .OR. IP12.LT.0) IP12 = 0
      IZFMAX = 3
      IF (IAE(4).NE.0) IZFMAX = 4
      DO 282  IZF=1,IZFMAX
 282  JDE(IZF) = JE(IZF) - 2*(JE(IZF)/2)
      IF (FFB.LE.0.01) FFB = 1.
CE    DAF IS SET AFTER DALDM IN LQPARM
      ARED = IAT*IAP/ACN
      ECM = ELAB*IAT/ACN
      if( iap .ne. 0 .and. ecm .gt. 0 ) then
        csl = 655.17/(ared*ecm)
        if( jcn .eq. 0 ) then
          if( cl0 .le. 0.01 .and. sigmcn .gt. 0.01) then
            cl0 = sqrt(sigmcn/csl) - 0.5
            write(6,*) ' cl0 (set by sigmcn and csl) = ',cl0
          endif
          if( abs(cl0) .lt. 0.01) then
            CL0 = CLFUS(IZP,IAP,IZT,IAT,ELAB)
            write(6,*) ' cl0 (set by call to clfus) = ',cl0
          endif
        endif
      else if (jcn .eq. 0 .and. abs(cl0) .lt. 0.01) then        
        write(6,*) ' iap equals zero and cl0 therefore set to 10'
        CL0 = 10.
      endif
      IF (DIFF.LE.0.1) DIFF = 2.
      JCR = LCO
      IF (JCR.GT.0) GO TO 284
      JCR = CL0 + 9.*DIFF
      
      IF (JCN.GT.0) JCR = MAX0(12,JCN+4)
 284  DO 286  IPS=1,500
 286  FT(IPS) = FTHETA
CE    DEFAULT VALUES FOR LEVEL DENS. PARAMETERS IN LQPARM, LDPARM
      ALPHA2 = 0.
      XIMIN = 1.E-15
      IF (XYE1.LE.XIMIN) XYE1 = 1.E-4
      IF (XYM1.LE.XIMIN) XYM1 = 3.E-2
      IF (XYE2.LE.XIMIN) XYE2 = 5.
      XIE1 = XYE1 * 0.62E-6 * ACN**(2./3.)
      XIM1 = XYM1 * 1.16E-7
      XIE2 = XYE2 * 0.67E-12 * ACN**(4./3.)
CSJS      IF (GMIN.LT.0.001) GMIN = 10.
      IF (GMIN.LT.0.001) GMIN = 1.
      GXMIN = GMIN * (XIE1+XIM1+XIE2)
      RHOGR = 0.28
      IF (WGR.LT.0.00000001) WGR = 0.001
      IF (CGR.LT.0.00000001) CGR = WGR/4.
      WQGR = 50. * WGR
      IF (CVCBE.LT.0.01) CVCBE = 0.3
      IF (CVCB.LT.0.01) CVCB = 0.04
      IF (CVK.LT.0.01) CVK = 0.05
      IF (EXR0.LE.19.) EXR0 = 32.
      IF (EXH.LE.0.1) EXH = 30.
      IF (CJC.LE.0.1) CJC = ACN/20.
      JC = CJC + .5
      IF (JC.LE.4) JC = 4
      IF (KOUTW.EQ.0) KOUTW = 100
      IF (KOUTL.EQ.0) KOUTL = 1000
      IF (KEVAP.EQ.0) KEVAP = 1000
      EMINT(4) = 0.
CE
CE    MASS TABLE FROM DISC
      REWIND 10
      DO 29  K=1,18
        IZZMAX = 8 * K
        IZZMIN = IZZMAX - 7
C        WRITE(6,6001) K
C 6001   FORMAT(' READING THE MASSES AT K= ',I5)
        
 29   READ (10,*) ((EB(NN,IZZ),NN=1,128),IZZ=IZZMIN,IZZMAX)
CE
CE    4. DECAY

      DO 291  IZF=1,3
 291  EBC(IZF) = 0.
      IF (IZFMAX.EQ.3) GO TO 292
      CALL EXCORR (EBC)
      IZZ = IZE(4)
      N = IAE(4) - IZZ
      NN = N + 1 - NPDRIP(IZZ)
      EBE(4) = EB(NN,IZZ)
 292  CONTINUE
CE
CE    CN EXCITATION ENERGY
      IF (EXCN.GT.0.01) GO TO 295
      NCN = IACN - IZCN
      NP = IAP - IZP
      NT = IAT - IZT
      
c
c       CODE ADDED FOR TETRA- AND PENTANEUTRON PROJECTILES
c       --------------------------------------------------
c               30-apr-87     sjs
c       
      if (izp .gt. 0 ) then
        nnp = np + 1 - npdrip(izp)
        ebproj = eb(nnp,izp)
      else
        if ( np .eq. 4 ) then
          ebproj = -32.284
        else if ( np .eq. 5 ) then
          ebproj = -40.355
        else
          write(6,*) 'error in setting neutron cluster binding energy'
        endif
      endif
      
c       ................................................
      
      NNP = NP + 1 - NPDRIP(IZP)
      NNT = NT + 1 - NPDRIP(IZT)
      NNCN= NCN+ 1 - NPDRIP(IZCN)
      QCN = EB(NNCN,IZCN) - EB(NNT,IZT) - EB(NNP,IZP)
      EXCN = ECM + QCN
 295  CONTINUE
      EXPOFET=EXP(-UXOFET)
CE
CE    STRUCTURE OF THE DECAY CASCADE
CE    KOPTK = NUMBER OF DECAY STEPS
      IF (KOPTK.EQ.1) GO TO 298
      IF (KOPTK.GT.1) GO TO 297
      KOPTK = EXCN/12. + 0.5
      IF (KOPTK.LT.5) KOPTK = 5
 297  IF (NNX.LE.0) NNX = MIN0(12,KOPTK)
      IF (NPX.LE.0) NPX = MIN0(10,KOPTK)
      IF (NAX.LE.0) NAX = MIN0(10,KOPTK)
 298  CALL KASKAD (KOPTK,NNX,NPX,NAX)
      ITMAX = 200
CE
CE    MASS AND ATOMIC NUMBERS OF THE NUCLEI IN THE DECAY CASCADE
      DO 302  IPS=1,IPSMAX
        IZ(IPS) = 0
 302  IA(IPS) = 0
      IZ(1) = IZCN
      IA(1) = IACN
      DO 31  IPS=1,IPS1
        IZF = 0
        IF (IZ(IPS).EQ.0) WRITE(6,304) IPS,IZF
        DO 31  IZF=1,IZFMAX
          IPSZF = IPSZO(IZF,IPS)
          IF (IPSZF.EQ.0) GO TO 31
          IZZ = IZ(IPSZF)
          IAA = IA(IPSZF)
          IZ(IPSZF) = IZ(IPS) - IZE(IZF)
          IA(IPSZF) = IA(IPS) - IAE(IZF)
          IF (IZZ.NE.0 .AND. (IZZ.NE.IZ(IPSZF) .OR. IAA.NE.IA(IPSZF)))
     1         WRITE(6,304) IPS,IZF
 304      FORMAT (' ***INCONSISTENCY OF THE CASCADE AT IPS,IZF =',2I3)
 31   CONTINUE
CE
CE    SEPARATION ENERGIES
      DO 37  IPS=1,IPSMAX
        DO 32  IZF=1,4
 32     ESEP(IZF,IPS) = 0.
        IZZ = IZ(IPS)
        IAA = IA(IPS)
        N = IAA - IZZ
        NN = N + 1 - NPDRIP(IZZ)
        EB1 = 0.
        IF (NN.GT.0 .AND. NN.LE.128) EB1=EB(NN,IZZ)
        IF (EB1.LT.0.1) WRITE(6,33)IZZ,IAA
 33     FORMAT (' ***MASS MISSING FOR IZ, IA =',2I5)
 34     DO 37  IZF=1,IZFMAX
          IPSZF = IPSZO(IZF,IPS)
          IZZ = IZ(IPS) - IZE(IZF)
          IAA = IA(IPS) - IAE(IZF)
          N = IAA - IZZ
          NN = N + 1 - NPDRIP(IZZ)
          EB2 = 0.
          IF (NN.GT.0 .AND. NN.LE.128) EB2=EB(NN,IZZ)
          IF (EB2.LT.0.1) WRITE(6,33)IZZ,IAA
          ESEP(IZF,IPS) = EB1 - EB2 - EBE(IZF)
          IF (EB2.LT.0.1 .AND. IPSZF.GT.IPS1) ESEP(IZF,IPS) = 20.
 37   CONTINUE
CE
CE
CE    EXCITATION ENERGY RANGES
      EXMAX(1) = EXCN
      DO 38  IPS=2,IPSMAX
 38   EXMAX(IPS) = -1000.
      DO 40 IPS=1,IPS1
        DO 40  IZF=1,3
          IPSZF = IPSZO(IZF,IPS)
          IF (IPSZF.EQ.0) GO TO 40
          EX = EXMAX(IPSZF)
          EXMAX(IPSZF) = EXMAX(IPS) - ESEP(IZF,IPS) - 0.5 + EBC(IZF)
          IF (EX.GT.-1000. .AND. ABS(EXMAX(IPSZF)-EX).GT.0.1) WRITE(6,39)
     1         IPS,IPSZF,EX,EXMAX(IPSZF)
 39       FORMAT (' ***INCONSISTENCY OF BINDING ENERGIES, IPS,IPSZF,EX,EX ',
     1         2I3,2F8.2)
 40   CONTINUE
CE
      VCBE = CVCBE* IZCN/(ACN**0.33333)
      IF (VK.LT.0.01) VK = EXCN/100.
cgamma
      wq(1) = 64
cgamma
      DO 41  IPS=2,IPSMAX
        ZD = IZCN - IZ(IPS)
        VCBX  = (ZD+CVCB*ZD*ZD)*VCBE
        X  = (EXCN-EXMAX(IPS))/9.
        IF (X.LE.1) X = 1.
        XD = X - 1.5
        IF (XD.LT.0.) XD = 0.
        VKX = (XD+CVK*XD*XD) * VK
        V = VCBX + VKX
        EXR = EXR0 + (64.-EXR0)*(X-2.)/8.
        IF (EXR.LT.EXR0) EXR = EXR0
        IPSZF = IPSZO(3,1)
        IF (IPS.GE.IPSZF) EXR = EXR + 0.15*EXR0
        IF (IPS.GE.IPSZO(3,IPSZF)) EXR = EXR + 0.25*EXR0
        IF (EXR.GT.64.)  EXR = 64.
        WQ(IPS) = EXR
        VLX = (8. - (EXMAX(IPS)-EXR-V))/8.
        IF (VLX.LE.0.) VLX = 0.
        IF (VLX.GT.8.) VLX = 8.
        IF (VLX.GT.0.5*V) VLX = 0.5 * V
        IV = V + VLX + 0.5
        EXMAX(IPS) = EXMAX(IPS) - IV
 41   CONTINUE
CE
cgamma      DO 43  IPS=2,IPSMAX
      do 43 ips = 1,ipsmax
        EXMIN(IPS) = EXMAX(IPS) - 64.
        IEXXMX(IPS) = 64
        IF (EXMIN(IPS).GT.-1.5) GO TO 43
        I = 0
 42     I = I + 1
        EX = EXMIN(IPS) + I
        IF (EX.LE.-1.5) GO TO 42
        EXMIN(IPS) = EXMIN(IPS) + I
        IEXXMX(IPS) = IEXXMX(IPS) - I
 43   CONTINUE
CE
CE    APPROXIMATE PARTICLE THRESHOLDS FOR NUCLEI
CE    OF THE LAST DECAY STEP
      IPS = IPSZO(3,1)
      IPS = IPSZO(3,IPS)
      IF (IPS.LE.0) IPS = 1
      CALL TSUMME (IPS,EMINT,1)
      IPS11 = IPS1 + 1
      DO 45  IPS=IPS11,IPSMAX
        ESMIN = 100.
        DO 44  IZF=1,3
          ESZF = ESEP(IZF,IPS) + EMINT(IZF)
          IF (ESZF.LT.ESMIN) ESMIN = ESZF
 44     CONTINUE
        IEXXSS = ESMIN - EXMIN(IPS) + 0.1
        IF (IEXXSS.LE.1) IEXXSS = 1
        IF (IEXXSS.GT.IEXXMX(IPS)) IEXXSS = IEXXMX(IPS) + 1
 45   IEXXS(IPS) = IEXXSS
      write(6,*) ' ips exmin(ips)  exmax(ips)  iexxmx(ips)  iexxss'
      do ips = 1,ipsmax
        write(6,'(i5,2f10.3,2i10)') 
     &       ips,exmin(ips),exmax(ips),iexxmx(ips),iexxss
      enddo
CE
CE    LOWER LIMITS IEXXL(IPS)
cgamma      DO 46  IPS=2,IPSMAX
      do 46 ips = 1,ipsmax
        IEXR = WQ(IPS) + .5
        IEXR = IEXR - 1
        IEXXL(IPS) = EXMAX(IPS) - IEXR + 0.5 - EXMIN(IPS)
        IF (IEXXL(IPS).LE.1) IEXXL(IPS) = 1
 46   CONTINUE
CE
cgamma      EXMIN(1) = EXMAX(1) - 1.
cgamma      IEXXMX(1) = 1
cgamma      IEXXS (1) = 1
cgamma      IEXXL (1) = 1
CE
CE
CE
CE    LEVEL DENSITY PARAMETERS
      CALL LDPARM(KOPTLD)
      IF (KOPTLQ.EQ.5) GO TO 47
      CALL LQPARM (KOPTLQ,KOPTEB,ALPHA2)
CE    INPUT OF INDIVIDUAL LEVEL DENSITY PARAMETERS
c       WRITE(6,5000)
c5000   FORMAT(' READING IN LEVEL DENSITIES')
 47   READ (5,471,END=8462) IZZ,IAA,CLV
c       WRITE(6,5001) IZZ,IAA,CLV
c5001   FORMAT(' LEV. DENS. ',2I5,4F10.3)
 471  FORMAT (2I5,4F10.3)
      IF (IZZ.EQ.0) GO TO 476
      DO 475  IPS=1,IPSMAX
        IF (IZZ.EQ.IZ(IPS) .AND. IAA.EQ.IA(IPS)) GO TO 473
        NN = IAA - IZZ
        IF (NN .EQ.IZ(IPS) .AND. IAA.EQ.IA(IPS)) GO TO 473
        GO TO 475
 473    DA(IPS)   = CLV(1)
        DELTA(IPS)= CLV(2)
        FT(IPS) = CLV(3)
        CK(IPS) = CLV(4)
        INRHOP = IPLUS
 475  CONTINUE
      GO TO 47
CE
CE    INPUT OF LEVELS
 476  DO 478  IPSLV=1,100
 478  LVMAX(IPSLV) = 0
      IPSLV = 1
c       WRITE(6,5002)
c5002   FORMAT(' READING IN LEVELS')
 48   READ (5,481,END=8462) IZZ,IAA,EX
c       WRITE(6,5003) IZZ,IAA,EX
c5003   FORMAT(' LEVELS ARE',2I5,F10.3)
 481  FORMAT (2I5,F10.3)
      IF (IZZ.EQ.0) GO TO 49
      DO 482  IPS=1,IPSMAX
C       WRITE(6,*)'IAA,IA(IPS),IZZ,IZ(IPS),IEXXMX(IPS),IPSLV'
C       WRITE(6,1) IAA,IA(IPS),IZ(IPS),IEXXMX(IPS),IPSLV
 1      FORMAT(5I10)
        IF (IAA.EQ.IA(IPS) .AND. (IZZ.EQ.IZ(IPS) .OR. IAA-IZZ.EQ.IZ(IPS))
     1       .AND. IEXXMX(IPS).GT.0 .AND. IPSLV.LT.100) GO TO 484
 482  CONTINUE
 483  continue
c       WRITE(6,1001)
c1001   FORMAT(' READING EX.,SPIN AND PARITY 1 SET')
      READ (5,486,END=8462) EX,J,IP
c       WRITE(6,5004) EX,J,IP
c5004   FORMAT(' EX,J,IP',7(F8.3,I2,A1))
      IF (IP.EQ.IBLANK .OR. IP.EQ.NULL) GO TO 48
      GO TO 483
 484  IPSLV = IPSLV + 1
      IZLV(IPSLV) = IZZ
      IALV(IPSLV) = IAA
      EXLVX(IPSLV) = EX
      LVMAX(IPSLV) = 0
 485  continue
c       WRITE(6,5009)
c5009   FORMAT(' READING IN EX SPIN AND PARITY 7 SETS')
      READ (5,486,END=8462) (EXL(I),JL(I),IPL(I),I=1,7)
c       WRITE(6,5004)(EXL(I),JL(I),IPL(I),I=1,7)
 486  FORMAT (7(F7.3,I2,A1))
      IF (IPL(1).EQ.IBLANK .OR. IPL(1).EQ.NULL) GO TO 48
      DO 487  I=1,7
        IF (IPL(I).EQ.IBLANK .OR. IPL(I).EQ.NULL) GO TO 487
        LV = LVMAX(IPSLV) + 1
        IF (LV.GT.100) GO TO 485
        LVMAX(IPSLV) = LV
        EXLV(LV,IPSLV) = EXL(I)
        JLV (LV,IPSLV) = JL(I)
        IF (2*(IAA/2).NE.IAA)  JLV(LV,IPSLV) = JL(I)/2
 487  CONTINUE
      GO TO 485
 49   IPSLVX = IPSLV
CE
CE    SPIN RANGE
      DO 50  IPS=1,IPSMAX
        JMAX(IPS)=YRASTL(EXMAX(IPS),iz(ips),IA(IPS),
     &       DLDM(IPS),R0LDM,DEF,DEFS,JCR,
     &       ISPECOPT,ips)
        JMIN(IPS) = JMAX(IPS) - 64
        IF (JMIN(IPS).LT.0) JMIN(IPS) = -1
 50   JJMAX(IPS) = JMAX(IPS) - JMIN(IPS)
      IF (JCN.EQ.0) GO TO 51
      IF (JMAX(1).GE.JCN) GO TO 51
      JMAX(1) = JCN
      JMIN(1) = JCN - 64
      IF (JMIN(1).LT.0) JMIN(1) = -1
      JJMAX(1) = JCN - JMIN(1)
 51   CONTINUE
CE
CE
CE
CE    COMPOUND NUCLEUS POPULATION
      DO 55  JJ=1,64
        DO 55  IEXX=1,64
 55   WT0(IEXX,JJ) = 0.
      SCN(1) = 0.
      SCN(2) = 0.
      IF (JCN.EQ.0) GO TO 59
      if(jcn.lt.0)then          ! gaussian distribution
        jcn=-jcn
        do 72055 kabc=1,64
          jj=kabc+jmin(1)
          croscros=1000.*exp(-float(jcn-jj)**2/widwid)
          wt0(iexxmx(1),kabc)=croscros
72055   scn(1)=scn(1)+croscros
      endif
      JJ = JCN - JMIN(1)
      WT0(iexxmx(1),JJ) = 1000.
      SCN(1) = 1000.
      GO TO 63
 59   JSU = IABS(JP-JT)
      JSO = JP + JT
      L1D = 1
      IF (IP12.EQ.2) L1D = 2
      JJX = 64
      write(6,*) '    l     txhold      tx'
      DO 61  JJ=1,JJX
        JC2 = 2*(JMIN(1)+JJ)
        IF (2*(IACN/2).NE.IACN) JC2 = JC2+1
        CJ = JC2 + 1.
        I = 1
        IF (JJ.GT.JJMAX(1)) I = 2
        DO 61  JS=JSU,JSO,2
          L1MIN = IABS(JC2-JS)/2 + 1
          L1MAX = (JC2+JS)/2 + 1
          IF (IP12.EQ.2 .AND. 2*(L1MIN/2).EQ.L1MIN) L1MIN = L1MIN + 1
          DO 60  L1=L1MIN,L1MAX,L1D
            CL = L1 - 1
            X = (CL-CL0)/DIFF
            E = 0.
            IF (ABS(X).LE.170.) THEN
              E = EXP(X)
            else
              write(6,*) '****warning exp out of range 170'
            endif
            TX = CJ/(1.+E)
CSJS    ADDITION OF GAUSSIAN
c       x = (cl-cl0-tlgaussoff)/tlgaussw
c       txhold = tx
c       if( abs(x) .lt. 6*tlgaussw)
c       1       TX = TX + TLGAUSSC*SIGMCN*EXP(-x**2/2.)/(2.506*TLGAUSSW)
c       write(6,*) cl,txhold,tx
c       csl = 1
c       tx = 0
c       if( abs(cl - tlgaussoff).lt. 0.5 ) tx = 100
            WT0(iexxmx(1),JJ) = WT0(iexxmx(1),JJ) + TX
 60       SCN(I) = SCN(I) + TX
 61   CONTINUE
CE
      C1 = 1000./(SCN(1)+SCN(2))
      IF (IAP.EQ.0) GO TO 611
      C1 =CSL/((JP+1.)*(JT+1.))
      IF (IP12.EQ.2) C1 = 2.*C1
 611  SCN(1) = C1 * SCN(1)
      SCN(2) = C1 * SCN(2)
      DO 612  JJ=1,JJX
        WT0(iexxmx(1),JJ) = C1 * WT0(iexxmx(1),JJ)
 612  continue
 63   CONTINUE
CE
CE
CE    TRANSMISSION COEFFICIENTS FOR GAMMA DECAY
      DO 64  IEKIN=1,32
        EKIN = IEKIN
        EKIN3 = EKIN**3
        EKIN5 = EKIN**5
        IF(IGIANT.EQ.1)THEN
          AGIANT=IA(1)
          ZGIANT=IZ(1)
          GIANT=DIPOLS*6.2E-7*ACN**(2./3.)
     &         *.107*(AGIANT-ZGIANT)*ZGIANT/AGIANT*DIPOLW*EKIN**4
          TLG(IEKIN,1)=GIANT/((DIPOLW*EKIN)**2+(EKIN**2-DIPOLE**2)**2)+
     &         XIM1*EKIN3+XIE2*EKIN5
        ELSE
          TLG (IEKIN,1) = (XIE1+XIM1)*EKIN3 + XIE2 * EKIN5
        ENDIF
        TLG (IEKIN,2) = XIE2 * EKIN5
C      IF (IEKIN.LE.22) GO TO 64
C      C1 = 1. - (EKIN-22.)/10.
C      C1 = C1**4
C      TLG (IEKIN,1) = C1 * TLG (22,1)
C      TLG (IEKIN,2) = C1 * TLG (22,2)
 64   CONTINUE
      DO 65  J=1,100
 65   ENH(J) = 1.
      IF (XYENH.LE.0.1) GO TO 67
      C1 = (XYENH-XYE2)/(CJG2-CJG1)
      JU = CJG1 + 1.
      DO 66  J=JU,100
        ENH(J) = (XYE2+C1*(J-CJG1))/XYE2
        IF (J.GT.CJG2) ENH(J) = XYENH/XYE2
 66   CONTINUE
 67   CONTINUE
CE
CE
ccx      CALL RTABLE
ccx      REWIND 12
ccx      ITR = 1
CE
      DO 75  IT=1,200
 75   INHWT(IT) = 0
      REWIND 13
      ITP = 1
      IWL = 0
CE
      VWQ1 = 0.
      VWQ2 = 0.
      VWQ3 = 0.
      VWQ4 = 0.
      DO 80  IPS=1,IPSMAX
        WQF(IPS) = 0.
        WQT(IPS) = 0.
 80   WQ(IPS)  = 0.
      WQT(1) = SCN(1)
      DO 83  IZF=1,4
        DO 82  IEKIN=1,100
 82     SESUM (IEKIN,IZF) = 0.
 83   CONTINUE
      REWIND 11
 154  FORMAT ('1NUCLEI OF THE DECAY CASCADE',32X,50A1///
     1     ' IPS   IZ  IA    EX-RANGE (MIN,L,S,MAX)     J-RANGE   DAU',
     2     'GHTER NUCLEI    BINDING E(N,P,A,4)'/)
 157  FORMAT (1H ,I3,1X,2I4, 2X,4F6.1,2X,2F5.1,2X,4I4,2X,4F5.1)
CSILENT      WRITE(6,154) (ITEXT(I),I=1,50)
      DO 158  IPS=1,IPSMAX
        IAA = IA(IPS)
        E1 = EXMIN(IPS) + 1.
        E2 = EXMIN(IPS) + IEXXL(IPS)
        E3 = EXMIN(IPS) + IEXXS(IPS)
        E4 = EXMAX(IPS)
        CJ1 = JMIN(IPS) + 1
        CJ2 = JMAX(IPS)
        IF (2*(IAA/2).EQ.IAA) GO TO 158
        CJ1 = CJ1 + .5
        CJ2 = CJ2 + .5
 158  CONTINUE
CSILENT WRITE(6,157,err=1571) IPS,IZ(IPS),IAA, E1,E2,E3,E4,CJ1,CJ2,
CSILENT     1   (IPSZO(IZF,IPS),IZF=1,4),(ESEP(IZF,IPS),IZF=1,4)
 1571 continue
CSILENT      WRITE(6,153)
CE
CE
CE
CSILENT      WRITE(6,161) (ITEXT(I),I=1,50)
CSILENT      DO 177  IPS=1,IPSMAX
 176  CONTINUE
CSILENT WRITE(6,162) IPS,IZ(IPS),IA(IPS),
CSILENT     1   DA(IPS),DELTA(IPS),FT(IPS),UTR,UJTR,CK(IPS),KOPTLD,LVX,
CSILENT     2           DALDM,DLDM(IPS),R0LDM,ULDM,UJLDM,KOPTLQ
CSILENT177   CONTINUE
CE
CE
CE
CE    *****************************************************************
CE    *****************************************************************
      DO 140  IPS=1,IPS1
        
        IF (IEXXMX(IPS).LE.0) GO TO 140
        IF (IPS.EQ.1) then
          continue
        else
          CALL GETW(IPS,IT0)
          IF (IT0.EQ.0) GO TO 140
        endif
 84     IEXXX = IEXXMX(IPS)
        JJX = JJMAX(IPS)
        
        JD1 = 0
        IAA = IA(IPS)
        IF (2*(IAA/2).NE.IAA) JD1 = 1
CE
        CALL TSUMME (IPS,EMINT,0)
CE
CE    PARTICLE THRESHOLD
        ESMIN = 100.
        DO 85  IZF=1,IZFMAX
          IPSZF = IPSZO(IZF,IPS)
          EXZF0 = 0.
          IF (IPSZF.NE.0) EXZF0 = EXMIN(IPSZF) + 1.
          ESZF = ESEP(IZF,IPS) + EMINT(IZF) + EXZF0
          IF (ESZF.LT.ESMIN) ESMIN = ESZF
 85     CONTINUE
        IEXXSS = ESMIN + 0.1 - EXMIN(IPS)
        IF (IEXXSS.LE.1) IEXXSS = 1
        IF (IEXXSS.GT.IEXXX) IEXXSS = IEXXX + 1
        IF (KGAMMA.NE.0 .AND. IEXXSS.GE.2) IEXXSS = 2
        IEXXS(IPS) = IEXXSS
CE
        DO 86  JJ=1,JJX
          DO 86  IEXX=1,IEXXX
            LZ (IEXX,JJ) = 0
            LZF(IEXX,JJ) = 0
 86     WGZ(IEXX,JJ) = 0.
        IZFX = IZFMAX + 1
        DO 87  IZF=1,IZFX
          DO 87  IEKIN=1,100
 87     SE (IEKIN,IZF) = 0.
        DO 872  IZF=1,IZFMAX
 872    ICZF(IZF) = 0
CE
        IF (IEXXX.LT.IEXXSS) GO TO 126
CE
ccx      CALL GETRHO (IPS,ITR)
        call rtable(ips,ISPECOPT)
CE
        JJFMAX = 65
CSJS      IF (IZFF.NE.0) CALL FISSN(IPS,JJFMIN,JJFMAX,FFB)
CSJS BEG
        IF (IZFF.NE.0 .and. ips .eq. 1) 
     &       CALL FISSN(IPS,JJFMIN,JJFMAX,FFB,SIERK,VSADOFF)
CSJS END
CE
        DO 89 IZF=1,IZFMAX
          IPSZF = IPSZO(IZF,IPS)
          IF (IPSZF.EQ.0 .OR. IEXXMX(IPSZF).LE.0) GO TO 89
          ICZF(IZF) = 2
          DO 88  JJZF=1,64
            DO 88  IEXXZF=1,64
 88       WT(IEXXZF,JJZF,IZF) = 0.
 89     CONTINUE
CE
CE
CE    *****************************************************************
        IEXXCX = IEXXX - IEXXSS + 1
        DO 1252  IEXXC=1,IEXXCX
          IEXX = IEXXX - IEXXC + 1
          EX = EXMIN(IPS) + IEXX
CE
          JSTEP = 1
          IF (EX.GT.EXH) JSTEP = 2
          IF (EX.GT.2.*EXH) JSTEP = 3
          JJ = JJX + 1
          JJSTEP = 1
          JJC = 0
CE
CE    JJ-LOOP 90-125
 90       JJ = JJ - JJSTEP
          IF (JJ.LE.0) GO TO 125
          W0 = WT0(IEXX,JJ) + WGZ(IEXX,JJ)
cgamma
c       if(ips.eq.1) then
c          write(6,*) 'iexx,iexxx,iexxss,iexxcs=',
c       1       iexx,iexxx,iexxss,iexxcs
c          write(6,'(2i10,2e20.6)') iexx,jj,wt0(iexx,jj),wgz(iexx,jj)
c       endif
          IF (JJSTEP.EQ.1) GO TO 92
          C1 = 0.5
          IF (JJSTEP.EQ.3) C1 = 1.
          C2 = C1
          IF (JJC.EQ.JC .AND. JJSTEP.EQ.2) C1 = 1.
          W0 = W0 +  C1 * (WT0(IEXX,JJ+1) + WGZ(IEXX,JJ+1))
          IF (JJ.GT.1) W0 = W0 + C2*(WT0(IEXX,JJ-1) +  WGZ(IEXX,JJ-1))
 92       IF (W0.GE.JJSTEP*WGR) GO TO 95
          VWQ1 = VWQ1 + W0
          GO TO 90
 95       JJC = JJC + 1
          J = JMIN(IPS) + JJ
          J1 = 2*J + JD1
          ENHGAM = ENH(J+1)
CE
          DO 96  IZF=1,4
            ISUMW(IZF) = 0
 96       SUMW(IZF) = 0.
          WGAMMA = 0.
          WFISS  = 0.
          IF (IZFF.EQ.0 .or. ips .ne. 1) GO TO 97
          do iaf = 6,iafmax
            do izfindx = 1,izfindxmax
              WFISS = wfiss + WF (IEXX,JJ,iaf,izfindx)*EXPOFET
            enddo
          enddo
          IF (JJ.LE.JJFMAX) GO TO 97
          LZF(IEXX,JJ) = 9900
          WQF(IPS) = WQF(IPS) + W0
          GO TO 1248
 97       CONTINUE
CE
CE    PARTICLE DECAY
          DO 114  IZF=1,IZFMAX
            IF (ICZF(IZF).LE.0) GO TO 114
            IPSZF = IPSZO(IZF,IPS)
            EKINX = EX - ESEP(IZF,IPS) - EXMIN(IPSZF)
            EKINXD = EKINX - EMINT(IZF) + 1.1
            IH2 = EKINXD - 1.
            IH1 = IEXXL(IPSZF)
            IH3 = IEXXMX(IPSZF)
            IF (IH3.LE.IH2) IH2 = IH3
            IEXXXZ(IZF) = IH2
            IF (IH2.LT.IH1) GO TO 114
CE
            JTMAX = 32
            IF (IZF.GE.3) JTMAX = 48
            JX = 2*JTMAX - 2 + JDE(IZF)
            JD2 = JD1 + JDE(IZF)
            IF (JD2.EQ.2) JD2 = 0
            J2MIN = 2*JMIN(IPSZF) + JD2
            JJXZF = JJMAX(IPSZF)
            JJMZF = 1
            JJZF = (J1-JX-JD2)/2 - JMIN(IPSZF)
            IF (JJZF.GT.1) JJMZF = JJZF
            JJMINZ(IZF) = JJMZF
            JJZF = (J1+JX-JD2)/2 - JMIN(IPSZF)
            IF (JJZF.LE.JJXZF) JJXZF = JJZF
            JJXXXZ(IZF) = JJXZF
            IF (JJXZF.LT.JJMZF) GO TO 114
CE
            IELPMAX=32
            IF(IZF.GE.3) IELPMAX=48
            SUMWX = 0.
            DO 112 JJZF=JJMZF,JJXZF
              J2 = J2MIN + 2*JJZF
              JT1 = IABS(J1-J2)/2 + 1
              JT2 = (J1+J2)/2 + 1
              IF (JT2.GT.JTMAX) JT2 = JTMAX
              JTL = JDIAG(JT2) - JT2 + JT1
CE
              DO 112 IEXXZF=IH1,IH2
                WX = 0.
                RHOZ = RHO (IEXXZF,JJZF,IZF)
C            IF (RHOZ.LE.RHOGR) GO TO 107! REMOVE DUE TO OFFSET
                IF(RHOZ.LE.0.) GO TO 107
                IEKIN = EKINXD - IEXXZF
                IF (IEKIN.GT.IELPMAX) IEKIN = IELPMAX
                WX = RHOZ * TSUM(IEKIN,JTL,IZF)
                SUMWX = SUMWX + WX
 107            W(IEXXZF,JJZF,IZF) = WX
 112        CONTINUE
            ISUMW(IZF) = 1
            SUMW(IZF) = SUMWX
 114      CONTINUE
CE
CE    GAMMA DECAY
          IZF = IZFMAX + 1
          IF (IEXX.LE.1) GO TO 117
          IH5 = IEXX - 1
          IH4 = IH5 - 31
          IF (IH4.LE.0) IH4 = 1
          JJZFU = JJ - 2
          IF (JJZFU.LE.0) JJZFU = 1
          JJZFO = JJ + 2
          IF (JJZFO.GT.JJX) JJZFO = JJX
          DO 116 JJZF=JJZFU,JJZFO
            JD = JJ - JJZF + 3
            MP = MPOL(JD)
            DO 116 IEXXZF=IH4,IH5
              WX = 0.
              RHOZ = RHO (IEXXZF,JJZF,IZF)
              IF (RHOZ.LE.RHOGR) GO TO 115
              IEKIN = IEXX - IEXXZF
              E2BAND=1.
              IF(IENE2BAND.EQ.1)THEN
                IF(MP.EQ.2)THEN
                  cj = jj
                  cjzf = jjzf
CSMS Should this IA be IA(1) ???
                  IX=YRASTLINE(cj,IA)-YRASTLINE(cjZF,IAA)
                  IF(IX.EQ.IEKIN)E2BAND=E2BANDPAR
                  ICOUNTEB=ICOUNTEB+1
                ENDIF
              ENDIF
              WX = RHOZ * TLG (IEKIN,MP) * ENHGAM*E2BAND
              WGAMMA = WGAMMA + WX
 115          WG (IEXXZF,JD) = WX
 116      CONTINUE
CE
CE    NORMALIZATION CONSTANT AND RELATIVE DECAY WIDTHS
 117      RHOX = RHO (IEXX,JJ,IZFMAX+1)
          WX = RHOX * GXMIN * ENHGAM
          SUMWX = SUMW(1)+SUMW(2)+SUMW(3)+SUMW(4)+WGAMMA+WFISS
          CNORM = 1./(SUMWX+WX)
          ZW(1) = SUMW(1) * CNORM
          ZW(2) = SUMW(2) * CNORM
          ZW(3) = SUMW(3) * CNORM
          ZW(4) = SUMW(4) * CNORM
          ZW5   = WGAMMA  * CNORM
          ZW6   = WX      * CNORM
          ZW7   = WFISS   * CNORM
          wwn(iexx,jj) = zw(1)
          wwp(iexx,jj) = zw(2)
          wwg(iexx,jj) = zw5  
          wwa(iexx,jj) = zw(3)
          wwf(iexx,jj) = zw7
          IZW1 = ZW(1) * 99.4 + 0.5
          IZW2 = ZW(2) * 99.4 + 0.5
          IZW3 = ZW(3) * 99.4 + 0.5
          IZW4 = ZW(4) * 99.4 + 0.5
          IZW5 = ZW5   * 99.4 + 0.5
          IZW7 = ZW7   * 99.4 + 0.5
          IZW8 = 0
          IZW9 = 0
          IF (KOUTL.GE.0) GO TO 1205
CE    LIFETIMES
          TAU = 1.E-38
          IF (SUMWX.LT.1.E-38) GO TO 1204
          TAU = 4.12E-21 * RHOX / SUMWX
          if( iexx .eq. iexxx .and. ips .eq. 1 .and.tau.gt.1e-25) then
            wid = 6.58e-22/tau
            write(67,'(a20,i5,3e12.3,f12.4)') 'j,rho,N,tau,wid =',
     &           jj,rhox,sumwx,tau,wid
          endif
 1204     ALG = -LOG10(TAU)
          IZW9 = ALG + 1.
          IZW8 = 10.**(IZW9-ALG) + .5
 1205     LZ (IEXX,JJ) = 1000000*IZW3 + 10000*IZW5 + 100*IZW1 + IZW2
          LZF(IEXX,JJ) = 1000000*IZW8 + 10000*IZW9 + 100*IZW7 + IZW4
          CNORM = W0 * CNORM
CE
CE    FISSION CROSS SECTION
          WQF(IPS)  = WQF(IPS) + ZW7 * W0
CE
CE    NORMALIZATION OF W, SUMMATION ONTO WT
CE    PARTICLE DECAY
          DO 123  IZF=1,IZFMAX
            IF (ISUMW(IZF).EQ.0) GO TO 123
            IPSZF = IPSZO(IZF,IPS)
            EKINXD= EX - ESEP(IZF,IPS) - EXMIN(IPSZF) - EMINT(IZF) + 1.1
            IH1 = IEXXL(IPSZF)
            IH2 = IEXXXZ(IZF)
            JJXZF = JJXXXZ(IZF)
            JJMZF = JJMINZ(IZF)
            WX = ZW(IZF) * W0
            WQT(IPSZF) = WQT(IPSZF) + WX
            IF (WX.GE.CGR) GO TO 121
            VWQ2 = VWQ2 + WX
            GO TO 123
 121        DO 1215 JJZF=JJMZF,JJXZF
              DO 1215 IEXXZF=IH1,IH2
                IEKIN = EKINXD - IEXXZF
                IF (IEKIN.GE.101) IEKIN = 100
                WX = CNORM * W (IEXXZF,JJZF,IZF)
                SE (IEKIN,IZF) = SE (IEKIN,IZF) + WX
 1215       WT (IEXXZF,JJZF,IZF) = WT (IEXXZF,JJZF,IZF) + WX
 123      CONTINUE
CE
CE    GAMMA DECAY
          IZF = IZFMAX + 1
          IF (IEXX.LE.1) GO TO 1246
          WX = ZW5 * W0
          IF (WX.GE.CGR) GO TO 124
          VWQ2 = VWQ2 + WX
          GO TO 1246
 124      DO 1242 JJZF=JJZFU,JJZFO
            JD = JJ - JJZF + 3
            DO 1242 IEXXZF=IH4,IH5
              IEKIN = IEXX - IEXXZF
              WX = CNORM * WG (IEXXZF,JD)
              SE (IEKIN,IZF) = SE (IEKIN,IZF) + WX
 1242     WGZ (IEXXZF,JJZF) = WGZ (IEXXZF,JJZF) + WX
CE    ISOMERS
CE    E2-CASCADE TO 0+ G.S. ASSUMED FOR ISOMERS
 1246     WX = W0 * ZW6
          WQ(IPS) = WQ(IPS) + WX
          VWQ4 = VWQ4 + WX
          CMULT = (J1+2)/4
          WX = CMULT * WX
          SE (1,IZF) = SE (1,IZF) + WX
CE
 1248     IF (JJSTEP.GT.1) GO TO 90
          IF (EX.LE.EXH .OR. JJC.LT.JC) GO TO 90
          JJSTEP = JSTEP
          IF (JJC.EQ.JC .AND. JSTEP.EQ.3) JJ = JJ + 1
          GO TO 90
 125      CONTINUE
 1252   CONTINUE
CE    *****************************************************************
CE
CE
CE    RESIDUE CROSS SECTION
 126    IEXXS1 = IEXXSS - 1
        IF (IEXXS1.LE.0) GO TO 128
        DO 127  JJ=1,JJX
          DO 127  IEXX=1,IEXXS1
 127    WQ(IPS) = WQ(IPS) + WT0(IEXX,JJ) + WGZ(IEXX,JJ)
 128    CONTINUE
CE
CE
CE    OUTPUT OF POPULATION AND DECAY MATRICES AND OF EVAP. SPECTRA
C      CALL OUTW (IPS,KOUTW,KOUTL,ITEXT,WQT(IPS),FFB,IZFF)
CSJS BEG 6-MAY-85    LABEL FISSION BARRIER CALCULATION
        CALL OUTW (IPS,KOUTW,KOUTL,ITEXT,WQT(IPS),FFB,IZFF,SIERK,VSADOFF)
CSJS END 6-MAY-85
        CALL OUTS(IPS,KEVAP,KGAMMA,EMINT,ITEXT,WQT(IPS),SCN(1))
CE
CE
CE    ERASE DAUGHTER NUCLEI IN THE LAST DECAY STEP
CE    OR WITH SMALL CROSS SECTION
        DO 1298  IZF=1,IZFMAX
          IF (ICZF(IZF).EQ.0) GO TO 1298
          IPSZF = IPSZO(IZF,IPS)
          IF (WQT(IPSZF).GT.WQGR) GO TO 129
          VWQ1 = VWQ1 + WQT(IPSZF)
          GO TO 1296
 129      IF (IPSZF.LE.IPS1) GO TO 1298
          IH2 = IEXXMX(IPSZF)
          IEXXSZ = IEXXS(IPSZF)
          JJXZF = JJMAX(IPSZF)
          IF (IH2.LT.IEXXSZ) GO TO 1294
          WX = 0.
          DO 1292 JJZF=1,JJXZF
            DO 1292 IEXXZF=IEXXSZ,IH2
 1292     WX = WX + WT (IEXXZF,JJZF,IZF)
          VWQ3 = VWQ3 + WX
          WQ(IPSZF) = WQ(IPSZF) + WX
CE
 1294     IEXXSZ = IEXXSZ - 1
          IF (IEXXSZ.LT.1) GO TO 1296
          WX = 0.
          DO 1295 JJZF=1,JJXZF
            DO 1295 IEXXZF=1,IEXXSZ
 1295     WX = WX + WT(IEXXZF,JJZF,IZF)
          WQ(IPSZF) = WQ(IPSZF)+ WX
 1296     ICZF(IZF) = 0
 1298   CONTINUE
CE
CE
CE    STORAGE OF DAUGHTER POPULATIONS IN THE W-TABLE
        DO 139  IZF=1,IZFMAX
          IF (ICZF(IZF).EQ.0) GO TO 139
          IPSZF = IPSZO(IZF,IPS)
          CALL GETW(IPSZF,IT)
          IF (IT.EQ.0) GO TO 138
          JJXZF = JJMAX(IPSZF)
          IH2 = IEXXMX(IPSZF)
          DO 137  JJZF=1,JJXZF
            DO 137  IEXXZF=1,IH2
 137      WT(IEXXZF,JJZF,IZF) = WT(IEXXZF,JJZF,IZF) + WT0(IEXXZF,JJZF)
 138      CALL STOREW(IPSZF,IZF)
 139    CONTINUE
CE
CE
CE    COMPRESS W-TABLE
        IF (IWL.GT.20) CALL CLEAN
CE
 140  CONTINUE
CE    ****************************************************************
CE    ****************************************************************
CE
CE
CE
CE    GENERAL OUTPUT
      CALL OUTS (0,KEVAP,KGAMMA,EMINT,ITEXT,0.D0,SCN(1))
 151  FORMAT (' NUCLEI OF THE DECAY CASCADE',32X,50A1///
     1     ' IPS   IZ  IA    EX-RANGE (MIN,L,S,MAX)     J-RANGE   DAU',
     2     'GHTER NUCLEI    BINDING E(N,P,A,4)      TRANS  FISSN  RESID'/)
 152  FORMAT (1H ,I3,1X,2I4, 2X,4F6.1,2X,2F5.1,2X,4I4,2X,4F5.1,
     1     4X,3F7.2)
 153  FORMAT (1H1)
CSILENT      WRITE(6,151) (ITEXT(I),I=1,50)
      DO 156  IPS=1,IPSMAX
        IAA = IA(IPS)
        E1 = EXMIN(IPS) + 1.
        E2 = EXMIN(IPS) + IEXXL(IPS)
        E3 = EXMIN(IPS) + IEXXS(IPS)
        E4 = EXMAX(IPS)
        CJ1 = JMIN(IPS) + 1
        CJ2 = JMAX(IPS)
        IF (2*(IAA/2).EQ.IAA) GO TO 155
        CJ1 = CJ1 + .5
        CJ2 = CJ2 + .5
 155    CONTINUE
CSILENT        WRITE(6,152) IPS,IZ(IPS),IAA, E1,E2,E3,E4,CJ1,CJ2,
CSILENT     1       (IPSZO(IZF,IPS),IZF=1,4),(ESEP(IZF,IPS),IZF=1,4),
CSILENT     2       WQT(IPS),WQF(IPS),WQ(IPS)
 156  CONTINUE
CSILENT      WRITE(6,153)
CE
CE
CE
 161  FORMAT (' LEVEL DENSITY PARAMETERS',35X,50A1///
     1     ' IPS   IZ  IA       DA    DELTA   FT/R0     U       UI '
     2     '     CK   OPT  LEV'/)
 162  FORMAT (1H ,I3,1X,2I4,2X,6F8.2,2I5/
     1     10X,'LDM  ',5F8.2,8X,I5)
CSILENT      WRITE(6,161) (ITEXT(I),I=1,50)
      DO 167  IPS=1,IPSMAX
        IF (IEXXMX(IPS).LE.0 .OR. WQT(IPS).LE.SCN(1)/500.) GO TO 167
        LVX = 0
        IF (IPSLVX.LT.2) GO TO 166
        DO 164  IPSLV=2,IPSLVX
          IF (IZLV(IPSLV).EQ.IZ(IPS) .AND. IALV(IPSLV).EQ.IA(IPS)) GO TO 165
          IF (IALV(IPSLV)-IZLV(IPSLV).EQ.IZ(IPS)
     1         .AND. IALV(IPSLV).EQ.IA(IPS)) GO TO 165
 164    CONTINUE
        GO TO 166
 165    LVX = LVMAX(IPSLV)
 166    CONTINUE
CSILENT        WRITE(6,162) IPS,IZ(IPS),IA(IPS),
CSILENT     1       DA(IPS),DELTA(IPS),FT(IPS),UTR,UJTR,CK(IPS),KOPTLD,LVX,
CSILENT     2       DALDM,DLDM(IPS),R0LDM,ULDM,UJLDM,KOPTLQ
 167  CONTINUE
      
CSILENT      WRITE(6,153)
CE
CE
      WX = 0.
      IPSX = 1
      DO 199  IPS=1,IPSMAX
        IF (WQ(IPS).LE.WX) GO TO 199
        WX = WQ(IPS)
        IPSX = IPS
 199  CONTINUE
      IARX = IA(IPSX)
      NZRX = IARX - 2*IZ(IPSX)
      DO 200  IAA=1,29
        DO 200  NZZ=1,40
 200  WQR(IAA,NZZ) = 0.
      IAMIN = IACN - 29
      DO 202  IPS=1,IPSMAX
        IAR = IA(IPS)
        IZR = IZ(IPS)
        IAA = IAR - IAMIN
        NZR = IAR - 2*IZR
        NZZ = NZR - NZRX + 20
        IF (IAA.GE.1 .AND. IAA.LE.29 .AND. NZZ.GE.1 .AND. NZZ.LE.40)
     1       WQR(IAA,NZZ) = WQR(IAA,NZZ) + WQ(IPS)
 202  CONTINUE
      DO 208  IAA=1,29
        SUM = 0.
        DO 206  NZZ=1,40
 206    SUM = SUM + WQR(IAA,NZZ)
 208  WQA(IAA) = SUM
      SR = 0.
      SFISS = 0.
      DO 210  IPS=1,IPSMAX
        SFISS = SFISS + WQF(IPS)
 210  SR = SR + WQ(IPS)
      siger = sr
CE
 216  FORMAT (1H0)
 217  FORMAT (' C A S C A D E  I  ',80A1)
 218  FORMAT (' --------------------------------------------------------',
     1'----------------------------')
 219  FORMAT (' --------------------------------------------------------',
     1'----------------------------'/)
 220  FORMAT (' ENTR.CHANNEL, CN  ZP,AP,ZT,AT,ELAB,ZCN,ACN,EXCN',
     1     2(I3,I4),F6.1,I3,I4,F6.1)
 221  FORMAT (' SPINS             JP,JT,IP12,JCN               ',
     1     2I7,I6,I7)
 222  FORMAT (' CASCADE STRUCTURE OPT,IPS1,IPSMAX,NN,NP,NA     ',
     1     6I4)
 2221 FORMAT (' 4.DECAY, FISSION  Z4,A4,J4, IZFF,DAF,FFB       ',
     1     3I4,I6,2F6.2)
 223  FORMAT (' ANGULAR M. IN CN  L0,DIFF,(SIGMACN)            ',
     1     2F6.2,'  (',F6.1,')')
 2235 FORMAT (' LEVEL DENS. PARM  FTHETA,OPTION,PARM/LEVLS IN  ',
     1     F5.2,I5,3X,2A1)
 224  FORMAT (' LEVEL DENS. PARM  DALDM,UTR,ULDM,UJTR,UJLDM,OPT',
     1     F5.2,4F5.1,I3,I2,F5.2)
 2242 FORMAT (' YRAST LINE        R0LDM,DEF,DEFS               ',
     1     F6.3,2E15.6)
 225  FORMAT (' GAMMA DECAY       E1,M1,E2(WEISSK.U),ENH,GMIN  ',
     1     F8.5,F6.3,F6.1,I3,'.',I2,'.',I3,'.',F5.1)
 226  FORMAT (' CUTOFFS           WGR,CGR,CVCBE,CVCB,VK,CVK    ',
     1     2F7.4,4F5.2)
 2261 FORMAT (' CUTOFFS           EX-RANGE,EXH,CJC,LCO         ',
     1     F5.1,F6.1,F5.1,I8)
 227  FORMAT (' OUTPUT OPTIONS    KOUTW,KOUTL,KEVAP,KGAMMA     ',
     1     4I5)
CE
      WRITE(6,218)
      WRITE(6,217) ITEXT
      WRITE(6,219)
      WRITE(6,220) IZP,IAP,IZT,IAT,ELAB,IZCN,IACN,EXCN
      IF (2*(IAP/2).EQ.IAP) JP = JP/2
      IF (2*(IAT/2).EQ.IAT) JT = JT/2
      IF (2*(IAE(4)/2).EQ.IAE(4)) JE(4) = JE(4)/2
      WRITE(6,221) JP,JT,IP12,JCN
      WRITE(6,222) KOPTK,IPS1,IPSMAX,NNX,NPX,NAX
      WRITE(6,2221)IZE(4),IAE(4),JE(4),IZFF,DAF,FFB
      WRITE(6,223) CL0,DIFF,SIGMCN
      IF (IPSLVX.GT.1) INLEVL = IPLUS
      WRITE(6,2235) FTHETA,KOPTLD,INRHOP,INLEVL
      WRITE(6,224) DALDM,UTR,ULDM,UJTR,UJLDM,KOPTLQ,KOPTEB,ALPHA2
      WRITE(6,2242) R0LDM,DEF,DEFS
      IF(ISPECOPT.EQ.1)WRITE(6,22421)JNOD,OFFEV,OFFODD,TRAMO
22421 FORMAT(' ---> SPECIAL OPTION YRAST LINE IN EFFECT <---'/
     &     'JNOD,OFFEV,OFFODD,TRAMO = ',I,F,F,F)
      I1 = CJG1 + 0.5
      I2 = CJG2 + 0.5
      I3 = XYENH + .5
      WRITE(6,225) XYE1,XYM1,XYE2,I1,I2,I3,GMIN
      IF(IGIANT.EQ.1)WRITE(6,2249)DIPOLE,DIPOLW,DIPOLS
 2249 FORMAT(' ---> SPECIAL OPTION GIANT E1 RESONANCE IN EFFECT <---'/
     &     '   E = ',F,' MeV  ;  WIDTH = ',F,' MeV;  STRENGTH = ',F)
      IF(IENE2BAND.EQ.1)THEN
        WRITE(6,2251)E2BANDPAR,ICOUNTEB
 2251   FORMAT(' ---> SPECIAL OPTION ENHANCED E2 BAND IN EFFECT <---'/
     &       ,'     ENHANCEMENT FACTOR = ',F,' ENHANCE COUNT = ',I)
      ENDIF
      WRITE(6,226) WGR,CGR,CVCBE,CVCB,VK,CVK
      WRITE(6,2261)EXR0,EXH,CJC,LCO
      WRITE(6,227) KOUTW,KOUTL,KEVAP,KGAMMA
      WRITE(6,219)
CE
 235  FORMAT ('  A',3X,11I3,' (N-Z)'/)
 237  FORMAT (1H ,I3,3X,5F6.1,3X,F8.2,1X,40A1)
 238  FORMAT (1H ,I3,6F6.1,F8.2,1X,40A1)
 239  FORMAT (1H ,17X,'RESIDUE CROSS S.',6X,F8.2,' MB')
 2391 FORMAT (1H ,17X,'FISSION CROSS S.',6X,F8.2,' MB')
 240  FORMAT (1H ,17X,'FUSION  CROSS S.',6X,F8.2,' MB'/)
 242  FORMAT (1H ,17X,'LOST CROSS SECTIONS',4X,F8.2,' MB CN.GT.JMAX'/
     1     40X,F8.2,' MB W0.LT.WGR'/
     2     40X,F8.2,' MB W0*ZW.LT.CGR'/
     3     40X,F8.2,' MB LAST STEP ABOVE THRESHOLD'/
     4     1H ,17X,'ISOMERS    ',11X,F8.2,' MB ')
CE
      DO 251  NZZ=15,25
        NZR = NZZ+NZRX-20
 251  IPLOT(NZZ) = NZR
      WRITE(6,235) (IPLOT(NZZ),NZZ=15,25)
      DO 260  IAA=1,29
        IAR = IAMIN + IAA
        DO 252  I=1,40
 252    IPLOT(I) = IBLANK
        IX = WQA(IAA)/15. + 1.5
        IF (IX.GT.40) IX = 40
        DO 255  I=1,IX
 255    IPLOT(I) = NULL
ctemp
        if( iar .eq. 102) then
          write(6,'(5f10.3)') (wqr(iaa,nzz),nzz=10,25,1)
        endif
        IF (IAR-2*(IAR/2)+IARX-2*(IARX/2).EQ.1) GO TO 258
        WRITE(6,237) IAR,(WQR(IAA,NZZ),NZZ=16,24,2),WQA(IAA),
     1       (IPLOT(I),I=1,40)
        GO TO 260
 258    WRITE(6,238) IAR,(WQR(IAA,NZZ),NZZ=15,25,2),WQA(IAA),
     1       (IPLOT(I),I=1,40)
 260  CONTINUE
      WRITE(6,218)
CE
      
      WRITE(6,239) SR
      WRITE(6,2391)SFISS
      WRITE(6,240) SCN(1)
      WRITE(6,242) SCN(2),VWQ1,VWQ2,VWQ3,VWQ4
      WRITE(6,219)
      WRITE(6,218)
      GO TO 19
 1000 continue
 8462 continue
CSMS    ii=sys$setprn('casc_done')
      STOP 'Execution terminated'
 8643 continue
CSMS    ii=sys$setprn('casc-err')
      stop 'Input error, execution terminated'
      END

      SUBROUTINE KASKAD (KOPTK,NNX,NPX,NAX)
      IMPLICIT REAL*8(A-H,O-Z)

CE    STRUCTURE OF THE DECAY CASCADE
      COMMON EXMIN(500),EXMAX(500),EBE(4),ESEP(4,500)
      COMMON IZFMAX,IZE(4),IAE(4),JE(4),JDE(4),IEXXMX(500),IEXXS(500)
      COMMON IPS1,IPSMAX,IPSZO(4,500),IZ(500),IA(500)
      COMMON IEXXL(500),JMIN(500),JMAX(500),JJMAX(500)
      
      
      DIMENSION NR(32,32,32)
      DO 7  IPS=1,500
        DO 7  IZF=1,4
 7    IPSZO(IZF,IPS) = 0
CE
      IF (KOPTK.GT.1) GO TO 10
CE
CE
CE    INPUT FROM CARDS
      KMAX = (IPS1+6)/7
      WRITE(6,1002)
 1002 FORMAT(' THIS TOO IS MORE JUNK')
      DO  8  K=1,KMAX
        IH2 = 7 * K
        IH1 = IH2 - 6
 8    READ (5,*)  ((IPSZO(IZF,IPS),IZF=1,4),IPS=IH1,IH2)
 9    FORMAT (7(2X,4I2))
      IF (IPS1.GT.499) IPS1 = 499
      IF (IPSMAX .GT.500) IPSMAX = 500
      GO TO 100
CE
CE
CE    INTERNAL CALCULATION
 10   DO 11 NA=1,32
        DO 11 NN=1,32
          DO 11 I =1,32
 11   NR(I,NN,NA) = 0
      IF (KOPTK.GT.31) KOPTK = 31
      IF (NNX.LE.1) NNX = 2
      IF (NPX.LE.1) NPX = 2
      IF (NAX.LE.1) NAX = 2
      IF (NNX.GT.KOPTK) NNX = KOPTK
      IF (NPX.GT.KOPTK) NPX = KOPTK
      IF (NAX.GT.KOPTK) NAX = KOPTK
      NMAX = KOPTK + 1
      NXN = NNX
      NXP = NPX
      NXA = NAX + 1
      NR (1,1,1) = 1
      N = 1
      DO 25  NN=2,NMAX
        IMIN = 1
        IMAX = NN
        IF (NN.LE.NXN) GO TO 21
        IMIN = 1 + (NN-NXN+1)/2
        IF (2*((NN-NXN)/2).NE.NN-NXN) NR(IMIN-1,NN,1) = 1000
 21     IF (NN.LE.NXP) GO TO 22
        IMAX = NN - (NN-NXP+1)/2
        IF (2*((NN-NXP)/2).NE.NN-NXP) NR(IMAX+1,NN,1) = 1000
 22     DO 25  I=IMIN,IMAX
          IF (NN.LT.NMAX) N = N + 1
 25   NR(I,NN,1) = N
CE
      DO 30  NA=2,NXA
        NNMAX = NMAX - NA + 1
        DO 28  NN=1,NNMAX
          DO 28  I =1,NN
            NRV = NR(I,NN,NA-1)
            IF (NRV.EQ.0) GO TO 28
            IF (NRV.NE.1000) GO TO 27
            IF (NA.GE.NXA) GO TO 28
            NR(I,NN,NA) = 1000
            GO TO 28
 27         IF (NN.LT.NNMAX .AND. NA.LT.NXA) N = N + 1
            NR(I,NN,NA) = N
 28     CONTINUE
 30   CONTINUE
CE
      IPS1 = N
      DO 35  NA=1,NXA
        NNMAX = NMAX - NA + 1
        DO 35  NN=1,NNMAX
          DO 35  I =1,NN
            NRV = NR(I,NN,NA)
            IF (NRV.EQ.0) GO TO 35
            IF (NRV.NE.1000 .AND. NN.NE.NNMAX .AND. NA.NE.NXA) GO TO 35
            N = N + 1
            NR(I,NN,NA) = N
 35   CONTINUE
      IPSMAX = N
      IF (IPSMAX.LE.500) GO TO 36
      KOPTK = KOPTK - 1
      GO TO 10
CE
 36   DO 40  NA=1,NAX
        NNMAX = NMAX - NA
        DO 40  NN=1,NNMAX
          DO 40  I =1,NN
            IPS = NR(I,NN,NA)
            IF (IPS.EQ.0 .OR. IPS.GT.IPS1) GO TO 40
            IPSZO(1,IPS) = NR(I,NN+1,NA)
            IPSZO(2,IPS) = NR(I+1,NN+1,NA)
            IPSZO(3,IPS) = NR(I,NN,NA+1)
 40   CONTINUE
CE
CE
CE    ASSIGNMENT IPSZO(4,IPS) FOR DECAY 4
CE    WITHIN THE DECAY CASCADE DEFINED BY N,P,ALPHA
      IF (IZFMAX.EQ.3) GO TO 100
      IZR = IZE(4)
      IAR = IAE(4)
      NALPHA = 0
 62   IF (IZR.LT.2 .OR. IAR.LT.4) GO TO 63
      IZR = IZR - 2
      IAR = IAR - 4
      NALPHA = NALPHA + 1
      GO TO 62
 63   INR = IAR - IZR
CE
      DO 80  IPS=1,IPS1
        IPSZF = IPS
        IF (NALPHA.LE.0) GO TO 66
        N = 0
 65     N = N + 1
        IPSZF = IPSZO(3,IPSZF)
        IF (IPSZF.EQ.0) GO TO 70
        IF (N.LT.NALPHA) GO TO 65
CE
 66     IF (IZR.LE.0) GO TO 68
        N = 0
 67     N = N + 1
        IPSZF = IPSZO(2,IPSZF)
        IF (IPSZF.EQ.0) GO TO 70
        IF (N.LT.IZR) GO TO 67
CE
 68     IF (INR.LE.0) GO TO 70
        N = 0
 69     N = N + 1
        IPSZF = IPSZO(1,IPSZF)
        IF (IPSZF.EQ.0) GO TO 70
        IF (N.LT.INR) GO TO 69
CE
 70     IPSZO(4,IPS) = IPSZF
 80   CONTINUE
CE
 100  RETURN
      END

      SUBROUTINE GETW (IPS,IT0)
      IMPLICIT REAL*8(A-H,O-Z)

CE    GETS THE POPULATION MATRIX FOR NUCLEUS IPS
CE    FROM THE W-TABLE (FILE 13) AND READS IT INTO WT0(64,64)
CE    THE LOCATION IT0 IN INHWT IS DETERMINED
CE    IT0 = 0 IF THE MATRIX IS NOT FOUND
CE    ITP = POINTER
      COMMON/C4/ ITP,ITMAX,INHWT(200),IWL
      COMMON/C5/ WT0(64,64),WT(64,64,4)
      DIMENSION WT0A(2048),WT0B(2048)
      EQUIVALENCE (WT0A(1),WT0(1)),(WT0B(1),WT0(2049))

CSMS Switch to direct access rather than backspace/read
CE
CE    IN ORDER TO AVOID BACKSPACE
CSMS      REWIND 13
      ITP = 1
CE
      DO 20  IT=1,ITMAX
        IF (INHWT(IT).EQ.IPS) GO TO 25
 20   CONTINUE
      IT0 = 0
      RETURN
CE
 25   IT0 = IT
CSMS      ID = IT0 - ITP
CSMS      IF (ID) 30,35,33
CSMS 30   IBACK = -ID
CSMS      DO 31 I=1,IBACK
CSMS        BACKSPACE 13
CSMS        BACKSPACE 13
CSMS 31   ITP = ITP - 1
CSMS      GO TO 35
CSMS 33   ISKIP = ID
CSMS      DO 34 I=1,ISKIP
CSMS        READ (13)
CSMS        READ (13)
CSMS 34   ITP = ITP + 1
      ITP=IT0
CE
 35   READ (13,REC=ITP*2) WT0A
      READ (13,REC=ITP*2+1) WT0B
      ITP = ITP + 1
      INHWT(IT0) = 9999
      IWL = IWL + 1
      IPSW = WT0(1,64) + 0.1
      WT0(1,64) = 0.
      IF (IPSW.NE.IPS) WRITE(6,40) IPS,IT0,IPSW,ITP
 40   FORMAT (' ***ERROR: WRONG LOCATION OF W IN TABLE, IPS,IT0,IPSW,I',
     1     'TP =',4I4//)
      RETURN
      END
      
      SUBROUTINE STOREW (IPSZF,IZF)
      IMPLICIT REAL*8(A-H,O-Z)
      
CE    STORES WT(64,64,IZF) IN W-TABLE
      COMMON/C4/ ITP,ITMAX,INHWT(200),IWL
      COMMON/C5/ WT0(64,64),WT(64,64,4)
      DIMENSION WT1A(2048),WT1B(2048),WT2A(2048),WT2B(2048)
      DIMENSION WT3A(2048),WT3B(2048),WT4A(2048),WT4B(2048)
      EQUIVALENCE (WT1A(1),WT(1)),(WT1B(1),WT(2049))
      EQUIVALENCE (WT2A(1),WT(4097)),(WT2B(1),WT(6145))
      EQUIVALENCE (WT3A(1),WT(8193)),(WT3B(1),WT(10241))
      EQUIVALENCE (WT4A(1),WT(12289)),(WT4B(1),WT(14337))
CE
CSMS      REWIND 13
      ITP = 1
CE
CE    SEARCH FOR AN EMPTY PLACE
      DO 20  IT=1,ITMAX
        IF (INHWT(IT).EQ.0) GO TO 25
 20   CONTINUE
      IT = ITMAX
      WRITE(6,21) IPSZF
 21   FORMAT (' ***ERROR: NO SPACE IN W-TABLE FOR IPSZF =',I3//)
CE
 25   ID = IT - ITP
CSMS      IF (ID) 30,35,33
CSMS 30   IBACK = -ID
CSMS      DO 31 I=1,IBACK
CSMS        BACKSPACE 13
CSMS        BACKSPACE 13
CSMS 31   ITP = ITP - 1
CSMS      GO TO 35
CSMS 33   ISKIP = ID
CSMS      DO 34 I=1,ISKIP
CSMS        READ (13)
CSMS        READ (13)
CSMS 34   ITP = ITP + 1
      ITP=IT
CE
 35   WT(1,64,IZF) = IPSZF
      IF (IZF.EQ.1) WRITE (13,REC=ITP*2) WT1A
      IF (IZF.EQ.1) WRITE (13,REC=ITP*2+1) WT1B
      IF (IZF.EQ.2) WRITE (13,REC=ITP*2) WT2A
      IF (IZF.EQ.2) WRITE (13,REC=ITP*2+1) WT2B
      IF (IZF.EQ.3) WRITE (13,REC=ITP*2) WT3A
      IF (IZF.EQ.3) WRITE (13,REC=ITP*2+1) WT3B
      IF (IZF.EQ.4) WRITE (13,REC=ITP*2) WT4A
      IF (IZF.EQ.4) WRITE (13,REC=ITP*2+1) WT4B
      ITP = ITP + 1
      INHWT(IT) = IPSZF
      RETURN
      END
      
      SUBROUTINE CLEAN
      IMPLICIT REAL*8(A-H,O-Z)
CE    COMPRESSES W-TABLE
CE    BY REMOVING UNNECESSARY MATRICES (LABELED INHWT()=9999)
      COMMON/C4/ ITP,ITMAX,INHWT(200),IWL
      DIMENSION WT0A(2048)
CSMS      REWIND 13
CSMS      REWIND 14
      ITC = 0
CE
      DO 20  IT=1,ITMAX
        INH = INHWT(IT)
        IF (INH.EQ.0) GO TO 30
        IF (INH.NE.9999) GO TO 10
CSMS        READ (13)
CSMS        READ (13)
        GO TO 20
 10     ITC = ITC + 1
        INHWT(ITC) = INH
        READ  (13,REC=IT*2) WT0A
        WRITE (14,REC=ITC*2) WT0A
        READ  (13,REC=IT*2+1) WT0A
        WRITE (14,REC=ITC*2+1) WT0A
 20   CONTINUE
CE
CE
 30   IF (ITC.LE.0) GO TO 50
CSMS      REWIND 13
CSMS      REWIND 14
      DO 40  IT=1,ITC
        READ (14,REC=IT*2) WT0A
        WRITE(13,REC=IT*2) WT0A
        READ (14,REC=IT*2+1) WT0A
 40   WRITE(13,REC=IT*2+1) WT0A
      IF (ITC.EQ.ITMAX) GO TO 50
      ITC = ITC + 1
      DO 42  IT=ITC,ITMAX
 42   INHWT(IT) = 0
CE
CE
 50   REWIND 13
      ITP = 1
      IWL = 0
      RETURN
      END
      
      SUBROUTINE RTABLE(ipsx,ISPECOPT)
      IMPLICIT REAL*8(A-H,O-Z)
CE    TABLE OF LEVEL DENSITIES

      COMMON EXMIN(500),EXMAX(500),EBE(4),ESEP(4,500)
      COMMON IZFMAX,IZE(4),IAE(4),JE(4),JDE(4),IEXXMX(500),IEXXS(500)
      COMMON IPS1,IPSMAX,IPSZO(4,500),IZ(500),IA(500)
      COMMON IEXXL(500),JMIN(500),JMAX(500),JJMAX(500)


CE
      COMMON/C2/ FT(500),DA(500),DELTA(500),CK(500)
      COMMON/C2/ R0LDM,DEF,DEFS,DALDM,DAF,UTR,ULDM,UJTR,UJLDM,DLDM(500)

      COMMON/C3/ EXLVX(100),EXLV(100,100),IPSLVX,IZLV(100),
     &     IALV(100),LVMAX(100), JLV(100,100)

CSMS    real*8 tsum(48,1200,4),RHOG(64,64)
CSMS      COMMON/C6/ tsUM,RHO(64,64,5),RHOG
      real*8 tsum(48,1200,4),RHOG(64,64,4)
      COMMON/C6/ tsUM,RHO(64,64,5),RHOG,dum_my(64,64,40,4)
      DIMENSION  RHOG1(2048), RHOG2(2048)
      EQUIVALENCE (RHOG1(1),RHOG(1)),(RHOG2(1),RHOG(2049))
CE
ccx     REWIND 12
ccx      DO 50  IPS=1,IPSMAX
ccx      IF (IEXXMX(IPS).GE.1) GO TO 7
ccx      WRITE (12) IPS
ccx      WRITE (12) IPS
ccx      GO TO 50
      do 50 izf=1,izfmax+1
        if(izf.lt.izfmax+1)ips=ipszo(izf,ipsx)
        if(izf.eq.izfmax+1)ips=ipsx
 7      IEXXX = IEXXMX(IPS)
        if(iexxx.le.0)goto 50
        JJX = JJMAX(IPS)
CE
        IF (DALDM.GT.0.01) GO TO 8
        DALD = DA(IPS)
        DLDM(IPS) = DELTA(IPS)
        GO TO 9
 8      DALD = DALDM
CE
 9      CALL LEVELD(EXMIN(IPS),IEXXX,JMIN(IPS),JJX,CK(IPS),
     1       iz(ips),IA(IPS),DA(IPS),DALD,DELTA(IPS),DLDM(IPS),
     2       FT(IPS),R0LDM,DEF,DEFS,UTR,ULDM,UJTR,UJLDM,izf,
     &       ISPECOPT)
CE
CE
CE    LEVELS FROM TABLE
        IF (IPSLVX.LE.1) GO TO 11
        DO 10  IPSLV=2,IPSLVX
          IZZ = IZLV(IPSLV)
          IAA = IALV(IPSLV)
          IF (IAA.EQ.IA(IPS) .AND. (IZZ.EQ.IZ(IPS).OR.IAA-IZZ.EQ.IZ(IPS)))
     1         GO TO 12
 10     CONTINUE
 11     CALL STANLV(IZ(IPS),IA(IPS))
        IPSLV = 1
CE
 12     DO 13  IEXX=1,IEXXX
          EX = EXMIN(IPS) + IEXX
          IF (EX.GT.EXLVX(IPSLV)) GO TO 14
          DO 13  JJ=1,JJX
 13     RHO(IEXX,JJ,izf) = 0.
CE
 14     LVX = LVMAX(IPSLV)
        IF (LVX.LE.0) GO TO 18
        DO 17  LV=1,LVX
          IEXX =  EXLV(LV,IPSLV)-EXMIN(IPS) + 0.5
          IF (IEXX.LE.0 .OR. IEXX.GT.IEXXX) GO TO 17
          JJ = JLV(LV,IPSLV) - JMIN(IPS)
          IF (JJ.LE.0 .OR. JJ.GT.JJX) GO TO 17
          RHO(IEXX,JJ,izf) = RHO(IEXX,JJ,izf) + 1.
          IF(EXLV(LV,IPSLV).LT.EXLVX(IPSLV)) GO TO 17
          LVF = MIN0(LV+1,LVX)
          IEXXF =  EXLV(LVF,IPSLV)-EXMIN(IPS) + 0.5
          IEXXF = MIN0(IEXXF-1,IEXXX)
          IEXX1 = IEXX
          JJ1 = JJ + 1
          IF (JJ1.GT.JJX) GO TO 17
          DO 16  JJ=JJ1,JJX
            DO 16  IEXX=IEXX1,IEXXF
 16       RHO(IEXX,JJ,izf) = 0.
 17     CONTINUE
CE
ccx18    RHOG(2,64) = IPS
ccx      WRITE (12) RHOG1
ccx      WRITE (12) RHOG2
 18     continue
 50   CONTINUE
CE
      RETURN
      END
      
      SUBROUTINE GETRHO (IPS,ITR)
      IMPLICIT REAL*8(A-H,O-Z)
CE    READS LEVEL DENSITY MATRICES FOR PARENT AND DAUGHTER NUCLEI
CE    FROM TABLE,  ITR = POINTER

      COMMON EXMIN(500),EXMAX(500),EBE(4),ESEP(4,500)
      COMMON IZFMAX,IZE(4),IAE(4),JE(4),JDE(4),IEXXMX(500),IEXXS(500)
      COMMON IPS1,IPSMAX,IPSZO(4,500),IZ(500),IA(500)
      COMMON IEXXL(500),JMIN(500),JMAX(500),JJMAX(500)
      
CSMS    real*8 tsum(48,1200,4),RHOG(64,64)
CSMS      COMMON/C6/ tsUM,RHO(64,64,5),RHOG
      real*8 tsum(48,1200,4),RHO_G(64,64,4),RHOG(64,64)
      COMMON/C6/ tsUM,RHO(64,64,5),RHO_G,dum_my(64,64,40,4)
      DIMENSION  RHOG1(2048), RHOG2(2048)
      EQUIVALENCE (RHO_G(1,1,1),RHOG(1,1))
      EQUIVALENCE (RHOG1(1),RHOG(1)),(RHOG2(1),RHOG(2049))
CE
      IZFM = IZFMAX + 1
      DO 40  IZF=1,IZFM
        IPSZF = IPSZO(IZF,IPS)
        IF (IZF.EQ.IZFM) IPSZF = IPS
        IF (IPSZF.EQ.0) GO TO 40
        IEXXX = IEXXMX(IPSZF)
        IF (IEXXX.LE.0) GO TO 40
        JJX = JJMAX(IPSZF)
        ID = IPSZF - ITR
        IF (ID) 30,35,33
C
C               MODIFICATION CANNOT BACKSPACE ON A DISK FILE
C               IF THERE NEEDS TO BE A BACKSPACE IT GOES TO THE
C               BEGINNING OF THE FILE AND STARTS OVER.......
C
 30     IBACK = -2*ID
        ITR = ITR +ID
        DO 31 I=1,IBACK
 31     BACKSPACE 12
        GO TO 35
C
C
C30     REWIND 12
C
C       ID=IPSZF
C       ITR=ID
 33     ISKIP = 2*ID
        ITR = ITR + ID
        DO 34 I=1,ISKIP
 34     READ (12)
 35     READ (12) RHOG1
        READ (12) RHOG2
        print *,'---Read record ',ITR,' from file 12'
        ITR = ITR + 1
CE
        IPSR = RHOG(2,64) + 0.1
        RHOG(2,64) = 0.
        IF (IPSR.NE.IPSZF) WRITE(6,37) IPSZF,IPSR
 37     FORMAT (' ***ERROR: RHO CANNOT BE FOUND,  IPSZF,IPSR =',2I4//)
        DO 38  JJ=1,JJX
          DO 38  IEXX=1,IEXXX
 38     RHO (IEXX,JJ,IZF) = RHOG(IEXX,JJ)
 40   CONTINUE
      RETURN
      END

      SUBROUTINE TSUMME (IPS,EMINT,IK)
      IMPLICIT REAL*8(A-H,O-Z)
CE    TRANSMISSION COEFFICIENTS (CASCADE I)
CE    IK.NE.0 FOR READING EMINT ONLY
CE
      COMMON EXMIN(500),EXMAX(500),EBE(4),ESEP(4,500)
      COMMON IZFMAX,IZE(4),IAE(4),JE(4),JDE(4),IEXXMX(500),IEXXS(500)
      COMMON IPS1,IPSMAX,IPSZO(4,500),IZ(500),IA(500)
      COMMON IEXXL(500),JMIN(500),JMAX(500),JJMAX(500)
      
CSMS    real*8 tsum(48,1200,4),T(6661)
      real*8 T(6661),RHOG(64,64)
      real*4 ttemp(6661)
CSMS      COMMON/C6/TSUM,RHO(64,64,5),T
CSMS    real*8 tsum(48,1200,4),RHOG(64,64)
CSMS      COMMON/C6/ tsUM,RHO(64,64,5),RHOG
      real*8 tsum(48,1200,4),RHO_G(64,64,4)
      COMMON/C6/ tsUM,RHO(64,64,5),RHO_G,dum_my(64,64,40,4)
      EQUIVALENCE(RHOG(1,1),RHO_G(1,1,1))
      EQUIVALENCE(T(1),RHOG(1,1))
      COMMON/JSPIN/JDIAG(48)
      DIMENSION  EMINT(4)
      
CSMS Patched to use REC= instead of READ/BACKSPACE
      integer recnum
      
      recnum = 1
      
CSMS init
      IZT=0
      
CE
CE    READ T FROM DISC (IZF=1,IZFT)
      IZZ = IZ(IPS)
      IF (IZZ.LT.6) IZZ = 6
      IVS = 0
 7    IVS = IVS + 1
      IF (IVS.LT.5) GO TO 9
      WRITE(6,8) IZZ,IZT
 8    FORMAT (' ***ERROR, TRANSMISSION COEFF CANNOT BE FOUND, IZZ,IZT:'
     1     ,2I3)
      GO TO 30
CE
 9    READ (11, rec=recnum) ttemp
      IZT = ttemp(1)
      recnum=recnum+1
      IF (IZT-IZZ) 12,30,14
 12   ISKIP = (IZZ-IZT-1)
      IF (ISKIP.EQ.0) GO TO 7
      recnum = recnum + iskip
CSMS      DO 13  I=1,ISKIP
CSMS13    READ (11)
      GO TO 7
 14   IBACK = (IZT-IZZ+1)
CSMS      DO 15  I=1,IBACK
CSMS15    BACKSPACE 11
      recum=recnum-iback
      GO TO 7
 30   CONTINUE
      DO 50  IZF=1,4
 50   EMINT(IZF) = ttemp(IZF+1)
      
      do i = 1,6661
        t(i)=ttemp(i)
      enddo
      
      IF (IK.NE.0) RETURN
CE
CE
CE
CE    CALCULATION OF TSUM(IEKIN,JT,IZF)
CE
      DO 90  IZF=1,IZFMAX
        IPSZF = IPSZO(IZF,IPS)
        IF (IPSZF.EQ.0) GO TO 90
        IF (IEXXMX(IPSZF).LE.0) GO TO 90
        JTMAX = 31
        IF (IZF.GE.3) JTMAX = 47
        IEMAX=32
        IF(IZF.GE.3) IEMAX=48
        JTMAXX=JTMAX+1
CE
CE
CE    PRE-SUMMATION
        INDEX1=1024*(IZF-1)+1280*(IZF/4)+5
        DO 55  IEKIN=1,IEMAX
          INDEX2=JTMAXX*(IEKIN-1)+INDEX1
          DO 55  JT1=1,JTMAXX
            SUM = 0.
            DO 54  JT2=JT1,JTMAXX
              JT = JDIAG(JT2) - JT2 + JT1
              INDEX=JT2+INDEX2
              SUM = SUM + T(INDEX)
 54         TSUM(IEKIN,JT,IZF) = SUM
 55     CONTINUE
CE
        CS = 1.
        I = JE(IZF) + 1
        GO TO (90,60,70,80), I
CE    SPIN   0 1/2 1 3/2
        CS = (JE(IZF)+1.)/4.
        GO TO 80
CE
CE    SPIN 1/2 PARTICLES
 60     DO 68  JT1=1,JTMAX
          DO 64  JT2=JT1,JTMAX
            JT = JDIAG(JT2) - JT2 + JT1
            IF (JT1.EQ.JT2) GO TO 62
            DO 61  IEKIN=1,IEMAX
              INDEX=JTMAXX*(IEKIN-1)+INDEX1
              LT1=JT1+INDEX
              LT2=JT2+INDEX
 61         TSUM(IEKIN,JT,IZF) = 2.*TSUM(IEKIN,JT,IZF)
     1             - T(LT1) + T(LT2+1)
            GO TO 64
 62         DO 63  IEKIN=1,IEMAX
              INDEX=JTMAXX*(IEKIN-1)+INDEX1
              LT1=JT1+INDEX
 63         TSUM(IEKIN,JT,IZF) = TSUM(IEKIN,JT,IZF) + T(LT1+1)
 64       CONTINUE
 68     CONTINUE
        GO TO 90
CE
CE
CE    SPIN 1 PARTICLES
 70     DO 78  JT1=1,JTMAX
          DO 78  JT2=JT1,JTMAX
            JT = JDIAG(JT2) - JT2 + JT1
            IF (JT1.EQ.JT2) GO TO 74
            IF (JT1.EQ.1)   GO TO 72
            DO 71  IEKIN=1,IEMAX
              INDEX=JTMAXX*(IEKIN-1)+INDEX1
              LT1=JT1+INDEX
              LT2=JT2+INDEX
 71         TSUM(IEKIN,JT,IZF) = 3.*TSUM(IEKIN,JT,IZF)
     1             - T(LT1) - T(LT2) + T(LT1-1)+T(LT2+1)
            GO TO 78
 72         DO 73  IEKIN=1,IEMAX
              INDEX=JTMAXX*(IEKIN-1)+INDEX1
              LT1=JT1+INDEX
              LT2=JT2+INDEX
 73         TSUM(IEKIN,JT,IZF) = 3.*TSUM(IEKIN,JT,IZF)
     1             -2.*T(LT1) - T(LT2)   + T(LT2+1)
            GO TO 78
CE
 74         IF (JT1.EQ.1) GO TO 76
            DO 75  IEKIN=1,IEMAX
              INDEX=JTMAXX*(IEKIN-1)+INDEX1
              LT1=JT1+INDEX
              LT2=JT2+INDEX
 75         TSUM(IEKIN,JT,IZF) = TSUM(IEKIN,JT,IZF)
     1             + T(LT1-1) + T(LT2+1)
            GO TO 78
 76         DO 77 IEKIN=1,IEMAX
              INDEX=JTMAXX*(IEKIN-1)+INDEX1
              LT1=2+INDEX
 77         TSUM(IEKIN,1,IZF)  = TSUM(IEKIN,1,IZF) + T(LT1)
 78     CONTINUE
        GO TO 90
CE
CE
CE    SPIN 3/2 PARTICLES
 80     DO 89  JT1=1,JTMAX
          DO 89  JT2=JT1,JTMAX
            JT  = JDIAG(JT2) - JT2 + JT1
            I = JT2 - JT1 + 1
            GO TO (87,85,83,81), I
CE
CE    CASE JT2.GT.JT1+2
 81         DO 82  IEKIN=1,IEMAX
              INDEX=JTMAXX*(IEKIN-1)+INDEX1
              LT1=JT1+INDEX
              LT2=JT2+INDEX
              TS = 4.*TSUM(IEKIN,JT,IZF) - 2.*T(LT1)
     1             -  T(LT1+1) + 2.*T(LT2+1)
              IF (JT1.EQ.1) TS = TS - T(LT1)
              IF (JT1.GT.1) TS = TS - T(LT1-1)
              IF (JT2+2.LE.JTMAXX) TS = TS + T(LT2+2)
 82         TSUM(IEKIN,JT,IZF) = CS * TS
            GO TO 89
CE
CE    CASE JT2 = JT1 + 2
 83         DO 84  IEKIN=1,IEMAX
              INDEX=JTMAXX*(IEKIN-1)+INDEX1
              LT1=JT1+INDEX
              LT2=JT2+INDEX
              TS = 3.*TSUM(IEKIN,JT,IZF) - T(LT1) + T(LT2+1)
              IF (JT1.EQ.1) TS = TS - T(LT1)
              IF (JT2+2.LE.JTMAXX) TS = TS + T(LT2+2)
 84         TSUM(IEKIN,JT,IZF) = CS * TS
            GO TO 89
CE
CE    CASE JT2 = JT1 + 1
 85         DO 86  IEKIN=1,IEMAX
              INDEX=JTMAX+(IEKIN-1)+INDEX1
              LT1=JT1+INDEX
              LT2=JT2+INDEX
              TS = 2.*TSUM(IEKIN,JT,IZF) + 2.*T(LT2+1)
              IF (JT1.EQ.1) TS = TS - T(LT1)
              IF (JT2+2.LE.JTMAXX) TS = TS + T(LT2+2)
 86         TSUM(IEKIN,JT,IZF) = CS * TS
            GO TO 89
CE
CE    CASE JT2 = JT1
 87         DO 88  IEKIN=1,IEMAX
              INDEX=JTMAXX*(IEKIN-1)+INDEX1
              LT1=JT1+INDEX
              TS = T(LT1+1)
              IF (JT1.GT.1) TS = TS + T(LT1) + T(LT1-1)
              IF (JT1+2.LE.JTMAXX) TS = TS + T(LT1+2)
 88         TSUM(IEKIN,JT,IZF) = CS * TS
 89     CONTINUE
 90   CONTINUE
CE
      RETURN
      END
      
      SUBROUTINE EXCORR (EBC)
      IMPLICIT REAL*8(A-H,O-Z)
CE    CORRECTION VALUES FOR EXCITATION ENERGY RANGES
CE    IN CASE OF IZFMAX = 4
      
      COMMON EXMIN(500),EXMAX(500),EBE(4),ESEP(4,500)
      COMMON IZFMAX,IZE(4),IAE(4),JE(4),JDE(4),IEXXMX(500),IEXXS(500)
      COMMON IPS1,IPSMAX,IPSZO(4,500),IZ(500),IA(500)
      COMMON IEXXL(500),JMIN(500),JMAX(500),JJMAX(500)

      DIMENSION EBC(3)
      EBC(1) = 0.
      EBC(3) = 0.
      IZE4 = IZE(4)
      IAE4 = IAE(4)
CE
CE    DEUTERON DECAY
      IF (IZE4.EQ.1 .AND. IAE4.EQ.2) EBC(1) = 1.
CE    TRITON
      IF (IZE4.EQ.1 .AND. IAE4.EQ.3) EBC(1) = 3.
CE    3HE
      IF (IZE4.EQ.2 .AND. IAE4.EQ.3) EBC(1) = 3.
CE    6LI
      IF (IZE4.EQ.3 .AND. IAE4.EQ.6) EBC(1) = 1.
      IF (IZE4.EQ.3 .AND. IAE4.EQ.6) EBC(3) = 2.
CE    7LI
      IF (IZE4.EQ.3 .AND. IAE4.EQ.7) EBC(1) = 3.
      IF (IZE4.EQ.3 .AND. IAE4.EQ.7) EBC(3) = 2.
CE    7BE
      IF (IZE4.EQ.4 .AND. IAE4.EQ.7) EBC(1) = 2.
      IF (IZE4.EQ.4 .AND. IAE4.EQ.7) EBC(3) = 2.
CE    9BE
      IF (IZE4.EQ.4 .AND. IAE4.EQ.9) EBC(1) = 1.
      IF (IZE4.EQ.4 .AND. IAE4.EQ.9) EBC(3) = 2.
CE    9B
      IF (IZE4.EQ.5 .AND. IAE4.EQ.9) EBC(1) = 1.
      IF (IZE4.EQ.5 .AND. IAE4.EQ.9) EBC(3) = 2.
CE    10BE
      IF (IZE4.EQ.4 .AND. IAE4.EQ.10)EBC(1) = 1.
      IF (IZE4.EQ.4 .AND. IAE4.EQ.10)EBC(3) = 2.
CE    10B
      IF (IZE4.EQ.5 .AND. IAE4.EQ.10)EBC(1) = 1.
      IF (IZE4.EQ.5 .AND. IAE4.EQ.10)EBC(3) = 2.
CE    11B
      IF (IZE4.EQ.5 .AND. IAE4.EQ.11)EBC(1) = 3.
      IF (IZE4.EQ.5 .AND. IAE4.EQ.11)EBC(3) = 2.
CE    11C
      IF (IZE4.EQ.6 .AND. IAE4.EQ.11)EBC(1) = 3.
      IF (IZE4.EQ.6 .AND. IAE4.EQ.11)EBC(3) = 2.
CE    12C
      IF (IZE4.EQ.6 .AND. IAE4.EQ.12)EBC(3) = 2.
CE    16O
      IF (IZE4.EQ.8 .AND. IAE4.EQ.16)EBC(3) = 4.
CE    ADD OTHER PARTICLES IF NECESSARY
CE    CHECK UPPER LIMIT OF EXCITATION ENERGY RANGES
      EBC(2) = EBC(1)
      RETURN
      END
      
      SUBROUTINE OUTW (IPS,KOUTW,KOUTL,ITEXT,WQT,FFB,IZFF,SIERK,VSADOFF)
      IMPLICIT REAL*8(A-H,O-Z)

c       OUTPUT OF POPULATION AND DECAY MATRICES
c       ---------------------------------------


      COMMON EXMIN(500),EXMAX(500),EBE(4),ESEP(4,500)
      COMMON IZFMAX,IZE(4),IAE(4),JE(4),JDE(4),IEXXMX(500),IEXXS(500)
      COMMON IPS1,IPSMAX,IPSZO(4,500),IZ(500),IA(500)
      COMMON IEXXL(500),JMIN(500),JMAX(500),JJMAX(500)
      
      COMMON/C2/ FT(500),DA(500),DELTA(500),CK(500)
      COMMON/C2/ R0LDM,DEF,DEFS,DALDM,DAF,UTR,ULDM,UJTR,UJLDM,DLDM(500)
      COMMON/C5/ WT0(64,64), WT(64,64,4)
      real*8 tsum(48,1200,4),W(64,64,4)
      COMMON/C6/ TSUM,RHO(64,64,5),W,
     &     WF(64,64,40,4)
      COMMON/C7/ WG(64,5),WGZ(64,64),LZ(64,64),LZF(64,64)
      COMMON/C7/ SE(100,5),SESUM(100,5)
      common/i2dpo/i2dpop
      common/fislev/rots,rotb
      common/fullres/wwn(64,64),wwp(64,64),wwa(64,64),wwg(64,64),wwf(64,64)
      INTEGER SIERK, probnp,probagam,probn,probp,probalpha,probgam,
     &     afis(65,40,4),listz(40)
      real*8 fmassdist(40,4), esp(64,40,4), ajmass(40,4), 
     &     sigl(0:120),sigfis(0:120),xtmp(40),ytmp(40),ztmp(40)
      
      common/lildeck/elab,excn,cl0,dafis,sigfus,siger,
     &     izt,iat,izp,iap,iafmax, izfindxoff,izfindxmax
      
      DIMENSION ITEXT(80),IW(64,64),BF(64)

CSMS init
      do jj=1,40
        ztmp(jj)=0
      enddo
      
 50   FORMAT (' POPULATION MATRIX (MIKRO-BARN)   IPS=',I3,'   IZ=',I3,
     &     '  IA=',I3,3X,F6.1,' MB', 4X,57A1)
 51   FORMAT (' POPULATION AFTER GAMMA DECAY     IPS=',I3,'   IZ=',I3,
     &     '  IA=',I3,4X,F6.1,' MB')
 55   FORMAT (1H )
 56   FORMAT (1H1)
 57   FORMAT ('1C A S C A D E  I'///)
 60   FORMAT (' DECAY PROBABILITIES (NEUTRON,PROTON) IPS=',I3,'  IZ=',
     &     I3,'  IA=',I3)
 61   FORMAT (' DECAY PROBABILITIES (ALPHA,GAMMA)    IPS=',I3,'  IZ=',
     &     I3,'  IA=',I3)
 62   FORMAT (' DECAY PROBABILITIES (FISSION,DECAY4) IPS=',I3,'  IZ=',
     &     I3,'  IA=',I3)
 63   FORMAT (' LIFETIMES                            IPS=',I3,'  IZ=',
     &     I3,'  IA=',I3)
 67   FORMAT (' FISSION BARRIER (IN MEV) FOR NUCLEUS IPS=',I3,'  IZ=',
     &     I3,'  IA=',I3)
 68   FORMAT (1H ,9X,24F5.1/)
 69   FORMAT (' FISSION COMPETITION NOT INCLUDED IN THIS RUN'/)
      IF (IPS.EQ.1) WRITE(6, 57)
      
c               STEP SIZE, SPIN RANGE, EX RANGE
c               -------------------------------
      
      IEXXX = IEXXMX(IPS)
      JJX = JJMAX(IPS)
      JJD = 1
      IF (JJX.GT.28 .OR. IEXXX.GT.32) JJD = 2
      IF (JJX/JJD.GT.25) JJX = JJX - 2
      JJMIN = JJX - 23*JJD
      IF (JJMIN.LE.0) JJMIN = 1
      IEXXM = 1
      IF (JJD.EQ.2.AND. IEXXX.GT.58) IEXXM = IEXXX - 57
      IF (JJD.EQ.1.AND. IEXXX.GT.30) IEXXM = IEXXX - 29
      
cscale  IF (WQT.LT.KOUTW*1.) GO TO 1000
      IF (WQT.LT.KOUTW*0.001) GO TO 1000
      
c                       POPULATION MATRIX
c                       -----------------
      
      WRITE(6,50) IPS,IZ(IPS),IA(IPS),WQT,(ITEXT(I),I=1,57)
      DO JJ=JJMIN,JJX,JJD
        DO IEXX=IEXXM,IEXXX
          IW(IEXX,JJ) = WT0(IEXX,JJ)*1000. + 0.5
        enddo
      enddo
      CALL PRINTW (IW,IPS,JJMIN,JJX,JJD,IEXXM)
      if(i2dpop.eq.1) then
        write(28)iz(ips),ia(ips),jjmin,jjx,jjd,iexxm,iexxx
        WRITE(28)WT0
      endif
      
c               POPULATION AFTER GAMMA DECAY
c               ----------------------------
      IF (WQT.LT.IABS(KOUTL)*1.) GO TO 1000
cgamma  IF (IPS.EQ.1) GO TO 20
      WQ1 = 0.
      DO JJ=1,JJX
        DO IEXX=1,IEXXX
          WQ1 = WQ1 + WGZ(IEXX,JJ)
        enddo
      enddo
      IF (WQ1.LE.1.) then
        write(6,*) 'Total gamma decay negligible: ',wq1
        GO TO 20
      endif
      DO JJ=JJMIN,JJX,JJD
        DO IEXX=IEXXM,IEXXX
          IW(IEXX,JJ) = WGZ (IEXX,JJ)*1000. + 0.5
        enddo
      enddo
      WRITE(6,51) IPS,IZ(IPS),IA(IPS),WQ1
      CALL PRINTW (IW,IPS,JJMIN,JJX,JJD,IEXXM)

c               DECAY PROBABILITIES (N,P)
c               -------------------------

 20   WRITE(6,60)  IPS,IZ(IPS),IA(IPS)
      DO JJ=JJMIN,JJX,JJD
        DO IEXX=IEXXM,IEXXX
          LZZ = LZ(IEXX,JJ)
          IW(IEXX,JJ) = LZZ - (LZZ/10000)*10000
        enddo
      enddo
      CALL PRINTW (IW,IPS,JJMIN,JJX,JJD,IEXXM)

c               DECAY PROBABILITIES (ALPHA,GAMMA)
c               ---------------------------------

      WRITE(6,61)  IPS,IZ(IPS),IA(IPS)
      DO JJ=JJMIN,JJX,JJD
        DO IEXX=IEXXM,IEXXX
          IW(IEXX,JJ) = LZ(IEXX,JJ)/10000
        enddo
      enddo
      CALL PRINTW (IW,IPS,JJMIN,JJX,JJD,IEXXM)

c               DECAY PROBABILITIES (FISSION,DECAY 4)
c               -------------------------------------

      IF (.not.(IZFF.EQ.0 )) then
        WRITE(6,62)  IPS,IZ(IPS),IA(IPS)
        DO JJ=JJMIN,JJX,JJD
          DO IEXX=IEXXM,IEXXX
            LZZ = LZF(IEXX,JJ)
            IW(IEXX,JJ) = LZZ - (LZZ/10000)*10000
          enddo
        enddo
        CALL PRINTW (IW,IPS,JJMIN,JJX,JJD,IEXXM)
      endif

c                       LIFETIMES
c                       ---------
      IF (KOUTL.lt.0) then
        WRITE(6,63)  IPS,IZ(IPS),IA(IPS)
        DO JJ=JJMIN,JJX,JJD
          DO IEXX=IEXXM,IEXXX
            IW(IEXX,JJ) = LZF(IEXX,JJ)/10000
          enddo
        enddo
        CALL PRINTW (IW,IPS,JJMIN,JJX,JJD,IEXXM)
      endif

c               OUTPUT OF THE FISSION BARRIER FOR THE COMPOUND NUCLEUS
c               ------------------------------------------------------

 1000 IF (IPS.eq.1.and.izff.ne.0) then
        WRITE(6, 55)
        WRITE(6,67)   IPS,IZ(IPS),IA(IPS)
        
        IF( SIERK .EQ. 0 .or. iz(ips).le.19) THEN
          WRITE(6,1005)
          CALL FBARR(IPS,BF,FFB)
        ELSE
          WRITE(6,2005)
          WRITE(6,*) 'CALLING SIERKBAR'
          CALL SIERKBAR(IPS,BF,FFB)
        ENDIF
 1005   FORMAT(' STANDARD LIQUID DROP FISSION BARRIER')
 2005   FORMAT(' SIERK FISSION BARRIER')
        WRITE(6,68) (BF(JJ),JJ=JJMIN,JJX,JJD)
        IF (IZFF.EQ.0) WRITE(6, 69)
        if( iz(ips) .gt. 19) then
          call asymbar(ips,VSADOFF,esp)
          do izfindx = 1,izfindxmax
            do jjj = 6,40
              listz(jjj) = jjj/2+izfindxoff+izfindx
            enddo
c              write(6,2081) VSADOFF,izfindx,(im, im=6,40),
c       1       (listz(im),im=6,40)
 2081       format('1 Asymmetric fission barriers: (OFFSET = ',F6.2,')'
     &           /'  z = a/2 - 2 + ',i3  ///
     &           '  j                                           V(saddle)'/
     &           10x,23i5/
     &           10x,23i5/
     &           ' ----',5x,23(' ----')/)
            do jj=jjmin,min(jjx,44)
              j = jj + jmin(1)
c                write(6,2082) j,(esp(jj,im,izfindx),im=6,iafmax)
 2082         format(i5,5x,23f5.1)
            enddo               !jj
          enddo                 !izfindx
        endif
        ex = exmin(1) + iexxmx(1)
        write(6,1010) iz(ips), ia(ips), ex
 1010   format('1    DETAILED SUMMARY OF COMPOUND',
     &       ' NUCLEUS DECAY',
     &       ' - (Z,A) = (',I3,',',I3,
     &       ')'/40x,'EXCITATION ENERGY = ',F6.2)
        write(6,1015)
 1015   FORMAT(
     &       '0  L  SIGL(MB)  n,p   alpha,gam  fission  sigfis   bfis   yrast',
     &       ' yr_sierk'/
     &       '  -   -------  -----    -----     -----    ----    -----  -----',
     &       '  --------')
 1020   format(1x,f4.1,2x,f7.2,1x,i2,1x,i2,3x,i2,1x,i2,6x,
     &       f6.1,2x,f7.2,2x,
     &       f6.2,1x,f6.2,f6.2,5x)
 1021   format(1x,f4.1,2x,f7.2,1x,i2,1x,i2,3x,i2,1x,i2,6x,
     &       f6.1,2x,f7.2,2x,
     &       f6.2,1x,f6.2,f6.2,5x,'*******')
        A = IA(ips)
        z = iz(ips)
        CR = 52.2371/R0LDM**2
        CR = CR/A**(5./3.)
        sumfis = 0
        sumfus = 0
        JD = 0
        IF (2*(IA(IPS)/2).NE.IA(IPS)) JD = 1
        do isum = 6,iafmax
          do izfindx = 1,izfindxmax
            fmassdist(isum,izfindx) = 0
            ajmass(isum,izfindx) = 0
          enddo
        enddo
        DO jj=jjmin,min(jjx,64)
          l = (JD+1) * (JMIN(IPS)+JJ) + JD
          fl = float(l)/(jd+1)
          CL2 = fl * fl
          CL4 = CL2 * CL2
          EROT = CR * FL * (fL+1.) / (1.+DEF*CL2+DEFS*CL4)
          sigl(l) = WT0(iexxmx(1),JJ) 
          sumfus = sumfus + sigl(l)
          LZZ = LZ(iexxmx(1),JJ)
c             probnp= LZZ - (LZZ/10000)*10000
c             probn = probnp/100
c             probp = probnp - 100*probn
c             probagam= LZ(iexxmx(1),JJ)/10000
c             probalpha = probagam/100
c             probgam = probagam - 100*probalpha
c             probfis = 0
          probn = 100*wwn(iexxmx(1),jj)
          probp = 100*wwp(iexxmx(1),jj)
          probalpha = 100*wwa(iexxmx(1),jj)
          probgam = 100*wwg(iexxmx(1),jj)
          probfis = 100*wwf(iexxmx(1),jj)
          bfis = 0
          if(.not.( izff .eq. 0 .and. izfmax.le.3).and.iz(ips).ge.10) then

c                probfis = lzf(iexxmx(1),JJ) - (lzf(iexxmx(1),JJ)/10000)*10000
c                probfis = probfis/100

            sigfis(l) = sigl(l) * probfis/100
            sumfis = sumfis + sigfis(l)
            if( iz(ips) .ge. 19) then
              call barfit(iz(ips),ia(ips),fl,
     &             bfis,yrsierk,selmax)
            else
              bfis = 100
              yrsierk = 0
              selmax = 200
            endif
            sumfp = 0
            do isum = 6,iafmax
              do izfindx = 1,izfindxmax
                sumfp = sumfp + wf(iexxmx(1),jj,isum,izfindx)
              enddo
            enddo
            fisnorm = 0
            if( sumfp .gt. 0 ) fisnorm = 1/sumfp
            do isum = 6,iafmax
              do izfindx = 1,izfindxmax
                afis(jj,isum,izfindx) = 
     &               99.4 * wf(iexxmx(1),jj,isum,izfindx)*fisnorm + 0.5
                fmassdist(isum,izfindx) = fmassdist(isum,izfindx) + 
     &               sigfis(l) * wf(iexxmx(1),jj,isum,izfindx)
     &               *fisnorm 
                ajmass(isum,izfindx) = ajmass(isum,izfindx) + 
     &               fl*sigfis(l)*wf(iexxmx(1),jj,isum,izfindx)
     &               *fisnorm
              enddo
            enddo       
          else
            bfis = 100
            yrsierk = 0
            selmax = 200
            do isum = 6,iafmax
              do izfindx = 1,izfindxmax
                afis(jj,isum,izfindx) = 0
              enddo
            enddo
          endif
          if( l .lt. selmax) then
            write(6,1020) fl,sigl(l),probn,probp,probalpha,probgam,
     &           probfis,sigfis(l),bfis,erot,yrsierk
          else
            write(6,1021) fl,sigl(l),probn,probp,probalpha,probgam,
     &           probfis,sigfis(l),bfis,erot,yrsierk
          endif
        enddo
        write(6,1029) sumfus
 1029   format('0Total fusion cross section =  ',f7.2)
        write(6,1030) sumfis
 1030   format('0Total fission cross section '/
     &       '   (assuming every partial wave calculated-check CJC!) =',
     &       f6.2)
        write(6,1041) rots, rotb
 1041   format('0Moments of inertia and spin cutoff calculated with:'/
     &       '      s = ',f10.3/
     &       '   beta = ',f10.3)
 1031   format('1')
        write(6,1031)
        write(6,1032)
 1032   format('0Breakdown of fission yield by mass and spin: (percent)'
     &       ///)
        do isum = 6,iafmax
          afis(65,isum,1) = isum
        enddo
        write(6,1033) (afis(65,isum,1),isum=6,iafmax)
 1033   format(10x,40i3)
        DO jj=jjmin,min(jjx,64)
          l = (JD+1) * (JMIN(IPS)+JJ) + JD
          fl = float(l)/(jd+1)
          do isum = 6,iafmax
            xtmp(isum) = 0
            do izfindx = 1,izfindxmax
              xtmp(isum) = xtmp(isum)+afis(jj,isum,izfindx)
            enddo
          enddo
          write(6,1034) fl,(nint(xtmp(isum)),isum=6,iafmax)
 1034     format(4x,f4.1,3x,40i3)
        enddo
        
        do isum = 6,iafmax
          ytmp(isum) = 0
          do izfindx = 1,izfindxmax
            ytmp(isum) = ytmp(isum)+fmassdist(isum,izfindx)
          enddo
        enddo
        write(6,1035) iafmax,(ytmp(iij),iij=6,iafmax)
 1035   format('0   Fission mass distribution (mb), A = 6-',i2,':'/
     &       5x,12f5.1/5x,12f5.1/5x,12f5.1/5x,12f5.1)
        do iij = 6,iafmax
          do izfindx = 1,izfindxmax
            ztmp(iij) = ztmp(iij) + ajmass(iij,izfindx)
          enddo
          if(ytmp(iij) .gt. 0 ) ztmp(iij) = ztmp(iij)/ytmp(iij)
        enddo
        write(6,1036) iafmax,(ztmp(iij),iij = 6,iafmax)
 1036   format('0    Average spin for masses A = 6-',i2,':'/
     &       5x,12f5.1/5x,12f5.1/5x,12f5.1/5x,12f5.1)
        fisjav = 0
        tempsum = 0
        do isum = 12,iafmax
          do izfindx = 1,izfindxmax
            tempsum = fmassdist(isum,izfindx) + tempsum
            fisjav = fisjav + ajmass(isum,izfindx)
          enddo
        enddo
        if(tempsum .gt. 0 ) fisjav = fisjav/tempsum
CSMS       call lildeck(fmassdist,ajmass,fisjav,sigfis,fisnorm,jd,jmin(ips),
CSMS     1)
CSMS Name clash function lildeck, common lildeck
        call lildeckf(fmassdist,ajmass,fisjav,sigfis,fisnorm,jd,jmin(ips))
        write(6,1031)

CSMS           II=SYS$SETPRN('NI56_STAGE2')
      endif
      return
      END
      
      SUBROUTINE PRINTW (IW,IPS,JJMIN,JJX,JJD,IEXXM)
      IMPLICIT REAL*8(A-H,O-Z)
CE    PRINTS THE MATRIX IW(64,64)  (FOR OUTW)
      COMMON EXMIN(500),EXMAX(500),EBE(4),ESEP(4,500)
      COMMON IZFMAX,IZE(4),IAE(4),JE(4),JDE(4),IEXXMX(500),IEXXS(500)
      COMMON IPS1,IPSMAX,IPSZO(4,500),IZ(500),IA(500)
      COMMON IEXXL(500),JMIN(500),JMAX(500),JJMAX(500)

      DIMENSION IW(64,64),J(64)
      DATA IBLANK,ICHS,ICHL /' ','S','L'/
CE
 52   FORMAT ('   EX     ',24I5)
 53   FORMAT ('   EX     ', 24(I3,'/2'))
 54   FORMAT (1H ,F6.2,1X,A1,1X,24I5)
 55   FORMAT (1H )
 56   FORMAT (1H1)
CE
CE
      JD = 0
      IF (2*(IA(IPS)/2).NE.IA(IPS)) JD = 1
      DO 12  JJ=JJMIN,JJX
 12   J(JJ) = (JD+1) * (JMIN(IPS)+JJ) + JD
      IF (JD.EQ.0) WRITE(6,52,err=13) (J(JJ),JJ=JJMIN,JJX,JJD)
      IF (JD.EQ.1) WRITE(6,53,err=13) (J(JJ),JJ=JJMIN,JJX,JJD)
 13   continue
C      WRITE(6, 55)
CE
      IEXXX = IEXXMX(IPS)
      DO 24  IEXQ=IEXXM,IEXXX
        IEXX = IEXXX + IEXXM - IEXQ
        EX = EXMIN(IPS) + IEXX
        ICH = IBLANK
        IF (IEXX.EQ.IEXXS(IPS)) ICH = ICHS
        IF (IEXX.EQ.IEXXL(IPS)) ICH = ICHL
        WRITE(6,54,err=14) EX,ICH,(IW(IEXX,JJ),JJ=JJMIN,JJX,JJD)
 14     continue
C      IF (JJD.EQ.1.AND. IEXQ.LT.IEXXX) WRITE(6, 55)
 24   CONTINUE
CE
      IF (IPS.EQ.1) WRITE(6, 55)
      IF (IPS.GT.1) WRITE(6, 56)
      RETURN
      END

      SUBROUTINE OUTS(IPS,KEVAP,KGAMMA,EMINT,ITEXT,WQT,SCN)
      IMPLICIT REAL*8(A-H,O-Z)
CE    PRINTOUT OF EVAPORATION AND GAMMA SPECTRA
      
      COMMON EXMIN(500),EXMAX(500),EBE(4),ESEP(4,500)
      COMMON IZFMAX,IZE(4),IAE(4),JE(4),JDE(4),IEXXMX(500),IEXXS(500)
      COMMON IPS1,IPSMAX,IPSZO(4,500),IZ(500),IA(500)
      COMMON IEXXL(500),JMIN(500),JMAX(500),JJMAX(500)
      
      COMMON/C7/ WG(64,5),WGZ(64,64),LZ(64,64),LZF(64,64)
      COMMON/C7/ SE(100,5),SESUM(100,5)
      DIMENSION ITEXT(80),WQE(5),X(5),S(64),SMAX(5),IPLOT(41),IPLOTG(41)
      DIMENSION EMINT(4),SEPLOT(100,5)
      DATA IBLANK,INZ,IPZ,IAZ,IDZ,NULL/' ','N','P','A','4','0'/
CE
      IZFX = IZFMAX + 1
      IF (IPS.EQ.0) GO TO 30
CE
CE    SUMMATION ONTO SESUM(IEKINA,IZF), TRANSFER TO SEPLOT
      DO 21  IZF=1,IZFX
        DO 18  IEKINA=1,100
 18     SEPLOT(IEKINA,IZF) = 0.
        DO 21  IEKIN=1,100
          SEX = SE (IEKIN,IZF)
          IF (IZF.LE.4) IEKINA = EMINT(IZF) + IEKIN
          IF (IZF.EQ.IZFX) IEKINA = IEKIN
          IF (IEKINA.GT.100) IEKINA = 100
          SEPLOT(IEKINA,IZF) = SEX
 21   SESUM (IEKINA,IZF) = SESUM(IEKINA,IZF) + SEX
CE
      IF (WQT.LT.KEVAP*1.) GO TO 1000
      GO TO 60
CE
CE    SUM SPECTRA INTO SEPLOT (IF IPS=0)
 30   DO 32  IZF=1,IZFX
        DO 32  IEKINA=1,100
 32   SEPLOT(IEKINA,IZF) = SESUM(IEKINA,IZF)
CE
 73   FORMAT (' EVAPORATION SPECTRA FOR NUCLEUS ',I3,'   IZ =',I3,
     1     '   IA =',I3,10X,50A1/)
 75   FORMAT (' SUMMED EVAPORATION SPECTRA ',40X,50A1/)
 77   FORMAT (' EKIN  ',3X,'N',7X,'P',5X,'ALPHA  ',
     1     '  SPECTRA',33X,'EKIN   GAMMA  SPECTRUM'/)
 79   FORMAT (' EKIN  ',2X,'N',6X,'P',4X,'ALPHA',4X,'4',4X,
     1     '  SPECTRA',33X,'EKIN   GAMMA  SPECTRUM'/)
 80   FORMAT (1H ,F4.1,1X,3F8.3,1X,41A1,1X,
     1     F5.1,F9.3,1X,41A1)
 81   FORMAT (1H ,F4.1,1X,4F7.3,1X,41A1,1X,
     1     F5.1,F9.3,1X,41A1)
 82   FORMAT (1H0)
 83   FORMAT (' SUM  ',3F8.1,' MB',39X,' SUM',F10.1,' MB'/
     1     6X,3F8.1,' MULTIPLICITY',35X,F8.1,' MULTIPLICITY')
 84   FORMAT (' SUM  ',4F7.1,' MB',39X,' SUM',F10.1,' MB'/
     1     6X,4F7.1,' MULTIPLICITY',35X,F8.1,' MULTIPLICITY')
 85   FORMAT (1H1)
 86   FORMAT (1H0,'GAMMA DECAY NOT CALCULATED BELOW PARTICLE THRESHOLD')
 87   FORMAT (1H0,'EKIN FOR DECAY 4 IS TO BE UNDERSTOOD AS THE PRINTED V',
     1     'ALUE + ',F5.2,' MEV')
CE
CE
 60   continue
      IF (IPS.EQ.0) WRITE(6,75)(ITEXT(I),I=1,50)
      IF (IPS.NE.0) then
        WRITE(6,73) IPS,IZ(IPS),IA(IPS),(ITEXT(I),I=1,50)
        WRITE(56,73) IPS,IZ(IPS),IA(IPS),(ITEXT(I),I=1,50)
        WRITE(57,73) IPS,IZ(IPS),IA(IPS),(ITEXT(I),I=1,50)
      endif
      IF (IZFMAX.LE.3) WRITE(6, 77)
      IF (IZFMAX.EQ.4) WRITE(6, 79)
CE
CE    TOTAL CROSS SECTIONS WQE(IZF), MULTIPLICITY X(IZF)
CE    MAXIMA OF THE SPECTRA SMAX(IZF)
      DO 98  IZF=1,IZFX
        WX = 0.
        SEX = 0.
        DO 92 IEKINA=1,100
          SX = SEPLOT(IEKINA,IZF)
          WX = WX + SX
          IF (IEKINA.EQ.1 .AND. IZF.EQ.IZFX) SX = 0.
          IF (SX.GT.SEX) SEX = SX
 92     CONTINUE
        WQE(IZF) = WX
        X(IZF) = WX/SCN
        IF (SEX.LT.0.0001) SEX = 0.0001
 98   SMAX(IZF) = SEX
CE
      DO 108  IEKINA=1,100
        EKIN = IEKINA - 0.5
        EKING = IEKINA
        DO 103 I=2,41
          IPLOT(I) = IBLANK
 103    IPLOTG(I) = IBLANK
        IF (IZFMAX.LE.3) GO TO 105
        S4 = SEPLOT(IEKINA,4)
        IX=0
        IF(SMAX(4).GT.0.)      IX = 40.*S4/SMAX(4) + 1.49
        IF(IX.GT.0)IPLOT(IX) = IDZ
 105    S2 = SEPLOT(IEKINA,2)
        IX=0
        IF(SMAX(2).GT.0.)      IX = 40.*S2/SMAX(2) + 1.49
        IF(IX.GT.0)IPLOT (IX) = IPZ
        S3 = SEPLOT(IEKINA,3)
        IX=0
        IF(SMAX(3).GT.0.)      IX = 40.*S3/SMAX(3) + 1.49
        IF(IX.GT.0)IPLOT (IX) = IAZ
        S1 = SEPLOT(IEKINA,1)
        IF(S1.NE.0.)WRITE(57,*)EKIN,S1
        IX=0
        IF(SMAX(1).GT.0.)      IX = 40.*S1/SMAX(1) + 1.49
        IF(IX.GT.0)IPLOT (IX) = INZ
        SG = SEPLOT(IEKINA,IZFX)
        IF(SG.NE.0.)WRITE(56,*)EKING,SG
        IX=0
        IF(SMAX(IZFX).GT.0.)      IX = 40.*SG/SMAX(IZFX) + 1.49
        IF (IX.GT.41) IX = 41
        IF(IX.GT.0)IPLOTG(IX) = NULL
        IPLOT (1) = NULL
        IPLOTG(1) = NULL
        IF (IZFMAX.EQ.3)then
          WRITE(6,80)EKIN,S1,S2,S3,   IPLOT,EKING,SG,IPLOTG
        endif
        IF(IZFMAX.EQ.4)WRITE(6,81)EKIN,S1,S2,S3,S4,IPLOT,EKING,SG,IPLOTG
 108  CONTINUE
CE
      WRITE(56,*)' PLOT'
      WRITE(57,*)' PLOT'
c       CLOSE(UNIT=56)
c       CLOSE(UNIT=57)
      WRITE(6, 82)
      IF (IZFMAX.EQ.3) WRITE(6,83) (WQE(IZF),IZF=1,4),(X(IZF),IZF=1,4)
      IF (IZFMAX.EQ.4) WRITE(6,84) WQE,X
      IF (KGAMMA.EQ.0) WRITE(6, 86)
      IF (IZFMAX.EQ.3) GO TO 130
      IEKINA = EMINT(4) + 1
      ED = EMINT(4) - IEKINA + 0.5
      WRITE(6,87) ED
 130  CONTINUE
      WRITE(6, 85)
CE
 1000 RETURN
      END
      
      SUBROUTINE MYERS (IZ,IA,EBLD0,EBGS,EVODD)
      IMPLICIT REAL*8(A-H,O-Z)
CE    CALCULATES THE GROUND STATE BINDING ENERGY OF A NUCLEUS
CE    USING THE DROPLET MODEL OF MYERS (PLENUM PRESS 1977)
CE    EBGS  = G.S. BINDING ENERGY IN MEV
CE    EBLD0 = BINDING ENERGY OF A SPHERICAL LIQUID DROP
CE            WITHOUT SHELL CORRECTION,BUT WITH PAIRING AND WIGNER TERM
CE    EVODD = EVEN-ODD TERM (SIGN OPPOSITE TO MYERS)
CE    S     = SHELL EFFECT AT EQUILIBRIUM DEFORMATION ( " )
CE    S EFF = SHELL CORRECTION (EBGS - EBLD0) (SIGN OPPOSITE TO MYERS)
CE
      DIMENSION MSHELL(9)
      DATA MSHELL /2,8,14,28,50,82,126,184,258/
      Z = IZ
      A = IA
      N = IA - IZ
      IF (IZ.LE.2 .OR. N.LE.2) GO TO 90
      CI = (A-2.*Z)/A
      A13 = A**(1./3.)
      A23 = A**(2./3.)
      A43 = A**(4./3.)
CE
CE    CONSTANTS
      A1 = 15.96
      A2 = 20.69
      CJ = 36.8
      R0 = 1.18
      A3 = 0.
      Q  = 17.
      CK = 240.
      CL = 100.
      CM = 0.
CE    CONSTANTS FOR SHELL CORRECTION
      CC  = 5.8
      CSC = 0.325
      CAR = 0.444
CE    DERIVED PARAMETERS
      C1 = 0.73219
      C2 = 1.6302E-4
      C3 = 1.28846
      C4 = 0.55911
      C5 = 4.9274E-4
CE
CE    BINDING ENERGY OF THE ATOMIC ELECTRONS
      ECLOUD = 14.33E-6*Z**2.39
CE    WIGNER TERM
      EWIGN= -30.*ABS(CI)
      IF (N.EQ.IZ .AND. 2*(N/2).NE.N) EWIGN = EWIGN - 30./A
CE    EVEN-ODD TERM
      DELTA = 12./SQRT(A)
      SDELTA= 20./A
      EVODD = -0.5 * SDELTA
      IF (2*(N/2).EQ.N .AND. 2*(IZ/2).EQ.IZ) EVODD = EVODD + DELTA
      IF (2*(N/2).NE.N .AND. 2*(IZ/2).NE.IZ) EVODD = EVODD-DELTA+SDELTA
CE
CE
CE    SHELL FUNCTION SNZ = S(N,Z)
CE    NEXT PROTON SHELL
      DO 10  I=2,9
        IF (IZ.LE.MSHELL(I)) GO TO 12
 10   CONTINUE
 12   MZI = MSHELL(I)
      MZI1= MSHELL(I-1)
CE    NEXT NEUTRON SHELL
      DO 14  I=2,9
        IF (N .LE.MSHELL(I)) GO TO 16
 14   CONTINUE
 16   MNI = MSHELL(I)
      MNI1= MSHELL(I-1)
CE
      QZ = 0.6 * (MZI**1.666667-MZI1**1.666667)/(MZI-MZI1)
      QN = 0.6 * (MNI**1.666667-MNI1**1.666667)/(MNI-MNI1)
      FZ = QZ*(IZ-MZI1) - 0.6*(IZ**1.666667-MZI1**1.666667)
      FN = QN*(N -MNI1) - 0.6*(N **1.666667-MNI1**1.666667)
      SNZ= -CC * (1.5874*(FN+FZ)/A23 - CSC*A13)
CE
CE
      EBX = 0.
      ALPHA2 = 0.
      IC = 1
CE
CE    SHAPE DEPENDENCES
CE    ALPHA2 IS THE DEFORMATION PARAMETER
CE    DEFINED IN ANN.PHYS. 84 TABLE 2
 20   AL2 = ALPHA2**2
      AL3 = ALPHA2**3
      AL4 = ALPHA2**4
      BS = 1. + 0.4*AL2 - 0.0381*AL3 - 0.3771*AL4
      BC = 1. - 0.2*AL2 - 0.0381*AL3 + 0.2082*AL4
      BK = 1. + 0.4*AL2 + 0.1524*AL3 - 0.4686*AL4
      BR = 1. + 0.4*AL2 + 0.1524*AL3 - 2.5264*AL4
      BV = 1. - 0.2*AL2 - 0.0190*AL3 - 0.2065*AL4
      BW = 1.                        - 0.9918*AL4
      THETA = ALPHA2*0.4472*A13/CAR
      BSHL = (1.-2.*THETA**2)*EXP(-THETA**2)
CE
      S = SNZ * BSHL
CE
      DBAR = (CI+0.0080756*BV*Z/A23)/(1.+4.87059*BS/A13)
      EBAR = (-2.*A2*BS/A13+CL*DBAR**2+C1*BC*Z*Z/A43)/CK
CE
      EVOL = (A1 - CJ*DBAR**2 + 0.5*CK*EBAR**2) * A
      ESURF= (-A2 - 2.25*CJ*CJ*DBAR*DBAR/Q)*BS * A23
      ECOUL= -C1*BC*Z*Z/A13 + C2*BR*Z*Z*A13 + C3*Z*Z/A
     1     + C4*Z/(2.**(1./3.)) + C5*BW*Z*Z
CE    TERMS WITH A3 AND CM=0. LEFT OUT
CE
      EBLD  = EVOL + ESURF + ECOUL + ECLOUD
      EBGS  = EBLD + EVODD + EWIGN + S
      IF (ALPHA2.GT.0.005) GO TO 30
      EBLQ  = EBLD
      EBLD0 = EBGS - S
      S0 = S
CE
 30   IF (SNZ.GT.0. .OR. IC.EQ.-1) GO TO 90
      IF (EBGS.LE.EBX) IC = -1
      ALPHA2 = ALPHA2 + IC*0.01
      EBX = EBGS
      IF (ALPHA2.LE.0.40) GO TO 20
CE
 90   SEFF = EBGS - EBLD0
 100  RETURN
      END
      
      SUBROUTINE STANLV (IZ,IA)
      IMPLICIT REAL*8(A-H,O-Z)
CE    CALCULATES A STANDARD SPECTRUM OF LOW-LYING LEVELS

      COMMON/C3/ EXLVX(100),EXLV(100,100),IPSLVX,IZLV(100),
     &     IALV(100),LVMAX(100), JLV(100,100)

      DIMENSION J0(41),        SHLLZ(7),SHLLN(7)
      DATA J0 /1,1,3,1,5,3,5,1,3,3,7,7,5,7,3,3,3,3,5,1,9,3,5,7,9,
     1     5,5,5,5,5,7,5,3,5,5,5,5,5,5,5,5/
      DATA SHLLZ /8.,20.,28.,50.,82.,114.,184./
      DATA SHLLN /8.,20.,28.,50.,82.,126.,184./
CE
      E2 = 0.1 * (173./IA)**2
      IF (E2.GT.1.8) E2 = 1.8
      N = IA - IZ
      ISHLLZ = 1
      DZ = 100.
      DO 10  I=1,7
        DZZ = IZ - SHLLZ(I)
        DZZ = ABS(DZZ)
        IF (DZZ.GE.DZ) GO TO 10
        DZ = DZZ
        ISHLLZ = I
 10   CONTINUE
      ISHLLN = 1
      DN = 100.
      DO 12  I=1,7
        DNN = N - SHLLN(I)
        DNN = ABS(DNN)
        IF (DNN.GE.DN) GO TO 12
        DN = DNN
        ISHLLN = I
 12   CONTINUE
CE
      SBZ = 1.3
      SBN = 1.3
      DBZ = 0.4*SQRT(SHLLZ(ISHLLZ))
      DBN = 0.4*SQRT(SHLLN(ISHLLN))
      X = DZ/DBZ
      EZ = 0.
      IF (X.LT.100.) EZ = EXP(-X)
      X = DN/DBN
      EN = 0.
      IF (X.LT.100.) EN = EXP(-X)
      SBZ = SBZ * EZ
      SBN = SBN * EN
      E2 = E2 + SBZ + SBN
CE
      E4 = 3.*E2
      IF (E2.GE.0.5) E4 = 2.3*E2
      IF (E4.GT.3.5) E4 = 3.5
      E6 = 6.*E2
      IF (E2.GE.0.5) E6 = 4.5 * E2
      IF (E6.GT.4.8) E6 = 4.8
      E8 = 10.*E2
      IF (E2.GE.0.5) E8 = 7.5 * E2
      IF (E8.GT.6.) E8 = 6.
CE
      IUU = 0
      J = 0
      IF (2*(IZ/2).EQ.IZ .AND. 2*(N/2).EQ.N) GO TO 30
      N2 = (IZ+1)/2
      IF (N2.GT.41) N2 = 11
      J = J0(N2)/2
      IF (2*(N/2).EQ.N) GO TO 30
      N2 = (N+1)/2
      IF (N2.GT.41) N2 = 11
      J = J0(N2)/2
      IF (2*(IZ/2).EQ.IZ) GO TO 30
      IUU = 2
      N2 = (N+1)/2
      IF (N2.GT.41) N2 = 11
      IZ2 = (IZ+1)/2
      IF (IZ2.GT.41) IZ2 = 11
      J = (J0(N2)+J0(IZ2))/2
 30   CONTINUE
CE
      IZLV(1) = IZ
      IALV(1) = IA
      EXLVX(1) = E4 - 0.05
      EXLV(1,1) = 0.
      EXLV(2,1) = E2
      EXLV(3,1) = E4
      EXLV(4,1) = E6
      EXLV(5,1) = E8
      JLV (1,1) = J
      JLV (2,1) = J + 2
      JLV (3,1) = J + 4
      JLV (4,1) = J + 6
      JLV (5,1) = J + 8
      LVMAX(1) = 5
      IF (IUU.LT.2) GO TO 100
      EXLVX(1) = E2 - 0.05
      LVMAX(1) = 2
 100  RETURN
      END
      
      FUNCTION YRASTL( EX,iz,IA,DELTA,R0,DEF,DEFS,LCR,ISPECOPT,ips)
      IMPLICIT REAL*8(A-H,O-Z)
CE    YRAST ANGULAR MOMENTUM, CALCULATED IN AGREEMENT WITH LEVELD
CE    MINIMUM = 8, MAXIMUM = LCR
      COMMON/OFFSET/UXOFET,OFFEV,OFFODD,TRAMO
     &     ,CSPLIEV,DSPLIEV,CSPLIOD,DSPLIOD,JNOD

      EXD = EX - DELTA
      A = IA
      IF (IA.LE.4) A = 4.
      CR = 34.540 * (1.2249/R0)**2
      CR = CR/A**(5./3.)
      DO 10 L=8,LCR
        CL2 = L * L
        CL4 = CL2 * CL2
C
        EROT = CR * L * (L+1.) / (1.+DEF*CL2+DEFS*CL4)
        cj = l
        if(iz .gt. 20) call barfit(iz,ia,cj,bfis,erot,selmax)
        if( erot .eq. 0 ) EROT = CR * L * (L+1.) / (1.+DEF*CL2+DEFS*CL4)

C
C       SPECIAL OPTION YRAST LINE FOR 154 ER
C
        IF(ISPECOPT.EQ.1)THEN
          cj = l
          EROT=YRASTLINE(cj,IA)
        ENDIF
C
        IF (EROT.GT.EXD) GO TO 20
 10   CONTINUE
      L = LCR
 20   YRASTL = L
 16   RETURN
      END
      
      FUNCTION NPDRIP(IZ)
      IMPLICIT REAL*8(A-H,O-Z)
CE    ANALYTICAL APPROXIMATION TO THE PROTON DRIP LINE (EB=-3.MEV)
CE    TAKEN FROM MYERS-SWIATECKI UCRL
CE    DEFINITION OF NPDRIP SEE EBTABLE
      ALPHA = -5.
      BETA = 0.70
      GAMMA = 4.95E-3
      NPD    = ALPHA + BETA*IZ + GAMMA*IZ*IZ + 0.5
      IF (NPD.LT.0) NPD = 0
      NPDRIP = NPD
      RETURN
      END
      
      SUBROUTINE TLCALC (IPS,EMINT4)
      IMPLICIT REAL*8(A-H,O-Z)
CE    IST NOCH ZU ERFINDEN *******************************************
CE    ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
CSMS    real*8 tsum(48,1200,4),T(64,64,4)
      real*8 tsum(48,1200,4),W(64,64,4)
      COMMON/C6/ tsUM,RHO(64,64,5),W,WF(64,64,40,4)
      WRITE(6, 1)
 1    FORMAT (' ERROR: INTERNAL CALC. OF TL FOR DECAY 4 NOT AVAILABLE'/)
      EMINT4 = 10.
      DO 10 L1=1,32
        DO 10  IEKIN=1,32
CSMS10    T(IEKIN,L1,4) = 0.
 10   W(IEKIN,L1,4) = 0.
      RETURN
      END
      
      FUNCTION CLFUS (IZP,IAP,IZT,IAT,ELAB)
      IMPLICIT REAL*8(A-H,O-Z)
CE    CALCULATES APPROXIMATE VALUE FOR MAXIMUM ANGULAR MOMENTUM
CE    FOR FUSION
CE
      write(6,222) izp,iap,izt,iat,elab
 222  format(' CLFUS::izp,iap,izt,iat,elab= ',4i10,f12.3)
      CL = 0.
      R0 = 1.18
      D1 = 0.8
      D2 = 2.9 - 0.005*(IAP+IAT)
      ZP = IZP
      AP = IAP
      ZT = IZT
      AT = IAT
      CMY = 931.*AP*AT/(AT+AP)
      AC = SQRT(2.*CMY)/197.
      R = R0*(AT**(1./3.)+AP**(1./3.))
      ECM = ELAB * AT/(AP+AT)
      ECB = 1.44 * ZP * ZT/(R+D2)
      IF (ECM.LE.ECB) GO TO 100
      CL = AC * SQRT(ECM-ECB) * (R+D1)
CE
CE    MAXIMUM VALUE, COHEN,PLASIL,SWIATECKI BF = 8 MEV
CE    FOR VALLEY OF STABILITY
      A0 = -4.
      A1 = 0.95
      A2 = -1.E-3
      A3 = -11.9E-6
      A = AP + AT
      CLCPS = A0 + A1*A + A2*A*A + A3*A*A*A
      IF (CLCPS.LT.0.) CLCPS = 0.
      IF (CL.GT.CLCPS) CL = CLCPS
 100  CLFUS = CL
      write(6,333) clfus
 333  format(' .....return clfus = ',f12.3)
      RETURN
      END
      
      FUNCTION EBLDM (IZ,IA,KOPTEB,ALPHA2)
      IMPLICIT REAL*8(A-H,O-Z)
CE    LIQUID-DROP BINDING ENERGY (MEV)
CE    OPTIONS KOPTEB =
CE        0 MYERS-SWIATECKI LYSEKIL
CE        1 MYERS DROPLET MODEL
CE        2 SAME WITH WIGNER TERM
CE        3 GROOTE,HILF,TAKAHASHI
CE        4 SAME WITH WIGNER TERM
CE        5 SEEGER
CE        6 SAME WITH WIGNER TERM
CE
      Z = IZ
      A = IA
      N = IA - IZ
      CI = (A-2.*Z)/A
      A13 = A**(1./3.)
      A23 = A**(2./3.)
      A43 = A**(4./3.)
CE
CE    SHAPE DEPENDENCE  (DROPLET MODEL) (KOPTEB = 1,2,3,4)
CE    ALPHA2 IS THE DEFORMATION PARAMETER
CE    DEFINED IN ANN.PHYS. 84 TABLE 2
      AL2 = ALPHA2**2
      AL3 = ALPHA2**3
      AL4 = AL2*AL2
      BS = 1. + 0.4*AL2 - 0.0381*AL3 - 0.3771*AL4
      BC = 1. - 0.2*AL2 - 0.0381*AL3 + 0.2082*AL4
      BK = 1. + 0.4*AL2 + 0.1524*AL3 - 0.4686*AL4
      BR = 1. + 0.4*AL2 + 0.1524*AL3 - 2.5264*AL4
      BV = 1. - 0.2*AL2 - 0.0190*AL3 - 0.2065*AL4
      BW = 1.                        - 0.9918*AL4
CE
      K = KOPTEB + 1
      GO TO  (10,20,20,30,30,40,40), K
CE    OPTION   0  1  2  3  4  5  6
CE
CE
CE    BINDING ENERGY OF A SPHERICAL LIQUID DROP
CE    WITHOUT EVEN-ODD CORRECTION
CE    MYERS-SWIATECKI LYSEKIL MASS FORMULA (ARKIV FOR FYSIK 36)
 10   A1 = 15.4941
      A2 = 17.9439
      CKAPPA = 1.7826
      C3 = 0.7053
      C4 = 1.1530
      E1 = (1.-CKAPPA*CI**2)*(A1*A - A2*A23)
      E2 = C3*Z*Z/A13
      E3 = C4*Z*Z/A
      EBLDM = E1 - E2 + E3
      RETURN
CE
CE
CE
CE    BINDING ENERGY (IN MEV) OF A SPHERICAL LIQUID DROP
CE    WITHOUT SHELL AND EVEN-ODD CORRECTION,
CE    ACCORDING TO THE DROPLET MODEL OF MYERS AND SWIATECKI,
CE    ANN. PHYS. 84 (1974) 186,
CE    WITH PARAMETER VALUES AS GIVEN BY MYERS, DROPLET MODEL OF
CE    ATOMIC NUCLEI, PLENUM PRESS, 1977
CE    IF KOPTEB = 2, THE WIGNER TERM IS INCLUDED
CE    DEFORMATION IS ALSO TREATED
CE
CE    CONSTANTS
 20   A1 = 15.96
      A2 = 20.69
      CJ = 36.8
      R0 = 1.18
      A3 = 0.
      Q  = 17.
      CK = 240.
      CL = 100.
      CM = 0.
CE    DERIVED PARAMETERS
      C1 = 0.73219
      C2 = 1.6302E-4
      C3 = 1.28846
      C4 = 0.55911
      C5 = 4.9274E-4
      DBAR = (CI+0.0080756*BV*Z/A23)/(1.+4.87059*BS/A13)
      EBAR = (-2.*A2*BS/A13+CL*DBAR**2+C1*BC*Z*Z/A43)/CK
CE
CE
      EVOL = (A1 - CJ*DBAR**2 + 0.5*CK*EBAR**2) * A
      ESURF= (-A2 - 2.25*CJ*CJ*DBAR*DBAR/Q)*BS * A23
      ECOUL= -C1*BC*Z*Z/A13 + C2*BR*Z*Z*A13 + C3*Z*Z/A
     1     + C4*Z/(2.**(1./3.)) + C5*BW*Z*Z
CE    TERMS WITH A3 AND CM=0. LEFT OUT
      EWIGN = 0.
      IF (KOPTEB.EQ.1) GO TO 22
      EWIGN= -30.*ABS(CI)
      IF (N.EQ.IZ .AND. 2*(N/2).NE.N) EWIGN = EWIGN - 30./A
 22   EBLDM = EVOL + ESURF + ECOUL + EWIGN + 14.33E-6*Z**2.39
      RETURN
CE
CE
CE
CE    DROPLET MODEL
CE    PARAMETERS FROM GROOTE,HILF,TAKAHASHI,
CE    ATOMIC DATA AND NUCL.DATA TABLES 17 (1976) 418
 30   A1 = 16.19
      A2 = 20.85
      CJ = 38.2
      R0 = 1.167
      A3 = 0.
      Q  = 17.7
      CK = 300.
      CL = 100.
      CM = 0.
      B0 = 0.7
CE    DERIVED PARAMETERS
      C1 = 0.7403
      C2 = 1.406E-4
      C3 = 0.6659
      C4 = 0.5653
      C5 = 4.838E-4
      B = B0/R0
      DBAR = (CI+0.1875*(C1/Q)*BV*Z/A23)/(1.+2.25*(CJ/Q)*BS/A13)
      EBAR = (-2.*A2*BS/A13+CL*DBAR**2+C1*BC*Z*Z/A43)/CK
      ETAZ = C3*Z*Z/A
      ETAZ = ETAZ * (2.-3.63*B/A13)
      ETAZ = ETAZ/(0.332*A2*A23-C3*Z*Z/A*(2.-7.26*B/A13))
CE
CE
      EVOL = (A1 - CJ*DBAR**2 + 0.5*CK*EBAR**2 - 0.5*CM*DBAR**4) * A
      ESURF= (-A2 - 2.25*CJ*CJ*DBAR*DBAR/Q)*BS*A23 - 0.166*A2*A23*
     1     ETAZ*ETAZ
      ECOUL= -C1*BC*Z*Z/A13 + C2*BR*Z*Z*A13 + C3*Z*Z/A*
     1     (1.+ETAZ)**2*(1.-1.21*B*(1.+ETAZ)/A13)
     2     + C4*Z**(4./3.)/A13  + C5*BW*Z*Z
      EWIGN = 0.
      IF (KOPTEB.EQ.4) EWIGN =-30.*ABS(CI)
      EBLDM = EVOL + ESURF + ECOUL + EWIGN + 14.33E-6*Z**2.39
      RETURN
CE
CE
CE
CE    LIQUID-DROP MODEL SEEGER 1976
CE    ATOMIC DATA AND NUCLEAR DATA TABLES 17 (1976) 428
 40   ALPHA = 15.2568
      BETA  = 33.166
      GAMMA = 17.073
      ZETA  = 3.28
      R0    = 1.2254
      PHI   = -0.76
      VN    = 35.37
      VP    = 31.08
      DB    = 9.75
CE
      EVS = ALPHA*A - BETA*CI*CI*A/(1.+ZETA/A13) - GAMMA*A23 + PHI*A13
      AD = .513
      RD= R0*A13
      R = RD * (1.+8.2247*(AD/RD)**2 -28.44*(AD/RD)**4)
      AD = AD/R
      EDIR = 0.864*Z*(Z-1.)/R * (1.+18.0295*AD**3 -85.233*AD**4)
      EEXC = EDIR/Z - 0.6598*Z**(4./3.)/R * (1.-1.3356*AD +7.127*AD**2
     1     -18.2104*AD**3)
      ESOR = (0.0369*A-0.0805*Z)*Z/R**3*(1.+9.8696*AD**2)
      ECOUL =-EDIR - EEXC - ESOR
      EWIGN = 0.
      IF (KOPTEB.EQ.6) EWIGN =-35.*ABS(CI)
      EBLDM = EVS + ECOUL + 14.33E-6*Z**2.39 + EWIGN
      RETURN
      END

      
      SUBROUTINE FBARR (IPS,BF,FFB)
      IMPLICIT REAL*8(A-H,O-Z)
CE    CALCULATES THE FISSION BARRIER BF(JJ) OF NUCLEUS IPS
CE    ACCORDING TO THE ROTATING-LIQUID-DROP MODEL OF CPS ANN.PHYS.82
CE    THE ESSENTIAL PARTS OF THIS SUBROUTINE ARE TAKEN FROM
CE    BLANN/PLASIL'S ALICE (FISROT)
CE    FFB IS A MULTIPLIER FOR THE LIQUID-DROP FISSION BARRIER

      COMMON EXMIN(500),EXMAX(500),EBE(4),ESEP(4,500)
      COMMON IZFMAX,IZE(4),IAE(4),JE(4),JDE(4),IEXXMX(500),IEXXS(500)
      COMMON IPS1,IPSMAX,IPSZO(4,500),IZ(500),IA(500)
      COMMON IEXXL(500),JMIN(500),JMAX(500),JJMAX(500)

      COMMON/C2/ FT(500),DA(500),DELTA(500),CK(500)
      COMMON/C2/ R0LDM,DEF,DEFS,DALDM,DAF,UTR,ULDM,UJTR,UJLDM,DLDM(500)
      DIMENSION BF(64)
      DIMENSION X1B(6,11),X2B(6,11),X3B(10,20),X1H(6,11),X2H(6,11),
     &     X3H(10,20)
      DATA X1B/.28,.243,.221,.208,.195,.18,.211,.186,.17,.1506,.136,.12,
     &     .152,.131,.1155,.096,.0795,.0625,.09725,.0795,.065,.0506,
     &     .0375,.0253,.05771,.0455,.03414,.0235,.014,.0065,.03325,
     &     .0235,.0153,.0081,.001,.0,.01625,.009,.0032,.0,.0,.0,.0071,
     &     .0,.0,.0,.0,.0,.0,.0,.0,.0,.0,.0,.0,.0,.0,.0,.0,.0,0.,0.,0.,
     &     0.,0.,0./
      DATA X1H/.0,.0,.0,.0,.0,.0,-.0057,-.0058,-.006,-.0061,-.0062,
     &     -.0063,-.0193,-.0203,-.0211,-.022,-.023,-.0245,-.0402,-.0427,
     &     -.0456,-.0497,-.054,-.0616,-.0755,-.0812,-.0899,-.0988,-.109,
     &     -.12,-.1273,-.1356,-.147,-.1592,-.1745,-.1897,-.1755,-.1986,
     &     -.2128,-.2296,-.251,-.26,-.255,-.271,-.291,-.301,-.327,-.335,
     &     -.354,-.36,-.365,-.372,-.403,-.42,0.,0.,0.,0.,0.,0.,0.,0.,0.,
     &     0.,0.,0./
      DATA X2B/.18,.1695,.1515,.133,.1155,.0949,.1495,.1363,.1165,.099,
     &     .0815,.0594,.12,.1032,.0864,.0678,.0469,.028,.09,.0725,.0556,
     &     .037,.019,.0057,.0625,.045,.0304,.016,.005,0.,.0406,.0264,
     &     .0151,.0052,0.,0.,.0253,.0144,.0027,0.,0.,0.,.0141,.006,0.,
     &     0.,0.,0.,.0065,.0008,0.,0.,0.,0.,.002,0.,0.,0.,0.,0.,0.,0.,
     &     0.,0.,0.,0./
      DATA X2H/0.,0.,0.,0.,0.,0.,-.0018,-.0019,-.00215,-.0024,-.0025,
     &     -.003,-.0063,-.00705,-.0076,-.0083,-.0091,-.0095,-.015,
     &     -.0158,-.0166,-.0192,-.0217,-.025,-.0245,-.0254,-.029,-.0351,
     &     -.0478,-.0613,-.038 7,-.0438,-.0532,-.0622,-.0845,-.0962,
     &     -.0616,-.0717,-.0821,-.0972,-.1123,-.1274,-.0793,-.1014,
     &     -.1138,-.1262,-.1394,-.1526,-.12,-.134,-.1503,-.1666,-.1829,
     &     -.1992,-.1528,-.171,-.1907,-.2104,-.2301,-.2498,0.,0.,0.,0.,
     &     0.,0./
      DATA X3H/0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,-.00012,-.00014,-.00016,-.00018,
     &     -.0002,-.00024,-.00029,-.00036,-.00065,-.00089,-.00047,-.0005,
     &     -.00058,-.00065,-.00074,-.00085,-.00101,-.00124,-.00138,-.00178,
     &     -.001,-.00105,-.00124,-.00138,-.00156,-.00179,-.00275,-.00292,-.003,
     &     -.003,-.00176,-.0019,-.00211,-.00235,-.00263,-.00298,-.00449,-.0053,
     &     -.0053,-.0053,-.003,-.00308,-.00318,-.00352,-.00392,-.00417,-.0062,
     &     -.0062,-.0062,-.0062,-.00374,-.0041,-.00444,-.00488,-.00521,-.00545,
     &     -.0066,-.0066,-.0066,-.0066,-.0053,-.0055,-.00585,-.0064,-.00695,
     &     -.007,-.007,-.007,-.007,-.007,-.00632,-.007,-.00742,-.00792,-.00856,
     &     -.009,-.009,-.009,-.009,-.009,-.0079,-.0085,-.01022,-.0119,-.012,
     &     -.012,-.012,-.012,-.012,-.012,-.00944,-.0102,-.0142,-.0182,-.019,
     &     -.019,-.019,-.019,-.019,-.019,-.0112,-.0133,-.0182,-.0238,-.024,
     &     -.024,-.024,-.024,-.024,-.024,-.01303,-.0178,-.0226,-.0274,-.028,
     &     -.028,-.028,-.028,-.028,-.028,-.0165,-.0254,-.0343,-.0343,-.034,
     &     -.034,-.034,-.034,-.034,-.034,-.0203,-.033,-.04,-.04,-.04,-.04,-.04,
     &     -.04,-.04,-.04,-.025,-.0406,-.046,-.047,-.047,-.047,-.047,-.047,
     &     -.047,-.047,-.03036,-.0482,-.048,-.048,-.048,-.048,-.048,-.048,
     &     -.048,-.048,-.0363,-.0558,-.056,-.056,-.056,-.056,-.056,-.056,-.056,
     &     -.056,-.04234,-.0634,-.064,-.064,-.064,-.064,-.064,-.064,-.064,
     &     -.064,0.,0.,0.,0.,0.,0.,0.,0.,0.,0./
      DATA X3B/.0949,.0755,.0564,.0382,.0223,.0121,.00588,.00242,.00069,
     &     .0001,.0873,.0684,.049,.0306,.0162,.0074,.00267,.00055,0.,0.,
     &     .0801,.061,.0418,.0235,.0108,.00373,.00071,0.,0.,0.,.073,
     &     .054,.035,.0178,.0062,.00125,0.,0.,0.,0.,.0661,.047,.0284,
     &     .012,.0025,0.,0.,0.,0.,0.,.0594,.0404,.022,.0065,0.,0.,0.,0.,
     &     0.,0.,.0528,.034,.0159,.002,0.,0.,0.,0.,0.,0.,.0465,.0277,
     &     .01,0.,0.,0.,0.,0.,0.,0.,.0401,.0217,.0044,0.,0.,0.,0.,0.,0.,
     &     0.,.0339,.0158,.00024,0.,0.,0.,0.,0.,0.,0.,.028,.0106,0.,0.,
     &     0.,0.,0.,0.,0.,0.,.0219,.0064,0.,0.,0.,0.,0.,0.,0.,0.,.0164,
     &     .0025,0.,0.,0.,0.,0.,0.,0.,0.,.0122,0.,0.,0.,0.,0.,0.,0.,0.,
     &     0.,.0085,0.,0.,0.,0.,0.,0.,0.,0.,0.,.0057,0.,0.,0.,0.,0.,0.,
     &     0.,0.,0.,.0035,0.,0.,0.,0.,0.,0.,0.,0.,0.,.0016,0.,0.,0.,0.,
     &     0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,
     &     0.,0.,0.,0.,0./
CE
CE
CE    INPUT PARAMETERS ESO,X,Y
      A = IA(IPS)
      Z = IZ(IPS)
      C = (A-2.*Z)/A
      ESO = 17.9439 * (1.-1.7826*C*C) * A**(2./3.)
      ECO = 0.7053*Z*Z/A**(1./3.)
      X = ECO/(2.*ESO)
      CR = 34.540 * 1.2249*1.2249/R0LDM**2
      CR = CR/A**(5./3.)
      CYC= CR/ESO
CE
CE
CE
      JJX = JJMAX(IPS)
      DO 30  JJ=1,JJX
        CJ = JMIN(IPS) + JJ
        IF (2*(IA(IPS)/2).NE.IA(IPS)) CJ = CJ + 0.5
        Y = CYC * CJ * CJ
CE
        IX=20.*X+1.
        CX=IX
        BX=20.*X+1.
        DX=BX-CX
        IF(X-.25)1,1,6
C
 1      BY=10.*Y+1.
        IF(BY-9.)3,3,2
 2      BY=9.
 3      IF(BY-1.)4,4,5
 4      BY=1.
 5      IY=BY
        CY=IY
        DY=BY-CY
        H1=(X1H(IX+1,IY)-X1H(IX,IY))*DX+X1H(IX,IY)
        H2=(X1H(IX+1,IY+1)-X1H(IX,IY+1))*DX+X1H(IX,IY+1)
        HF=(H2-H1)*DY+H1
        B1=(X1B(IX+1,IY)-X1B(IX,IY))*DX+X1B(IX,IY)
        B2=(X1B(IX+1,IY+1 )-X1B(IX,IY+1))*DX+X1B(IX,IY+1)
        BFF =(B2-B1)*DY+B1
        GO TO 19
C
 6      IF(X-.5)7,7,12
 7      BY=20.*Y+1.
        IF(BY-11.)9,9,8
 8      BY=11.
 9      IF(BY-1.)10,10,11
 10     BY=1.
 11     IX=IX-5
        IY=BY
        CY=IY
        DY=BY-CY
        H1=(X2H(IX+1,IY)-X2H(IX,IY))*DX+X2H(IX,IY)
        H2=(X2H(IX+1,IY+1)-X2H(IX,IY+1))*DX+X2H(IX,IY+1)
        HF=(H2-H1)*DY+H1
        B1=(X2B(IX+1,IY)-X2B(IX,IY))*DX+X2B(IX,IY)
        B2=(X2B(IX+1,IY+1 )-X2B(IX,IY+1))*DX+X2B(IX,IY+1)
        BFF =(B2-B1)*DY+B1
        GO TO 19
C
 12     IF(X-.95)14,14,13
 13     X=.95
 14     IX=20.*X+1.
        IX=IX-10
        BY=100.*Y+1.
        IF(BY-19.)16,16,15
 15     BY=19.
 16     IF(BY-1.)17,17,18
 17     BY=1.
 18     IY=BY
        CY=IY
        DY=BY-CY
        H1=(X3H(IX+1,IY)-X3H(IX,IY))*DX+X3H(IX,IY)
        H2=(X3H(IX+1,IY+1)-X3H(IX,IY+1))*DX+X3H(IX,IY+1)
        HF=(H2-H1)*DY+H1
        B1=(X3B(IX+1,IY)-X3B(IX,IY))*DX+X3B(IX,IY)
        B2=(X3B(IX+1,IY+1 )-X3B(IX,IY+1))*DX+X3B(IX,IY+1)
        BFF =(B2-B1)*DY+B1
C
 19     ERO = Y * ESO
        DELR=ERO+HF*ESO
 30   BF(JJ) = FFB * BFF * ESO
CE
CE
      RETURN
      END

      FUNCTION YRASTLINE(XJ,IA)
      IMPLICIT REAL*8(A-H,O-Z)

      COMMON/OFFSET/UXOFET,OFFEV,OFFODD,TRAMO
     &     ,CSPLIEV,DSPLIEV,CSPLIOD,DSPLIOD,JNOD

      J=XJ
      IA2=IA/2
      IF(FLOAT(IA2).EQ.(FLOAT(IA)/2.))THEN !EVEN
        IF(J.GE.JNOD)THEN
          YRASTLINE=OFFEV+XJ*(XJ+1.)/TRAMO
          RETURN
        ELSE
          YRASTLINE=CSPLIEV*XJ+DSPLIEV*XJ*XJ
          RETURN
        ENDIF
      ELSE                      !ODD
        IF(J.GE.JNOD)THEN
          YRASTLINE=OFFODD+XJ*(XJ+1.)/TRAMO
          RETURN
        ELSE
          YRASTLINE=CSPLIOD*XJ+DSPLIOD*XJ*XJ
          RETURN
        ENDIF
      ENDIF
      END

CSMS    SUBROUTINE SCHLAF(ISEC)
CSMS            IMPLICIT REAL*8(A-H,O-Z)
CSMS    INTEGER ITIM(2)
CSMS    CHARACTER TIM*6
CSMS    DATA TIM/'0 ::01'/
CSMS    SS=SYS$BINTIM(TIM,ITIM)
CSMS    DO 1 I=1,ISEC
CSMS    SS=SYS$SETIMR(%VAL(1),ITIM,,)
CSMS    SS=SYS$WAITFR(%VAL(1))
CSMS1   CONTINUE
CSMS    RETURN
CSMS    END
