c
c                       MODIFIED VERSION OF LILITA
c               last update: 4-aug-92    S. Sanders
c       --Added check for read in tl's
c               check if cbl already set, if so: skip
c               The code assumes mass independent tl's for given z
c       --Added addition output information about the c.m. distributions
c               calculated using averaged kinematics.
c       --Added pre- and post-evaporation velocity spectra, to be written
c               out on unit 15.
c       --Removed mass calculation based on post-evaporation velocities.
c       --Added LILITA_DECK front end to directly accept .pre file input form
c               FISCASCADE program.
c       --Removed "hardwired" value for the compound nucleus c.m.
c               velocity. (Search vcn)
c       --Added write statements to create file (for111) containing
c               results of two-body calculation. (Search eventbuf)
c               last update: 5-apr-87     S. Sanders
c       --Correct problem with calculation of lab angles when angle
c               greater than 90 degrees. Now checks argument of ATAN
c               function to see what quadrant the solution vector should
c               be in. (Search on ATAN to find changes.)
c       --Correct problem where recoil lab angles were calculated to be
c               negative.  These angles were generating nonsense indexes
c               for the v-theta array. All angles now forced to be positive.
c               (Search on ATAN to find changes.)
c       --Change angle option to force d(sigma)/d(theta) = constant. The
c               ETHE parameters are now ignored, and for each fragment in
c               the table angles are now randomly selected between 0 and 180
c               degrees. DO NOT INCLUDE COMPLEMENTARY FRAGMENTS IN TABLE.
c               (Search on SUBROUTINE ANGLE to find changes.) Note that
c               the original version determined angles in a fashion different
c               than the writeup description. Angular distributions where
c               being calculated differently depending on the total Q value
c               of the reaction. (Search on TEX to see how this was being
c               done.)
c       --Eliminate division by velocity of velocity spectra.
c               (Search  IPK(J)/EBA   )
c
c       --Change energy sharing to E3 = ECN *(m3/mtot)* (2*m3/mtot)
c               (Search FUDGE)
c       
c       --Modified function gaus to use probability array read in from cards
c               (Search GAS, lil29.dat)
c               The gaussian probability array is generated by noting that
c
c                1            x
c             -------      int ( exp(-0.5*((x-mu)/sigma)**2) dx =
c       (sigma)*sqrt(2*pi)   -inf       
c                                      0.5 *(1+erf( (x-mu)/(sigma*sqrt(2))))
c                                       
c                               == G (z)
c
c                 with:  z = (x-mu)/sigma
c
c                 the program lets G take on a random value between 0 and 1
c                 and then does a table lookup for the corresponding value
c                 of z, which is then used to find x.
c               
c               The program change is to greatly increase the size of the
c               lookup array to obtain a more uniform gaussian distribution.
c
c                            21-mar-91    SJS
c       -- restored normal calculation of energy sharing proportional to
c          mass
c               
      integer missing_mass(100,100)
      real iarrz(80)
      common/missing_mass/missing_mass
      common/icount/icount
c
c       tke_*(nint(4*tke)+1,z,a-2*z+3,nint(angle)/2+1)
c
      integer tke_pre_f(240,20,6,26),tke_post_f(240,20,6,26)
      integer tke_pre_b(240,20,6,26),tke_post_b(240,20,6,26)
      common/tkec/tke_pre_f,tke_post_f,
     &     tke_pre_b,tke_post_b,icnt_pre, icnt_post,
     &     icnt_pre_f,icnt_post_f,icnt_pre_b,icnt_post_b
      
      DIMENSION PRO(80),QGG(80),QMM(80),SIQ(80),XJ(80),SXJ(80),ETHE(80),
     1     RAA(80),RBB(80),QJMA(80)
      real siginz(80), sigina(80), sigoutz(80), sigouta(80)
      common/fragments/pro,qgg,qmm,siq,xj,sxj,ethe,raa,rbb,qjma
      common/random/irx
      COMMON AM(80,12),PM(3),DE(80,12),EIM(80,12),ALD(80,12),ECT(80,12)
     1     ,DLD(80,12),GAMA(80,12),RA(2,84),CMUL(80),MUL(80),CMAX(3,84)
      COMMON IUI(80,20),ITT(80),LIMT(80),IMAX(80),LMAX3,CB(2,80,12),
     1     INEU(80),LNU(3),NCH(3,2),ITP(3),ICO(7),LN(3),L12(3)
      COMMON PR(80,2),EMTA(80),CMTA(80),CCE(14),PD(4),
     1     SSIM(6),SIM(6),ENU(6),RH(6),RT(6),RT1(6),CMUL2(80),CMUL3(80)
     2     ,EMA(6),CNA(6)
      COMMON LMAX1,LMAX2,IANG,IPT,INU,IXN,IXX,IEN,ITIME
      COMMON AAU(6),CU1(3),AA(6),TDE(3),ZZMIN,ICUTO,NREP
      COMMON CM1,CM2,CNM,ZT,ZP,PADE
      COMMON/KINE/KI,IPAR(14),ILOR(14),P(14),ALM(14),PAM(14),CJJI(15),
     1     IANFI,CNLA,SNLA,ZZZ,YYY
      COMMON/KINLI/ILK(30000),IALKI,ILKI,IELKI,MAKLI,ISHIF,IARRA(80)
      COMMON/QUA/IQME(22880),ISCL(2720),NN(20,20)
      COMMON/GLE/NDG(26,30),IGLEB(20155)
      COMMON/CONST/FAC12,EFACT,EBCONS,EBONE,EBTWO,BCUT,BCUT1,DELB(3,80)
      COMMON/DISC/YRST(80,12),YRAST(80,12),CBL(60,84),SIG(88),CNU(3),
     1     B(3),TEMPR(3)
      COMMON/OTP/IPK(500010),LOGI
      COMMON/CONTR/IMOD,JONE,JKK,IONLY,ICARD,ICLA,ICOMNU,MC,IZC,JMAX,
     1     IBAR,IMAS1,MASMIN
      DIMENSION JRA(20),JRB(20),FUSI(11),FASI(56)
      DIMENSION SZ(40),SN(40)
      REAL*8 AM,PM,AMXT
      real vcn,eventbuf(7)
      integer proj_like_mass, targ_like_mass
      logical daphne, forward_tag, forward
      common/daphne/daphne,vcn,eventbuf,proj_like_mass, targ_like_mass
      INTEGER*2 IPK
c       all integer*2 statments removed, exept for ipk array 3-6-83
C PROGRAM LILITA II. THIS PROGRAM IS A MODIFIED VERSION OF LILITA. INCLUDES
C A QUANTUM MECHANICAL CALCULATION FOR THE EMMITTED LIGHT PARTICLES
C N,P,ALPHA. IN ADDITION CAN PRODUCE AND OUT-PUT FILE PROPER FOR COINCEDENCE
C CALCULATIONS. CAN TAKE A ONE BODY INPUT(FUSION) OR A TWO BODY INPUT(D.I.)
C AND THIS INPUT IS CONTROLED BY THE SUBROUTINE PRIMAR, THAT DEFINES THE PRI
C DISTRIBUTION
C     MORE<0 EXIT, MORE=0 COMPLETE INPUT FOLLOWS AND MORE>0SKIP THE
C TABLE PARAMETERS.ITIME=MAX RUNNING TIME AFTER WICH THE PROGRAM WILL GO TO
C PRINT OUT RESULTS..IPRINT=#OF EVENTS FOR A DETAILED OUT-PUT(CHOOSE SMALL
C NUMBER LIKE 10).
C GILBERT AND CAMERON SHELL CORRECTION.LEVEL D./A=0.00917*S+ABS(ALMAS).THIS
C TION IS ACTIVATED IF ALMAS<0.SEE BELOW.
      common /gas/ngas,gas(1001)
      DATA SZ/0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,-2.91,-4.17,-5.72,-7.8,
     1     -8.97,-9.7,-10.1,-10.7,-11.38,-12.07,-12.55,-13.24,-13.93,
     2     -14.71,-15.53,-16.37,-17.36,-18.52,-18.44,-18.19,-17.68,-17.09,
     3     -16.65,-16.66,-16.59,-16.35,-16.18,-16.44,-16.6,-16.54/
      DATA SN/0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,6.8,7.53,7.55,7.21,7.44,
     1     8.07,8.94,9.81,10.6,11.39,12.54,13.68,14.34,14.19,13.83,13.5,
     2     13.0,12.13,12.6,13.26,14.13,14.92,15.6,16.38,17.08,17.55,17.98,
     3     18.33,18.56,18.71/
CSMS    ipronam=sys$setprn('LIL2')

      do i = 1,60
        do j = 1,84
          cbl(i,j) = 0
        enddo
      enddo
cccccccccccccccccccccccccccccccccccccccccccccccc
c
c       Initialize array to hold number of times a T(l) value
c       requested for each unknown mass. If these numbers become too
c       large a new entry is needed in the LIL19.DAT file.
c       

      do iz1m = 1,100
        do im1m = 1,100
          missing_mass(iz1m,im1m) = 0
        enddo
      enddo
ccccccccccccccccccccccccccccccccccccccccccccccccc
c
c       Open LILITA data files
c
CSMS
C      open(unit=19,file='lil19.dat',READONLY,STATUS='OLD')
C      open(unit=27,file='lil27.dat',READONLY,STATUS='OLD')
C      open(unit=28,file='lil28.dat',READONLY,STATUS='OLD')
C      open(unit=29,file='lil29.dat',readonly,status='old')
      include 'fislilita.lildat'

ccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c       Set up calculation using LILITA_DECK front end
c
      open(unit=21,file='summary.work',status='new')
      call lilita_deck
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c       Open unit 9 to append - this is initially the .pre
c       file generated using FISCASCADE.  The changes in the
c       TKE and mass values which occur because of light particle
c       emissions from the fragments are appended at the end.
c
      open(unit=9,file='fislilita.work',status='old',access='APPEND')
cccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c       Open other output files
c
c       unit 14:  General information output, copy of batch log
c               file with some stuff eliminated
c       unit 15:  Velocity spectra output.  Labelled z_pre, z_post,
c               a_pre, a_post.  The velocity spectra are binned with
c               v/c = .002*bin# + 0.001
      open(unit=14,file='fislilita.lilout',status='new')
      open(unit=15,file='fislilita.tke',status='new',
     &     form='unformatted')
c       
c
c
c       read in gas array
c
      read(29,*) ngas
      read(29,*) (gas(i),i=1,ngas)
      CALL INIFLAG              !THIS IS NEEDED TO STOP LILITA EXTERNALLY
      call getseed(iseed)       !determine time-dependant seed for random numbers
      irx=iseed*2+1
c       FUDGE ADMISSION
c       write(6,*) ' WARNING:  ENERGY SHARING MODIFIED(2) -- DETAILS IN CODE'
c       write(6,*) ' NOTE: MASS PROPORTIONED ENERGY SHARING'
CSMS take input from file written out earlier
      open(unit=110,file='fislilita.inp',readonly,status='old')
 510  READ (110,60) MORE,ITIME,IPRINT,NREP,IMAS1,MASMIN
      write(6,*) 'imas1,masmin=',imas1,masmin
      write(14,*) 'imas1,masmin=',imas1,masmin
      CNORMA=NREP
      DO 44 I=1,80
        ITT(I)=0
        CMUL(I)=0.0
        MUL(I)=0
        CMUL2(I)=0.0
        CMUL3(I)=0.0
        DO 44 J=1,20
          IF(J.GT.12)GO TO 44
          AM(I,J)=-1.0
 44   IUI(I,J)=0
      IF(MORE.LT.0) GO TO 820
C IMOD=0 FOR SINGLES KINEMATIC CALCULATIONS OF FRAGMENTS AND/ORLIGHT PAR-
C TICLES..IMOD=1 FOR TOTAL YIELD OF RESIDUAL FRAGMENTS..IMOD=2 FOE EVENT BY
C EVENT OUT-PUT ON DISK.USED FOR COINCIDENCE CALCULATIONS.
C JONE .NE.1 FUSION INPUT..JONE=1 TWO BODY INPUT..IPT=MAXIMUN PROTON NUMBER
C THE INPUT TABLE.INU=MAXIMUN NEUTRON NUMBER.(PRESENT LIMITATION IPT<35 AND
C INU<13).IEN TOTAL NUMBER OF ENERGY BINS FOR STORAGE IN SINGLES CALCULATION
C IANG=ANGULAR STEPS FOR SINGLES.ICUTO IS 10**-ICUTO FOR THE
C TRANSMITION FUNCTION CUT-OFF.THIS PARAMETER HAS AN STRONG INFLUENCE IN THE
C MA RAY COMPETITION.A RESONABLE VALUE IS 2..IONLY=0 TAKES THE EVAPORETION O
C TON FOR THE PRIMARY DISTRIBUTION. IONLY=1 NO EVAPORATION AND ONLY A MONTE-
C CARLO SELECTION OF THE PRIMARY INPUT IS DONE(USELESS FOR FUSION).
      READ (110,40) IMOD,JONE,IPT,INU,IEN,IANG,ICUTO,IONLY
      daphne = .false.
      if(imod .gt. 9) then
        open(unit=111,file='lil_to_dap.dat',status='new')
        daphne = .true.
        imod = imod - 10
      endif
      IF(IMOD.eq.2 ) then
        OPEN(UNIT=12,FILE='LILEVENT.DAT',FORM='UNFORMATTED',
     1       STATUS='NEW')
      endif
C     IMAX(I)=MAXIMUN ANGLE/IANG FOR Z PRODUCTS IN THE I LOCATION OF
C     THE TABLE. USED ONLY FOR IMOD=0
C FOR IMOD=2 SET IMAX(I)=1 FOR ALL RESIDUAL PRODUCTS UNELESS YOU WANT TO
C EXCLUDE THEM FROM THE EV.BY.EV. CALC. IN WICH CASE IMAX(I)=0.
 9917 IF(IMOD.NE.0)GO TO 45
      DO 43 I=1,500000
        IF(I.GT.30000)GO TO 43
        ILK(I)=0
 43   IPK(I)=0
 45   READ (110,41) (IMAX(I),I=1,IPT)
C     ICO(1)=# OF EVENTS, ICO(2)=MAXIMUN A AND ICO(3)=MAXIMUN Z CONSIDE
C     RED IN THE INPUT TABLE.ICO(4)=MINIMUN Z INCLUDED IN THE KINEMA
C     TIC CALCULATION,ICO(5)=2*JMAX,ICO(6)=ZMAX+1 WHERE ZMAX IS THE
C     MAXIMUN Z INCLUDED IN THE KINEMATICS.............
C ICO(5) IS NOT USED AT PRESENT. ICO(7) IS THE LOGICAL UNIT NUMBER OF THE
C OUT-PUT FILE FOR IMOD=2. LMAX1,LMAX2,LMAX3,MAXIMUN ORBITAL L FOR N,P,ALPHA
C RESPECTIVELY.MAXIMUN VALUES 15,15,25. LMAX ACCTUALLY L-1.
      READ (110,40) (ICO(I),I=1,7),LMAX1,LMAX2,LMAX3
      flat = ico(1)/2.
C CM1,CM2,CNM,PROJECTILE,TARGET AND COMPOSITE MAS(CM1+CM2)RESPECTIVELY.E1 IS
C THE BOMBARDING ENERGY IN MEV. EMG MINIMUN ENERGY  FOR SINGLES(USUALLY 0).
C ZZMIN MINIMUN Z CONSIDERED IN THE CALCULATION(USUALLY0 AND LET THE PROGRAM
C DECIDE).
      READ (110,50) CM1,CM2,CNM,ZT,ZP,E1,EMG,ZZMIN
      vcn =sqrt(2*e1/(931.504*cm1))*(cm1/(cm1+cm2))
      write(6,*) 'vcn = ',vcn
C DELB(1,2,3) PARAMETER OF THE FERMI FUNCTION TRANSMITION COEFFICIENTS.(T)
C THIS ARE DEFINED BY T=TMAX/(1+EXP((BL-E)/DELBBL)).WERE BL IS THE CENTRIFUG
C PLUS COULOMB BARRIERS(USUALLY OBTAIN FROM FIT TO OP. MODEL)
C ALMAS SETS THE OPTIONS FOR THE LEVEL DENSITY PARAMETER A. ALMAS<0 GILBERT
C CAMERON. ALMAS>0 GIVES A=ALMAS*(MASS) IF A FROM INPUT IS ZERO,OTHERWISE TH
C INPUT A IS PRESERVED.
      READ (110,50) ALMAS
      IF(MORE.GT.0) GO TO 500
      READ (110,31) (INEU(IZ),IZ=1,IPT)
      F22=0.00917
      IXN=IPT+INEU(1)+INU-5
      IXX=IXN+4
C READ INPUT FILE FOR ALL NUCLEI THAT WILL BE USED IN THE CALCULATIONS,IZ1 I
C THE Z IM1 IS THE MASS NUMBER AMXT IS THE MASS(IN AMU).FUSI FRON 1-11 ARE T
C PARAMETERS: LEVEL D(A),PAIRING(DELTA),EIM(MINIMUN THERSHOLD. FOR PART. EMI
C N),ECT(CUT-OFF FOR LEVEL DENSITY),GAMMA(TOTAL PROB.FOR GAMMA COMP.),DLD(DI
C TE LEVEL DENSITY=LEVEL/MEV FROM 0 TO ECT).,FUSI(7) IF NEGATIVE HBAR**2)/(2
C SCRETE),IF>0I(DISC)=I(RIGID)/FUSI(7),FUSI(8)=J0(J0+1) WHERE J0 G.S. SPIN.
C FUSI(9)=R0 FOR COMPUTATION OF I(RIGID).FUSI(10)=R0 FOR L=0 PROTON BARRIER
C FUSI(11)=R0 FOR L=0 ALPHA BARRIER.
C CALCULATION OF CENTRIFUGAL BARRIER BL TO USE IN FERMI FUNCTION..
C FASI(1-15) ARE THE BL(MEV) FOR NEITRONS FOR L=0 TOL=14. FASI(16-30) ARE TH
C S TO COMPUTE BL'S FOR PROTONS L=0 TO L=14. FASI(31-55) ARE THE R'S FOR
C ALPHAS TO COMPUTE BL'S FROM L=0 TOL=24.ACCTUALLY THE PROGRAM USES THE DEFI
C TIONS OF BL=BL+COULOMB(THE L=0 BARRIER FOR P AND ALPHA FUSI(10) AND FUSI(1
C FOR NEUTRONS BL=BL+B0(FOR L=0)
C A1,A2,A3, ARE THE MAXIMUN T(TMAX) FOR N,P,ALPHA RESCPECTIVELY(USUALLY ONE)
C D1,D2,D3, ARE THE WIDTHS(DELTA) FOR OPTICAL MODEL TL'S,FOR N,P,ALPHA AND
C NUCLEUS IZ1,IM1
      DO 10 LIX=1,800
        lhold = lix
        READ(19,190) IZ1,IM1
        READ(19,191)AMXT,(FUSI(L),L=1,11)
        IF(IZ1.LT.0)GO TO 46
        READ(19,192)(FASI(L),L=1,55),A1,A2,A3,D1,D2,D3
 190    FORMAT(2I5)
 191    FORMAT(F14.6,11F6.2)
 192    FORMAT(10F8.2)
        IF(IZ1.GT.ICO(3)) GO TO 46
        I=IZ1+IPT-ICO(3)
        IF(I.LT.1.OR.I.GT.IPT)GO TO 10
        J=I+ICO(2)-INEU(I)-IPT-IM1+1
        IF(J.LT.1.OR.J.GT.INU)GO TO 10
        AM3=IM1
        AMFL=IM1
        AM3=AM3**0.3333
        COULOM=1.44*IZ1/(1.0+AM3)
        CB1=COULOM/FUSI(10)
        COULOM=2.88*IZ1/(1.587+AM3)
        CB2=COULOM/FUSI(11)
        R1=(FUSI(10))**2
        R2=FUSI(11)**2
        DELB(1,I)=D1
        DELB(2,I)=D2
        DELB(3,I)=D3
        CB(1,I,J)=CB1
        CB(2,I,J)=CB2
        IF(AMFL.LT.5.)AMFL=5.0
        AM1=20.9*(AMFL)/(AMFL-1.0)
        AM2=5.225*AMFL/(AMFL-4.0)
        AM4=(AMFL-1.0)**0.3333
        AM1=AM1/((1.0+AM4)**2)
        AM5=(AMFL-4.0)**0.3333
        AM2=AM2/((1.587+AM5)**2)
        K=IM1-ICO(2)+IXN
        IF(K.LT.1)GO TO 16
        CMAX(1,K)=A1
        CMAX(2,K)=A2
        CMAX(3,K)=A3
        RA(1,K)=R1/AM1
        RA(2,K)=R2/AM2
c--change added 4-aug-1992: check if cbl already set, if so: skip
c--     code assumes mass independent tl's
        if( cbl(1,k) .le. 0 ) then
          DO 11 IZN=1,3
            IZL=IZN-1
            DO 11 L=1,55
              IF(IZL-1)12,13,14
 12           IF(L.GT.15)GO TO 11
              CBL(L,K)=FASI(L)
              GO TO 11
 13           IF(L.LE.15.OR.L.GT.30)GO TO 11
              TTL=L-15-1
              CBL(L,K)=TTL*(TTL+1.)*AM1/(FASI(L)**2)
              GO TO 11
 14           IF(L.LE.30)GO TO 11
              TTL=L-30-1
              CBL(L,K)=TTL*(TTL+1.)*AM2/(FASI(L)**2)
 11       CONTINUE
        endif
 16     INFC=IM1+IXX-ICO(2)
        IF(INFC.LT.1)GO TO 10
        RNUC=(FUSI(9)*AM3)**2
        SIG(INFC)=0.0192*AMFL*RNUC
        AM(I,J)=AMXT
        ALD(I,J)=FUSI(1)
        IN1=IM1-IZ1
C GILBERT AND CAMERON OPTION
        IF(ALMAS.LT.0.0)ALD(I,J)=(ABS(ALMAS)+(SZ(IZ1)+SN(IN1))*F22)*AMXT
        DE(I,J)=FUSI(2)
        EIM(I,J)=FUSI(3)
        ECT(I,J)=FUSI(4)
        GAMA(I,J)=FUSI(5)
        DLD(I,J)=FUSI(6)
        YRST(I,J)=FUSI(7)
        YRAST(I,J)=FUSI(8)
 10   CONTINUE
 46   CONTINUE
      write(6,*) ' Number of elements in mass table = ',lhold
C ILKI=0 NO STORING OF LIGHT PARTICLE KINEMATICS.IELKI=# OF ENERGY BINS FOR
C SINGLES (LPK).IALKI ANGULAR STEPS(LAB) FOR LPK.. ISHIF IS DEFINED BY: E*IE
C(E1+ISHIF), WHERE E IS THE CALC. ENERGY OF THE LIGHT PARTICLE.. IANFI NOT U
C IALKI ALLWAYS >0.
      READ (110,40) ILKI,IELKI,IALKI,ISHIF,IANFI
      MAKLI=180.0/IALKI+1.5
      DO 34 I=1,IPT
        DO 34 J=1,INU
          IF(AM(I,J).LE.0.0) GO TO 37
          IF(ALD(I,J).GT.0.0) GO TO 37
          IF(ALMAS.EQ.0.0)ALMAS=0.1333
          ALD(I,J)=ABS(ALMAS)*AM(I,J)
 37       AAAY=ABS(YRST(I,J))
          IF(AAAY.GT.0.0)GO TO 34
          YRST(I,J)=2.0
 34   CONTINUE
 500  CONTINUE
C     TWO COMMENTS CARDS
      READ (110,21) (JRA(I),I=1,20)
      READ (110,21) (JRB(I),I=1,20)
      WRITE(6,24) (JRA(I),I=1,20)
      WRITE(6, 24) (JRB(I),I=1,20)
C ccccccccccccccccccccccccccccccccccccccccccccccc
c
c       LILOUT.DAT output: used to generate velocity spectra
c               for comparisons with experiment
c
c       WRITE(10,24)(JRA(I),I=1,20)
c       WRITE(10,24)(JRB(I),I=1,20)
C
      ZZMIN=ZZMIN-ICO(3)+IPT
      LM=LMAX2
      IZMA=ICO(6)-1
      WRITE(6,300) E1,CM1,CM2,CNM,LMAX1,LMAX2,LMAX3
      WRITE(6,708) ICUTO,ZT,ZP
      WRITE(14,300) E1,CM1,CM2,CNM,LMAX1,LMAX2,LMAX3
      WRITE(14,708) ICUTO,ZT,ZP
C ICARD # OF CARDS TO DEFINE THE PRIMARY DISTRIBUTION. ICOMNU=1 FOR FUSION A
C 0 IF TWO BODY. IBAR(FOR FUSION) ONLY EQ.1 IF IF SHARP-CUTOFF FOR ENTRANCE
C CHANNEL ,0 IF GIVEN FROM INPUT CARDS(ICARD OF THESE). JMAX=2*JMAX FOR FUSI
C AND IBAR=1.ICLA=1 WILL DO THE ERICSSON/STRUTINSKI ANG. DIST.,0 WIL DO
C QUANTUM MECH.(FOR THE QUANTUM CASE THE ANG. DIST ARE CALCULATED PREVIOUSLY
C IS USEDIGLEB,IQME,ISCL).UP TO J=26 AND L=15 .OUTSIDE THIS LIMITS ERICSON F
C JKK IS A PARAMETER TO SHARE THE EXCITATION ENERGY ACCORDING TO MASS RATIO
C (ONLY FOR A TWO BODY INPUT).IN THE FOLLOWING WAY: IF TOTAL EX<JKK EX IS SH
C BY MASS RATIO,OTHER WISE EX FRON T1=T2(EQUILIBRIUM ASSUMTION).EQUAL TEMP(T
C MC=COMPOUND MASS NUMBER,IZC=COMP. Z.SIGTO=TOTAL CROSS SECTION ,EX=EXCITATI
C IN THE COMP. NUCL.. RAM=RATIO OF RANDOM TO ALIGNED COMPONET FOR A TWO BODY
C INPUT.
      READ (110,25) ICARD,ICOMNU,IBAR,JMAX,ICLA,JKK,MC,IZC,SIGTO,EX,RAM
 25   FORMAT(8I5,3F10.0)
      sigfrag = sigto
      CALL PRIMAR(0,I,JONE,1,1,1,1,1,1,1,1,0.,E1,SIGTO,RAM,EX,0.,0.,0.,
     1     0.,0.,0.,0.,0.,0.,0.)
      SIT12=653.2*(MC**2)/(E1*CM1*CM2)
      SIGFUS=SIT12*((JMAX/2.0+1.0)**2)/CM2
      IF(IBAR.EQ.1)SIGTO=SIGFUS
      WRITE(6,310) SIGTO,ICO(2),ICO(3),RAM,EX,SIGFUS
      WRITE(14,310) SIGTO,ICO(2),ICO(3),RAM,EX,SIGFUS
      LOGI=ICO(7)
      IF(IMOD-1) 311,312,313
 311  WRITE(6,314) ICO(4),IZMA,IANG
      IUMA=0
      DO 317 I=1,IPT
 317  IUMA=IUMA+IMAX(I)
      IPRO=IEN*IUMA
      IF(IPRO.GT.500000) GO TO 800
      GO TO 320
 312  WRITE(6,315)
 315  FORMAT(1H ,53H  ONLY TOTAL YIELDS OF    RESIDUES WILL BE CALCULATE
     1     D)
      GO TO 320
 313  WRITE(6,316)
 320  CONTINUE
      KMIN=IPT
      ISI=1
      DO 95 I=1,IPT
        LIMT(I)=ISI
        ISI=ISI+IEN*IMAX(I)
 95   CONTINUE
      WRITE(6,610)
 610  FORMAT(1H ,'INPUT DATA FROM FILE 19')
      DO 600 I=1,IPT
        IZO=I+ICO(3)-IPT
c      WRITE(6,900)
        DO 601 J=1,INU
          IMN=I+ICO(2)-INEU(I)-IPT-J+1
 601    ITT(J)=IMN
C      WRITE(6, 700) IZO,(ITT(J),J=1,INU)
C  700 FORMAT(1H ,6HZ ION=,I2,5X,12(I5,2X))
C      WRITE(6,701) (ALD(I,J),J=1,INU)
C  701 FORMAT(1H ,1HA,12X,12(F5.2,2X))
C      WRITE(6,702) (DE(I,J),J=1,INU)
C  702 FORMAT(1H ,5HDELTA,8X,12(F5.2,2X))
C      WRITE(6,703) (DLD(I,J),J=1,INU)
C  703 FORMAT(1H ,3HDLD,10X,12(F5.2,2X))
C      WRITE(6,704) (ECT(I,J),J=1,INU)
C  704 FORMAT(1H ,3HECT,10X,12(F5.2,2X))
C      WRITE(6,707) (YRST(I,J),J=1,INU)
C  707 FORMAT(1H ,4HYRST,9X,12(F5.2,2X))
C      WRITE(6,709) (EIM(I,J),J=1,INU)
 600  CONTINUE
c      WRITE(6,900)
      DO 603 I=1,IPT
        ITT(I)=0
        IZO=I+ICO(3)-IPT
C      WRITE(6,706) IZO
C      WRITE(6,705) (AM(I,J),J=1,INU)
 603  CONTINUE
c      WRITE(6,900)
      DO 120 J=1,IPT
        DO 120 I=1,INU
 120  AM(J,I)=AM(J,I)*931.478
      PM(1)=939.55
      PM(2)=938.767
      PM(3)=3728.3367
      ITP(1)=0
      ITP(3)=0
      ITP(2)=0
      BCUT=ICUTO*2.3026
      BCUT1=-1.0*BCUT
      FAC12=1.111*10**(-ICUTO)
      EFACT=0.81*10**(2*ICUTO)
      EBCONS=(BCUT+2.1972)*(0.9-10**(-ICUTO))
      EBONE=BCUT
      EBTWO=2.1972
      IF(IMOD.EQ.1.OR.IONLY.EQ.1)GO TO 445
      IF(ICLA.EQ.1)GO TO 445
      DO 441 I=1,26
 441  READ(27,193)(NDG(I,J),J=1,30)
      READ(27,193) IDUM,JX,(IGLEB(I),I=1,JX)
      WRITE(6,447) IDUM,JX
      READ(28,193) IDUM,JX,(IQME(I),I=1,JX)
      WRITE(6,447) IDUM,JX
      READ(28,193) IDUM,JX,(ISCL(I),I=1,JX)
      WRITE(6,447) IDUM,JX
      DO 442 I=1,20
 442  READ(28,193)(NN(I,J),J=1,20)
 193  FORMAT(16I5)
 445  CONTINUE
      IF(IMOD.NE.1.AND.IPRINT.GT.0)WRITE(6,613)
 613  FORMAT(1H ,'DETAIL PRINTOUT OF EVAPORATION SEQUENCE',2X,'PI IS 1,2 ',
     1     'OR 3FOR N,P, ALPHA EMISSION',/,2X,'KI IS THE NUMBER OF EMITTED ',
     2     'LIGHT PARTICLES',2X,'J1,J2,L ARE J INITIAL,FINAL AND L(OF LIGHT ',
     3     'PARTICLE')
      CALL NXTEVN(SIGTO,EMG,E1,RAM,KMIN,KMAX,IPRINT)
C     PRINT OUT RESULTS ACCORDING TO IMOD.
      DO 910 I=1,80
 910  IARRA(I)=0
      CNORMA=NREP
      PORC=0.0
      ANGA=IANG
      IKI5=1
      DE12=0.0
      DO 908 LIZ=1,IPT
 908  PORC=PORC+ITT(LIZ)
      IPORC=PORC
      WRITE(6,909) IPORC
 909  FORMAT(1H0,17HNUMBER OF EVENTS=,I8)
      WRITE(6,614)
 614  FORMAT(1H ,'THE FOLLOWING TABLE GIVES THE ISOTOPE DISTRIBUTIONS FOR ',
     1     'FRAGMENT Z',/,2X,'(VERTICAL) AND MASS A(HORIZONTAL) STARTING ',
     2     'AT THE INDICATED Z,A VALUES')
      WRITE(6,615)
 615  FORMAT(1H ,'THE LAST FOUR COLUMNS ARE: PERCENT OF CROSS SECTION ',
     1     'FOR A GIVEN Z',/,2X,'AVE,SG, AND SKE ARE THE FIRST 3 MOMENTS OF ',
     2     'THE GAMA-RAY MULTIPLICITY',/,2X,'CALCULATED FROM M=J/2+2, WHERE ',
     3     'J IS THE FINAL ANGULAR MOMENTUM')
      DO 902 LIZZ=1,IPT
        IOZ=ICO(3)-LIZZ+1
        LIZ=IPT-LIZZ+1
        PARC=ITT(LIZ)
        PERC=PARC/PORC
        IMAS=ICO(2)-INEU(LIZ)-IPT+LIZ
        DENO=MUL(LIZ)
        AVMU=0.0
        AV2=0.0
        AV3=0.0
        IF(DENO.EQ.0.0)GO TO 4
        AVMU=CMUL(LIZ)/DENO
        AVMU2=CMUL2(LIZ)/DENO
        AVMU3=CMUL3(LIZ)/DENO
        AV2=AVMU2-AVMU**2
        IF(AV2.LE.0.0)GO TO 4
        AV2=SQRT(AV2)
        AV3=AVMU3-3.0*AVMU2*AVMU+2.0*AVMU**3
        AV3=AV3/(AV2**3)
 4      WRITE(6,903) IOZ,IMAS,(IUI(LIZ,KA),KA=1,12),PERC,AVMU,AV2,AV3
        WRITE(14,903) IOZ,IMAS,(IUI(LIZ,KA),KA=1,10)
        IF(IMAS1.EQ.0)GO TO 902
c       write(6,*) '    m  liz ico2 ineu  ipt    j'
        DO 904 J=1,INU
          M=LIZ+ICO(2)-INEU(LIZ)-IPT-J+1
c       write(6,'(6i5)') m,liz,ico(2),ineu(liz),ipt,j
          iarrz(ioz) = iui(liz,j) + iarrz(ioz)
 904    IARRA(M)=IUI(LIZ,J)+IARRA(M)
 902  CONTINUE
      IF(IMOD.NE.0) GO TO 1001
      IF(IMAS1.EQ.0)GO TO 2001
      WRITE(6,905)
 905  FORMAT(1H ,'MASS DISTRIBUTION FOLLOWS')
      MMAX=ICO(2)
      MMIN=ICO(2)-INEU(1)-IPT-INU+2
      IF(MMIN.LT.1)MMIN=1
      WRITE(6,911) MMAX,MMIN
 911  FORMAT(1H ,'MAX M=',I8,2X,'MIN M=',I8)
      WRITE(6,906) (IARRA(J),J=MMIN,MMAX)
 906  FORMAT(1H ,20I6)
 2001 DO 920 K=KMIN,KMAX
        IF(IMAX(K).EQ.0) GO TO 920
        Z=K+ICO(3)-IPT
        IF(IMAS1.GT.0)Z=K+MASMIN-1
c      WRITE(6,400) Z,E1
        IISUM=0
c      IF(IMAS1.GT.0) WRITE(6,1005)
c 1005 FORMAT(1H ,'MASS DISTRIBUTION OPTION Z=M XXXX ')
c  400 FORMAT (1H0,15X,20HANGULAR DISTRIBUTION,2X,7HZ  ION=,F8.0,2X,
c     111HLAB.ENERGY=,F8.3)
        MAX=IMAX(K)
c      WRITE(6,428)
c  428 FORMAT(1H0,16X,10HTHETA LAB.,3X,6HCOUNTS,10X,
c     120HDSIG/DTHETA (MB/RAD),8X,16HDSIG/DOME(MB/SR))
        DO 1920 I=1,MAX
          ISO=0
          DO 901 J=1,IEN
            KSU=(I-1)*IEN+J+LIMT(K)-1
            ISO=ISO+IPK(KSU)
 901      CONTINUE
          I1=I-1
          CI1=(I-1)*IANG
          CASO=ISO*SIGTO*57.29578/(PORC*ANGA)
          IF(CNORMA.GT.0.)CASO=CASO/CNORMA
          IF(I.EQ.1) CI1=0.25*IANG
          IF(I.EQ.1) CASO=2*CASO
          IF(I.EQ.MAX.AND.IKI5.EQ.0)CI1=180.0-0.25*IANG
          IF(I.EQ.MAX.AND.IKI5.EQ.0)CASO=2*CASO
          THETA=CI1*0.017453
          CASOS=CASO*0.15915/SIN(THETA)
          IISUM=ISO+IISUM
c      WRITE(6,410) CI1,ISO,CASO,CASOS
 1920   CONTINUE
c      WRITE(6,1983) IISUM
c 1983 FORMAT(1H0,18X,'TOTAL =',5X,I8)
 920  CONTINUE
ccccccccccccccccccccccccccccccccccccccccccc
c
c       output table of missing masses
c
      nmissing = 0
      write(6,*) ' '
      WRITE(6,*) ' MISSING MASSES:'
      write(6,*) '         z          a          cnt'
      write(14,*) ' '
      WRITE(14,*) ' MISSING MASSES:'
      write(14,*) '         z          a          cnt'
      do iz1m = 1,100
        do im1m = 1,100
          if( missing_mass(iz1m,im1m) .ne. 0 ) then
            write(6,'(3i10)') iz1m,im1m,missing_mass(IZ1M,IM1M)
            write(14,'(3i10)') iz1m,im1m,missing_mass(IZ1M,IM1M)
          endif
        enddo
      enddo
      
c  410 FORMAT(1H ,18X,F6.2,5X,I6,22X,F10.3,14X,F10.3)
ccccccccccccccccccccccccccccccccccccccccccccccccc
c
c       LILOUT.DAT output of velocity spectra information
c
c       WRITE(10,5000)PADE
c 5000  FORMAT(1H ,E12.4)
C
      write(6,*) '  kmin  kmax  minm  maxm'
      minm = kmin+masmin-1
      maxm = kmax+masmin-1
      
      
      DO 650 K=KMIN,KMAX
        IF(IMAX(K).EQ.0) GO TO 650
        MAX=IMAX(K)
        KK=K+ICO(3)-IPT
 430    FORMAT(1H0,38H  ENERGY DISTRIBUTIONS CTS IN DE STEPS)
        IF(IMAS1.GT.0)KK=K+MASMIN-1
        IF(IMAS1.EQ.0) WRITE(6,430)
ccccccccccccccccccccccccccccccccccccccccccccccccc
c
c       LILOUT.DAT output of velocity spectra information
c
C
C
        if( kk .ge. 1 .and. kk .le. 80 ) then
          esig = 0
          do ij = 1,icard
            if( nint(raa(ij)) .eq. kk ) esig = esig+pro(ij)*sigfrag
          enddo
          gsig = 0
          do ij = 1,icard
            if( nint(rbb(ij)) .eq. kk ) gsig = gsig+pro(ij)*sigfrag
          enddo
          fsig = sigfrag*iarrz(kk)/flat
          hsig = sigfrag*iarra(kk)/flat 
          siginz(kk) = esig
          sigina(kk) = gsig
          sigoutz(kk) = fsig
          sigouta(kk) = hsig
        endif
        DO 650 I=1,MAX
          II=I-1
          CII=(I-1)*IANG
          IF(I.EQ.1) CII=0.25*IANG
          IA=(I-1)*IEN+1+LIMT(K)-1
          IB=IA+IEN-1
          IUM=0
          DEVBA=PADE
          LULI=0
          DEV2=PADE/2.0
          DO 448 J=IA,IB
            LULI=LULI+1
            EBA=LULI*DEVBA-DEV2
            ISCL(LULI)=IPK(J)
c      IF(IMAS1.GT.0)ISCL(LULI)=IPK(J)/EBA
 448      IUM=IUM+ISCL(LULI)
          IF(IUM.EQ.0)IUM=1
          CUN=IUM
          S2=0.0
          S1=0.0
          PROD=1.0
          
          DO 449 J=1,LULI
            EBA=J*DEVBA-DEV2
            PPP=ISCL(J)/CUN
 449      S1=S1+PPP*EBA
          S2=SQRT(S2)
          DO 450 J=1,LULI
            EBA=J*DEVBA-DEV2
            PPP=ISCL(J)/CUN
 450      S2=S2+PPP*(EBA-S1)**2
          S2=SQRT(S2)
          J1=LULI
 650  CONTINUE
ccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c       Special Output of cross sections and velocities
c
      if( imas1 .gt. 0 ) then
c
c       write out pre- and post-evaporation cross sections
c
        call tkeout(sigfrag,flat)
        
      endif                     !imas1
c
c       End Special output sections
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      
      ADE=PADE
      PAPA=PORC*ADE*0.10966*ANGA
      CORM=SIGTO/PAPA
      IF(CNORMA.GT.0.)CORM=CORM/CNORMA
 429  FORMAT(51H   (D2SIG/DOME*DE) (MB/STR-MEV)=CTS*CORM/SIN(THETA),5X
     1     ,8HDE(MEV)=,F8.3,5X,5HCORM=,E12.3)
      IF(IMAS1.EQ.0)WRITE(6,429) ADE,CORM
      IF(IMAS1.GT.0)WRITE(6,427) ADE
 427  FORMAT(1H ,E12.4,'  VELOCITY STEPS IN C UNITS')
 1001 WRITE(6,1002) (ITP(I),I=1,3),E1
 1002 FORMAT(1H0,50H   TOTAL PRODUCTION OF NEUTRONS PROTONS AND ALPHAS,
     1     3(I8,3X),5X,11HLAB.ENERGY=,F8.3)
      IF(ILKI.EQ.0)GO TO 1004
      IF(IMOD.EQ.2)GO TO 1004
      WRITE(6,2003)
 2003 FORMAT(1H0,33HLIGHT PARTICLE KINEMATICS FOLLOWS)
      DO 2000 I=1,30000
        IF( ILK(I) .GT. 32000 ) THEN
          WRITE(6,11121) I,ILK(I)
11121     FORMAT(' WARNING: ILK OUT OF RANGE - I,ILK(I)=',2I10)
          ILK(I)=0
        ENDIF
 2000 IPK(I)=ILK(I)
      DO 2002 I=1,3
        IMAX(I)=MAKLI
        LIMT(I)=(I-1)*IELKI*MAKLI+1
 2002 CONTINUE
      KMIN=1
      KMAX=3
      ICO(3)=IPT-1
      IEN=IELKI
      IANG=IALKI
      ANGA=IANG
      ILKI=0
      IKI5=0
      PADE=(E1+ISHIF)/IELKI
      IMAS1=0
      GO TO 2001
 1004 CONTINUE
      DO 530 I=1,IPT
        DO 530 J=1,INU
 530  AM(I,J)=AM(I,J)/931.478
      PM(1)=PM(1)/939.55
      PM(2)=PM(2)/938.767
      PM(3)=PM(3)/3728.3367
      GO TO 510
 800  WRITE(6,805)
 805  FORMAT(1H ,29HTOO MUCH OUTPUT CHECK IMAX(I))
 40   FORMAT(10I8)
 41   FORMAT(20I4)
 50   FORMAT(8F10.0)
 31   FORMAT(26I3)
 21   FORMAT(20A4)
 24   FORMAT(1H ,20A4)
 680  FORMAT(1H ,11HLAB. ANGLE=,F6.2,5X,7HZ IONS=,I3,3X,8HCENTROID,
     1     f12.5,3X,5HWIDTH,f12.5,'   sum',f10.1,'  tke=',f10.2)
 300  FORMAT(1H1,18H       LAB.ENERGY=,F8.2,2X,9HMASSES OF,2X,
     1     11HPROJECTILE=,F12.6,2X,7HTARGET=,F12.6,2X,8HCOMPOUND,F12.6/
     2     1H ,9HLMAX N,P=,2I5,2X,11HLMAX ALPHA=,I3)
 708  FORMAT(1H0,5HICUTO,I5,2X,2HZT,F5.2,2X,2HZP,F5.2)
 310  FORMAT(1H ,//,1H ,8HSIG.TOT.,E12.3,2X,5HAMAX=,I3,2X,5HZMAX=,I3,
     1     3X,4HRAM=,F5.2,2X,2HEX,F8.2,2X,6HSIGFUS,'FROM SHARP CUTOFF',
     2     F10.2)
 314  FORMAT(1H ,52H  ENERGY AND ANGULAR DISTRIBUTIONS OF THE RESIDUAL P
     1     ,35HRODUCTS WILLBE CALCULATED FOR ZIONS,/,8H   ZMIN=,I3,2X,
     2     5HZMAX=,I3,2X,2HIN,I3,2X,12HDEGREE STEPS)
 316  FORMAT(1H ,38HEVENT BY EVENT WILL BE PRINTED ON TAPE)
 709  FORMAT(1H ,3HEIM,10X,12(F5.2,2X))
 903  FORMAT(1H ,1HZ,I3,2X,1HA,2X,I3,2X,12I6,2X,F5.4,2X,4H AVE,F5.2,
     1     2X,2HSG,F5.2,2X,3HSKE,F5.2)
 447  FORMAT(1H ,4HFILE,I5,5X,5HTOTAL,I6,'CHECK OF FILES 27 AND 28')
 900  FORMAT(1H0)
 705  FORMAT(1H ,4HMASS,9X,8(1H ,F9.5,3X))
 706  FORMAT(1H ,6HZ ION=,I2)
 60   FORMAT(6I5)
 820  STOP
      END
      SUBROUTINE NXTEVN(SIGTO,EMG,E1,RAM,KMIN,KMAX,IPRINT)
      common/icount/icount
      integer tke_pre_f(240,20,6,26),tke_post_f(240,20,6,26)
      integer tke_pre_b(240,20,6,26),tke_post_b(240,20,6,26)
      common/tkec/tke_pre_f,tke_post_f,
     &     tke_pre_b,tke_post_b,icnt_pre, icnt_post,
     &     icnt_pre_f,icnt_post_f,icnt_pre_b,icnt_post_b
      real vcn,eventbuf(7)
      integer proj_like_mass, targ_like_mass
      logical daphne
      common/daphne/daphne,vcn,eventbuf,proj_like_mass, targ_like_mass
      common/random/irx
      integer missing_mass(100,100)
      common/missing_mass/missing_mass
      COMMON AM(80,12),PM(3),DE(80,12),EIM(80,12),ALD(80,12),ECT(80,12)
     1     ,DLD(80,12),GAMA(80,12),RA(2,84),CMUL(80),MUL(80),CMAX(3,84)
      COMMON IUI(80,20),ITT(80),LIMT(80),IMAX(80),LMAX3,CB(2,80,12),
     1     INEU(80),LNU(3),NCH(3,2),ITP(3),ICO(7),LN(3),L12(3)
      COMMON PR(80,2),EMTA(80),CMTA(80),CCE(14),PD(4),
     1     SSIM(6),SIM(6),ENU(6),RH(6),RT(6),RT1(6),CMUL2(80),CMUL3(80)
     2     ,EMA(6),CNA(6)
      COMMON LMAX1,LMAX2,IANG,IPT,INU,IXN,IXX,IEN,ITIME
      COMMON AAU(6),CU1(3),AA(6),TDE(3),ZZMIN,ICUTO,NREP
      COMMON CM1,CM2,CNM,ZT,ZP,PADE
      COMMON/KINE/KI,IPAR(14),ILOR(14),P(14),ALM(14),PAM(14),CJJI(15),
     1     IANFI,CNLA,SNLA,ZZZ,YYY
      COMMON/KINLI/ILK(30000),IALKI,ILKI,IELKI,MAKLI,ISHIF,IARRA(80)
      COMMON/DISC/YRST(80,12),YRAST(80,12),CBL(60,84),SIG(88),CNU(3),
     1     B(3),TEMPR(3)
      COMMON/CONST/FAC12,EFACT,EBCONS,EBONE,EBTWO,BCUT,BCUT1,DELB(3,80)
      COMMON/OTP/IPK(500010),LOGI
      COMMON/CONTR/IMOD,JONE,JKK,IONLY,ICARD,ICLA,ICOMNU,MC,IZC,JMAX,
     1     IBAR,IMAS1,MASMIN
      common/ipderr/ipderr
      integer ipderr
      DIMENSION PRD(3,50),L13(3),CU2(3),FEX(60),LMAX(3)
      REAL*8 AM,PM,X
      INTEGER*2 IPK
      logical forward, forward_tag
      DIMENSION PRO(80),QGG(80),QMM(80),SIQ(80),XJ(80),SXJ(80),ETHE(80),
     1     RAA(80),RBB(80),QJMA(80)
      common/fragments/pro,qgg,qmm,siq,xj,sxj,ethe,raa,rbb,qjma
      ANGA=IANG
      KI1=ICO(2)
      KIN=IPT
      IZU=ICO(4)-ICO(3)+IPT
      ICO(6)=ICO(6)-ICO(3)+IPT
      LMAX(1)=LMAX1
      LMAX(2)=LMAX2
      LMAX(3)=LMAX3
C     THIS SUBROUTINE CALCULATES THE EVAPORATION RESIDUE YIELDS WITH THE
C     MONTE CARLO METHOD.  ALSO CALCULETS THE KINEMATICS OF THE RESIDUE
C     IN THE LABORATORY SYSTEM
      ICONT=0
      LTOTAL=0
      ICON=JONE
      ECM=E1*CM2/CNM
      ECO=E1*CM1/CNM
      VCM=SQRT(2*ECO/CNM)*0.032765
      VBEAM=SQRT(2.0*E1/CM1)*0.032765
      PADE=E1*(1.0-EMG)/IEN
      IF(IMAS1.GT.0)PADE=VBEAM*(1.0-EMG)/IEN
      NE=ICO(1)
      LUGA=0
      ITSN=1
      LAT=0
      LU=0
      KMAX=0
      IZZM=ZZMIN
      ITIM=SECNDS(0.)
      IEVN=IMOD
      GO TO 20
 26   IF(IZ.LT.1.OR.K8.LT.1) GO TO 20
      ITT(IZ)=ITT(IZ)+ITSN
      IF(K8.GT.20) GO TO 20
      IUI(IZ,K8)=IUI(IZ,K8)+ITSN
 20   I=1
      CMULT=0.0
      ITIP=SECNDS(0.)
      ITODO=(ITIP-ITIM)/100
      IF(ITODO.GT.ITIME) GO TO 60
      LAT=LAT+1
      if (mod(lat,2500).eq.0) print *,lat,icnt_pre,icnt_post,
     &     icnt_pre_f,icnt_post_f, icnt_pre_b,icnt_post_b

      IF(LAT.GT.NE) GO TO 60
      CALL PRIMAR(1,I,ICONT,IZ,IMN,K8,IBOD,IZ2,IM2,K82,KK2,Z22,ECM,
     1     SIGTO,RAM,EAA,EA2,Q,E,VR3,THETA,ANGU,CJL,CJN2,CJBUM,CJL2)
      mproj_prim = imn
      IF(IEVN.EQ.2)GO TO 807
 806  ZZZ=VCM+VR3*COS(THETA)
      if( abs(zzz) .lt. 1e-7 ) goto 91
      YYY=VR3*SIN(THETA)
      VZY=YYY**2+ZZZ**2
      EII=465.739*IMN*VZY
      ANGU=ATAN(YYY/ZZZ)
      angu = abs(angu)
      if( zzz .lt. 0 ) then
        angu = 3.1415926-angu
      endif
 807  IARRA(1)=Z22
      IARRA(2)=IMN
      IARRA(3)=10*Q
      icount = icount + 1
ccccccccccccccccccccccccccccccccccccccccccccc
c
c       increments for pre-evaporation tke array
c
      icnt_pre=icnt_pre+1
      if( angu .lt. 0 ) then
        write(6,*) 'Pre Angle less than 0: absolute value used'
        angu = abs(angu)
      endif
      iangx = 57.295*angu/2.+1
      if( iangx.gt.26 ) iangx = 26
      if( iangx.ge.1.and.iangx.le.26.and.vzy.gt.0) then
        izz = z22
        iaa = imn
        iax = iaa - 2*izz + 3
        v = sqrt(vzy)
        ftke = tke(57.295*angu,iaa,v,cm1,cm2,cnm,e1,v3cm,forward_tag)
        itke = 4*ftke+1
        if( izz.ge.1.and.izz.le.20.and.iax.ge.1.and.iax.le.6.and.
     &       ftke.gt.0.and.itke.le.240) then
          if( forward_tag ) then
            tke_pre_f(itke,izz,iax,iangx) =
     &           tke_pre_f(itke,izz,iax,iangx) + 1
            icnt_pre_f = icnt_pre_f + 1
          else
            tke_pre_b(itke,izz,iax,iangx) =
     &           tke_pre_b(itke,izz,iax,iangx) + 1
            icnt_pre_b = icnt_pre_b + 1
          endif
        endif
      endif
c
cccccccccccccccccccccccccccccccccccccccccccccccc
      
      IF(IONLY.EQ.1) GO TO 91
 805  CJ=CJL
      IARRA(4)=2*CJL
      IF(EAA.LE.EIM(IZ,K8))GO TO 91
      CNLA=COS(ANGU)
      SNLA=SIN(ANGU)
 90   I=I+1
      CJJI(I)=CJ
      IF(I.GT.14)GO TO 26
      KLA=IMN-ICO(2)+IXN
      IF(KLA.LT.1) GO TO 20
      J1=KI1-IMN-(KIN-1-IZ)
      LJ=J1+1
      J=J1+2
      EL=EAA-E
      IO=IMN-1
      ID=IMN-4
      IUA=1
      FIA=2.0
      I2=0
      K=IMN-ICO(2)+IXX
      PD(4)=GAMA(IZ,K8)
C     EMISION PROBABILITY CALCULATED FOR THE CONTINIUM
      DO 51 II=1,3
        III=II+3
        IKZZ=16*(II-1)-II+2
        IREG=1
        ILA=K-1
        NCH(II,1)=1
        NCH(II,2)=1
        LN(II)=1
        PD(II)=0.0
        PRD(II,1)=0.0
        IZN=IZ-II+1
        IF(IZN.LT.1) GO TO 502
        JJ=J1+2-II
        IF(II.LT.3) GO TO 71
        JJ=J1+2
        FIA=1.0
        IUA=2
        ILA=K-4
 71     J8=JJ-INEU(IZN)
        IF(J8.LT.1.OR.J8.GT.INU) THEN
          iz1m = izn + ico(3) - ipt
          im1m = izn + ico(2) - ineu(izn) - ipt + 1 - j8
          missing_mass(iz1m,im1m) = missing_mass(iz1m,im1m) + 1
          GO TO 502
        ENDIF
        IF(AM(IZN,J8).LE.0) then
          iz1m = izn + ico(3) - ipt
          im1m = izn + ico(2) - ineu(izn) - ipt + 1 - j8
          missing_mass(iz1m,im1m) = missing_mass(iz1m,im1m) + 1
          GO TO 502
        endif
        A=PM(II)+AM(IZN,J8)-AM(IZ,K8)
        CUB=CBL(1,KLA)
        IF(II.EQ.1) GO TO 61
        CUB=CB(IUA,IZN,J8)
 61     CNU(II)=EL-A
        TDE(II)=CMAX(II,KLA)
        BDEL=DELB(II,IZN)
        EMINI=CNU(II)-CUB
        B(II)=CUB
        IF(CNU(II).LE.ECT(IZN,J8).OR.CNU(II).LE.EIM(IZN,J8)) GO TO 501
        U=CNU(II)-DE(IZN,J8)
        ALA=ALD(IZN,J8)*U
c       WRITE(6,*) '  IZN   J8           U         ALA'
c       WRITE(6,'(2I5,2E12.3)') IZN,J8,U,ALA
        IF(EMINI.LE.0.0.OR.U.LE.1.0) GO TO 501
        DUMC=RA(IUA,KLA)
        LN(II)=SQRT(0.25+DUMC*EMINI)+0.6
        IF(LN(II).GT.LMAX(II))LN(II)=LMAX(II)
        PAUT=SIG(ILA)*EMINI
        AAU(II)=SQRT(PAUT+YRAST(IZN,J8))
        BA=CJL-LN(II)+1
        IF(BA.GT.AAU(II)) GO TO 501
        U1=(U-DE(IZN,J8))*0.5
        AU=SQRT(ALA)
        U2=0.25*(U-3*DE(IZN,J8))
        UU=U1
        UU2=U2
        IF(U1.LE.0.0) UU=U/2.0
        AUU=SQRT(ALD(IZN,J8)*UU)
        ASIG=SQRT(SIG(ILA)*U)
        ASIG1=SQRT(SIG(ILA)*UU)
        AX=2*AU
        RH(II)=FIA*EXP(AX)/(24.0*U*ASIG)
        AX=2*AUU
        RH(III)=FIA*EXP(AX)/(24.0*UU*ASIG1)
        EX2=CNU(II)-UU-DE(IZN,J8)
        RT1(II)=EX2/(ALOG(RH(II)/RH(III)))
        IF(RT1(II).LE.0.0) GO TO 501
        SSIM(II)=AU*SIG(ILA)/ALD(IZN,J8)
        CU2(II)=EX2
        ELOW=CNU(II)/2.0
        IF(ELOW.LE.ECT(IZN,J8)) IREG=2
        IF(U2.LE.0.0) IREG=2
        IF(IREG.EQ.2) CU2(II)=CNU(II)-ECT(IZN,J8)
        UU=CU2(II)
        IF(IREG.EQ.2) GO TO 69
        AUU2=SQRT(ALD(IZN,J8)*UU2)
        ASIG2=SQRT(SIG(ILA)*UU2)
        AX=2*AUU2
        RH3=FIA*EXP(AX)/(24.0*UU2*ASIG2)
        RATIO=RH(III)/RH3
        IF(RATIO.LE.1.0) IREG=2
        IF(IREG.EQ.2) CU2(II)=CNU(II)-ECT(IZN,J8)
        UU=CU2(II)
        IF(IREG.EQ.2) GO TO 69
        SSIM(III)=AUU*SIG(ILA)/ALD(IZN,J8)
        if( ssim(iii) .eq. 0 ) then
          write(6,*) 'ssim(iii),iii,izn,j8,ila=',ssim(iii),iii,izn,j8,
     &         ila,sig(ila),ald(izn,j8)
          goto 502
        endif
        EX3=CNU(II)-UU2-DE(IZN,J8)
        RT1(III)=(EX3-EX2)/(ALOG(RATIO))
        PAUT=UU*SIG(ILA)
        AAU(III)=SQRT(PAUT+YRAST(IZN,J8))
 65     AX=(CNU(II)-UU)/RT1(III)
        CNA(III)=EXP(-AX)
 69     AX=UU/RT1(II)
        CNA(II)=EXP(-AX)
        I1=I2+1
        I2=LN(II)+I2
        L=0
        IF(CUB.GT.UU) L13(II)=0
        DO 58 LEK=I1,I2
          L=L+1
          LXX=(II-1)*15+L
          TRR=RT1(II)
          AX=CBL(LXX,KLA)+CUB
          IF(AX.LT.UU) L13(II)=L
          IF(AX.GE.UU) GO TO 67
          AX=AX/TRR
          CMTA(LEK)=EXP(-AX)
          GO TO 58
 67       TRR=RT1(III)
          IF(IREG.EQ.2) GO TO 52
          AX=(AX-UU)/TRR
          CMTA(LEK)=EXP(-AX)
 58     CONTINUE
        GO TO 51
 52     BA=CJL-L13(II)+1
        IF(BA-AAU(II)) 501,501,53
 53     IREG=1
        GO TO 501
 502    NCH(II,1)=0
        NCH(II,2)=0
        CNU(II)=0.0
        I2=I2+1
        PR(I2,1)=0.0
        PR(I2,2)=0.0
        GO TO 51
 501    NCH(II,IREG)=0
C     CALCULATION OF EMISSION PROBABILITY FOR DISCRETE REGION
        ACNU=CNU(II)
        IF(IREG.EQ.2) ACNU=ECT(IZN,J8)
        IF(ACNU.LE.0.0) GO TO 502
        EPSMIN=0.0
        IF(IREG.EQ.2)EPSMIN=CNU(II)-ECT(IZN,J8)
        EPSMAX=CNU(II)
        S=0.5
        IF(II.EQ.3) S=0.0
        SUTA=0.0
        YR=YRST(IZN,J8)/SIG(ILA)
        IF(YR.LT.0.0)YR=ABS(YRST(IZN,J8))
        YR1=YR*YRAST(IZN,J8)
        YMAX1=YRAST(IZN,J8)+ACNU/YR
        LM2=1
        TT=SQRT(ACNU/ALD(IZN,J8))
        IF(TT.LT.1.0)TT=1.0
        TEMP=TT/YR
        TEMPR(II)=TEMP
        L=0
        SUTA=0.0
        CINTE=0.0
        DO 504 JLD=1,LMAX3
          L=L+1
          PRD(II,L)=0.0
          IF(L.GT.LMAX(II))GO TO 513
          LXX=(II-1)*15+L
          B3=CBL(LXX,KLA)+CUB
          B4=BDEL*B3
          B2=(B3-EPSMIN)/B4
          BT2=0.0
          IF(B2.GT.BCUT)BT2=B3-EPSMIN
          IF(B2.LE.BCUT.AND.B2.GE.BCUT1)BT2=ALOG(1.0+EXP(B2))*B4
          B1=(B3-EPSMAX)/B4
          BT1=0.0
          IF(B1.GT.BCUT)BT1=B3-EPSMAX
          IF(B1.LE.BCUT.AND.B1.GE.BCUT1)BT1=ALOG(1.0+EXP(B1))*B4
          CINT=EPSMAX-EPSMIN+BT1-BT2
          CLOJ=ABS(CJL-JLD+1)
          CLUJ=CJL+JLD-1
          ALOJ=CLOJ*(CLOJ+1)
          IF(ALOJ.GT.YMAX1)GO TO 506
          ALUJ=CLUJ*(CLUJ+1)
          IF(ALUJ.GT.YMAX1)ALUJ=YMAX1
          FSPIN=EXP(-ALOJ/TEMP)
          FSPI2=EXP(-ALUJ/TEMP)
          CINTE=CINT*(FSPIN-FSPI2)*DLD(IZN,J8)*ACNU*TDE(II)/2.0
          CINTE=CINTE*FIA
 506      PRD(II,L)=CINTE
 504    SUTA=SUTA+CINTE
 513    LM2=L
 505    PD(II)=SUTA
        IF(IREG-1) 510,510,511
 510    LN(II)=LM2
        I1=I2+1
        I2=I2+LN(II)
        GO TO 512
 511    I1=I1
        I2=I2-LN(II)
        LN(II)=MAX0(LM2,LN(II))
        I2=I2+LN(II)
 512    CONTINUE
        L=0
        DO 55 LEK=I1,I2
          L=L+1
          IF(L.GT.LM2) PRD(II,L)=0.0
          if(lek.lt.1.or.ireg.lt.1.or.ii.lt.1.or.l.lt.1) then
            write(6,*) 'lek,ireg,ii,l=',lek,ireg,ii,l
            write(6,*) 'i1,i2,lm2,ln(ii) = ',i1,i2,lm2,ln(ii)
            goto 20
          endif
          if(lek.gt.80.or.ireg.gt.2.or.ii.gt.3.or.l.gt.50) then
            write(6,*) 'lek,ireg,ii,l=',lek,ireg,ii,l
            write(6,*) 'i1,i2,lm2,ln(ii) = ',i1,i2,lm2,ln(ii)
            goto 20
          endif
 55     PR(LEK,IREG)=PRD(II,L)
 51   CONTINUE
      NCTH=NCH(1,1)+NCH(2,1)+NCH(3,1)
      IF(NCTH-1) 92,93,93
 92   I=I-1
C     EXTRACTION OF PARTICLE AND ORBITAL ANGULAR MOMENTUM,WHEN ONLY
C     THE DISCRETE REGIONS ARE OPEN
      if( pd(4) .eq. 1 ) then
        ipderr = ipderr + 1
        pt = 0
        if( mod(ipderr,100) .eq. 1 ) then
          write(6,4323) ipderr
 4323     format(' *****ERROR***** ipderr = ',i5)
        endif
      else
        PT=(PD(1)+PD(2)+PD(3))/(1-PD(4))
      endif
      IF(PT.GT.0) GO TO 47
      IDEC=0
      IF(EIM(IZ,K8).LE.0.0) IDEC=1
      IF(IDEC.EQ.0) GO TO 42
      PD(3)=CNU(3)
      PD(1)=CNU(1)
      PD(2)=CNU(2)
      PD(4)=0.0
      PT=PD(1)+PD(2)+PD(3)
      IF(PT.GT.0.0) GO TO 47
 42   IF(IZ-ICO(6))91,26,26
 47   V=RAN(IRX)
      XP=0.0
      PD(1)=PD(1)/PT
      PD(2)=PD(2)/PT
      PD(3)=PD(3)/PT
      DO 40 LI=1,4
        IF(PD(LI).EQ.0.0) GO TO 40
        II=LI
        XP=XP+PD(LI)
        IF(XP.GE.V) GO TO 41
 40   CONTINUE
 41   IF(II.LT.4) GO TO 43
      IF(IZ-ICO(6))91,26,26
 43   ITP(II)=ITP(II)+ITSN
      I=I+1
      S=0.5
      ILA=K-1
      IMN=IO
      IZ=IZ-II+1
      KL=J1+2-II
      IF(II.NE.3) GO TO 45
      IMN=ID
      KL=J1+2
      S=0.0
      ILA=K-4
 45   K8=KL-INEU(IZ)
      IF(IZ.GE.ICO(6)) GO TO 26
      IPAR(I)=II
      PAM(I)=PM(II)
      IF(K8.LT.1.OR.K8.GT.INU) GO TO 26
      ALM(I)=AM(IZ,K8)
      CCE(I)=CNU(II)
      ILOR(I)=0
      CJJI(I+1)=CJL+S
      IP=II
      IF(IDEC.EQ.1) GO TO 91
      V=RAN(IRX)
      XP=0.0
      IDUM=LN(II)
      DO 48 IX=1,IDUM
        ITX=IX
        IF(PRD(II,IX).EQ.0.0) GO TO 48
        XP=XP+PRD(II,IX)/(PD(II)*PT)
        IF(XP.GE.V) GO TO 49
 48   CONTINUE
 49   IAR=ITX
      ILOR(I)=IAR-1
      LXX=(II-1)*15+IAR
      I=I-1
      CLO1=ABS(CJL-IAR+1)
      CALL DISCRE(II,LXX,KLA,ILA,IZ,K8,ECXE,ILOJ,INDEX,CLO1)
      IF(INDEX.LT.0)GO TO 91
      I=I+1
      CCE(I)=ECXE
      ILO1=CLO1
      CLOJ=ILOJ+S+CLO1-ILO1
      CLOJ=ILOJ+S
      CJL=CLOJ
      CJ=CJL
      IP=II
      LITO=1
      E=CCE(I)
      EAA=CNU(II)
      ELU=CNU(II)-EIM(IZ,K8)
      C2=CJL+CJJI(I)
      IF(ILOR(I).GT.C2)ILOR(I)=C2
      IF(E.LT.ELU) GO TO 90
      CJJI(I+1)=CJL
      GO TO 91
 93   SUMA=0.0
      I2=0
C     COMBINATION OF PROBABILITIES FOR DISCRETE AND CONTINIUM OR
C     CONTINIUM REGIONS (1) AND (2).
      DO 121 II=1,3
        III=II+3
        I1=I2+1
        I2=LN(II)+I2
        DO 121 KLL=I1,I2
          IF(NCH(II,1).EQ.0) GO TO 122
          CL=KLL-I1
          PR(KLL,1)=0.0
          LCC=CL+1
          BA=ABS(CJ-CL)+0.5
          IF(L13(II).EQ.0) GO TO 123
          BAA=BA-0.5
          IF(BAA.GT.AAU(II).OR.LCC.GT.L13(II)) GO TO 123
          AX=(BA**2)/SSIM(II)
          CAX=EXP(-AX)
          BE=(1+BA/SSIM(II))*CAX
          BI=(CJ+CL+1.5)
          BIX=AAU(II)+1
          IF(BI.GT.BIX) BI=BIX
          AX=(BI**2)/SSIM(II)
          CAX=EXP(-AX)
          BO=(1+BI/SSIM(II))*CAX
          BU=BE-BO
          ATUB=BU*RH(II)*RT1(II)*TDE(II)
          PR(KLL,1)=(CMTA(KLL)-CNA(II))*ATUB
          IF(PR(KLL,1).LT.0.0) PR(KLL,1)=0.0
 123      IF(NCH(II,2).EQ.0) GO TO 121
          IF(BAA.GT.AAU(III)) GO TO 122
          BI=CJ+CL+1.5
          AX=AAU(III)+1
          IF(BI.GT.AX) BI=AX
          IF(SSIM(III) .EQ. 0 ) THEN
            goto 122
          ENDIF
          AX=(BA**2)/SSIM(III)
          CAX=EXP(-AX)
          BE=(1+BA/SSIM(III))*CAX
          AX=(BI**2)/SSIM(III)
          CAX=EXP(-AX)
          BO=(1+BI/SSIM(III))*CAX
          BU=BE-BO
          ATUB=BU*RH(III)*RT1(III)*TDE(II)
          PR(KLL,2)=(CMTA(KLL)-CNA(III))*ATUB
          IF(LCC.LE.L13(II)) PR(KLL,2)=(1-CNA(III))*ATUB
          IF(PR(KLL,2).LT.0.0) PR(KLL,2)=0.0
          GO TO 121
 122      PR(KLL,2)=0.0
 121  SUMA=SUMA+PR(KLL,1)+PR(KLL,2)
      IF(SUMA.LE.0.0) GO TO 92
      DO 141 JJI=1,I2
        PR(JJI,1)=PR(JJI,1)/SUMA
 141  PR(JJI,2)=PR(JJI,2)/SUMA
      XP=0.0
      L=0
C     EXTRACTION OF PARTICLE AND ORBITAL ANGULAR MOMENTUM WHEN AT LEAST
C     ONE CONTINIUM CHANNEL IS OPEN.
      V=RAN(IRX)
      DO 191 LXX=1,2
        LITO=LXX
        DO 191 LX=1,I2
          LI=LX
          IF(PR(LX,LXX).EQ.0.0) GO TO 191
          XP=XP+PR(LX,LXX)
          IF(XP.GE.V) GO TO 221
 191  CONTINUE
 221  L1=LN(1)
      L2=LN(1)+LN(2)
      IAR=LI
      IF(LI-L1)151,151,171
 151  IP=1
      LP=LI
      GO TO 251
 171  IF(LI-L2) 161,161,241
 161  IP=2
      LP=LI-L1
      GO TO 251
 241  IP=3
      LP=LI-L2
 251  IZ=IZ-IP+1
      ITP(IP)=ITP(IP)+ITSN
      SPIN=0.5
      KL=J1+2-IP
      IPAR(I)=IP
      IMN=IO
      ILA=K-1
      ILOR(I)=LP-1
      IF(IP.NE.3) GO TO 258
      IMN=ID
      SPIN=0.0
      KL=J1+2
      ILA=K-4
 258  K8=KL-INEU(IZ)
      IF(IZ.LE.1) GO TO 26
      IF(K8.LT.1.OR.K8.GT.INU) GO TO 26
      IP3=IP+3*(LITO-1)
      V=RAN(IRX)
      IF(NCH(IP,LITO).EQ.0) GO TO 255
      Y=CMTA(IAR)-V*(CMTA(IAR)-CNA(IP3))
      IF(LITO.EQ.2.AND.LP.LE.L13(IP)) Y=1-V*(1-CNA(IP3))
      IF(Y.LE.0.0.OR.Y.GT.1.0)GO TO 26
      CCE(I)=CU2(IP)*(LITO-1)-RT1(IP3)*ALOG(Y)
      GO TO 257
 255  LXX=(IP-1)*15+LP
      I=I-1
      CLO1=ABS(CJL-LP+1.0)
      CALL DISCRE(IP,LXX,KLA,ILA,IZ,K8,ECXE,ILOJ,INDEX,CLO1)
      IF(INDEX.LT.0)GO TO 91
      I=I+1
      CCE(I)=ECXE
      ILO1=CLO1
      CLOJ=ILOJ+SPIN+CLO1-ILO1
      CLOJ=ILOJ+SPIN
      CJL=CLOJ
 257  E=CCE(I)
      ALM(I)=AM(IZ,K8)
      PAM(I)=PM(IP)
      ELU=CNU(IP)-EIM(IZ,K8)
      EAA=CNU(IP)
      SIM2=SSIM(IP3)
      BIX=AAU(IP3)+1
C     EMISION OF SEVERAL PARTICLES UNTIL A RESIDUE HAS BEEN PRODUCED
C     BELOW PARTICLE THRESHOLD. LOOP STARTS AT STATEMENT 90 ENDING AT 91
      CLIH=CJL
      P5=1.0
      IF(NCH(IP,LITO).EQ.0) GO TO 103
      IF(LP.EQ.1) GO TO 98
      IF(CJL.EQ.0) GO TO 99
      ATAU=BIX-1.0
      COJ=ABS(CJL-LP+1)
      CUJ=CJL+LP-1
      IF(CUJ.GT.ATAU)CUJ=ATAU
      LOJ=CUJ-COJ
      LOJ=LOJ+1
      IF(LOJ.LE.1)LOJ=1
      SUMA=0.0
      DO 97 LIL=1,LOJ
        SIL=COJ+LIL-1
        FEX(LIL)=(2.0*SIL+1.0)*EXP(-((SIL+0.5)**2)/SIM2)
        SUMA=SUMA+FEX(LIL)
 97   CONTINUE
      W=RAN(IRX)
      XP=0.0
      DO 970 LIL=1,LOJ
        SIL=COJ+LIL-1
        XP=XP+FEX(LIL)/SUMA
        CLIH=SIL
        IF(XP.GT.W)GO TO 98
 970  CONTINUE
 98   CJL=CLIH
      GO TO 101
 99   CJL=LP-1
 101  CJL=CJL+SPIN
 103  CJ=CJL
      IF(E.LT.ELU) GO TO 90
      IF(EAA.LT.0.0.AND.IBOD.EQ.1)GO TO 20
      CJJI(I+1)=CJL
 91   KI=I
C     END LOOP FOR SUCCESSIVE EVAPORATION
      IF(IZ.LT.IZU.OR.IZ.GE.ICO(6)) GO TO 26
      IUI(IZ,K8)=IUI(IZ,K8)+ITSN
      ITT(IZ)=ITT(IZ)+ITSN
      CMULT=2.0+CJL/2.0
      ISUM=0
      IF(EAA.LE.0.10)CMULT=0.0
      IF(IBOD.EQ.1)MZ=IZ
      CMUL(MZ)=CMUL(MZ)+CMULT
      MUL(MZ)=MUL(MZ)+1
      CMUL2(MZ)=CMULT**2+CMUL2(MZ)
      CMUL3(MZ)=CMULT**3+CMUL3(MZ)
      IF(IMOD.EQ.1) GO TO 1000
      IARRA(5)=IZ+ICO(3)-IPT
      IARRA(6)=IMN
      IF(IMAX(IZ).EQ.0) GO TO 1000
C     START KINEMATICS CALCULATION OF EVAPORATION RESIDUES.
      ION=IZ
      IF(IMAS1.GT.0)ION=IMN-MASMIN+1
      IF(ION.LT.1)GO TO 1000
      IF(ION.GT.IPT)GO TO 1000
      IF(KI.GT.0)GO TO 94
      E=EII
      PSI=ANGU/0.017453
      IARRA(7)=IARRA(4)
      IARRA(8)=10*EAA
      IARRA(9)=0
      IARRA(10)=0
      IARRA(11)=0
      IARRA(12)=0
      JACK=12
      IF(IMOD.EQ.2)GO TO 1005
      GO TO 95
 94   IARRA(7)=2*CJJI(KI+1)
      IARRA(8)=10*EAA
      IARRA(9)=KI
      DO 30 J=1,KI
        CE=CCE(J)
        BOBO=ALM(J)*(ALM(J)+PAM(J))
        IF(BOBO.LE.0)
     &       WRITE(6,*) 'iz,imn,bobo, j,ki,alm(j),pam(j),ion,masmin:',
     &       iz,imn,bobo,j,ki,alm(j),pam(j),ion,masmin
        BABO=SQRT(BOBO)
        P(J)=SQRT(ABS((CE**2)+2*PAM(J)*CE))/BABO
 30   CONTINUE
      IF(LU.LT.IPRINT)WRITE(6,1010) IARRA(1),IARRA(5),IARRA(2),IMN,
     1     (IPAR(J),J=1,KI)
 1010 FORMAT(1H0,16H(Z1,Z2,M1,M2,PI),8I5)
 112  CALL KINT(E,PSI,QP2,E1,JACK,IEVN,ICLA,LU,IPRINT)
      IF(JACK.EQ.0)GO TO 20
 95   IA=PSI/ANGA+1.5
      JACK=JACK+1
      JE=E/PADE
      IF(IMAS1.EQ.0)GO TO 1012
      VE=SQRT(2.0*E/IMN)*0.03276
      
ccccccccccccccccccccccccccccccccccccccccccccc
c
c       increment post-evaporation velocity arrays
c
      
      
      icnt_post=icnt_post + 1
      if( angu .lt. 0 ) then
        write(6,*) 'Post Angle less than 0: absolute value used'
        angu = abs(angu)
      endif
      iangx = 57.295*angu/2.+1
      if( iangx.gt.26 ) iangx = 26
      if( iangx.ge.1.and.iangx.le.26.and.vzy.gt.0) then
        izz = iz + ico(3) - ipt
        iaa = imn
        iax = iaa-2*izz + 3
        ftke = tke(57.295*angu,iaa,ve,cm1,cm2,cnm,e1,v3cm,forward)
        itke = 4*ftke + 1
        if( izz.ge.1.and.izz.le.20.and.iax.ge.1.and.iax.le.6.and.
     &       ftke.gt.0.and.itke.le.240) then
          if( forward_tag ) then
CSMS should be ???          if( forward ) then
            tke_post_f(itke,izz,iax,iangx)
     &           = tke_post_f(itke,izz,iax,iangx)+1
            icnt_post_f = icnt_post_f + 1
          else
            tke_post_b(itke,izz,iax,iangx)
     &           = tke_post_b(itke,izz,iax,iangx)+1
            icnt_post_b = icnt_post_b + 1
          endif
        endif
      endif
      
      
c
cccccccccccccccccccccccccccccccccccccccccccccccc
      
      if( ibod .eq. 1 ) then
        mproj_sec = imn
        vproj_sec = ve
        iang_sec   = ia
        ang_sec    = angu
      else if (ibod .eq. 2) then
c
c       output data for daphne file
c
        if(daphne) then
          eventbuf(1) = mproj_sec
          eventbuf(2) = vproj_sec
          eventbuf(3) = ang_sec * 57.29578
          eventbuf(4) = imn
          eventbuf(5) = ve
          eventbuf(6) = angu * 57.29578
          eventbuf(7) = proj_like_mass
          call put_daphne(eventbuf)
        endif           
        ici = (iang_sec-1)*nint(anga)
        iciin = 0
        if ( ici .eq. 8 ) then
          iciin = 1
        else if (ici .eq. 16) then
          iciin = 2
        else if (ici .eq. 28) then
          iciin = 3
        else if (ici .eq. 38) then
          iciin = 4
        else if (ici .eq. 48) then
          iciin = 5
        endif
        if( iciin .gt. 0) then
          v3sin = vproj_sec*sin(ang_sec)
          v3cosvcn = vproj_sec*cos(ang_sec)-vcn
          if( v3cosvcn .lt. -1.e-4 ) then
            phi3 = 1.570796+atan(abs(v3sin/v3cosvcn))
          else if (v3cosvcn .gt. 1.e-4) then
            phi3 = atan( v3sin/v3cosvcn )
          else
            phi3 = 1.570796
          endif
          v4sin = ve*sin(angu)
          if( phi3 .ne. 0 ) then
            v3p = v3sin/sin(phi3)
            v4p = v4sin/sin(phi3)
          else
            v3p = 0
            v4p = 0
          endif
          mtarg_sec = imn
          vtarg_sec = ve
          mproj_calc = cnm * v4p/(v3p + v4p) + 0.5
          if(mproj_sec.gt.1.and.mproj_sec.lt.60.and.mproj_calc.gt.1
     &         .and.mproj_calc.lt.600) then
            wang = 57.2957*ang_sec
          endif
        endif
c
c       now reverse it
c       --------------          
c
c       output data for daphne file
c
        if( daphne ) then
          eventbuf(1) = imn
          eventbuf(2) = ve
          eventbuf(3) = angu * 57.29578
          eventbuf(4) = mproj_sec
          eventbuf(5) = vproj_sec
          eventbuf(6) = ang_sec * 57.29578
          eventbuf(7) = targ_like_mass
          call put_daphne(eventbuf)
        endif
        
        ici = (ia-1)*nint(anga)
        iciin = 0
        if ( ici .eq. 8 ) then
          iciin = 1
        else if (ici .eq. 16) then
          iciin = 2
        else if (ici .eq. 28) then
          iciin = 3
        else if (ici .eq. 38) then
          iciin = 4
        else if (ici .eq. 48) then
          iciin = 5
        endif
        if( iciin .gt. 0) then
          mtarg_sec = imn
          vtarg_sec = ve
          
          v3sin = vtarg_sec*sin(angu)
          v3cosvcn = vtarg_sec*cos(angu)-vcn
          if( v3cosvcn .lt. -1.e-4 ) then
            phi3 = 1.570796+atan(abs(v3sin/v3cosvcn))
          else if (v3cosvcn .gt. 1.e-4) then
            phi3 = atan( v3sin/v3cosvcn )
          else
            phi3 = 1.570796
          endif
          v4sin = vproj_sec*sin(ang_sec)
          if( phi3 .ne. 0 ) then
            v3p = v3sin/sin(phi3)
            v4p = v4sin/sin(phi3)
          else
            v3p = 0
            v4p = 0
          endif
          
          mproj_calc = cnm * v4p/(v3p + v4p) + 0.5
          if(mtarg_sec.gt.1.and.mtarg_sec.lt.60.and.mproj_calc.gt.1
     &         .and.mproj_calc.lt.600) then
            wang = 57.2957*ang_sec
          endif
        endif
      endif
      JE=VE/PADE
 1012 IARRA(JACK)=1000.0*CJBUM
      KL=ION
      ISUM=ISUM+1
      IF(IMOD.EQ.2) GO TO 1005
      IF(IA.GT.IMAX(ION)) IA=IMAX(ION)
      JE=JE+1
      IF(JE.GT.IEN) JE=IEN
      IF(JE.LE.0) JE=1
      KION=(IA-1)*IEN+JE+LIMT(ION)-1
C     STORE EVENTS ACCORDING TO IMOD
      IPK(KION)=IPK(KION)+ITSN
      IF(KL.GT.KMAX) KMAX=KL
      IF(KL.LT.KMIN) KMIN=KL
      IF(ISUM.LT.NREP.AND.KI.GT.0)GO TO 112
      GO TO 1000
 1005 KTY=JACK
C STORE EVENTS ON OUTPUT DEVICE
      LUGA=LUGA+KTY
      IF(LUGA.GT.8190) GO TO 1007
 1008 DO 1006 J=1,KTY
        JLU=J+LUGA-KTY
 1006 IPK(JLU)=IARRA(J)
      IPK(JLU+1)=-9999
      IFIRST=1+LUGA-KTY
      LAST=LUGA
      LUGA=LUGA+1
      IF(ISUM.LT.NREP.AND.KI.GT.0)GO TO 112
      GO TO 1000
 1007 LUGA=LUGA-KTY
      CALL OUTP(LUGA,LTOTAL)
      
      REALLU=LU
      REALLUT=LTOTAL
      WRITE(6,100) LUGA,REALLU,REALLUT,LOGI
C       PRINT 100,LUGA,LU,LTOTAL,LOGI
      LUGA=0
      GO TO 1005
 1000 LU=LU+1
      IF(LU.GT.NE) GO TO 60
      IF(ICONT.EQ.0)GO TO 20
      IBOD=2
      EAA=EA2
      IZ=IZ2
      Z22=ZT+ZP-Z22
      IMN=IM2
      K8=K82
      K=KK2
      CJL=CJL2
      CJBUM=CJN2
      ICONT=0
      I=0
      THETA=3.1416+THETA
      VR3=VR3*(CNM-IMN)/IMN
      E=0.0
      IF(IEVN-1)806,806,807
 60   LAT=LAT-1
      WRITE(6,111) LAT,NE
 111  FORMAT(1H0,12HTOTAL TRIAL=,I8,14HTOTAL REQUEST=,I8)
 100  FORMAT(1H0,3HNUM,I5,2X,3HEVN,E10.4,2X,3HSUM,E10.4,2X,4HFILE,I5)
      
      IF(IMOD.NE.2) GO TO 713
      CALL OUTP(LUGA,LTOTAL)
      REALLU=LU
      REALLUT=LTOTAL
      WRITE(6,100) LUGA,REALLU,REALLUT,LOGI
 713  RETURN
      END
      subroutine getseed(iseed)
      y=secnds(0.)
      iseed=y*2+1
      return
      end
      SUBROUTINE KINT(E,PSI,QP2,E1,JACK,IEVN,ICLA,NE,IPRINT)
      common/random/irx
      real vcn,eventbuf(7)
      integer proj_like_mass, targ_like_mass
      logical daphne
      common/daphne/daphne,vcn,eventbuf,proj_like_mass, targ_like_mass
      COMMON/KINE/KI,IPAR(14),ILOR(14),P(14),ALM(14),PAM(14),CJJI(15),
     1     IANFI,CNLA,SNLA,ZZZ,YYY
      COMMON/KINLI/ILK(30000),IALKI,ILKI,IELKI,MAKLI,ISHIF,IARRA(80)
      COMMON/QUA/IQME(22880),ISCL(2720),NN(20,20)
      COMMON/GLE/NDG(26,30),IGLEB(20155)
      DIMENSION XX(14),YY(14),ZZ(14),R(3,3),TA(14,3,3)
      DIMENSION PRO(80),QGG(80),QMM(80),SIQ(80),XJ(80),SXJ(80),ETHE(80),
     1     RAA(80),RBB(80),QJMA(80)
      common/fragments/pro,qgg,qmm,siq,xj,sxj,ethe,raa,rbb,qjma
      JPP=0
      JACK=0
      E=0.0
      IPI=IPRINT
      PSI=0.0
      THP=0.0
      SMALL=1.0E-15
      DO 50 J=1,KI
        JOTA=J+9
        IARRA(JOTA)=IPAR(J)
        JPP=JPP+1
        LPAR=ILOR(J)
        J1=CJJI(J)+0.51
        J2=CJJI(J+1)+0.51
        L1=IABS(J1-J2)
        L2=J1+J2
        L11=L1-1
        IF(LPAR.EQ.L11)LPAR=L11+1
        IF(NE.LT.IPRINT)WRITE(6,70) KI,J1,J2,LPAR,L1,L2
 70     FORMAT(1H0,18H(KI,J1,J2,L,L1,L2),6I8)
        IF(LPAR.LT.L1)GO TO 93
        IF(LPAR.GT.L2)GO TO 93
        V=6.28318*RAN(IRX)
        SND1=SIN(V)
        CND1=COS(V)
        IF(ICLA.EQ.0.AND.LPAR.LE.15)CALL QUAN(LPAR,J1,J2,L1,CNU,NE,IPI)
        IF(ICLA.EQ.1.OR.LPAR.GT.15)CALL CLAS(LPAR,J1,J2,CNU,THP)
        B4=1-CNU**2
        IF(B4.LT.0.0)GO TO 93
        SNU=SQRT(B4)
        XW=0.5-RAN(IRX)
        CNU=CNU*sign(1.,xw)
        XX(J)=P(J)*CNU
        YY(J)=P(J)*SNU*SND1
        ZZ(J)=P(J)*SNU*CND1
        IF(KI.EQ.1) GO TO 308
        CNUJ=1.0
        SNUJ=0.0
        CND=1.0
        SND=0.0
        L=LPAR
        IF(L.LT.1)GO TO 10
        IF(L.EQ.L1.AND.J2.LT.J1)GO TO 10
        IF(L.EQ.L1.AND.J1.EQ.0)GO TO 10
        CNUJ=THP
        IF(ICLA.EQ.0.AND.LPAR.LE.15)CALL GLEB(LPAR,J1,J2,L1,CNUJ,NE,IPI)
        B2=1-CNUJ**2
        IF(B2.LT.0.0)GO TO 93
        SNUJ=SQRT(B2)
        V=6.28318*RAN(IRX)
        SND=SIN(V)
        CND=COS(V)
 10     R(1,1)=CNUJ
        R(1,2)=SNUJ*CND
        R(1,3)=-SNUJ*SND
        R(2,1)=-SNUJ
        R(2,2)=CNUJ*CND
        R(2,3)=-CNUJ*SND
        R(3,1)=0.0
        R(3,2)=SND
        R(3,3)=CND
        IF(J.GT.1) GO TO 301
        DO 302 L=1,3
          DO 302 M=1,3
 302    TA(1,L,M)=R(L,M)
        GO TO 50
 301    DO 303 L=1,3
          DO 303 M=1,3
            SUMA=0.0
            DO 304 K=1,3
 304        SUMA=SUMA+R(L,K)*TA(J-1,K,M)
 303    TA(J,L,M)=SUMA
 50   CONTINUE
 308  KROT=JPP-1
      JACK=1
      X1=XX(1)
      X2=YY(1)
      X3=ZZ(1)
      IF(ILKI.EQ.0) GO TO 320
      RATIO=ALM(1)/PAM(1)
      JT=IPAR(1)
      XL1=-X1*RATIO
      XL2=-X2*RATIO
      XL3=-X3*RATIO
      IF(IEVN.NE.2)GO TO 90
      IARRA(JOTA+1)=10000*XL1
      IARRA(JOTA+2)=10000*XL2
      IARRA(JOTA+3)=10000*XL3
      JACK=JOTA+4
      GO TO 320
 90   XT1=XL1
      XT2=XL2
      XT3=XL3
      XL3=XT3*CNLA-XT2*SNLA+ZZZ
      XL2=XT3*SNLA+XT2*CNLA+YYY
      XL1=XT1
      IF(ABS(XL1).LT.SMALL)XL1=SMALL
      WLA=XL1**2+XL2**2+XL3**2
      ELAI=(SQRT(1+WLA)-1)*PAM(1)
      JE=1+ELAI*IELKI/(E1+ISHIF)
      IF(JE.GT.IELKI)JE=IELKI
      ZETA=ABS(XL3)
      IF(ZETA.LT.SMALL)ZETA=SMALL
      TANTL=SQRT(XL1**2+XL2**2)/ZETA
      PSI=ATAN(TANTL)*57.295779
      IF(XL3.LT.0)PSI=180.0-PSI
      IA=PSI/IALKI+1.5
      KION=(IA-1)*IELKI+JE+(JT-1)*IELKI*MAKLI
      IF(KION.GT.30000)KION=30000
      ILK(KION)=ILK(KION)+1
 320  IF(KROT.EQ.0) GO TO 307
      DO 305 J=2,KI
        J1=J-1
        XP3=X3
        XP2=X2
        XP1=X1
        XXXX1=XX(J)*TA(J1,1,1)+YY(J)*TA(J1,2,1)+ZZ(J)*TA(J1,3,1)
        XXXX2=XX(J)*TA(J1,1,2)+YY(J)*TA(J1,2,2)+ZZ(J)*TA(J1,3,2)
        XXXX3=XX(J)*TA(J1,1,3)+YY(J)*TA(J1,2,3)+ZZ(J)*TA(J1,3,3)
        IF(ILKI.EQ.0)GO TO 306
        RATIO=ALM(J)/PAM(J)
        JT=IPAR(J)
        XL1=-XXXX1*RATIO+XP1
        XL2=-XXXX2*RATIO+XP2
        XL3=-XXXX3*RATIO+XP3
        IF(IEVN.NE.2)GO TO 91
        IARRA(JACK)=10000*XL1
        IARRA(JACK+1)=10000*XL2
        IARRA(JACK+2)=10000*XL3
        JACK=JACK+3
        GO TO 306
 91     XT1=XL1
        XT2=XL2
        XT3=XL3
        XL3=XT3*CNLA-XT2*SNLA+ZZZ
        XL2=XT3*SNLA+XT2*CNLA+YYY
        XL1=XT1
        WLA=XL1**2+XL2**2+XL3**2
        IF(ABS(XL1).LT.SMALL)XL1=SMALL
        ELAI=(SQRT(1+WLA)-1)*PAM(J)
        JE=1+ELAI*IELKI/(E1+ISHIF)
        IF(JE.GT.IELKI)JE=IELKI
        ZETA=ABS(XL3)
        IF(ZETA.LT.SMALL)ZETA=SMALL
        TANTL=SQRT(XL1**2+XL2**2)/ZETA
        PSI=ATAN(TANTL)*57.295779
        IF(XL3.LT.0)PSI=180.0-PSI
        IA=PSI/IALKI+1.5
        KION=(IA-1)*IELKI+JE+(JT-1)*IELKI*MAKLI
        IF(KION.GT.30000)KION=30000
        ILK(KION)=ILK(KION)+1
 306    X1=X1+XXXX1
        X2=X2+XXXX2
        X3=X3+XXXX3
 305  CONTINUE
 307  CONTINUE
      IF(IEVN.NE.2)GO TO 92
      IARRA(JACK)=10000*X1
      IARRA(JACK+1)=10000*X2
      IARRA(JACK+2)=10000*X3
      JACK=JACK+2
      GO TO 93
 92   XX3=X3*CNLA-X2*SNLA+ZZZ
      XX2=X3*SNLA+X2*CNLA+YYY
      XX1=X1
      X1=XX1
      X2=XX2
      XX1=X1
      XX2=X2
      VRHO=XX1**2+XX2**2
      QM2=VRHO+XX3**2
      QFI=ABS(SQRT(VRHO)/XX3)
      E=(SQRT(1+QM2)-1)*ALM(KI)
      PSI=ATAN(QFI)/0.017453
      if(xx3.lt.0) psi = 180.-psi
 93   RETURN
      END
      SUBROUTINE CLAS(L,J,I,TH,TP)
      common/random/irx
      A1=J**2
      A2=L**2
      A3=I**2
      ANUM=A1+A2-A3
      ADENO=2*J*L
      ADUNO=2*I*J
      ANUNO=A1+A3-A2
      CNUL=0.0
      CNUJ=1.0
      IF(ADENO.GT.0.0)CNUL=ANUM/ADENO
      IF(ADUNO.GT.0.0.AND.ADENO.GT.0.0)CNUJ=ANUNO/ADUNO
      B1=1-CNUL**2
      SNUL=SQRT(B1)
      ALFA=3.14159*RAN(IRX)
      B3=1.0+COS(ALFA)
      CNU=SNUL*0.707106*SQRT(B3)
      TH=CNU
      TP=ABS(CNUJ)
      RETURN
      END
      SUBROUTINE GLEB(L,J1,J2,L1,CNUJ,NE,IPRINT)
      common/random/irx
      COMMON/GLE/NDG(26,30),IGLEB(20155)
      V=RAN(IRX)
      CNUJ=1.0
      IF(J1.GT.26.OR.J2.GT.30)GO TO 308
      IF(J2.GT.J1+4)GO TO 308
      LMA=MIN0(10,J1+J2)
      JF1=MIN0(J2+1,10)
      IF(L.GT.LMA)GO TO 308
      IV=V*1000.0
      LMIN=L1
      IF(L1.EQ.0)LMIN=1
      INDEX=NDG(J1,J2)+(L-LMIN)*JF1
      ISU=0
      K1=INDEX+1
      K2=INDEX+JF1
      DO 10 MC=1,JF1
        ML=J2-MC+1
        ISU=ISU+IGLEB(INDEX+MC)
        IF(ISU.GT.IV)GO TO 12
 10   CONTINUE
 12   DJ=J2
      CNUJ=ML/DJ
      IF(NE.LT.IPRINT)WRITE(6,25) L,J1,J2,INDEX,(IGLEB(KPR),KPR=K1,K2)
      GO TO 305
 308  A1=J1**2
      A2=J2**2
      A3=L**2
      ADU=2*SQRT(A1)*SQRT(A2)
      ANU=A1+A2-A3
      CNUJ=ANU/ADU
      CNUJ=ABS(CNUJ)
      IF(CNUJ.GT.1.0)CNUJ=1.0
 25   FORMAT(1H0,3HGLE,2X,14I6)
 305  RETURN
      END
      SUBROUTINE QUAN(L,J1,J2,L1,CNU,NE,IPRINT)
      common/random/irx
      COMMON/QUA/IQME(22880),ISCL(2720),NN(20,20)
      DIMENSION NQ(16),LMAX(20),LMIN(20)
      DATA NQ/0,38,95,171,266,380,513,665,836,1026,1235,1463,1710,1976,
     1     2261,2565/
      DATA LMAX/5,7,7,7,8,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10/
      DATA LMIN/1,1,1,1,2,2,2,3,3,3,4,4,4,4,5,5,5,5,5,5/
      LTWO=L
      VV=RAN(IRX)
      L2=L1+1
      IF(J1.LT.1.OR.J2.LT.1)GO TO 104
      IF(J1.GT.20.OR.J2.GT.20)GO TO 50
      IF(L.LT.LMIN(J1).OR.L.GT.LMAX(J1))GO TO 50
C     STRETCH TRANSITION
      L2=MAX0(L2,LMIN(J1))
      IF(L.LT.L2)GO TO 50
      L3=J1+J2-1
      IF(L.GT.L3)GO TO 50
      INDEX=NN(J1,J2)+(L-L2)*19
      IS=0
      IV=VV*(2000-IQME(INDEX+19))
      K1=INDEX+1
      K2=K1+18
      IF(NE.LT.IPRINT)WRITE(6,25) L,J1,J2,INDEX,(IQME(KPR),KPR=K1,K2)
      DO 10 I=1,18
        K=I
        LC=INDEX+I
        IA=IQME(LC)
        IB=IQME(LC+1)
        IS=IS+IA+IB
        IF(IS.GT.IV)GO TO 15
 10   CONTINUE
 15   I2=IB
      I1=IA
      DI=I2-I1
      IF(I1.EQ.0)GO TO 54
      IF(DI.EQ.0.0)GO TO 55
      FLI=(I2+I1)*DI
      FAC=RAN(IRX)*FLI/(I1**2)+1.0
      TH=(K-1)*5.00+5.00*I1*(SQRT(FAC)-1.0)/DI
      GO TO 53
 54   TH=5.00*SQRT(RAN(IRX))+(K-1)*5.00
      GO TO 53
 55   TH=5.00*RAN(IRX)+(K-1)*5.00
 53   THE=TH*0.017453
      CNU=COS(THE)
      GO TO 100
 50   JDJ=L2
      IF(L.GT.0)GO TO 52
      GO TO 104
 52   CONTINUE
      IF(L.GT.15)L=15
      ITO=NQ(L)+(JDJ-1)*19
      IS=0
      IV=VV*(2000-ISCL(ITO+19))
      K1=ITO+1
      K2=ITO+19
      IF(NE.LT.IPRINT)WRITE(6,27) L,JDJ,ITO,(ISCL(KPR),KPR=K1,K2)
      L=LTWO
      DO 20 I=1,18
        K=I
        IA=ISCL(ITO+I)
        IB=ISCL(ITO+I+1)
        IS=IS+IA+IB
        IF(IS.GT.IV)GO TO 15
 20   CONTINUE
 25   FORMAT(1H0,3HQUA,2X,14I6)
 27   FORMAT(1H0,3HCLA,2X,13I6)
      GO TO 15
 104  CNU=1.0-VV
 100  RETURN
      END
      SUBROUTINE DISCRE(II,LXX,KLA,ILA,IZ,K8,ECXE,ILOJ,INDEX,SO)
      common/random/irx
      COMMON/CONST/FAC12,EFACT,EBCONS,EBONE,EBTWO,BCUT,BCUT1,DELB(3,80)
      COMMON/DISC/YRST(80,12),YRAST(80,12),CBL(60,84),SIG(88),CNU(3),
     1     B(3),TEMPR(3)
      INDEX=-1
      SOSO=SO*(SO+1.0)
      BARR=CBL(LXX,KLA)
      BARR=BARR+B(II)
      DEL=DELB(II,IZ)
      EBCON1=EBCONS*DEL/2.0
      EBTW1=EBTWO*DEL
      EBON1=EBONE*DEL
      EPS1=BARR*(1.0-EBON1)
      IF(CNU(II).LT.EPS1)GO TO 15
      INDEX=1
      EPS2=BARR*(1.0+EBTW1)
      AAA=BARR*EBCON1
      BBB=CNU(II)-EPS2
      IF(BBB.LT.0.0)BBB=0.0
      ATOT=AAA+BBB
      AA1=AAA/ATOT
      V=RAN(IRX)
      IF(V.GT.AA1)GO TO 5
      FAC=SQRT(1.0+EFACT*RAN(IRX))-1.0
      ECXE=EPS1+(EPS2-EPS1)*FAC12*FAC
    7 EX=CNU(II)-ECXE
      ILOJ=SO
      AEX=SOSO/TEMPR(II)
      IF(AEX.GT.25.0)GO TO 10
      YR=YRST(IZ,K8)/SIG(ILA)
      IF(YR.LT.0.0)YR=ABS(YRST(IZ,K8))
      CJCJ1=YRAST(IZ,K8)+EX/YR
      A1=EXP(-AEX)
      IF(CJCJ1.LT.SOSO)CJCJ1=SOSO
      A2=0.0
      AEX=CJCJ1/TEMPR(II)
      IF(AEX.LE.25.0)A2=EXP(-AEX)
      V=RAN(IRX)
      AS=A1*(1.0-V)+A2*V
      IF(AS.LE.0.0000000)AS=0.0000001
      AST=-1.0*ALOG(AS)*TEMPR(II)
      ILOJ=SQRT(AST)+0.5
      GO TO 10
    5 V=RAN(IRX)
      ECXE=V*CNU(II)+EPS2*(1-V)
      GO TO 7
 15   ECXE=CNU(II)
      INDEX=1
      GO TO 7
 10   RETURN
      END
      SUBROUTINE OUTP(L,J)
      common/random/irx
      COMMON/OTP/IPK(500010),LOGI
      INTEGER*2 IPK
      INTEGER*2 IBUFF(8192)
      DO JJ=2,8192
        IBUFF(JJ)=IPK(JJ-1)
      ENDDO
      IBUFF(1)=L
      WRITE(12) IBUFF
      ITEST=ISFLAG(1)
      IF(ITEST.NE.0)THEN
        CLOSE(UNIT=12)
        STOP ' Run stopped by external command !'
      endif
      J=J+L
      RETURN
      END
      subroutine INIFLAG
CSMS    integer sys$ascefc,sys$clref
CSMS    I=SYS$ASCEFC(%VAL(64),'FLAG',,)
CSMS    I=SYS$CLREF(%VAL(64))
CSMS    I=SYS$CLREF(%VAL(64))
      return
      end
      FUNCTION ISFLAG(I)
CSMS    INTEGER SYS$CLREF
CSMS    J=I+63
CSMS    ISFLAG=SYS$CLREF(%VAL(J))-1
CSMS    IF(ISFLAG.GT.1)ISFLAG=1
      ISFLAG=0
      RETURN
      END
CSMS    SUBROUTINE SETFLAG(I)
CSMS    INTEGER SYS$SETEF
CSMS    J=I+63
CSMS    II=SYS$SETEF(%VAL(J))
CSMS    RETURN
CSMS    END
CSMS    SUBROUTINE CLRFLAG(I)
CSMS    INTEGER SYS$CLREF
CSMS    J=I+63
CSMS    II=SYS$CLREF(%VAL(J))
CSMS    RETURN
CSMS    END
      SUBROUTINE PRIMAR(ICALL,I,ICONT,IZ,IMN,K8,IBOD,IZ2,IM2,K82,KK2,
     1     Z22,ECM,SIGTO,RAM,EAA,EA2,Q,E,VR3,THETA,ANGU,CJL,CJN2,CJBUM,CJL2)
      real vcn,eventbuf(7)
      integer proj_like_mass, targ_like_mass
      logical daphne
      common/daphne/daphne,vcn,eventbuf,proj_like_mass, targ_like_mass
      common/random/irx
      COMMON AM(80,12),PM(3),DE(80,12),EIM(80,12),ALD(80,12),ECT(80,12)
     1     ,DLD(80,12),GAMA(80,12),RA(2,84),CMUL(80),MUL(80),CMAX(3,84)
      COMMON IUI(80,20),ITT(80),LIMT(80),IMAX(80),LMAX3,CB(2,80,12),
     1     INEU(80),LNU(3),NCH(3,2),ITP(3),ICO(7),LN(3),L12(3)
      COMMON PR(80,2),EMTA(80),CMTA(80),CCE(14),PD(4),
     1     SSIM(6),SIM(6),ENU(6),RH(6),RT(6),RT1(6),CMUL2(80),CMUL3(80)
     2     ,EMA(6),CNA(6)
      COMMON LMAX1,LMAX2,IANG,IPT,INU,IXN,IXX,IEN,ITIME
      COMMON AAU(6),CU1(3),AA(6),TDE(3),ZZMIN,ICUTO,NREP
      COMMON CM1,CM2,CNM,ZT,ZP,PADE
      COMMON/KINE/KI,IPAR(14),ILOR(14),P(14),ALM(14),PAM(14),CJJI(15),
     1     IANFI,CNLA,SNLA,ZZZ,YYY
      COMMON/KINLI/ILK(30000),IALKI,ILKI,IELKI,MAKLI,ISHIF,IARRA(80)
      COMMON/CONST/FAC12,EFACT,EBCONS,EBONE,EBTWO,BCUT,BCUT1,DELB(3,80)
      COMMON/DISC/YRST(80,12),YRAST(80,12),CBL(60,84),SIG(88),CNU(3),
     1     B(3),TEMPR(3)
      COMMON/CONTR/IMOD,JONE,JKK,IONLY,ICARD,ICLA,ICOMNU,MC,IZC,JMAX,
     1     IBAR,IMAS1,MASMIN
      DIMENSION PRO(80),QGG(80),QMM(80),SIQ(80),XJ(80),SXJ(80),ETHE(80),
     1     RAA(80),RBB(80),QJMA(80)
      common/fragments/pro,qgg,qmm,siq,xj,sxj,ethe,raa,rbb,qjma
      REAL*8 AM,PM
C EXPLANATION OF QUANTITIES IN THE ARGUMENT OF PRIMAR.........
C ICALL=0(FIRST CALL),OTHER WISE 1. I INDEX TO CONTROL NUMBER OF EMITTED
C PARTICLES IN PRIMAR, USUALLY 0. ICONT=1 FOR TWO BODY, 0 FOR FUSION. IZ
C Z INDEX OF PLF. IMN MASS INDEX OF PLF. K8 INDEX FOR PLF. IBOD=1 FOR PLF, I1578
C 2 FOR TLF. IZZ INDEX OF TLF. IM2 MASS INDEX FOR TLF. K82 INDEX OF TLF.
C KK2 INDEX FOR TLF. ZZ2 Z OF TLF. ECM CENTER OF MASS ENERGY. SIGTO TOTAL
C CROSS SECTION. RAM RATIO OF RANDOM TO ALIGNED COMPONENT OF ANGULAR
C MOMENTUM. EAA EX FOR PLF. EA2 EX FOR TLF. E ENERGY OF EMITTED LIGHT PARTIC1582
C (PRESENTLY 0). VR3 CM VELOCITY OF TLF. THETA CM ANGLE OF PRIMARY REACTION 1583
C . ANGU=THETA. CJL IS J OF PLF. CJN2 J OF TLF. CJBUM RANDOM NUMBER
C FOR PLF USED TO COMPUTE THE ANGLE BETWWEN RANDOM AND ALIGNED COMPO-
C NENTS. CJL2 SAME AS CJBUM BUT FOT TLF.)
C FOR FUSION PLF=COMPOUND NUCLEUS.
      IF(ICALL.EQ.1)GO TO 100
      KI1=ICO(2)
      KIN=IPT
      IEVN=IMOD
      ICON=JONE
      RAN2=RAM**2+1.0
      TEMP=EAA
      EX=EAA
      M1=CM1
      M2=CM2
      CM=JMAX/2.0
      IF(ICOMNU.EQ.1.AND.IBAR.EQ.0)WRITE(6,312)
 312  FORMAT(1H0,'FUSION INPUT + J DISTRIBUTION BY CARDS OPTION')
      IF(ICOMNU.EQ.1.AND.IBAR.EQ.1) WRITE(6,310)
 310  FORMAT(1H0,'FUSION INPUT AND SHARP CUT-OFF ENTRANCE CHANNEL OPTION')
      IF(IBAR.EQ.1)WRITE(6,311) CM,SIGTO
 311  FORMAT(1H0,26HMAXIMUN J COMPOUND NUCLEUS,F5.2,5X,
     1     5X,20HFUSION CROSS SECTION,'FROM CARD 11',F10.2)
      IF(ICOMNU.EQ.0)WRITE(6,315)
 315  FORMAT(1H0,'TWO BODY INPUT SELECTED')
      IF(ICARD.EQ.0)GO TO 500
      SIGTO=0.0
C INPUT OF THE PRIMARY DISTRIBUTION. FOR FUSION PRO(I)=SIG(J),QMM(I)=EXCITAT1611
C ENERGY IN COM. NUCL. XJ(I)=J,RAA(I)=Z COMPUND, RBB(I)= M COMPUND. THE REST1612
C OF THE ARRAYS ARE NOT USED
CCCCCCCCCCCCCCCCC
C FOR TWO BODY INPUT : PRO(I)=CROSS SECTION IN CHANNEL I. QGG(I) Q GROUND - 1615
C ND. QMM(I)=AVERAGE Q , SIQ(I) Q-SPREAD, XJ(I)=TOTAL TRANSFERED ANGULAR MOM1616
C TUM,, SXJ(I)= J SPREAD,,ETHE(I)= N FOR THE PRIMARY ANG. DIST DEFINED AS
C DSIG/DOME(CM)=1/SIN(THETA)**N
C  RAA(I)= Z OF FRAGMENT,, RBB(I)= MASS FRAGMENT
      WRITE(6,21)
 21   FORMAT(1H ,'INPUT DATA FOR PRIMARY DISTRIBUTION GIVEN BY CARDS')
      DO 4 I=1,ICARD
        READ (110,23) PRO(I),QGG(I),QMM(I),SIQ(I),XJ(I),SXJ(I),ETHE(I),
     1       RAA(I),RBB(I),QJMA(I)
        SIGTO=SIGTO+PRO(I)
        WRITE(6,26) PRO(I),QGG(I),QMM(I),SIQ(I),XJ(I),SXJ(I),
     &       ETHE(I),RAA(I),RBB(I)
    4 CONTINUE
      
      close(110)

      DO 5 I=1,ICARD
    5 PRO(I)=PRO(I)/SIGTO
      GO TO 500
 100  CONTINUE
      IF(ICOMNU.EQ.1.AND.IBAR.EQ.1)GO TO 200
      V=RAN(IRX)
 801  INIT=1
      SUMA=0.0
      IFIN=ICARD
 803  DO 800 JI=INIT,IFIN
        LX=JI
        SUMA=SUMA+PRO(JI)
        IF(SUMA.GE.V)GO TO 804
 800  CONTINUE
 804  IAR=LX
      I=0
      E=0.0
      IF(ICON.EQ.1)ICONT=1
      IZ=RAA(IAR)-ICO(3)+IPT
      IMN=RBB(IAR)
      proj_like_mass = imn
      KL=KI1-IMN-(KIN-1-IZ)
      K8=KL-INEU(IZ)
      K=IMN-ICO(2)+IXX
      IBOD=1
      IF(ICOMNU.EQ.0)GO TO 810
      IF(IBAR.EQ.1)GO TO 500
      EAA=QMM(IAR)
      Z22=RAA(IAR)
      CJL=XJ(IAR)
      VR3=0.0
      THETA=0.0
      Q=EAA
      GO TO 500
 810  V=RAN(IRX)
      Q=QMM(IAR)*(1+GAUS(V)*SIQ(IAR))
      IA123=IAR
      IF(IAR.EQ.ICARD)IA123=IAR-1
      IF(QMM(1).LT.0.0)Q=V*QMM(IA123)+(1.0-V)*QMM(IA123+1)
      IM2=CNM-IMN
      targ_like_mass = im2
      IZ2=ZT+ZP-RAA(IAR)-ICO(3)+IPT
      K82=KI1-IM2-(KIN-1-IZ2)-INEU(IZ2)
      KK2=IM2-ICO(2)+IXX
      EXF=Q+QGG(IAR)
      IF(EXF.LT.0.0)GO TO 100
C    EX1,EX2,SWITCH
      QTHRS=JKK
      IF(EXF.LT.QTHRS)GO TO 9001
      EAA=IMN*(EXF-DE(IZ2,K82))+IM2*DE(IZ,K8)
      EAA=EAA/CNM
      GO TO 9002
 9001 EAA=EXF*IMN/CNM
c       FUDGE
c9001   eaa = exf * 2 * (float(imn)/cnm)**2
 9002 EA2=EXF-EAA
      Z22=RAA(IAR)
      XJIAR=(QJMA(IAR)-Q)**2
      XJIAR=XJIAR/(TEMP**2)
      XJIAR=XJ(IAR)*EXP(-XJIAR)
      CJL=XJIAR+SXJ(IAR)*GAUS(V)
      CM53=RBB(IAR)**1.6666
      C253=(CNM-RBB(IAR))**1.6666
      ICJL=CJL*CM53/(CM53+C253)
      ICJ2L=CJL-ICJL
      V=RAN(IRX)
      CJNV=V
      CJL=(ICJL**2)*(RAN2+2.0*RAM*(2*V-1))
      CJL=SQRT(CJL)
      ICJL=CJL
      V=RAN(IRX)
      CJN2=V
      CJL2=(ICJ2L**2)*(RAN2+2.0*RAM*(2.0*V-1))
      CJL2=SQRT(CJL2)
      ICJ2L=CJL2
      PAUT=EAA*SIG(K)+YRAST(IZ,K8)
      if( paut .le. 0 ) then
        write(6,*) 'k,sig,eaa,yrast(iz,k8),iz,k8',k,sig(k),eaa,
     &       yrast(iz,k8),iz,k8
      endif
      JJ1=SQRT(PAUT)
      IF(ICJL.GT.JJ1)ICJL=JJ1
c       WRITE(6,*) '  KK2  IZ2  K82'
c       WRITE(6,'(3I5)') KK2,IZ2,K82
      PAUT=EA2*SIG(KK2)+YRAST(IZ2,K82)
      if( paut .le. 0 ) then
        write(6,*) 'kk2,sig,ea2,yrast(iz2,k82),iz2,k82',kk2,sig(kk2),
     &       ea2,
     &       yrast(iz2,k82),iz2,k82
        PAUT = 0
      endif
      JJ1=SQRT(PAUT)
      IF(ICJ2L.GT.JJ1)ICJ2L=JJ1
      CJBUM=CJNV
      IFO=IMN/2
      IFO2=IM2/2
      CJL=ICJL+(IMN-2*IFO)/2.0
      CJL2=ICJ2L+(IM2-2*IFO2)/2.0
      ANGU=0.0
      IF(EAA.LE.0.0)GO TO 100
      RM2=RBB(IAR)
      EREL=ECM-Q
      IF(EREL.LE.0.0)GO TO 100
      E3P=IM2*EREL/CNM
      VR3=SQRT(2*E3P/IMN)*0.032765
      THETA=0.0
      IF(IEVN.EQ.2)GO TO 500
      V=RAN(IRX)
c      TEX=ETHE(IAR)
c      TEX=TEX*QMM(IAR)/Q
c      CALL ANGLE(TEX,V,THETA)
      call angle(v,theta)
 23   FORMAT(10F8.0)
 26   FORMAT(1H ,9F8.2)
      GO TO 500
 200  V=RAN(IRX)
      JL=SQRT((V*(CM+1.)**2)-V+1.)-1.
      CJL=JL+CM-JMAX/2
      IF(M1.EQ.M2)CJL=(JL/2)*2.0
      EAA=EX
      Z22=IZC
      VR3=0.0
      THETA=0.0
      Q=EAA
      RAA(1)=IZC
      RBB(1)=MC
      ANGU=0.0
      LX=1
      GO TO 804
 500  RETURN
      END
c      SUBROUTINE ANGLE(T,V,TX)
      subroutine angle(v,tx)
      common/random/irx
      SMAL=1.0E-10
      tx = 3.1415926*v
c      TX=1.57079*V
c      IF(T.LE.1.0)GO TO 600
c      TX1=EXP(4.04812*V-4.04812)
c      TX1=2*ATAN(TX1)
c      IF(T.GT.2.0)GO TO 501
c      DT=2.0-T
c      TX=TX1+DT*(TX-TX1)
c      GO TO 600
c  501 DT=3.0-T
c      TX2=57.2899-57.2899*V
c      IF(TX2.LT.SMAL)TX2=SMAL
c      TX2=ATAN(1/TX2)
c      TX=TX2+DT*(TX1-TX2)
c      IF(TX.LT.0.0)TX=0.0
c  600 RETURN
      END
      FUNCTION GAUS(V)
      common/random/irx
      common/gas/ngas,gas(1001)
c      DIMENSION GAS(22)
c      DATA GAS/-5.0,-1.7,-1.29,-1.04,-0.85,-0.68,-0.53,-0.39,-0.26
c     1,-0.13,0.0,0.13,0.26,0.39,0.53,0.68,0.85,1.04,1.29,1.7,5.0,5.0/
      IX=ngas*V+1
      DIF=GAS(IX)-GAS(IX+1)
      DIF=ABS(DIF)
      GAUS=GAS(IX)+DIF*(ngas*V-IX+1)
      RETURN
      END
c
c       Subroutine to write out fragment data for subsequent
c       Daphne replay
c
      subroutine put_daphne(ev)
      real ev(7)
      write(111) ev
      return
      end
      
      subroutine lilita_deck
      implicit none
      integer i, j, k, imod, jone, ipt, z, a
      real*4 mu, lambda2
      integer card1_more, card1_itime, card1_iprint, card1_nrep,
     &     card1_massopt, card1_massmin
      integer   card2_imod, card2_jone, card2_ipt, card2_inu, card2_ien,
     &     card2_iang, card2_icut0, card2_ionly
      integer card3_imax(80)
      integer card4_nevt, card4_maxa, card4_maxz, card4_minz,
     &     card4_null, card4_zmax, card4_lun,  card4_lmax1, card4_lmax2,
     &     card4_lmax3
      real      card5_proja, card5_targa, card5_cna, card5_targz,
     &     card5_projz, card5_elab, card5_emg
      real      card6_almas
      integer card7_ineu(80)
      integer card8_ilki, card8_ielki, card8_ialki, card8_ishif,
     &     card8_ianfi
      integer card11_nchan, card11_icomnu, card11_ibar, card11_jmax2,
     &     card11_icla, card11_jkk, card11_mc, card11_izc
      real      card11_sigtot, card11_ex, card11_ram
      character*80      message
      integer icard, numevt, ztarg, atarg, zproj, aproj
      real      pro(80), qgg(80), qmm(80), siq(80), xj(80),
     &     sxj(80), ethe(80), raa(80), rbb(80), qjma(80)
      real      elab, binding, sigtot, ecm, spin
      character*80      label, message1, message2
      integer last
      common/entrance/elab,ztarg,atarg,zproj,aproj
      data      last/-1/
c
c       open input file
c
      open(unit=9,file='fislilita.work',status='old')


c
c               READ blank
c               ---------------------
c
      read(9,'(a80)') message1
      write(21,'(a80)') message1
c
c               READ ENTRANCE CHANNEL DEFINITION
c               --------------------------------
c
c       read(9,1000) label
 1000 format(a80)
c
c       imod = 0 (E and Theta distribtution)
c              1 (Calculates only total yields of evaporation residues)
c              2 (Event by event)
c              imod+10  (Daphne event-by-event output)
c
c       jone = 0 (Fusion input)
c            = 1 (Two-body input)
c
c       read(9,*) imod, jone
      imod = 0
      jone = 1
      read(9,1000) label
      WRITE(21,'(A80)') LABEL
      read(9,*) ztarg, atarg, zproj, aproj, elab, binding, spin
      WRITE(21,'(4i9,2F10.2,f9.0)') ztarg,atarg,zproj,aproj,elab,
     &     binding,spin
c
c               READ NUMBER OF EVENTS
c               ---------------------
c
      read(9,1000) label
      read(9,*) numevt
      read(9,1000) label
c
c               READ CHANNEL DEFINITION CARDS
c               -----------------------------
c
      icard     = 0
      if( jone .eq. 1 ) then
        sigtot  = 0
 100    icard = icard + 1
 95     read(9,*,end=101,err=101) pro(icard), qgg(icard), qmm(icard),
     &       siq(icard), xj(icard),     raa(icard), rbb(icard)
        if( pro(icard) .gt. 0 .and. pro(icard).lt.0.1 ) then
          goto 95
        endif
        sxj(icard)  = xj(icard)*0.085
        ethe(icard) = 1
        qjma(icard) = qmm(icard)
        sigtot  = sigtot + pro(icard)
        if (pro(icard) .ne. 0) goto 100
 101    icard = icard - 1
      endif

CSMS Added explicit file name for unit 110
      open(unit=110,file='fislilita.inp',status='new')

c
c                       CARD 1
c                       ------
c
      card1_more        = 0     !flags start of calculation
      card1_itime       = 27000 !print output after itime
      card1_iprint      = 1     !detailed output each event
      card1_nrep        = 1     !repeat kinematics calculation
      card1_massopt     = 1     !0/energy, 1/velocity
      card1_massmin     = 5     !minimum mass for velocity option
      if( jone .ne. 1) card1_massmin = 26
      write(110,1) card1_more, card1_itime, card1_iprint, card1_nrep,
     &     card1_massopt, card1_massmin
 1    format(6i5)
c
c                       CARD 2
c                       ------
c
      card2_imod        = imod  !=1/event by event
      card2_jone        = jone  !=1,two-body input/otherwise fusion
      card2_ipt = 78            !maximum number of protons in input tab.
      ipt               = card2_ipt
      card2_inu = 11            !max. num. of isotopes for given z
      card2_ien = 120           !determines energy,velocity bin size
      card2_iang        = 2     !ang. dist. stored every iang deg.
      card2_icut0       = 2     !T cutoff parameter
      card2_ionly       = 0     !=0,Monte Carlo  1,primary distribution
      write(110,2) card2_imod, card2_jone, card2_ipt, card2_inu, card2_ien,
     &     card2_iang, card2_icut0, card2_ionly
 2    format(8i8)
c
c                       CARD 3
c                       ------
c
      do i = 1, card2_ipt
        card3_imax(i) = 26      !max lab angle
      enddo
      write(110,3) (card3_imax(i),i=1,card2_ipt)
 3    format(20i4)
c
c                       CARD 4
c                       ------
      card4_nevt        = numevt !number of events for all the residues
                                !Note that this is twice the number
                                !  of compound nucleus decays.
      card4_maxa        = 80    !max A of input table
      card4_maxz        = 80    !max Z of input table
      card4_minz        = 2     !min Z
      card4_null        = 1     !
      card4_zmax        = 80    !max Z for calculation  
      card4_lun = 12            !logical unit for event-by-event output
      card4_lmax1       = 14    !max l - 1 for n
      card4_lmax2       = 14    !max l - 1 for p
      card4_lmax3       = 23    !max l - 1 for alphas
      write(110,4) card4_nevt, card4_maxa,
     &     card4_maxz, card4_minz, card4_null,
     &     card4_zmax, card4_lun, card4_lmax1,
     &     card4_lmax2, card4_lmax3
 4    format(10i8)
c
c                       CARD 5
c                       ------
c
      card5_proja       = aproj !projectile A
      card5_targa       = atarg !target A
      card5_cna = aproj+atarg   !CN mass
      card5_targz       = ztarg !target Z
      card5_projz       = zproj !projectile Z
      card5_elab        = elab  !lab energy
      card5_emg = -0.6          !v or E bin scale factor
      write(110,5) card5_proja, card5_targa, card5_cna, card5_targz,
     &     card5_projz, card5_elab, card5_emg
 5    format(8f10.2)
c
c                       CARD 6
c                       ------
c
      card6_almas       = 0.125 !level density option
      write(110,6) card6_almas
 6    format(f10.2)
c
c                       CARD 7
c                       ------
c
      do i = 1,ipt
        z = i + card4_maxz - ipt
        a = 2*z+6
c         a = 2*z+7
        if(a .gt. card4_maxa) a = card4_maxa
        if(a .lt. card2_inu ) a = card2_inu
        card7_ineu(i) = i + card4_maxa - ipt - a
      enddo
      write(110,7) (card7_ineu(i),i=1,card2_ipt)
 7    format(26i3)
c
c                       CARD 8
c                       ------
c
      card8_ilki        = 1     !light particle energies stored
      card8_ielki       = 30    !number of energy bins
      card8_ialki       = 6     !number of angle bins
      card8_ishif       = 0     
      card8_ianfi       = 0
      write(110,8) card8_ilki, card8_ielki, card8_ialki, card8_ishif,
     &     card8_ianfi
 8    format(10i8)
c
c                       CARDS 9 AND 10
c                       --------------
c               wait for card 11 ram parameter
c
c
c                       CARD 11
c                       -------
c
      card11_nchan      = icard !number of two body cards following
      card11_icomnu     = 0     !two body       
      if( jone .ne. 1 ) card11_icomnu  = 1
      card11_ibar       = 1     !sharp cutoff
      card11_jmax2      = 2*spin !2 times CN spin
      card11_icla       = 0     !QM calculation
      card11_jkk        = 30    !energy sharing control param.
      if( jone .NE. 1 ) card11_jkk = 0
      card11_mc = atarg+aproj   !mass of CN
      card11_izc        = ztarg+zproj !charge of CN
      ecm               = elab*atarg/(atarg+aproj)
      mu                = float(atarg*aproj)/(atarg+aproj)
      lambda2           = 197.3**2/(2*931.504*mu*ecm)
      if( jone .ne. 1 ) sigtot = 31.415 * lambda2*(spin+1)**2
      card11_sigtot     = sigtot !total cross for process
      card11_ex = binding+ecm   !CN excitation energy
      card11_ram        = 0.9   !fluctuating to aligned ratio


      write(message2,88) card5_emg,card11_ram, card2_ien
 88   format(' emg = ',f5.2,'      ram = ',f5.2,'     ien = ',i5)
      write(110,9) message1
      write(110,9) message2
 9    format(a80)


      write(110,11) card11_nchan, card11_icomnu, card11_ibar,
     &     card11_jmax2, card11_icla, card11_jkk, card11_mc,
     &     card11_izc, card11_sigtot, card11_ex, card11_ram
 11   format(8i5,3f10.2)
c
c                       TWO-BODY CHANNEL SET
c                       --------------------
c
      if( icard .gt. 0 ) then
        do i = 1,icard
          write(110,12) pro(i),qgg(i),qmm(i),siq(i),xj(i),sxj(i),
     &         ethe(i),raa(i),  rbb(i), qjma(i)
 12       format(10f8.2)
        enddo
      endif
c
c                       FINAL CARD
c                       ----------
c
      write(110,1) last
      close(9)
      close(110)
      return
      end


c$$$      function tke(ang,m,v3,cm1,cm2,cnm,e1,v3cm,open)
c$$$C SMS
c$$$C open was declared implictly as real here, but it's always passed as logical
c$$$C so I declare it as logical, now I need a new real variable for the
c$$$C calculation - openr, and I need to decide what value of openr corresponds
c$$$C to true or false. I'm going to decide open=openr.gt.0
c$$$      logical open
c$$$      real openr
c$$$      logical foo
c$$$
c$$$      open=.false.
c$$$      a3 = m
c$$$      rang = ang*0.01745
c$$$      v1 = sqrt(2.0*e1/(931.504*cm1))
c$$$      vcm = cm1*v1/cnm
c$$$      v3cm2= vcm**2+v3**2-2*vcm*v3*cos(rang)
c$$$      tke = 0
c$$$      if( v1.lt.0.or.vcm.lt.0.or.v3cm2.lt.0) then
c$$$        write(6,*) 'ang,m,v3,cm1,cm2,cnm,e1=',ang,m,v3,cm1,cm2,cnm,e1
c$$$        write(6,*) 'v1,vcm,v3cm2=',v1,vcm,v3cm2
c$$$      endif
c$$$      if(v3cm2.le.0) return
c$$$      v3cm = sqrt(v3cm2)
c$$$c 
c$$$c       check if forward or backward c.m. solution
c$$$c       
c$$$      openr = v3cm2+v3*v3-vcm**2
c$$$      open=(openr.gt.0)
c$$$c       if( openr .lt. 0 ) then
c$$$c          tke = 0
c$$$c          goto 10
c$$$c       endif
c$$$      v4cm = a3*v3cm/(cnm-a3)
c$$$      tke = 0.5*931.504*(a3*v3cm2+(cnm-a3)*v4cm**2)
c$$$ 10   continue
c$$$c       if( m .eq. 40 ) then
c$$$c       write(9,'(2f5.1,6f10.4)') ang,a3,v3,v3cm,v1,vcm,openr,tke
c$$$c       endif
c$$$      return
c$$$      end       

      function tke(ang,m,v3,cm1,cm2,cnm,e1,v3cm,forward)
      logical forward
      a3 = m
      rang = ang*0.01745
      v1 = sqrt(2.0*e1/(931.504*cm1))
      vcm = cm1*v1/cnm
      v3cm2= vcm**2+v3**2-2*vcm*v3*cos(rang)
      tke = 0
      if( v1.lt.0.or.vcm.lt.0.or.v3cm2.lt.0) then
        write(6,*) 'ang,m,v3,cm1,cm2,cnm,e1=',ang,m,v3,cm1,cm2,cnm,e1
        write(6,*) 'v1,vcm,v3cm2=',v1,vcm,v3cm2
      endif
      if(v3cm2.le.0) return
      v3cm = sqrt(v3cm2)
c 
c     check if forward or backward c.m. solution
c 
      open = v3cm2+v3*v3-vcm**2
      
      forward = .false.
      if( open .gt. 0 ) forward = .true.
      v4cm = a3*v3cm/(cnm-a3)
      tke = 0.5*931.504*(a3*v3cm2+(cnm-a3)*v4cm**2)
 10   continue
c     if( m .eq. 40 ) then
c       write(9,'(2f5.1,6f10.4)') ang,a3,v3,v3cm,v1,vcm,open,tke
c     endif
      return
      end	
      
c$$$      subroutine tkeout(sigfrag,flat)
c$$$      integer tke_pre_f(240,20,6,26),tke_post_f(240,20,6,26)
c$$$      integer tke_pre_b(240,20,6,26),tke_post_b(240,20,6,26)
c$$$      common/tkec/tke_pre_f,tke_post_f,
c$$$     &     tke_pre_b,tke_post_b,icnt_pre, icnt_post,
c$$$     &     icnt_pre_f,icnt_post_f,icnt_pre_b,icnt_post_b
c$$$      integer tkecnt_pre_f,tkecnt_post_f(26)
c$$$      integer tkecnt_pre_b,tkecnt_post_b(26)
c$$$      integer ang_post(26)
c$$$      logical seen_f, seen_b, forward
c$$$      real ftke_pre_f,ftke_post_f(26),ftke_pre_b,ftke_post_b(26),
c$$$     &     dsig_post_f(26),dsig_post_b(26),
c$$$     &     dsigomlab_f(26), dsigomcm_f(26), dsigthcm_f(26),
c$$$     &     dsigomlab_b(26), dsigomcm_b(26), dsigthcm_b(26),
c$$$     &     theta_cm_b(26),theta_cm_f(26)
c$$$      real sigzpre_f(20),sigzpost_f(20)
c$$$      real sigapre_f(40),sigapost_f(40)
c$$$      real sigzpre_b(20),sigzpost_b(20)
c$$$      real sigapre_b(40),sigapost_b(40)
c$$$      real elab, edif(26)
c$$$      integer ztarg,atarg,zproj,aproj
c$$$      common/entrance/elab,ztarg,atarg,zproj,aproj
c$$$
c$$$      real degrad
c$$$      parameter (degrad = 57.29578)
c$$$
c$$$      renorm = 2*sigfrag/icnt_pre_f
c$$$      write(9,*) '    pre     post   pre_f   post_f   pre_b    post_b'  
c$$$      write(9,'(6i8)') icnt_pre,icnt_post,icnt_pre_f,icnt_post_f,
c$$$     &     icnt_pre_b,icnt_post_b
c$$$      sigcpre_f=0
c$$$      sigcpost_f=0
c$$$      sigcpre_b=0
c$$$      sigcpost_b=0
c$$$      write(9,100)
c$$$ 100  FORMAT(
c$$$     &     '  Z  A SIG  SIG <TKE> ANG COUNT  SG/TH  SG/OM <TKE>',
c$$$     &     ' ANG    SG/TH  SG/OM  EDIF'/
c$$$     &     '       PRE  AFT  PRE  LAB        (LAB)  (LAB)  AFT ',
c$$$     &     ' (CM)   (CM)   (CM)  (MEV)'/)
c$$$      mcnt_pre_f = 0
c$$$      mcnt_post_f = 0
c$$$      mcnt_pre_b = 0
c$$$      mcnt_post_b = 0
c$$$      do iz = 1,20
c$$$        do iax = 1,6
c$$$          ia = 2*iz-3+iax
c$$$          ncnt_post_f = 0
c$$$          tkecnt_pre_f = 0
c$$$          ftke_pre_f = 0
c$$$          ncnt_post_b = 0
c$$$          tkecnt_pre_b = 0
c$$$          ftke_pre_b = 0
c$$$          do iang = 1,26
c$$$            tkecnt_post_f(iang) = 0
c$$$            ftke_post_f(iang) = 0
c$$$            tkecnt_post_b(iang) = 0
c$$$            ftke_post_b(iang) = 0
c$$$            dsig_post_f(iang) = 0
c$$$            dsigomlab_f(iang) = 0
c$$$            dsigomcm_f(iang) = 0
c$$$            dsigthcm_f(iang) = 0
c$$$            dsig_post_b(iang) = 0
c$$$            dsigomlab_b(iang) = 0
c$$$            dsigomcm_b(iang) = 0
c$$$            dsigthcm_b(iang) = 0
c$$$            theta_cm_f(iang) = 0
c$$$            theta_cm_b(iang) = 0
c$$$          enddo
c$$$          seen_f = .false.
c$$$          seen_b = .false.
c$$$          iangmax = 0
c$$$          do iang = 1,26
c$$$            do itke = 1,240
c$$$              tkecnt_pre_f = tkecnt_pre_f+tke_pre_f(itke,iz,iax,iang)
c$$$              tkecnt_pre_b = tkecnt_pre_b+tke_pre_b(itke,iz,iax,iang)
c$$$              tkecnt_post_f(iang) =
c$$$     &             tkecnt_post_f(iang)+tke_post_f(itke,iz,iax,iang)
c$$$              tkecnt_post_b(iang) =
c$$$     &             tkecnt_post_b(iang)+tke_post_b(itke,iz,iax,iang)
c$$$              ncnt_post_f = ncnt_post_f+tke_post_f(itke,iz,iax,iang)
c$$$              ncnt_post_b = ncnt_post_b+tke_post_b(itke,iz,iax,iang)
c$$$              ftke_pre_f = ftke_pre_f
c$$$     &             + (itke/4.-0.125)*tke_pre_f(itke,iz,iax,iang)
c$$$              ftke_pre_b = ftke_pre_b
c$$$     &             + (itke/4.-0.125)*tke_pre_b(itke,iz,iax,iang)
c$$$              ftke_post_f(iang) = ftke_post_f(iang)
c$$$     &             + (itke/4.-0.125)*tke_post_f(itke,iz,iax,iang)
c$$$              ftke_post_b(iang) = ftke_post_b(iang)
c$$$     &             + (itke/4.-0.125)*tke_post_b(itke,iz,iax,iang)
c$$$            enddo
c$$$            if(tkecnt_post_f(iang).gt.0) then
c$$$              ftke_post_f(iang)=ftke_post_f(iang)/tkecnt_post_f(iang)
c$$$              dsig_post_f(iang) = tkecnt_post_f(iang)*renorm/0.034906
c$$$CSMS Was:
c$$$              seen = .true.
c$$$CSMS Should be              seen_f = .true.
c$$$            endif
c$$$            if(tkecnt_post_b(iang).gt.0) then
c$$$              ftke_post_b(iang)=ftke_post_b(iang)/tkecnt_post_b(iang)
c$$$              dsig_post_b(iang) = tkecnt_post_b(iang)*renorm/0.034906
c$$$CSMS Was:
c$$$              seen = .true.
c$$$CSMS should be              seen_b = .true.
c$$$            endif
c$$$            ang_post(iang) = 2*iang-1
c$$$            if( dsig_post_f(iang) .gt. 0 ) iangmax = iang
c$$$          enddo
c$$$          if(tkecnt_pre_f.gt.0) then
c$$$            ftke_pre_f=ftke_pre_f/tkecnt_pre_f
c$$$            seen_f = .true.
c$$$          endif
c$$$          if(tkecnt_pre_b.gt.0) then
c$$$            ftke_pre_b=ftke_pre_b/tkecnt_pre_b
c$$$            seen_b = .true.
c$$$          endif
c$$$          if( seen_f ) then
c$$$            sigpre_f=tkecnt_pre_f*renorm
c$$$            sigpost_f=ncnt_post_f*renorm
c$$$            sigcpre_f=sigcpre_f+sigpre_f
c$$$            sigcpost_f=sigcpost_f+sigpost_f
c$$$            sigpre_b=tkecnt_pre_b*renorm
c$$$            sigpost_b=ncnt_post_b*renorm
c$$$            sigcpre_b=sigcpre_b+sigpre_b
c$$$            sigcpost_b=sigcpost_b+sigpost_b
c$$$            a1 = aproj
c$$$            a2 = atarg
c$$$            a3 = ia
c$$$            a4 = aproj+atarg-ia
c$$$            ecm = elab*atarg/float(atarg+aproj)
c$$$            do iang = 1,26
c$$$              q_f = ftke_post_f(iang)-ecm
c$$$              theta_lab = ang_post(iang)
c$$$              forward = .true.
c$$$              call labtocm(theta_lab,elab,a1,a2,a3,a4,q_f,forward,
c$$$     &             theta_f,v_lab_f,fjac_f)
c$$$              edif(iang) = 0
c$$$              theta_cm_f(iang) = 0
c$$$              theta_cm_b(iang) = 0
c$$$              dsigomlab_f(iang) = 0
c$$$              dsigomcm_f(iang) = 0
c$$$              if( theta_f .gt. 0 ) then
c$$$                e_f = 0.5*931.504*a3*v_lab_f**2
c$$$                theta_cm_f(iang) = theta_f
c$$$                q_b = ftke_post_b(iang)-ecm
c$$$                forward = .false.
c$$$                call labtocm(theta_lab,elab,a1,a2,a3,a4,q_b,forward,
c$$$     &               theta_b,v_lab_b,fjac_b)
c$$$                theta_cm_b(iang) = theta_b
c$$$                e_b = 0.5*931.504*a3*v_lab_b**2
c$$$                edif(iang) = e_f - e_b
c$$$              endif
c$$$              if( theta_f .gt. 0 .and. fjac_f .gt. 0 ) then
c$$$                dsigomlab_f(iang)=
c$$$     &               dsig_post_f(iang)/(2*3.1415926*sin(theta_lab/degrad))
c$$$                dsigomcm_f(iang) = dsigomlab_f(iang)/fjac_f
c$$$                dsigthcm_f(iang) =
c$$$     &               dsigomcm_f(iang)*2*3.141592*sin(theta_f/degrad)
c$$$                if( dsigomlab_f(iang).gt.9999.99) dsigomlab_f(iang) = -1
c$$$                if( dsigomcm_f(iang).gt.9999.99) dsigomcm_f(iang) = -1
c$$$              endif
c$$$            enddo
c$$$            if( sigpre_f .gt. .1 ) then
c$$$              write(9,'(2i3,3f5.1,i4,I6,2f7.2,f6.1,f6.1,2f7.2,f7.1/
c$$$     &             26(21x,i4,I6,2f7.2,f6.1,f6.1,2f7.2,f7.1/))')
c$$$     &             iz,ia,sigpre_f,sigpost_f,ftke_pre_f,
c$$$     &             (ang_post(iang),tkecnt_post_f(iang),dsig_post_f(iang),
c$$$     &             dsigomlab_f(iang),ftke_post_f(iang),theta_cm_f(iang),
c$$$     &             dsigthcm_f(iang),dsigomcm_f(iang),edif(iang),
c$$$     &             iang=1,iangmax)
c$$$            endif
c$$$            if( iz.ge.1.and.iz.le.20.and.ia.ge.iz.and.ia.le.40) then
c$$$              if( .not. (iz.eq.4.and.ia.eq.8)) then
c$$$                sigzpre_f(iz) = sigzpre_f(iz) + sigpre_f
c$$$                sigzpost_f(iz) = sigzpost_f(iz) + sigpost_f
c$$$                sigapre_f(ia) = sigapre_f(ia) + sigpre_f
c$$$                sigapost_f(ia) = sigapost_f(ia) + sigpost_f
c$$$                sigzpre_b(iz) = sigzpre_b(iz) + sigpre_b
c$$$                sigzpost_b(iz) = sigzpost_b(iz) + sigpost_b
c$$$                sigapre_b(ia) = sigapre_b(ia) + sigpre_b
c$$$                sigapost_b(ia) = sigapost_b(ia) + sigpost_b
c$$$              endif
c$$$            endif
c$$$          endif
c$$$          mcnt_pre_f = mcnt_pre_f + tkecnt_pre_f
c$$$          mcnt_post_f = mcnt_post_f + ncnt_post_f
c$$$        enddo
c$$$      enddo
c$$$      write(9,*) 'sig frag, nev, renorm:',sigfrag,flat,renorm
c$$$      write(9,*) 'pre,post counts:', mcnt_pre_f,mcnt_post_f
c$$$      write(9,*) 'sigcpre,sigcpost=',sigcpre_f,sigcpost_f
c$$$      write(9,*) '   z     pre    post'
c$$$      write(21,*) '   z     pre    post'
c$$$      do iz = 1,20
c$$$        if( sigzpre_f(iz).ne.0.or.sigzpost_f(iz).ne.0) then
c$$$          write(9,'(i4,2f8.2)') iz,sigzpre_f(iz),sigzpost_f(iz)
c$$$          write(21,'(i4,2f8.2)') iz,sigzpre_f(iz),sigzpost_f(iz)
c$$$        endif
c$$$      enddo
c$$$      stop
c$$$      end

      subroutine tkeout(sigfrag,flat)
      integer tke_pre_f(240,20,6,26),tke_post_f(240,20,6,26)
      integer tke_pre_b(240,20,6,26),tke_post_b(240,20,6,26)
      common/tkec/tke_pre_f,tke_post_f,
     &     tke_pre_b,tke_post_b,icnt_pre, icnt_post,
     &     icnt_pre_f,icnt_post_f,icnt_pre_b,icnt_post_b
      integer tkecnt_pre_f,tkecnt_post_f(26)
      integer tkecnt_pre_b,tkecnt_post_b(26)
      integer ang_post(26)
      logical seen_f, seen_b, forward
      real ftke_pre_f,ftke_post_f(26),ftke_pre_b,ftke_post_b(26),
     &     dsig_post_f(26),dsig_post_b(26),
     &     dsigomlab_f(26), dsigomcm_f(26), dsigthcm_f(26),
     &     dsigomlab_b(26), dsigomcm_b(26), dsigthcm_b(26),
     &     theta_cm_b(26),theta_cm_f(26)
      real sigzpre_f(20),sigzpost_f(20)
      real sigapre_f(40),sigapost_f(40)
      real sigzpre_b(20),sigzpost_b(20)
      real sigapre_b(40),sigapost_b(40)
      real sigpre, sigpost
      real elab, edif(26)
      integer ztarg,atarg,zproj,aproj
      common/entrance/elab,ztarg,atarg,zproj,aproj

      real degrad
      parameter (degrad = 57.29578)

      renorm = sigfrag/flat
      write(9,*) '    pre     post   pre_f   post_f   pre_b    post_b'	
      write(9,'(6i8)') icnt_pre,icnt_post,icnt_pre_f,icnt_post_f,
     &     icnt_pre_b,icnt_post_b
      sigcpre_f=0
      sigcpost_f=0
      sigcpre_b=0
      sigcpost_b=0
      sigpre = 0
      sigpost = 0
      write(9,100)
 100  FORMAT(
     &     '  Z  A SIG  SIG <TKE> ANG COUNT  SG/TH  SG/OM <TKE>',
     &     ' ANG    SG/TH  SG/OM  EDIF'/
     &     '       PRE  AFT  PRE  LAB        (LAB)  (LAB)  AFT ',
     &     ' (CM)   (CM)   (CM)  (MEV)'/)
      mcnt_pre_f = 0
      mcnt_post_f = 0
      mcnt_pre_b = 0
      mcnt_post_b = 0
      do iz = 1,20
	do iax = 1,6
	  ia = 2*iz-3+iax
	  ncnt_post_f = 0
	  tkecnt_pre_f = 0
	  ftke_pre_f = 0
	  ncnt_post_b = 0
	  tkecnt_pre_b = 0
	  ftke_pre_b = 0
 	  do iang = 1,26
            tkecnt_post_f(iang) = 0
            ftke_post_f(iang) = 0
            tkecnt_post_b(iang) = 0
            ftke_post_b(iang) = 0
            dsig_post_f(iang) = 0
            dsigomlab_f(iang) = 0
            dsigomcm_f(iang) = 0
            dsigthcm_f(iang) = 0
            dsig_post_b(iang) = 0
            dsigomlab_b(iang) = 0
            dsigomcm_b(iang) = 0
            dsigthcm_b(iang) = 0
            theta_cm_f(iang) = 0
            theta_cm_b(iang) = 0
	  enddo
	  seen_f = .false.
	  seen_b = .false.
	  iangmax = 0
	  do iang = 1,26
            do itke = 1,240
              tkecnt_pre_f = tkecnt_pre_f+tke_pre_f(itke,iz,iax,iang)
              tkecnt_pre_b = tkecnt_pre_b+tke_pre_b(itke,iz,iax,iang)
              tkecnt_post_f(iang) = 
     &             tkecnt_post_f(iang)+tke_post_f(itke,iz,iax,iang)
              tkecnt_post_b(iang) = 
     &             tkecnt_post_b(iang)+tke_post_b(itke,iz,iax,iang)
              ncnt_post_f = ncnt_post_f+tke_post_f(itke,iz,iax,iang)
              ncnt_post_b = ncnt_post_b+tke_post_b(itke,iz,iax,iang)
              ftke_pre_f = ftke_pre_f 
     &             + (itke/4.-0.125)*tke_pre_f(itke,iz,iax,iang) 
              ftke_pre_b = ftke_pre_b 
     &             + (itke/4.-0.125)*tke_pre_b(itke,iz,iax,iang) 
              ftke_post_f(iang) = ftke_post_f(iang) 
     &             + (itke/4.-0.125)*tke_post_f(itke,iz,iax,iang) 
              ftke_post_b(iang) = ftke_post_b(iang) 
     &             + (itke/4.-0.125)*tke_post_b(itke,iz,iax,iang) 
            enddo
            if(tkecnt_post_f(iang).gt.0) then
              ftke_post_f(iang)=ftke_post_f(iang)/tkecnt_post_f(iang)
              dsig_post_f(iang) = tkecnt_post_f(iang)*renorm/0.034906
              seen_f = .true.
            endif
            if(tkecnt_post_b(iang).gt.0) then
              ftke_post_b(iang)=ftke_post_b(iang)/tkecnt_post_b(iang)
              dsig_post_b(iang) = tkecnt_post_b(iang)*renorm/0.034906
              seen_b = .true.
            endif
            ang_post(iang) = 2*iang-1
            if( dsig_post_f(iang) .gt. 0 ) iangmax = iang 
	  enddo
	  if(tkecnt_pre_f.gt.0) then
            ftke_pre_f=ftke_pre_f/tkecnt_pre_f
            seen_f = .true.
	  endif
	  if(tkecnt_pre_b.gt.0) then
            ftke_pre_b=ftke_pre_b/tkecnt_pre_b
            seen_b = .true.
	  endif
	  if( seen_f ) then
            sigpre_f=tkecnt_pre_f*renorm
            sigpost_f=ncnt_post_f*renorm
            sigcpre_f=sigcpre_f+sigpre_f
            sigcpost_f=sigcpost_f+sigpost_f
            sigpre_b=tkecnt_pre_b*renorm
            sigpost_b=ncnt_post_b*renorm
            sigcpre_b=sigcpre_b+sigpre_b
            sigcpost_b=sigcpost_b+sigpost_b
            sigpre = sigpre_f + sigpre_b
            sigpost = sigpost_f + sigpost_b
            a1 = aproj
            a2 = atarg
            a3 = ia
            a4 = aproj+atarg-ia
            ecm = elab*atarg/float(atarg+aproj)
            do iang = 1,26
              q_f = ftke_post_f(iang)-ecm
              theta_lab = ang_post(iang)
              forward = .true.
              call labtocm(theta_lab,elab,a1,a2,a3,a4,q_f,forward,
     &             theta_f,v_lab_f,fjac_f)
              edif(iang) = 0
              theta_cm_f(iang) = 0
              theta_cm_b(iang) = 0
              dsigomlab_f(iang) = 0
              dsigomcm_f(iang) = 0
              if( theta_f .gt. 0 ) then
                e_f = 0.5*931.504*a3*v_lab_f**2 
                theta_cm_f(iang) = theta_f
                q_b = ftke_post_b(iang)-ecm
                forward = .false.
                call labtocm(theta_lab,elab,a1,a2,a3,a4,q_b,forward,
     &               theta_b,v_lab_b,fjac_b)
                theta_cm_b(iang) = theta_b
                e_b = 0.5*931.504*a3*v_lab_b**2
                edif(iang) = e_f - e_b
              endif

              if( theta_f .gt. 0 .and. fjac_f .gt. 0 ) then
                dsigomlab_f(iang)=
     &               dsig_post_f(iang)/(2*3.1415926*sin(theta_lab/degrad))
                dsigomcm_f(iang) = dsigomlab_f(iang)/fjac_f
                dsigthcm_f(iang) = 
     &               dsigomcm_f(iang)*2*3.141592*sin(theta_f/degrad)
                if( dsigomlab_f(iang).gt.9999.99) dsigomlab_f(iang) = -1
                if( dsigomcm_f(iang).gt.9999.99) dsigomcm_f(iang) = -1
              endif

              if( theta_b .gt. 0 .and. fjac_b .gt. 0 ) then
                dsigomlab_b(iang)=
     &               dsig_post_b(iang)/(2*3.1415926*sin(theta_lab/degrad))
                dsigomcm_b(iang) = dsigomlab_b(iang)/fjac_b
                dsigthcm_b(iang) = 
     &               dsigomcm_b(iang)*2*3.141592*sin(theta_b/degrad)
                if( dsigomlab_b(iang).gt.9999.99) dsigomlab_b(iang) = -1
                if( dsigomcm_b(iang).gt.9999.99) dsigomcm_b(iang) = -1
              endif
            enddo
            if( sigpre_f .gt. .1 ) then
              write(9,'(      2i3,3f5.1,i4,I6,2f7.2,f6.1,f6.1,2f7.2,f7.1/
     &             1x,1hb,14x,f5.1,i4,i6,2f7.2,f6.1,f6.1,2f7.2/
     &             26(        21x,i4,I6,2f7.2,f6.1,f6.1,2f7.2,f7.1/
     &             1x,1hb,19x,i4,i6,2f7.2,f6.1,f6.1,2f7.2/))') 
     &             iz,ia,sigpre,sigpost,ftke_pre_f,
     &             ang_post(1),tkecnt_post_f(1),dsig_post_f(1),
     &             dsigomlab_f(1),ftke_post_f(1),theta_cm_f(1),
     &             dsigthcm_f(1),dsigomcm_f(1),edif(1),
     &             ftke_pre_b,
     &             ang_post(1),tkecnt_post_b(1),dsig_post_b(1),
     &             dsigomlab_b(1),ftke_post_b(1),theta_cm_b(1),
     &             dsigthcm_b(1),dsigomcm_b(1),
     &             (ang_post(iang),tkecnt_post_f(iang),dsig_post_f(iang),
     &             dsigomlab_f(iang),ftke_post_f(iang),theta_cm_f(iang),
     &             dsigthcm_f(iang),dsigomcm_f(iang),edif(iang),
     &             ang_post(iang),tkecnt_post_b(iang),dsig_post_b(iang),
     &             dsigomlab_b(iang),ftke_post_b(iang),theta_cm_b(iang),
     &             dsigthcm_b(iang),dsigomcm_b(iang),
     &             iang=2,iangmax)
            endif
            if( iz.ge.1.and.iz.le.20.and.ia.ge.iz.and.ia.le.40) then
              if( .not. (iz.eq.4.and.ia.eq.8)) then
                sigzpre_f(iz) = sigzpre_f(iz) + sigpre_f
                sigzpost_f(iz) = sigzpost_f(iz) + sigpost_f
                sigapre_f(ia) = sigapre_f(ia) + sigpre_f
                sigapost_f(ia) = sigapost_f(ia) + sigpost_f
                sigzpre_b(iz) = sigzpre_b(iz) + sigpre_b
                sigzpost_b(iz) = sigzpost_b(iz) + sigpost_b
                sigapre_b(ia) = sigapre_b(ia) + sigpre_b
                sigapost_b(ia) = sigapost_b(ia) + sigpost_b
              endif
            endif
	  endif
	  mcnt_pre_f = mcnt_pre_f + tkecnt_pre_f
	  mcnt_post_f = mcnt_post_f + ncnt_post_f
	enddo
      enddo
      write(9,*) 'sig frag, nev, renorm:',sigfrag,flat,renorm
      write(9,*) 'pre,post counts:', mcnt_pre_f,mcnt_post_f
      write(9,*) 'sigcpre,sigcpost=',sigcpre_f,sigcpost_f
      write(9,*) '   z     pre    post'
      write(21,*) '   z     pre    post'
      do iz = 1,20
        if( sigzpre_f(iz).ne.0.or.sigzpost_f(iz).ne.0) then
          write(9,'(i4,2f8.2)') iz,sigzpre_f(iz),sigzpost_f(iz)
          write(21,'(i4,2f8.2)') iz,sigzpre_f(iz),sigzpost_f(iz)
        endif
      enddo
      stop
      end


      subroutine labtocm(theta_lab,elab,a1,a2,a3,a4,q,forward,
     &     theta,v_lab,fjac)
      real*4 theta,elab,a1,a2,a3,a4,q,theta_lab,v_lab,v1,vcm,ecmin,ecmout
      real degrad
      parameter (degrad = 57.29578)
      logical reccalc,forward
      theta = 0
      v_lab = 0
      thlab = theta_lab/degrad
      v1  = sqrt(2.0 * elab /(931.504*a1))
      vcm = a1 * v1/(a1+a2)
      ecmin = elab * a2/(a1+a2)
      ecmout = ecmin + q
      if( ecmout .le. 0 ) return
      tmp = 1 + a3/a4
      v3 = sqrt(2*ecmout/(931.504*a3*tmp))
      if( v3 .gt. vcm ) then
        thmax = 6.283185
      else
        thmax = asin(v3/vcm)
      endif     
      if( thlab .gt. thmax ) then
        theta = -degrad*thmax
        return
      endif
      arg = v3**2-(vcm*sin(thlab))**2
      theta_rec = 0
      if( arg.le.0 ) return
      
      if( forward ) then
        v_lab = vcm*cos(thlab)+sqrt(arg)
      else
        v_lab = vcm*cos(thlab)-sqrt(arg)
      endif
      arg = v_lab*sin(thlab)/v3
      if( abs(arg).le.1 ) then
        theta = asin(arg)
      else
        theta = 0
        fjac = 0
      endif
      test = v_lab**2 - v3**2 - vcm**2
      if( test .lt. 0 ) theta = 3.1415926 - theta
c
c       now find jacobian
c
      thlab2 = thlab+0.001
      arg = v3**2-(vcm*sin(thlab2))**2
      fjac = 0
      if( arg.le.0 ) return
      if( forward ) then
        v_lab2 = vcm*cos(thlab2)+sqrt(arg)
      else
        v_lab2 = vcm*cos(thlab2)-sqrt(arg)
      endif
      arg = v_lab2*sin(thlab2)/v3
      if( abs(arg).le.1) then
        theta2 = asin(arg)
      else
        fjac = 0
        theta = 0
        return
      endif
      test = v_lab2**2 - v3**2 - vcm**2
      if( test .lt. 0 ) theta2 = 3.1415926 - theta2

      if( thlab .eq. 0 ) then
        fjac = (theta2-theta)/0.001
      else
        fjac = (theta2-theta)*sin(theta)/(0.001*sin(thlab))
      endif
      fjac = abs(fjac)
      theta = degrad*theta
      return
      end
