      subroutine init_vasym
      implicit real*8 (a-h,o-z)
      real*8 param(15),dparam(15)
      character*20  names(15), parmname(15)
      
      common/vasymc/param,dparam,names,nparam,mode
      common/potential/krappe_pot
      common/wigscale/wigscale
      real*8 mh,mn
      real*8 found(40,90)
      common/found/found
      logical krappe_pot
CSMS+
      integer err1

CSMS BEG
C These were undeclared and uninitialised on the VAX code so presumably they
C were double precision 0.0D0. I assume that, when read as logicals they
C became .false.
      logical full,pair
      data full/.false./,pair/.false./
CSMS END

      data parmname/
     &     'voff0','voff1','ba_0','ba_asym','s0',
     &     'sacn','wigscale',
     &     'fracgs',' ',' ',' ',
     &     ' ',' ',' ',' '/
      data mh/7.289034d0/,mn/8.071431d0/
      
C      OPEN(UNIT=66,FILE = 
CSMS    1  'MASSdir:MASSTAB.DAT',ACCESS='DIRECT',
C     &     'MASSTAB.DAT',ACCESS='DIRECT',
C     +     RECORDTYPE='FIXED',RECL = 168,TYPE='OLD',READONLY,
C     &     err=10)

      include 'functn.masstab'
      
      do iz1 = 2,40
        do ia1 = max(4,2*iz1-8),2*iz1+8
          call tables(ia1,iz1,em1,err1)
          if( err1 .eq. 0 ) then
            be1 = iz1*mh + (ia1-iz1)*mn - em1/1000
          else
            be1 = -ground(z1,a1,full,pair)
          endif
          found(iz1,ia1) = be1
        enddo
      enddo     
      krappe_pot = .true.
      if( krappe_pot ) then
        write(6,*) 'Krappe potential in use'
      else
        write(6,*) 'Proximity potential with Toke parameters used'
      endif
c       write(6,*) 'WARNING: fission barrier adjusted by 3.0 MeV'
c       write(6,*) 'WARNING: Wigner term turned off'
c       write(6,*) '   (search code for CFULL)'
C       write(6,*) 'WARNING: Wigner term set to 50% of normal'
C       write(6,*) '   (search code for wigscale)'
C       wigscale = 0.5
      WIGSCALE = 1.0
 4    open(unit=4,
CSMS     &      file='kunuc2$DKa0:[SANDERS.FISSION_PROGRAMS]parameters.dat',
     &     file='parameters.dat',
     &     status='old',err=10
     &     ,readonly)



      write(6,*) 'Reading from parameter file'
 5    read(4,*,end=6,err=6) nparam
      do i = 1,nparam
        read(4,'(1x,a20,2e20.5)') names(i),param(i),dparam(i)
      enddo
      goto 5
 6    continue
      write(6,*) 'Number of parameters read = ',nparam
      do i = 1,nparam
        write(6,'(1x,a20,f15.5)') names(i),param(i)
      enddo
      close(4)
      return
CSMS10  open(unit=4,file='fiscasc:parameters.dat',status='new')
 10   open(unit=4,file='parameters.dat',status='new')
      close(4)
      param(1) = 0
      param(2) = 0
      param(3) = 0.85
      param(4) = 0.2
      param(5) = 1.5
      param(6) = 0
      param(7) = 0
      param(8) = 0
      nparam = 8
      do i = 1,nparam
        names(i) = parmname(i)
      enddo

      dparam(1) = .0001
      dparam(2) = .00001
      dparam(3) = .0001
      dparam(4) = .0001
      dparam(5) = .00001
      dparam(6) = .0001
      dparam(7) = .00001
      dparam(8) = .0001
      dparam(9) = .0001
      dparam(10) = .0001
      mode = 2

      return
      end

      function vasym(z1,a1,z2,a2,j,jtran,tke)
      implicit real*8(a-h,o-z)
      integer z1,a1,z2,a2,mode
      logical full,pair
      real*8 jtran,j
      real*8 param(15),dparam(15)
      character*20  names(15), parmname(15)

      common/vasymc/param,dparam,names,nparam,mode



      common/lildeck/elab,excn,cl0,dafis,sigfus,siger,
     &     izt,iat,izp,iap,iafmax, izfindxoff,izfindxmax


      acn = a1 + a2
      zcn = z1 + z2
      if( acn .lt. 20 .or. zcn .lt. 10 ) then
        vasym = 100
        return
      endif
      
      a3 = min(a1,a2)
      if( a1 .eq. a3 ) then
        z3 = z1
      else
        z3 = z2
      endif
      spin = j
      if(zcn.ge.20) 
     &     call barfit( nint(zcn), nint(acn), 0.d0,bfis, segs, selmax)
c       if( spin .gt. selmax ) spin = selmax
      full = .true.
cFull   full = .false.
      pair = .false.
      vasym=fbar(full,pair,param,zcn,acn,spin,z3,a3,
     &     jtran,tke,vr,vc,vn,vrel,voff,zaoff,
     &     s,ba1)
      return
      end
      



      function functn(type,i,param)
      implicit real*8(a-h,o-z)
      real*8 zcn(700),acn(700),spin(700),a3(700),vb(700),tkecalc(700)
      logical full,pair
      common/arrays/zcn,acn,spin,a3,vb,tkecalc
      real*8 jtran
      common/shape_en/s,ba1,jtran,vr,vc,vn,vrel,voff,zaoff,tke
      real*8 param(15)
      z3 = zcn(i)*a3(i)/acn(i)
      full = .false.
      pair = .false.
      functn = fbar(full,pair,param,zcn(i),acn(i),spin(i),
     &     z3,a3(i),jtran,tke,vr,vc,
     &     vn,vrel,voff,zaoff,s,ba1)
      return
      end


      function fbar(fullp,pairp,param,zcn,acn,lin,z3,a3,jtran,tke,vrot,
     &     vcoul,vnuc,
     &     vrotrel,voff,zaoff,s,ba1)
      implicit real*8(a-h,o-z)
      real*8 param(15)
      real*8 ground
      external ground
      external tables
      real*8 jtran,l12,lin,moi1,moi2,moi12,moitot
      logical full,rotentry,pair,fullp,pairp
      real*8 found(40,90)
      common/found/found
      real*8 mh,mn
      common/fixdif/fixdif,qgs

      common/groundc/e_volume,coulomb_exchange,p_form_fact,e_pairing,
     &     e_wigner, ch_asym, a0_term, vfixed
      real*8 e_volume,coulomb_exchange,p_form_fact,e_pairing,
     &     e_wigner, ch_asym, a0_term, vfixed

      common/lildeck/elab,excn,cl0,dafis,sigfus,siger,
     &     izt,iat,izp,iap,iafmax, izfindxoff,izfindxmax

      parameter (hbar2 = 38927.29)
      parameter (amu   = 931.504)
      parameter (ayuka = 0.75)

      data mh/7.289034d0/,
     &     mn/8.071431d0/

      rotentry = .false.


      full = fullp
      pair = pairp
      spin = lin
      a1  = a3
      a2  = acn - a3
      facn = acn
      fzcn = zcn
      if( .not. full) then
        z1 = fzcn*a1/facn
      else
        z1 = z3
      endif

      z2 = fzcn-z1

      goto 100
      entry rotmoi( fa1,fa2, param, tke,vrot,
     &     vcoul,vnuc,
     &     vrotrel,voff,zaoff,s,ba1)
      full = .true.
      pair = .true.
      rotentry = .true.
      a1 = fa1
      a2 = fa2
      facn = a1 + a2
      fzcn = facn/2.
      z1 = fzcn*a1/facn
      z2 = fzcn-z1
      spin = 1

 100  continue

      r0 = 1.16
      asym = (facn-2*a1)/facn
      voff  = param(1) + param(2)*facn
      ba1   = param(3) + param(4)*asym  
      ba2   = param(3) + param(4)*asym 
      s     = param(5) + param(6)*facn 
      fracgs = param(8)
      fzaoff = 0

      vn = 0
      vr = 0
      vrel = 0

      if( a1 .gt. 1.0 .and. .not. rotentry ) then
        
        g1 = -ground(z1,a1,full,pair)
        g2 = -ground(z2,a2,full,pair)
        gcn = -ground(fzcn,facn,.false.,.false.)
        zaoffa = gcn - g1 - g2
      endif
      
      ia1 = a1
      iz1 = z1
      ia2 = a2
      iz2 = z2
      iacn = ia1+ia2
      izcn = iz1+iz2
      
      zaoff = found(izcn,iacn) - found(iz1,ia1) - found(iz2,ia2)
      zaoff = (1-fracgs)*zaoffa + fracgs*zaoff

      tke = barrier(s,r0,z1,a1,ba1,z2,a2,ba2,spin,vn,vc,vr,vrel,
     &     vrelin,l12,
     &     moi1,moi2,moi12) 

      if( rotentry) then
CSMS To get here we must have come through entry rotmoi rather than function
C    fbar.
        rotmoi = 2 * (moi1+moi2+moi12)/hbar2
        return
      endif

      jtran = spin - l12
      vcoul = vc
      vrot = vr
      vrotrel = vrel
      vnuc = vn

      vbar = vr + vc + vn + voff 
      tld = sqrt( (excn - vbar)*dafis/(a1+a2))


      fbar = vbar + zaoff
      return
      end

      function barrier(s,r0,z1,aa1,ba1,z2,aa2,ba2,spin,vn,vc,vr,vrel,
     &     vrelin,l12,
     &     moi1,moi2,moi12)
      implicit real*8 (a-z)
      common/potential/krappe_pot
      logical krappe_pot
      common/shape_quad/rquad,squad,r01quad,r02quad,beta1quad,beta2quad,
     &     a1quad,b1quad,a2quad,b2quad
CSMS    commone/shape_ellipse/rell,sell,r01ell,r02ell,ba1ell,ba2ell,
      common/shape_ellipse/rell,sell,r01ell,r02ell,ba1ell,ba2ell,
     &     a1ell,b1ell,a2ell,b2ell

      parameter (hbar2 = 38938.564)
      parameter (amu   =931.504)
      parameter (ayuka = 0.75)

ccccccccccccccccccccccccccccccc
c
c       Geometry Calcutations
c

      r01 = r0*aa1**.333333
      a1 = r01
      if( ba1 .gt. 0 ) a1 = r01*ba1**(-0.666666666)
      r02 = r0*aa2**.333333
      a2 = r02
      if( ba2 .gt. 0 ) a2 = r02*ba2**(-0.666666666)
      r12 = a1 + a2
      r = s + r12
      b1 = a1 * ba1
      b2 = a2 * ba2
      r01ell = r01
      r02ell = r02
      rell = r
      sell = s
      a1ell = a1
      a2ell = a2
      b1ell = b1
      b2ell = b2
      ba1ell = ba1
      ba2ell = ba2
c
c
c       Equivalent Quadrupoloid
c
      beta1quad = 3.170662*(1.-ba1)/(1+2*ba1)
      beta2quad = 3.170662*(1.-ba2)/(1+2*ba2)
      rquad = r
      renorm1 = 1.d0-1.432393d-3*beta1quad-7.581893e-2*beta1quad**2
      renorm2 = 1.d0-1.432393d-3*beta2quad-7.581893e-2*beta2quad**2
      r01quad = renorm1*r01
      r02quad = renorm2*r02
      a1quad = r01quad*(1+beta1quad*0.630783)
      a2quad = r02quad*(1+beta2quad*0.630783)
      squad = rquad - a1quad - a2quad
      b1quad = a1quad * ba1
      b2quad = a2quad * ba2
c       write(6,*) 
c       1'    r01    r02     a1     a2      s      r    sb1    sb2'
c       write(6,'(8f7.3)') r01ell,r02ell,a1ell,a2ell,sell,rell,ba1ell,ba2ell
c       write(6,'(8f7.3)') r01quad,r02quad,a2quad,a2quad,squad,
c       1       rquad,beta1quad,beta2quad
c
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      vn = 0
      vc = 0
      vr = 0
      
      if( aa1 .gt. 2) then
        if( krappe_pot ) then
          vn =    krappe(s,z1,aa1,r01,ba1,z2,aa2,r02,ba2)
        else
          vn = proximity(s,z1,aa1,r01,ba1,z2,aa2,r02,ba2)
        endif
      endif
      if( z1 .gt. 0 ) vc = coulomb(s,r0,z1,aa1,ba1,z2,aa2,ba2)
      l12 = 0
      facn = aa1 + aa2
      if( spin .gt. 0 ) then
        rdout = r
        xmu12=amu*aa1*aa2/facn
        moi1=0.2*amu*r0**2*aa1**1.66666*(ba1**0.66666+ba1**(-1.333333))
        moi2=0.2*amu*r0**2*aa2**1.66666*(ba2**0.66666+ba2**(-1.333333))
        moi12  = xmu12 * rdout**2

        moi1 = moi1   + 4 * amu * aa1 * ayuka**2
        moi2 = moi2   + 4 * amu * aa2 * ayuka**2
        moitot = moi1 + moi2 + moi12
        l12 = spin * moi12/moitot
        vr = spin * (spin + 1) * hbar2 / (2 * moitot)
        if(moi12.gt.0) then
          vrel =l12*(l12+1)*hbar2/(2*moi12)
          vrelin = spin *(spin+1)*hbar2/(2*moi12)
        endif
      endif
      barrier = vrel + vc + vn
      return
      end

c               PROXIMITY POTENTIAL CALCULATION
c               -------------------------------
c
c       parameters:     z, aa   - atomic number, weight
c                       s       - separation of two surfaces
c                       beta1,beta2 - deformation, r = r0 * (1 + beta*ylm)
c                       
c       note: the geometry is only approximate, ellipsoidal shapes are assumed
c               to obtain the curvature of the two surfaces
c
c       note: (5JUN85) The surface energy coefficient has been corrected as
c               indicated in Toke et al. GSI preprint(84) ...see Birger Back
c
      
      real*8 function proximity ( s, z1, aa1, r1, ba1, z2, aa2, r2, ba2)
      implicit real*8 ( a-z )
c                       proximity parameters
c                       --------------------
      zeta0 = 2.54
      zeta1 = 1.2511
      k = 0.0852
      b = 1.0
      
c                       check input parameters
c                       ----------------------
      proximity = 0
      
c                       find equivalent radius R-bar
c                       ----------------------------
      cnst     = sqrt( 5 / 3.1415926 )
      b1       = r1 * ba1**.3333333
      a1       = b1 / ba1
      b2       = r2 * ba2**.3333333
      a2       = b2 / ba2
      c1       = b1**2/a1
      c2       = b2**2/a2
      kappa1   = 2/c1 
      kappa2   = 2/c2
      nc1      = -0.5*kappa1*b**2
      nc2      = -0.5*kappa2*b**2
      c1       = c1 + nc1
      c2       = c2 + nc2
      r_bar    = c1 * c2 / ( c1 + c2 )
c                       calculate energy
c                       ----------------
      zeta = (s -nc1 - nc2) / b
      i = (aa1 + aa2 - 2 * (z1 + z2) ) / (aa1 + aa2 )
      gamma = 1.2496 * ( 1 - 2.3 * i ** 2 )
      if ( zeta .lt. zeta1 ) then
        phi = -0.5 * ( zeta - zeta0 )**2 - k * ( zeta - zeta0 )**3
      else
        phi = -3.437 * exp ( - zeta / 0.75)
      endif
      proximity = 4 * 3.1415 * gamma * r_bar * b * phi
      return
      end
c               COULOMB ENERGY BETWEEN TWO DEFORMED SPHEROIDS
c               ---------------------------------------------
      
CSMS    real function coulomb*8( s, r00, z1, m1, ba1, z2, m2, ba2 )
      real*8 function coulomb( s, r00, z1, m1, ba1, z2, m2, ba2 )
      implicit real*8 (a-z)
      common/shape_quad/rquad,squad,r01quad,r02quad,beta1quad,beta2quad,
     &     a1quad,b1quad,a2quad,b2quad
      common/shape_ellipse/rell,sell,r01ell,r02ell,ba1ell,ba2ell,
     &     a1ell,b1ell,a2ell,b2ell

      r1 = r01quad
      r2 = r02quad
      beta1 = beta1quad
      beta2 = beta2quad
      a1 = a1quad
      a2 = a2quad
      r = s + a1 + a2
      coulomb = 1.44*z1*z2/r
      coulomb = coulomb*(1. + 0.37847*(beta1*r1**2+beta2*r2**2)/r**2)
 300  return
      END 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c               Krappe POTENTIAL CALCULATION
c               -------------------------------
c
c       parameters:     z, a    - atomic number, weight
c                       s       - separation of two surfaces
c                       beta1,beta2 - deformation, r = r0 * (1 + beta*ylm)
c                       
c
      
      real*8 function krappe( s, z1, aa1, r1, ba1, z2, aa2, r2, ba2)
      implicit real*8 ( a-z )
      common/shape_quad/rquad,squad,r01quad,r02quad,beta1quad,beta2quad,
     &     a1quad,b1quad,a2quad,b2quad
      common/shape_ellipse/rell,sell,r01ell,r02ell,ba1ell,ba2ell,
     &     a1ell,b1ell,a2ell,b2ell

      parameter (r0 = 1.16)
      parameter (a = 0.68)
      parameter (as = 21.13)
      parameter (ks = 2.3)
      parameter (y20 = 0.630783)

c       parameter (r0 = 1.18)
c       parameter (a = 0.65)
c       parameter (as = 21.7)
c       parameter (ks = 3)
c       parameter (y20 = 0.630783)


      beta1 = beta1quad
      beta2 = beta2quad

      n1 = aa1 - z1
      n2 = aa2 - z2
      ac = 0.6*1.44/r0
      i1 = (n1-z1)/aa1
      i2 = (n2-z2)/aa2
      cs1 = as*(1-ks*i1**2)
      cs2 = as*(1-ks*i2**2)
      csp = sqrt(cs1*cs2)
      r01 = r01quad
      r02 = r02quad
      a1  = a1quad
      a2  = a2quad
      r12 = r01 + r02
      r = s + a1quad + a2quad
      s0 = r - r01 - r02
      xx1 = r01/a
      g1 = xx1*cosh(xx1) - sinh(xx1)
      f1 = xx1**2*sinh(xx1)
      xx2 = r02/a
      g2 = xx2*cosh(xx2) - sinh(xx2)
      f2 = xx2**2*sinh(xx2)
      f = 4 + r12/a - f1/g1 - f2/g2
      d = 4*a**3*g1*g2*exp(-r12/a)*csp/(r0**2*r12)
      vn0 = -d*(f+s0/a)*r12*exp(-s0/a)/r
      dv1 = 0
      dv2 = 0
      if( ba1 .gt. 0 ) dv1 =  vdef(r02,r01,r,a,beta1,r0,csp)
      if( ba2 .gt. 0 ) dv2 =  vdef(r01,r02,r,a,beta2,r0,csp)
      krappe = vn0 + dv1 + dv2
      end

      function vdef(r1,r2,r,ain,beta,r0,csp)
      implicit real*8 (a-z)
      parameter (y20 = 0.630783)
      deltaa = 0.01
      a = ain - deltaa/2.

      g2 = cosh(r1/a)*r1/a - sinh(r1/a)
      j2 = (sinh(r2/a)*(a/r2+3.d0*(a/r2)**3)-
     &     3.d0*(a/r2)**2*cosh(r2/a))
      h2 = (a/r+ 3.d0*(a/r)**3 + 3.d0*(a/r)**2)*exp(-r/a) 
      a2arg1 = g2*j2*h2

      a = ain + deltaa/2.
      g2 = cosh(r1/a)*r1/a - sinh(r1/a)
      j2 = (sinh(r2/a)*(a/r2+3.d0*(a/r2)**3)-
     &     3.d0*(a/r2)**2*cosh(r2/a))
      h2 = (a/r+ 3.d0*(a/r)**3 + 3.d0*(a/r)**2)*exp(-r/a) 
      a2arg = g2*j2*h2

      a2 = ain*(a2arg-a2arg1)/deltaa

      vdef = -4.d0*r2**3*csp*a2*beta*y20/(ain*r0**2)

      return
      end
