      function ground(zcn,acn,full,pairp)
      implicit real*8(a-z)
      logical full
      logical nodd,zodd,pair,pairp
      integer i,j,k,indx,kscan,ioff,scan_index,iloc,index
      integer nfit,info,lwa,iflag,nparam, asymcoord
      common/groundc/e_volume,coulomb_exchange,p_form_fact,e_pairing,
     &     e_wigner, ch_asym, a0_term, vfixed
      common/wigscale/wigscale

      parameter (pi = 3.1415926d0)
      parameter (hbar = 197.32857d0)
      parameter (third = .333333333333333d0)
      
      DATA FACTOR,ONE,ZERO /1.0d2,1.0d0,0.0d0/
      
      data mh/7.289034d0/,
     &     mn/8.071431d0/,
     &     esq/1.4399764d0/,
     &     aden/0.68d0/,
     &     ael/1.433d-5/,
     &     delpair/12./,
     &     delpairasym/20./,
     &     rp/0.80/,
     &     r0/1.16/,
     &     a/0.68/,
     &     ac/0.703/,
     &     as/21.13/,
     &     ks/2.3/,
     &     av/15.9937/,
     &     kv/1.927/,
     &     wigner/36.0/,
     &     c0/4.4/,
     &     ca/0.212/,
     &     m0ld/939.15/
      
      ground = 0
      if ( zcn .eq. 0 .or.  acn .eq. 0 ) return
      pair = pairp
      ncn = acn - zcn
      ii = (ncn-zcn)/acn
      cs = as *(1-ks*ii**2 )

      r = r0*acn**third
      vcoulsharp = 0.6*1.44*zcn**2/r
      ar = ac/r
      vcouldiff = -(5*vcoulsharp*ar**2) *
     &     (1-(15./8.)*ar+(21./8.)*ar**3 -
     &     0.75*exp(-2/ar)*(1+(9./2.)*ar+7*ar**2+(7./2.)*ar**3))
      vcoul = vcoulsharp + vcouldiff
      ar = a/r
      vnuclsharp = cs * acn ** .666666666d0
      vnucl= vnuclsharp*(1-3*ar**2+(1/ar+1)*
     &     (2+3*ar+3*ar**2)*exp(-2/ar))
      ground = vcoul + vnucl 


      volume = (4.d0/3.d0)*pi*acn*r0**3
      e_volume = -av * (1-kv*ii**2) * acn
      coulomb_exchange = -0.75*(1.5/pi)**0.6666666d0*esq*
     &     zcn**1.3333333333/(r0*acn**.33333333d0)
      kf = ((9./4.)*pi*zcn/acn)**.3333333d0/r0
      kfrpsq=(kf*rp)**2
      p_form_fact=-(1./8.)*rp**2*esq*zcn**2/(r0**3*acn) *
     &     (145./48.-327.*kfrpsq/2880.+1527.*kfrpsq**2/1209600d0)
      zodd = .false.
      nodd = .false.
      if( mod(zcn,2.d0).ne.0) zodd = .true.
      if( mod(ncn,2.d0).ne.0) nodd = .true.
      e_pairing = 0
      if( pair ) then
        if( zodd .and. nodd ) then
          e_pairing = delpair/sqrt(acn)-0.5*delpairasym/acn
        else if (zodd .or. nodd ) then
          e_pairing = 0.5*delpairasym/acn
        else
          e_pairing = -(delpair/sqrt(acn)-0.5*delpairasym/acn)
        endif
      endif
      e_wigner = 0
      if( full ) then
        e_wigner = wigscale*wigner*abs(ii)
        if( zodd .and. nodd .and. zcn-ncn .eq. 0) 
     &       e_wigner=e_wigner+wigner/acn 
      endif
      ch_asym = ca*(zcn-ncn)
      a0_term = c0
      vfixed=e_volume+coulomb_exchange+p_form_fact
     &     +e_pairing+e_wigner+ch_asym+a0_term

      ground = ground + vfixed
      return
      end
