      SUBROUTINE LEVELD (EXMIN,IEXXMX,JMIN,JJMAX,CK,iz,IA,
     1     DA,DALDM,DELTA,DLDM,FTHETA,R0LDM,DEF,DEFS,
     2     UTR,ULDM,UJTR,UJLDM,izf,ISPECOPT)
      IMPLICIT REAL*8(A-H,O-Z)
CE    LEVEL DENSITY SUBROUTINE FOR CASCADE I
CE    FERMI GAS LEVEL DENSITY (LANG'S FORMULA)
CE    WITH ENERGY DEPENDENT PARAMETERS A,DELTA,I
      real*8 tsum(48,1200,4),W(64,64,4), rhosum(64),thetaj(64),erotj(64)
      real*8 erotjldm(64), rj(64)
CSMS      COMMON/C6/ tsUM,RHO(64,64,5),W,WF(64,64,40,3)
      COMMON/C6/ tsUM,RHO(64,64,5),W,WF(64,64,40,4)
      
      COMMON/OFFSET/UXOFET,OFFEV,OFFODD,TRAMO
     &     ,CSPLIEV,DSPLIEV,CSPLIOD,DSPLIOD,JNOD
      
      
      common/lildeck/elab,excn,cl0,dafis,sigfus,siger,
     &     izt,iat,izp,iap,iafmax, izfindxoff,izfindxmax
      
      
      logical sierk(64)
CE
      A = IA/DA
      ALDM = IA/DALDM
      C1 = 0.75/ALDM
      C2 = 0.5625/(ALDM*ALDM)
      THLDM = 0.01917 * R0LDM**2 * IA**1.6666667
c     THETA = FTHETA * THLDM
      THETA = THLDM
      ETR = UTR + DELTA
      ELDM = ULDM + DELTA
      AA = (ALDM-A)/(ELDM-ETR)
      DD = (DLDM-DELTA)/(ELDM-ETR)
      EJTR = UJTR + DELTA
      EJLDM = UJLDM + DELTA
      TT = (THLDM-THETA)/(EJLDM-EJTR)
      CJD = 0.5
      IF (2*(IA/2).EQ.IA) CJD = 0.
      DO 10  JJ=1,64
        rhosum(jj) = 0
        thetaj(jj) = 0
        erotj(jj)  = 0
        erotjldm(jj) = 0
        rj(jj) = 0
        DO 10  IEXX=1,64
 10   RHO(IEXX,JJ,izf) = 0.
CE

      DO 30  IEXX=1,IEXXMX
        EX = EXMIN + IEXX
        AX = ALDM
        DELTAX = DLDM
        IF (EX.GT.ELDM) GO TO 18
        AX = A
        DELTAX = DELTA
        IF (EX.LE.ETR) GO TO 18
        EE = EX - ETR
        AX = A + AA*EE
        DELTAX = DELTA + DD*EE
 18     THETAX = THLDM
        IF (EX.GT.EJLDM) GO TO 19
        THETAX = THETA
        IF (EX.LE.EJTR) GO TO 19
        EE = EX - EJTR
        THETAX = THETA + TT*EE
 19     U = EX - DELTAX
        R = THETAX/AX
        RA = CK / (12.*SQRT(R)*AX*AX)
        fracldm = 0.85
        
        DO JJ=1,JJMAX
          
          CJ = JMIN + JJ + CJD
          
          if( ispecopt .eq. 1 ) then
            erot = yrastline(cj,ia)
            sierk(jj) = .true.  !prevents ldm scaling
          else
            sierk(jj) = .false.
            cj2 = cj*cj
            theta = THETAX*(1.+DEF*CJ2+DEFS*CJ2*CJ2)
            erot = CJ*(cj+1)/theta
            erotjldm(jj) = erot
            if( iz .ge. 19 ) then !barfit only good for iz .ge. 19
              call barfit(iz,ia,cj,bfis,berot,selmax)
              if( berot .gt. 0) then
                fracldm = berot/erot
              endif             ! scaling ratio for when barfit gives out
              if( cj .lt. selmax ) then
                sierk(jj) = .true.
                erot = berot
                if( cj .gt. 2 ) then !find moi parameter 2I/hbar^2
                  theta =  cj*(cj+1)/erot
                else
                  ccj = 2.
                  call barfit(iz,ia,ccj,bfis2,erot2,selmax2)
                  theta = ccj*(ccj+1)/erot2
                endif           !  ( cj .gt. 2 )
              endif
            endif               !  (iz .lt. 19 )        
          endif                 ! ( ispecopt )
          if( .not. sierk(jj) ) erot = fracldm * erot
          u1 = u - erot
          if( u1 .lt. 0 ) goto 30
          erotj(jj) = erot
          thetaj(jj) = theta
          rhox = ((2*cj+1)/12.)*sqrt(ax/theta**3)*exp(2*sqrt(ax*u1))/u1**2
          RHO(IEXX,JJ,izf) = RHOX
          rhosum(jj) = rhosum(jj) + rhox
          rj(jj) = fracldm
          erotjldm(jj) = fracldm * erotjldm(jj)
        enddo                   !jj loop
 30   CONTINUE
      write(42,*) 'iz ia if mx   da aldm  delta',
     &     '   dldm  exmin   eldm selmax'
      write(42,'(4i3,2f5.1,6f7.2)') iz,ia,izf,iexxmx,da,daldm,delta,
     &     dldm,exmin,eldm,ejtr,selmax
      write(42,*) '    j           rho     erotj  erotjldm',
     &     '    thetaj         rj    sierk'
      DO JJ=1,JJMAX
        CJ = JMIN + JJ + CJD
        write(42,'(f5.1,e15.5,4f10.3,l10)') cj,rhosum(jj),
     &       erotj(jj),erotjldm(jj),thetaj(jj),rj(jj),sierk(jj)
      enddo
      RETURN
      END
      
      SUBROUTINE LQPARM (KOPTLQ,KOPTEB,ALPHA2)
      IMPLICIT REAL*8(A-H,O-Z)
CE    CALCULATES STANDARD PARAMETERS FOR LEVEL DENSITIES
CE    IN THE LIQUID-DROP REGION
      
      COMMON EXMIN(500),EXMAX(500),EBE(4),ESEP(4,500)
      COMMON IZFMAX,IZE(4),IAE(4),JE(4),JDE(4),IEXXMX(500),IEXXS(500)
      COMMON IPS1,IPSMAX,IPSZO(4,500),IZ(500),IA(500)
      COMMON IEXXL(500),JMIN(500),JMAX(500),JJMAX(500)
      
CE
      COMMON/C2/ FT(500),DA(500),DELTA(500),CK(500)
      COMMON/C2/ R0LDM,DEF,DEFS,DALDM,DAF,UTR,ULDM,UJTR,UJLDM,DLDM(500)
      real*8 tsum(48,1200,4),W(64,64,4)
CSMS      COMMON/C6/ tsUM,RHO(64,64,5),W,WF(64,64,40,3)
      COMMON/C6/ tsUM,RHO(64,64,5),W,WF(64,64,40,4)
      real*4 EB(128,144)
      EQUIVALENCE (EB(1),TSUM(1))
      common/lildeck/elab,excn,cl0,dafis,sigfus,siger,
     &     izt,iat,izp,iap,iafmax, izfindxoff,izfindxmax
      
CE
      Z = IZ(1) - 2
      A = IA(1) - 4
      IF (R0LDM.GT.0.01) GO TO 12
      A3RT2 = A**(2./3.)
      R0LDM = 1.13 + 2.1/A3RT2
      IF (R0LDM.GT.1.3) R0LDM = 1.3
 12   IF (ABS(DEF).GT.1.E-8) GO TO 13
      CALL CPS (Z,A,R0LDM,DEF,DEFS)
 13   IF (DALDM.LE.0.01) DALDM = 8.
      IF (DAF  .LE.0.01) DAF = DALDM
      IF (ULDM .LE.0.01) ULDM = 20.
      IF (UTR  .LE.0.01) UTR = 10.
      IF (UJLDM.LE.0.01) UJLDM = ULDM
      IF (UJTR .LE.0.01) UJTR = UTR
      IF (KOPTLQ.NE.2) GO TO 14
      DALDM = 0.
      RETURN
CE
 14   DO 15  IPS=1,IPSMAX
        DLDM(IPS) = 0.
        IF (IEXXMX(IPS).LE.0) GO TO 15
        IZZ = IZ(IPS)
        IAA = IA(IPS)
        N = IAA - IZZ
        NN = N + 1 - NPDRIP(IZZ)
        
c       tebldm = ebldm(izz,iaa,kopteb,alpha2)
c      DLDM(IPS) = EB(NN,IZZ) - EBLDM(IZZ,IAA,KOPTEB,ALPHA2)
        fz = izz
        fa = iaa
        tebldm = -ground(fz,fa,.true.,.false.) !Wigner ...no pairing
        
        DLDM(IPS) = EB(NN,IZZ) - tebldm
c        write(42,'(a25,2i4,4f12.4)') 'z,a,eb,ebldm,gf,gt',
c     &       izz,iaa,eb(nn,izz),tebldm,
c     &       fgf,fgt
        IF (EB(NN,IZZ).LT.0.1) DLDM(IPS) = 0.
 15   CONTINUE
CE
      RETURN
      END
      
      SUBROUTINE LDPARM (KOPTLD)
      IMPLICIT REAL*8(A-H,O-Z)
CE    CALCULATES STANDARD LEVEL DENSITY PARAMETERS
CE
      
      COMMON EXMIN(500),EXMAX(500),EBE(4),ESEP(4,500)
      COMMON IZFMAX,IZE(4),IAE(4),JE(4),JDE(4),IEXXMX(500),IEXXS(500)
      COMMON IPS1,IPSMAX,IPSZO(4,500),IZ(500),IA(500)
      COMMON IEXXL(500),JMIN(500),JMAX(500),JJMAX(500)
CE
      COMMON/C2/ FT(500),DA(500),DELTA(500),CK(500)
      COMMON/C2/ R0LDM,DEF,DEFS,DALDM,DAF,UTR,ULDM,UJTR,UJLDM,DLDM(500)
CE
CE
      IF (FT(1).GT.0.01) GO TO 10
      DO 8  IPS=1,IPSMAX
 8    FT(IPS) = 0.85
CE
 10   IF (KOPTLD.GE.50) GO TO 30
      KDILG = KOPTLD
      IF (KDILG.GE.10) KDILG = KDILG - 10
      CALL DILG (KDILG)
      IF (KOPTLD.LE.9) GO TO 100
      DO 20  IPS=1,IPSMAX
        DA(IPS) = DA(IPS) - 1.
 20   DELTA(IPS) = DELTA(IPS) + 1.
      GO TO 100
CE
CE
 30   DO 38  IPS=1,IPSMAX
        CK(IPS) = 1.
        DA(IPS) = 8.
        IZZ = IZ(IPS)
        NN = IA(IPS) - IZZ
        D = 0.7
        IF (2*(IZZ/2).EQ.IZZ .AND. 2*(NN/2).EQ.NN) GO TO 35
        D = -0.7
        IF (2*(IZZ/2).EQ.IZZ .OR. 2*(NN/2).EQ.NN) GO TO 35
        D = -2.
 35     DELTA(IPS) = D
 38   CONTINUE
 100  RETURN
      END
      
      SUBROUTINE DILG (KDILG)
      IMPLICIT REAL*8(A-H,O-Z)
CE    CALCULATES LEVEL DENSITY PARAMETERS DA,DELTA,CK
CE    USING ANALYTICAL EXPRESSIONS FITTED TO THE EMPIRICAL VALUES
CE    OF DILG ET AL. NUCL.PHYS. A217 (1973) 269
CE
      COMMON EXMIN(500),EXMAX(500),EBE(4),ESEP(4,500)
      COMMON IZFMAX,IZE(4),IAE(4),JE(4),JDE(4),IEXXMX(500),IEXXS(500)
      COMMON IPS1,IPSMAX,IPSZO(4,500),IZ(500),IA(500)
      COMMON IEXXL(500),JMIN(500),JMAX(500),JJMAX(500)
      
      COMMON/C2/ FT(500),DA(500),DELTA(500),CK(500)
      COMMON/C2/ R0LDM,DEF,DEFS,DALDM,DAF,UTR,ULDM,UJTR,UJLDM,DLDM(500)
      real*8 tsum(48,1200,4),V(64,64,4)
      COMMON/C6/ TSUM,RHO(64,64,5),V,dum_my(64,64,40,4)
      real*4 EB(128,144)
      common/lildeck/elab,excn,cl0,dafis,sigfus,siger,
     &     izt,iat,izp,iap,iafmax, izfindxoff,izfindxmax
      
      EQUIVALENCE (EB(1),TSUM(1))
      DIMENSION SHLLZ(5),SHLLN(5)
      DATA SHLLZ /28.,50.,82.,114.,184./
      DATA SHLLN /28.,50.,82.,126.,184./
CE
      DO 90  IPS=1,IPSMAX
        IF (IEXXMX(IPS).LE.0) GO TO 90
        CK(IPS) = 1.
        AA = IA(IPS)
        IZZ = IZ(IPS)
        NN = IA(IPS) - IZZ
CE
        KD = KDILG + 1
        GO TO (10,20,30,30,30,60), KD
CE
CE    OPTION 0
CE    BACKSHIFT B AND LEVEL DENSITY PARAMETERS DAZ AND DAN
CE    WITHOUT SHELL EFFECTS
 10     B = 1.1 + 80./AA
        IF (AA.LT.40.) B = 3.1 + (40.-AA)*0.035
        DAZ = 7.7
        DAN = 7.7
        IF (IZZ.GE.65) DAZ = 9.
        IF (NN.GE.100) DAN = 9.
        IF (IZZ.GT.50 .AND. IZZ.LT.65) DAZ = 7.7 + .0867*(IZZ-50)
        IF (NN .GT.82 .AND. NN.LT.100) DAN = 7.7 + .0722*(NN-82)
        IF (IZZ.LE.20) DAZ = 9.
        IF (NN .LE.20) DAN = 9.
        IF (IZZ.GT.20 .AND. IZZ.LT.24) DAZ = 9.0 -  0.325*(IZZ-20)
        IF (NN .GT.20 .AND. NN .LT.24) DAN = 9.0 -  0.325*(NN -20)
        IF (AA.GE.30.) GO TO 12
        DAZ = 9. - (30.-AA)*0.05
        DAN = DAZ
 12     SB = -1.5
        SD = 2.
        W  = 0.4
        GO TO 50
CE
CE    OPTION 1
 20     B = 1.7 + 80./AA
        IF (AA.LT.40.) B = 3.7 + (40.-AA)*0.035
        DAZ = 7.2
        DAN = 7.2
        IF (IZZ.GE.65) DAZ = 9.
        IF (NN.GE.100) DAN = 9.
        IF (IZZ.GT.50 .AND. IZZ.LT.65) DAZ = 7.2 + .1200*(IZZ-50)
        IF (NN .GT.82 .AND. NN.LT.100) DAN = 7.2 + .1000*(NN-82)
        IF (IZZ.LE.20) DAZ = 9.
        IF (NN .LE.20) DAN = 9.
        IF (IZZ.GT.20 .AND. IZZ.LT.24) DAZ = 9.0 -  0.450*(IZZ-20)
        IF (NN .GT.20 .AND. NN .LT.24) DAN = 9.0 -  0.450*(NN -20)
        IF (AA.GE.30.) GO TO 22
        DAZ = 9. - (30.-AA)*0.05
        DAN = DAZ
 22     SB = -2.
        SD = 2.
        W  = 0.5
        GO TO 50
CE
CE    OPTION 2
 30     B = 0.7 + 19./SQRT(AA)
        DAA = 7.2
        SB = - 1.5
        SD = 1.8
        W  = 0.4
        IF (KDILG.EQ.3) SB = -2.
        IF (KDILG.EQ.4) SD = 2.3
CE
CE    SHELL EFFECT FOR OPTIONS 0..4
CE    NEXT SHELLS ISHLLZ,ISHLLN
 50     ISHLLZ = 1
        DZ = 100.
        DO 51 I=1,5
          DZZ = IZZ - SHLLZ(I)
          DZZ = ABS(DZZ)
          IF (DZZ.GE.DZ) GO TO 51
          DZ = DZZ
          ISHLLZ = I
 51     CONTINUE
        ISHLLN = 1
        DN = 100.
        DO 52 I=1,5
          DNN = NN - SHLLN(I)
          DNN = ABS(DNN)
          IF (DNN.GE.DN) GO TO 52
          DN = DNN
          ISHLLN = I
 52     CONTINUE
CE
CE    DAMPING FUNCTIONS
        DBZ = W * SQRT(SHLLZ(ISHLLZ))
        DBN = W * SQRT(SHLLN(ISHLLN))
        X = DZ/DBZ
        EZ = 0.
        IF (X.LT.100.) EZ = EXP(-X)
        X = DN/DBN
        EN = 0.
        IF (X.LT.100.) EN = EXP(-X)
CE
CE    DELTA WITH SHELL EFFECT
        SBZ = SB  * EZ
        SBN = SB  * EN
        B = B + SBZ + SBN
        P = 29.4/AA
        IF (KDILG.GE.2) P = P + 0.5
        IF (2*(IZZ/2).EQ.IZZ .OR. 2*(NN/2).EQ.NN) P = 12.8/SQRT(AA)
        IF (2*(IZZ/2).EQ.IZZ .AND.2*(NN/2).EQ.NN) P = 2. * P
        DELTA(IPS) = P - B
CE
CE    DA WITH SHELL EFFECT
        SDZ = SD  * EZ
        SDN = SD  * EN
        DAZ = DAZ + SDZ
        DAN = DAN + SDN
        DA(IPS) = AA/(NN/DAN+IZZ/DAZ)
        IF (KDILG.GE.2) DA(IPS) = DAA + SDZ + SDN
CE
CE    CORRECTIONS FOR LIGHT NUCLEI
        IF (AA.GT.44.1) GO TO 90
        IF (2*(IZZ/2).EQ.IZZ .AND. IZZ.EQ.NN) GO TO 55
        GO TO 56
 55     DA(IPS) = DA(IPS) + 0.5
        DELTA (IPS) = DELTA(IPS) + 0.5
 56     IF (IZZ.EQ.NN .AND.(NN.EQ.8.OR.NN.EQ.20)) GO TO 57
        GO TO 58
 57     DA(IPS) = DA(IPS) + 0.5
        DELTA (IPS) = DELTA(IPS) + 0.5
 58     IF (IA(IPS).EQ.39 .AND.(IZZ.EQ.20.OR.IZZ.EQ.19))GO TO 59
        GO TO 90
 59     DA(IPS) = DA(IPS) + 1.5
        DELTA (IPS) = DELTA(IPS) + 1.2
        GO TO 90
CE
CE
CE    OPTION 5
CE    SHELL EFFECTS IN THE LEVEL DENSITY PARAMETERS DERIVED
CE    FROM THOSE OF THE G.S. BINDING ENERGY
 60     CALL MYERS (IZZ,IA(IPS),EBLD0,EBGS,P)
        NNN = NN + 1 - NPDRIP(IZZ)
        S = EB(NNN,IZZ) - EBLD0
CE
        DA(IPS) = 8.5 + 0.70*S
        B = 19./SQRT(AA) - 1.9 - 0.40*S
        IF (2*(IZZ/2).EQ.IZZ .OR. 2*(NN/2).EQ.NN) GO TO 61
        DA(IPS) = DA(IPS) - 0.5
        B = B - 0.5
 61     DELTA(IPS) = P - B
CE
CE
 90   CONTINUE
CE
      RETURN
      END
