/* 	file ftapeop.c J.Campbell June 1992	*/
/*
	int ftape(fd,op,count)
	int *fd;	file descriptor
	int *op;	operation
	int *count;	count
	
	implement fortran tape controls
	 MTWEOF		0	write an end-of-file record
	 MTFSF		1	forward space over file mark
	 MTBSF		2	backward space over file mark (1/2" only )
	 MTFSR		3	forward space to inter-record gap
	 MTBSR		4	backward space to inter-record gap
	 MTREW		5	rewind
	 MTOFFL		6	rewind and put the drive offline
	 MTNOP		7	no operation, sets status only
	 MTRETEN	8	retension the tape (cartridge tape only)
	 MTERASE	9	erase the entire tape
	 MTEOM		10	position to end of media
	 MTNBSF		11	backward space file to BOF

*/

#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/mtio.h>

int ftape(fd, op, count)	/* do tape operation op (see <sys/mtio.h>)
                                 count times */
	int	*fd,
		*op,
		*count;
{
	struct mtop mt;
	mt.mt_op    = *op;
	mt.mt_count = *count;
	return( ioctl(*fd, MTIOCTOP, &mt) );
}

