/* file rdwrtrec.c  */

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/vfs.h>

#define MAXBUF 16384

struct header {
	union {
		short length;
		unsigned char  b[2];
	}h;
	union {
		short filler;
		unsigned char  b1[2];
	}f;
};

/*
   int freadrec(buffer,maxcnt,len,fp)
   unsigned char buffer[]; buffer to put data in
   int maxcnt;             length of physical gec block
   int len;                length required
   FILE *fp;               file pointer   
  gets a record from block structured file
  returns length read or 0 if eof or error 
 */

int freadrec(buffer,maxcnt,len,fp)
unsigned char buffer[];
int maxcnt;
int len;
FILE *fp;
{
	static struct header bufhead,rechead;
	static unsigned char iobuf[MAXBUF];
	static int physcnt=0;
	static unsigned char *curptr;
	int temp;
	if (physcnt <= 0) {
		curptr = iobuf;
		if ((physcnt = fread(iobuf,1,maxcnt,fp)) <= 0){
		    if (physcnt < 0) perror("freadrec error: ");
		    return (physcnt);
		}
		bufhead.h.b[0] = *curptr++;
		bufhead.h.b[1] = *curptr++;
		curptr += 2;
		physcnt -= 4;
		bufhead.h.length -= 4;
	}
	rechead.h.b[0] = *curptr++;
	rechead.h.b[1] = *curptr++;
	curptr += 2;
	physcnt -= 4;
	temp = rechead.h.length - 4;
	(void) memcpy(buffer,curptr,(temp>len)?len:temp);
	curptr += temp;
	physcnt -= temp;
	if ( (bufhead.h.length -= rechead.h.length) <= 0)
		physcnt = 0;
	return ((temp>len)?len:temp);
}/* end of freadrec */

/*
  int fwriterec(buffer,maxcnt,len,fp)
  unsigned char buffer[];	buffer to put
  int maxcnt;			length physical buffer
  int len; 			length to put  
  FILE *fp;			file pointer
 puts record to block structured file
 returns length put or 0 if eof or error 
 */
 
static struct header bufhead,rechead;
static unsigned char iobuf[MAXBUF];
static unsigned char *curptr;
static int numrecs = 0;

int fwriterec(buffer,maxcnt,len,fp)
unsigned char buffer[];
int maxcnt;
int len;
FILE *fp;
{
	int ierr;
	if ((maxcnt-bufhead.h.length-4) < len){
		iobuf[0] = bufhead.h.b[0];
		iobuf[1] = bufhead.h.b[1];
		iobuf[2] = bufhead.f.b1[0];
		iobuf[3] = bufhead.f.b1[1];
		if ((ierr = fwrite(iobuf,1,maxcnt,fp)) <= 0){
			if (ierr < 0) perror("fwriterec error: ");
			return (ierr);
		}
		curptr = iobuf + 4;
		bufhead.h.length = 4;
		bufhead.f.filler = 0x8020;
	}
	if (numrecs == 0){
		curptr = iobuf + 4;
		bufhead.h.length = 4;
		bufhead.f.filler = 0x8020;
	}
	rechead.h.length = len+4;
	rechead.f.filler = 0;
	*curptr++ = rechead.h.b[0];
	*curptr++ = rechead.h.b[1];
	*curptr++ = rechead.f.b1[0];
	*curptr++ = rechead.f.b1[1];
	(void) memcpy(curptr,buffer,len);
	bufhead.h.length += rechead.h.length;
	curptr += len;
	numrecs++;
	return (len);
}/* end of fwriterec */

/*
  int flushrec(maxcnt,fp)
  int maxcnt;			length physical block
  FILE *fp;			file pointer

  
  flushes incomplete record buffer
 */ 

int flushrec(maxcnt,fp)
int maxcnt;
FILE *fp;
{
	int ierr;
	if (bufhead.h.length > 4) {
		iobuf[0] = bufhead.h.b[0];
		iobuf[1] = bufhead.h.b[1];
		iobuf[2] = bufhead.f.b1[0];
		iobuf[3] = bufhead.f.b1[1];
		if ((ierr = fwrite(iobuf,1,maxcnt,fp)) <= 0){
			if (ierr < 0) perror("flushrec error: ");
			return (ierr);
		}
		curptr = iobuf + 4;
		bufhead.h.length = 4;
		bufhead.f.filler = 0x8020;
	}
	numrecs = 0;
	return (ierr);
}/* end of flushrec */
	
	
	
	
