C
C     *****************************************************************
C
C
C
      SUBROUTINE BUFFIT(SPEC,NCHAN,ICHAN,JCHAN,NPEAK,NBACK,CENTIN,
     >FWHMIN,FWLOIN,WIDTH,WIDLO,IPKSCH,IVARWD,ISKEW,IFIXWD,IFIXCN,  
     >LORENTZ,TOTAL,FIT,PEAKS,BKGRD,CENTR,AREA,HEIGHT,
     >FWHM,FWHMLO,GWIDHI,GWIDLO,
     >BKAREA,BAKFIT, CENERR,ARERR,HTERR,FWERR,FWLERR,
     >GWHERR,GWLERR,BKAERR,BAKERR,CHISQ)                                        
C    
C    
C     *****************************************************************
C     BUFFIT- A PEAK FITTING SUBROUTINE BY N M CLARKE,BIRMINGHAM 1992
C
C     DEVELOPED FROM THE GAFIT CODE BY RYZARD ZYBERT, BIRMINGHAM 1986
C
C
C     VERSION 3.0 23/11/92 FOR SUNGRAF                              
C    
C     CHANGES FROM VS. 2.1 :-
C     IMPROVED ERROR TREATMENT OF PEAK AREAS INCLUDING CORRELATION
C     COEFFICIENTS.
C     FWHM NOW RETURNS THE FWHM ON THE HIGH SIDE FOR SKEW PEAKS
C     INSTEAD OF THE MEAN VALUE ( FWHM ON LOW SIDE IS RETURNED
C     IN FWHMLO )
C
C     CORRECTED ERRORS FOR BACKGROUND AREA INCLUDING CORRELATION COEFFS
C
C     PLEASE REPORT ANY ERRORS TO nmc@np.ph.bham.ac.uk
C
C     OPTIONS IFIXWD FOR FIXED WIDTH OF GAUSSIANS 
C     OPTION  IFIXCN FOR FIXED CENTROID OF GAUSSIANS
C     OPTION LORENTZ FOR LORENTZIAN SHAPES
C
C     PLEASE NOTE THAT VS. 3.0 IS A DEVELOPMENT VERSION WHICH DOES
C     NOT REPRESENT THE  FINAL CAPABILITIES OF THE BUFFIT
C     PACKAGE.
C
C   
C     CHANGES FROM THE PROGRAM GAFIT BY RYSZARD ZYBERT
C
C   - NEW ARRAY &VARIABLE  NAMES CREATED TO IMPROVE READABILITY
C   - AND MORE COMMENT CARDS INSERTED
C   - COMMON BLOCKS ELIMINATED, PARAMETERS & ARRAYS PASSED AS
C     ARGUMENTS
C     SUBROUTINES RE-WRITTEN AND RE-ARRANGED TO ENABLE FURTHER
C     EXPANSION
C   - FITTING FOR SYMMETRIC GAUSSIANS 
C   - WITH SAME OR DIFFERENT WIDTHS, FIXED CENTROIDS AND/OR WIDTHS
C   - FITTING FOR SKEW GAUSSIANS WITH SAME OR DIFFERENT WIDTHS
C    - FITTING OF LORENTZIAN SHAPES
C
C   - TOTAL& BACKGROUND AREA & ERROR CALCULATED,CHECK ON INTEGRALS
C
C
C
C     ******************************************************************
C
C
C     INPUT PARAMETERS AND ARRAYS
C
C     SPEC (8192) ARRAY CONTAINING SPECTRUM CONTENTS
C    
C     NCHAN DIMENSION OF SPEC IE. NO. OF CHANNELS
C
C     ICHAN  INITIAL (START) CHANNEL FOR FITTING
C
C     JCHAN FINAL CHANNEL FOR FITTING
C
C     NPEAK NUMBER OF GAUSSIAN PEAKS TO FIT  (2*NPEAK+NBACK+1 .LE.80)
C
C     NBACK NUMBER OF BACKGROUND PARAMETERS TO FIT ( MAX. 6)
C
C
C
C     CENTIN  (30) CENTIN( 1 TO NPEAK) ARE THE INPUT GUESSES FOR
C     THE CENTROIDS OF THE PEAKS.                                    
C
C
C     FWHMIN ( 30) = FWHM VALUES FOR EACH  OF THE NPEAK PEAKS
C                  = FWHM ON HIGH SIDE FOR SKEW PEAKS
C
C      FWLOIN (30)= FWHM ON LOW SIDE OF PEAKS FOR SKEW GAUSSIANS
C
C
C     WIDTH   = FWHM OF PEAKS WHEN ALL HAVE SAME FIXED WIDTH
C             = FWHM ON HIGH SIDE FOR SKEW PEAKS
C
C      WIDLO = FWHM ON LOW SIDE OF PEAKS FOR SKEW GAUSSIANS
C
C
C
C     IPKSCH = 0 DO NOT SEARCH ON VALUES OF CENTIN
C     IPKSCH > 0 SEARCH OVER REGION FROM CENTIN-IPKSCH TO CENTIN
C     + IPKSCH FOR BETTER GUESS AT CENTROID
C
C     IVARWD= 0 SAME WIDTH FOR ALL PEAKS                     
C     IVARWD > 0 USE VALUES OF FWHMIN FOR PEAK WIDTHS
C
C     ISKEW =0 SYMMETRIC GAUSSIAN SHAPE
C           =1 USE SKEW GAUSSIAN 
C     IFIXWD=0 SEARCH ON WIDTH OF PEAKS
C     IFIXWD=1 KEEP WIDTH OF PEAKS FIXED AT VALUE GIVEN BY WIDTH
C
C     IFIXCN=0 SEARCH ON CENTROIDS OF PEAKS
C     IFIXCN=1 KEEP CENTROIDS FIXED AT VALUES GIVEN IN CENTIN
C
CC     LORENTZ= 0 USE GAUSSIAN SHAPE
C       LORENTZ=1 USE LORENTZIAN SHAPE FOR PEAKS
C
C      NOTE THAT ISKEW=1 OR IFIXCN=1 OR IFIXWD=1 MAY ONLY BE USED FOR GAUSSIANS
C
C     OUTPUT PARAMETERS
C
C     TOTAL = INTEGRAL OF SPECTRUM BETWEEN ICHAN & JCHAN
C
C     FIT ( 8192) THE FITTED SPECTRUM INCLUDING THE BACKGROUND
C     
C     PEAKS(8192) THE PEAKS SPECTRUM ONLY
C
C     BKGRD (8192) THE BACKGROUND SPECTRUM ONLY
C
C     CENTR ( 30), CENERR(30) CENTROIDS, ERRORS ON CENTROIDS FROM FIT
C
C     AREA (30) ARERR (30) AREA, ERRORS ON AREAS FROM FITT
C
C     HEIGHT(30),HTERR(30) HEIGHT OF GAUSSIAN, ERRORS ON HEIGHT
C
C
C     FWHM (30) FWERR(30) FWHM, ERRORS ON FWHM FROM FIT
C     - IF SKEW GAUSSIANS ARE USED, THEN FWHM IS FOR HIGH SIDE OF PEAK
C
C     FWHMLO(30) ,FWLERR(30), FWHM &ERRORS FOR LOW SIDE OF PEAK
C
C     GWIDHI(30),GWHERR(30),  WIDTH,ERRORS FOR THE GAUSSIANS,
C     WHERE GWIDHI=SQRT(2) * SIGMA
C     FOR LORENTZIAN GWIDHI= GAMMA = 0.5*FWHM
C
C     GWIDLO(30),GWLERR(30), WIDTH,ERRORS FOR GAUSSIAN ON LOW
C     SIDE OF PEAK WHEN SKEW GAUSSIANS ARE USED
C
C     BKAREA,BKAERR, BACKGROUND AREA & ERROR
C
C     BAKFIT (6) BAKERR(6) BACKGROUND PARAMETERS, ERRORS ON BKGRD
C     FROM FIT
C
C
C     CHISQ  FINAL VALUE OF CHISQ FOR FIT
C
C
C  
C     THE GAUSSIANS ARE GIVEN BY THE FOLLOWING FORMULA:-
C
C
C      I IS THE CHANNEL NUMBER
C
C     G( I) = AREA/(C1* FWHM) * EXP( -C2* ((CENTR-I)/FWHM)**2)
C     WHERE C1= 1.0644467019, C2= 2.772588725
C
C     ALTERNATIVELY THE GAUSSIANS MAY BE CALCULATED BY:-
C
C     F(I) = HEIGHT*EXP( -((I-CENTR)/GWIDHI)**2 )     
C     (THIS ALSO APPLIES TO THE HIGH SIDE OF THE PEAK FOR AYMMETRIC
C       GAUSSIANS )
C     THE GAUSSIANS ARE CALCULATED THUS INSIDE THE CODE
C
C      FOR THE LOW SIDE OF THE ASYMMETRIC GAUSSIANS
C
C     F(I) = HEIGHT *EXP( - (( I=CENTR)/GWIDLO)**2 )
C    
C
C     THE LORENTZIANS ARE GIEVN BY THE FOLLOWING FORMULA
C
C      L(I)= HEIGHT* GAMSQ/( (I-CENTR)**2 +GAMSQ )
C
C       WHERE GAMSQ=GAM**2 AND GAM =0.5*FWHM
C
C
C     THE BACKGROUND IS GIVEN BY:-
C
C     B( I) = SUM OF J=1 TO 6 [ BAKFIT(J) * (I-ICHAN)**(J-1) ]
C
C
C
C     *************************************************************
C
C     A note to those who wish to modify this code!
C
C     BUFFIT is structured in a fashion which makes it easy
C     to add further options..
C     To add another option, you will need :-
C     a. A control word (eg. IFIXWD ) in the arguments for  BUFFIT
C     b. A  section of code  with IF ( control word) --> ENDIF  -this must
C         be installed in the BUFFIT subroutine; between the IF-ENDIF you
C         need  the following:-
C     c. a CALL Gxxxx( arguments..) and a CALL Xxxxx(args..)
C       statements between the IF,ENDIF statements, where
C      Gxxx is the generating subroutine which sets up the option
C       and defines the use of the array A used in the search, and
C      Xxxxx is the subr. which reconstructs the fit etc from
C      the array A when the search is complete
C      d. a subroutine Fxxx which must be declared as EXTERNAL
C        inside Gxxxx, and whose name is substituted for the
C       FUNC argument when the CALL SEARCH(args..) is made
C       at the end of the Gxxxx subroutine. The Fxxx contains
C       the definition of the fitting function in terms of the
C       array A, and also calculates the derivatives of the function
C       with respect to each parameter( used by the search routines)
C
C       Note that the no. of fitted values of A ( MFIT) may be
C       less than the no. of values of A (MA), thus A(N) where
C       N = MFIT+1,,,MA may be constants. Also the two arrays
C       PEAKS,BKGRD are fed through into all the Gxxx & Fxxx
C      subroutines, but may be substituted for other useful
C      arrays...
C
C      ***********************************************************
C
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)  
      DIMENSION SPEC(8192),CENTIN(30),FWHMIN(30),FWLOIN(30)
      DIMENSION FIT(8192),BKGRD(8192),PEAKS(8192)
      DIMENSION CENTR(30),AREA(30),FWHM(30),FWHMLO(30),BAKFIT(6)
      DIMENSION HEIGHT(30),GWIDHI(30),GWIDLO(30)
      DIMENSION CENERR(30),ARERR(30),FWERR(30),FWLERR(30),BAKERR(6)
      DIMENSION HTERR(30),GWHERR(30),GWLERR(30)
      PARAMETER ( NCA=80 ,NCA1=NCA+2)
      DOUBLE PRECISION A(NCA),SUM(NCA1),COVAR(NCA,NCA),DA(10)              
C     
C
C
C
C
C
  660 FORMAT(8F10.2)
      WRITE(6,'(/'' BUFFIT-Birmingham University Fast FITting'')')
      WRITE(6,'(''  by N.M.Clarke: vs 3.0 23/11/92'')')
      WRITE(6,'('' Number of peaks='',I5)')NPEAK
      WRITE(6,'('' Number of background parameters='',I5)')NBACK
      WRITE(6,'('' Start channel='',I5,''  End Channel='',I5)')             
     > ICHAN,JCHAN
       IF(LORENTZ.NE.0)THEN
      WRITE(6,'('' Lorentzian peak shape'')')
      ISKEW=0
       IFIXWD=0
       IFIXCN=0
       ELSE
       IF(ISKEW.NE.0) THEN
      WRITE(6,'('' Asymmetric (skew) Gaussian shape '')')
       ELSE
      WRITE(6,'('' Symmetric Gaussian shape '')')
      ENDIF
      ENDIF
       IF(IPKSCH.NE.0)WRITE(6,'('' Search on Centroid guesses'')')
       IF(IFIXCN.NE.0) THEN
      WRITE(6,'('' Centroids of peaks fixed in search'')')
C      ISKEW=0
C       IVARWD=0
       ENDIF
      IF(IVARWD.EQ.0)THEN
             WRITE(6,'('' Single width, Fwhm='',F5.1)')WIDTH
      ELSE
             WRITE(6,'('' Different widths for peaks'')')
      ENDIF
      
      IF(IFIXWD.NE.0) THEN
      WRITE(6,'('' Width of peaks fixed in search'')')
C       ISKEW=0
      ENDIF
      
     
C
C
      IF(IPKSCH.NE.0) THEN
      CALL PKSRCH(SPEC,CENTIN,NCHAN,NPEAK,IPKSCH)
      ENDIF
C
C
      NDATA=JCHAN-ICHAN+1
      DATN=REAL(NDATA)
C
      TOTAL=0.0D0
      DO 1 J=ICHAN,JCHAN
      TOTAL=TOTAL+SPEC(J)
  1   CONTINUE
C
C
C
C
C     BEGIN CALLS TO SETUP SEARCHES
C      **********************************************************
C      SECTIONS FOR CASE WHERE IFIXWD OR IFIXCN ARE NE 0
C
C      FIXED WIDTHS ONLY
C
      IF(IFIXWD.NE.0) THEN
C 
C     SEARCH ON CENTROIDS AND PEAK HEIGHTS ONLY
C
C      
      IF( IFIXCN.EQ.0) THEN
C
      IF(ISKEW.EQ.0) THEN
C
C     FIXED WIDTHS, VARIABLE CENTROIDS FOR SYMMETRIC GAUSSIANS
C
      CALL GFWVC(SPEC,PEAKS,BKGRD,ICHAN,JCHAN,NPEAK,NBACK,
     * CENTIN,FWHMIN,WIDTH,A,COVAR,CHISQ,*4000)
4000  CONTINUE
C
      NPAR=2*NPEAK+NBACK
C
      CALL XFWVC(SPEC,NCHAN,ICHAN,JCHAN,NPEAK,NBACK,
     > TOTAL,FIT,PEAKS,BKGRD, CENTR,AREA,HEIGHT,
     > FWHM,FWHMLO,GWIDHI,GWIDLO,BKAREA,BAKFIT,
     > CENERR,ARERR,HTERR,FWERR,FWLERR,GWERR,GWLERR,BKAERR,BAKERR,
     > A,COVAR                       )
C
C
      ELSE
C
C     FIXED WIDTHS, VARIABLE CENTROIDS FOR SKEW GAUSSIANS
C
      CALL GSFWVC(SPEC,PEAKS,BKGRD,ICHAN,JCHAN,NPEAK,NBACK,
     * CENTIN,FWHMIN,WIDTH,WIDLO,A,COVAR,CHISQ,*4100)
4100  CONTINUE
C
      NPAR=2*NPEAK+NBACK
C
      CALL XSFWVC(SPEC,NCHAN,ICHAN,JCHAN,NPEAK,NBACK,
     > TOTAL,FIT,PEAKS,BKGRD, CENTR,AREA,HEIGHT,
     > FWHM,FWHMLO,GWIDHI,GWIDLO,BKAREA,BAKFIT,
     > CENERR,ARERR,HTERR,FWERR,FWLERR,GWERR,GWLERR,BKAERR,BAKERR,
     > A,COVAR                       )
C
      ENDIF
C
C      SEARCH ON HEIGHTS ONLY - FIXED CENTROIDS AND WIDTHS
C
      ELSE                         
C
      IF(ISKEW.EQ.0) THEN
C     
C      FIXED WIDTHS, FIXED CENTROIDS FOR SYMMETRIC GAUSSSIANS
C
      CALL GFWFC(SPEC,PEAKS,BKGRD,ICHAN,JCHAN,NPEAK,NBACK,
     * CENTIN,FWHMIN,WIDTH,A,COVAR,CHISQ,*4500)
4500  CONTINUE
      NPAR=NPEAK+NBACK
C
C
C
      CALL XFWFC(SPEC,NCHAN,ICHAN,JCHAN,NPEAK,NBACK,
     > TOTAL,FIT,PEAKS,BKGRD, CENTR,AREA,HEIGHT,
     > FWHM,FWHMLO,GWIDHI,GWIDLO,BKAREA,BAKFIT,
     > CENERR,ARERR,HTERR,FWERR,FWLERR,GWERR,GWLERR,BKAERR,BAKERR,
     > A,COVAR                       )
C
      ELSE
C
C      FIXED WIDTHS, FIXED CENTROIDS FOR SKEW GAUSSIANS
C
      CALL GSFWFC(SPEC,PEAKS,BKGRD,ICHAN,JCHAN,NPEAK,NBACK,
     * CENTIN,FWHMIN,WIDTH,WIDLO,A,COVAR,CHISQ,*4600)
4600  CONTINUE
      NPAR=NPEAK+NBACK
C
C
C
      CALL XSFWFC(SPEC,NCHAN,ICHAN,JCHAN,NPEAK,NBACK,
     > TOTAL,FIT,PEAKS,BKGRD, CENTR,AREA,HEIGHT,
     > FWHM,FWHMLO,GWIDHI,GWIDLO,BKAREA,BAKFIT,
     > CENERR,ARERR,HTERR,FWERR,FWLERR,GWERR,GWLERR,BKAERR,BAKERR,
     > A,COVAR                       )
C
      ENDIF
C

       ENDIF
       GOTO 800
       ENDIF
C
C
       IF(ISKEW.EQ.0.AND.LORENTZ.EQ.0) THEN
C
C      START SECTION FOR SYMMETRIC GAUSSIANS
C
       IF(IVARWD.EQ.0.AND.IFIXCN.EQ.0)THEN
C
C      SAME WIDTHS FOR All GAUSSIANS
C
      CALL GSYMF(SPEC,PEAKS,BKGRD,ICHAN,JCHAN,NPEAK,NBACK,
     * CENTIN,FWHMIN,WIDTH,A,COVAR,CHISQ,*5000)
5000  CONTINUE
C
      NPAR=2*NPEAK+NBACK+1
C
      CALL XSYMF(SPEC,NCHAN,ICHAN,JCHAN,NPEAK,NBACK,
     > TOTAL,FIT,PEAKS,BKGRD, CENTR,AREA,HEIGHT,
     > FWHM,FWHMLO,GWIDHI,GWIDLO,BKAREA,BAKFIT,
     > CENERR,ARERR,HTERR,FWERR,FWLERR,GWERR,GWLERR,BKAERR,BAKERR,
     > A,COVAR                       )
C
C      SECTION FOR GAUSSIANS OF DIFFERENT WIDTHS
C
       ENDIF
C
            IF(IVARWD.EQ.0.AND.IFIXCN.EQ.1) THEN
C
C      SAME WIDTHS FOR All GAUSSIANS WITH FIXED CENTROIDS
C
      CALL GSYMFC(SPEC,PEAKS,BKGRD,ICHAN,JCHAN,NPEAK,NBACK,
     * CENTIN,FWHMIN,WIDTH,A,COVAR,CHISQ,*5200)
5200  CONTINUE
C
      NPAR=  NPEAK+NBACK+1
C
      CALL XSYMFC(SPEC,NCHAN,ICHAN,JCHAN,NPEAK,NBACK,
     > TOTAL,FIT,PEAKS,BKGRD, CENTR,AREA,HEIGHT,
     > FWHM,FWHMLO,GWIDHI,GWIDLO,BKAREA,BAKFIT,
     > CENERR,ARERR,HTERR,FWERR,FWLERR,GWERR,GWLERR,BKAERR,BAKERR,
     > A,COVAR                       )
C
C
      ENDIF
C
C
C     DIFFERENT WIDTHS FOR GAUSSIANS
C
      IF(IVARWD.EQ.1.AND.IFIXCN.EQ.0) THEN
C
      CALL GSYM (SPEC,PEAKS,BKGRD,ICHAN,JCHAN,NPEAK,NBACK,
     * CENTIN,FWHMIN,WIDTH,A,COVAR,CHISQ,*5500)
5500  CONTINUE
C
      NPAR=3*NPEAK+NBACK  
C
      CALL XSYM (SPEC,NCHAN,ICHAN,JCHAN,NPEAK,NBACK,
     > TOTAL,FIT,PEAKS,BKGRD, CENTR,AREA,HEIGHT,
     > FWHM,FWHMLO,GWIDHI,GWIDLO,BKAREA,BAKFIT,
     > CENERR,ARERR,HTERR,FWERR,FWLERR,GWERR,GWLERR,BKAERR,BAKERR,
     > A,COVAR                       )
C
C
       ENDIF
       ENDIF
C
C      END OF SECTION WHERE ISKEW=0
C
C
C
       IF(ISKEW.EQ.1) THEN
C
C      SECTION FOR ASYMMETRIC (SKEW) GAUSSIANS
C
C
       IF(IVARWD.EQ.0) THEN
C
C
C      SAME WIDTHS (HI AND LO) FOR ALL GAUSSIANS
C
      CALL GSKEWF(SPEC,PEAKS,BKGRD,ICHAN,JCHAN,NPEAK,NBACK,
     * CENTIN,FWHMIN,WIDTH,A,COVAR,CHISQ,*6000)
6000  CONTINUE
C
      NPAR=2*NPEAK+NBACK+2
C
      CALL XSKEWF(SPEC,NCHAN,ICHAN,JCHAN,NPEAK,NBACK,
     > TOTAL,FIT,PEAKS,BKGRD, CENTR,AREA,HEIGHT,
     > FWHM,FWHMLO,GWIDHI,GWIDLO,BKAREA,BAKFIT,
     > CENERR,ARERR,HTERR,FWERR,FWLERR,GWERR,GWLERR,BKAERR,BAKERR,
     > A,COVAR                       )
C
C      SECTION FOR GAUSSIANS WITH DIFFERENT WIDTHS (HI AND LO)
C
       ELSE
C
C
      CALL GSKEW(SPEC,PEAKS,BKGRD,ICHAN,JCHAN,NPEAK,NBACK,
     * CENTIN,FWHMIN,WIDTH,A,COVAR,CHISQ,*6500)
6500  CONTINUE
C
      NPAR=4*NPEAK+NBACK  
C
      CALL XSKEW(SPEC,NCHAN,ICHAN,JCHAN,NPEAK,NBACK,
     > TOTAL,FIT,PEAKS,BKGRD, CENTR,AREA,HEIGHT,
     > FWHM,FWHMLO,GWIDHI,GWIDLO,BKAREA,BAKFIT,
     > CENERR,ARERR,HTERR,FWERR,FWLERR,GWERR,GWLERR,BKAERR,BAKERR,
     > A,COVAR                       )
C
C
       ENDIF
       ENDIF
C
C      END OF SECTION WHERE ISKEW=1
C
       IF(LORENTZ.EQ.1) THEN
C
C      START SECTION FOR LORENTZIANS 
C
       IF(IVARWD.EQ.0.AND.IFIXCN.EQ.0)THEN
C
C      SAME WIDTHS FOR All LORENTZIANS
C
      CALL GLORF(SPEC,PEAKS,BKGRD,ICHAN,JCHAN,NPEAK,NBACK,
     * CENTIN,FWHMIN,WIDTH,A,COVAR,CHISQ,*7000)
7000  CONTINUE
C
      NPAR=2*NPEAK+NBACK+1
C
      CALL XLORF(SPEC,NCHAN,ICHAN,JCHAN,NPEAK,NBACK,
     > TOTAL,FIT,PEAKS,BKGRD, CENTR,AREA,HEIGHT,
     > FWHM,FWHMLO,GWIDHI,GWIDLO,BKAREA,BAKFIT,
     > CENERR,ARERR,HTERR,FWERR,FWLERR,GWERR,GWLERR,BKAERR,BAKERR,
     > A,COVAR                       )
C
C
       ENDIF
C
C
C
C     DIFFERENT WIDTHS FOR LORENTZIANS
C
      IF(IVARWD.EQ.1.AND.IFIXCN.EQ.0) THEN
C
      CALL GLOR (SPEC,PEAKS,BKGRD,ICHAN,JCHAN,NPEAK,NBACK,
     * CENTIN,FWHMIN,WIDTH,A,COVAR,CHISQ,*7500)
7500  CONTINUE
C
      NPAR=3*NPEAK+NBACK  
C
      CALL XLOR(SPEC,NCHAN,ICHAN,JCHAN,NPEAK,NBACK,
     > TOTAL,FIT,PEAKS,BKGRD, CENTR,AREA,HEIGHT,
     > FWHM,FWHMLO,GWIDHI,GWIDLO,BKAREA,BAKFIT,
     > CENERR,ARERR,HTERR,FWERR,FWLERR,GWERR,GWLERR,BKAERR,BAKERR,
     > A,COVAR                       )
C
C
       ENDIF
       ENDIF
C
C      END OF SECTION WHERE LORENTZ=1
C
  800 CONTINUE
C
C    
      SUMG=0.0D0
      DO 810 J=1,NPEAK
      SUMG=SUMG+AREA(J)
 810  CONTINUE
C
C
      CHECK=1.0D2*( ( SUMG+BKAREA)-TOTAL)/TOTAL
      WRITE(6,'(''   Check=100*(Fit-Total)/Total = '',F7.2,'' %'')')     
     > CHECK
      CHISQF= DATN*CHISQ/(REAL(NDATA-NPAR))
      WRITE(6,'(''   Chisq per data point        = '',F10.2)')CHISQ             
      WRITE(6,'(''   Chisq per degree of freedom = '',F10.2//)')CHISQF
 1000 CONTINUE
  100 RETURN 
      END
