C
C
C
C     ****************************************************************
C
      SUBROUTINE FGAUS(X,A,Y,DYDA,NA,NPEAK,NBACK,ZP,ZB,NP,NB)
C
C
C     CALCULATES THE SPECTRUM FUNCTION AS SUM OF GAUSSIANS
C     WITH DIFFERENT WIDTHS AND A BACKGROUND POLYNOMIAL
C
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)  
      DOUBLE PRECISION A(NA),DYDA(NA),ZP(NP),ZB(NB)
*
      Y = 0.0
      DO  100  I = 1, NA-NBACK, 3
        ARG = (X-A(I))/A(I+2)
        IF( ABS(ARG) .LT. 10.0 ) THEN
          EX = EXP(-ARG**2)
        ELSE
          EX = 0.0
        ENDIF
        FAC = A(I+1)*EX*2.0*ARG
        Y = Y+A(I+1)*EX
        DYDA(I) = FAC/A(I+2)
        DYDA(I+1) = EX
        DYDA(I+2) = FAC*ARG/A(I+2)
100   CONTINUE
      DO  200  I = NA-NBACK+1, NA
        ARG = X**(I-NA+NBACK-1)
        Y = Y + A(I)*ARG
        DYDA(I) = ARG
200   CONTINUE
      END
