C
C
C     ****************************************************************
C
      SUBROUTINE FGAUSF(X,A,Y,DYDA,NA,NPEAK,NBACK,ZP,ZB,NP,NB)
C
C
C     CALCULATES THE SPECTRUM FUNCTION AS A SUM OF GAUSSIANS WITH
C     SAME WIDTH AND A BACKGROUND POLYNOMIAL
C
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)  
      DOUBLE PRECISION A(NA),DYDA(NA), ZP(NP),ZB(NB)
*
      Y = 0.0
      DYDA(2*NPEAK+1) = 0.0
      DO  100  I = 1, NA-NBACK-1, 2
        ARG = (X-A(I))/A(2*NPEAK+1)
        IF( ABS(ARG) .LT. 10.0 ) THEN
          EX = EXP(-ARG**2)
        ELSE
          EX = 0.0
        ENDIF
        FAC = A(I+1)*EX*2.0*ARG
        Y = Y+A(I+1)*EX
        DYDA(I) = FAC/A(2*NPEAK+1)
        DYDA(I+1) = EX
        DYDA(2*NPEAK+1) = DYDA(2*NPEAK+1)+FAC*ARG
100   CONTINUE
      DYDA(2*NPEAK+1) = DYDA(2*NPEAK+1)/A(2*NPEAK+1)
      DO  200  I = NA-NBACK+1, NA
        ARG = X**(I-NA+NBACK-1)
        Y = Y + A(I)*ARG
        DYDA(I) = ARG
200   CONTINUE
      END
