C
C
C     ****************************************************************
C
      SUBROUTINE FLORF(X,A,Y,DYDA,NA,NPEAK,NBACK,ZP,ZB,NP,NB)
C
C
C     CALCULATES THE SPECTRUM FUNCTION AS A SUM OF LORENTZIANS WITH
C     SAME WIDTH AND A BACKGROUND POLYNOMIAL
C
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)  
      DOUBLE PRECISION A(NA),DYDA(NA), ZP(NP),ZB(NB)
*
      Y = 0.0
      DYDA(2*NPEAK+1) = 0.0
      GAM=A(2*NPEAK+1)
      GAMSQ=GAM**2
      DO  100  I = 1, NA-NBACK-1, 2
        ARG = (X-A(I))
      ARGSQ=ARG**2
        IF( ARGSQ+GAMSQ .LT. 1.0D-20 ) THEN
          EX = 1.0D20
        ELSE
          EX = 1.0D0/(ARGSQ+GAMSQ)
        ENDIF
        FAC = GAMSQ*EX
        Y = Y+ A(I+1)*FAC
        DYDA(I) = A(I+1)*FAC*2.0D0*ARG*EX
        DYDA(I+1) = FAC
        DYDA(2*NPEAK+1)=DYDA(2*NPEAK+1) + 2.0D0*A(I+1)*EX*(1.0D0-FAC)
100   CONTINUE
      DYDA(2*NPEAK+1) = DYDA(2*NPEAK+1)*A(2*NPEAK+1)
      DO  200  I = NA-NBACK+1, NA
        ARG = X**(I-NA+NBACK-1)
        Y = Y + A(I)*ARG
        DYDA(I) = ARG
200   CONTINUE
      END
