#include <stdio.h>
#include <memory.h>


#define FIT_DIM 30
#define MAX_FIT_DIM 8192
#define BK_ORDER 6

typedef struct buffit_in {
      double spec[MAX_FIT_DIM];   /* input spectrum array */
      double centin[FIT_DIM];    /* input guesses for centroids */
      double fwhmin[FIT_DIM];    /* fwhm for each peak */
      double fwloin[FIT_DIM];    /* fwhm on low side for skew */
      double width;              /* fwhm of the peaks */
      double widlo;              /* fwhm of low side of the peaks */
      int    nchan;              /* dimension of input array */ 
      int    ichan;              /* start channel for fit */
      int    jchan;              /* end channel for fit */
      int    npeak;              /* number of peaks */
      int    nback;              /* order of background fit */
      int    ipksch;             /* flag > 0 search on peak centroid positions using value of ipksch */
      int    ivarwd;             /* flag == TRUE use fwhmin for peak widths ELSE use same width */
      int    iskew;              /* flag == TRUE use skew guassian */
      int    ifixwd;             /* flag == TRUE use fixed centroid widths */
      int    ifixcn;             /* flag == TRUE use fixed centroid positions */
      int    lorentz;            /* flag == TRUE use lorentzian shape for peak */
      int    offset;             /* channel offset ie spec[i] = data[i+offset] */
} buffit_in_t;

typedef struct buffit_out {
      double total;             /* total nos of counts between ichan & jchan */
      double centr[FIT_DIM];    /* calculated peak centroids */
      double cenerr[FIT_DIM];   /* error on peak centroids */
      double area[FIT_DIM];     /* calculated peak areas */
      double arerr[FIT_DIM];    /* error on peak areas */
      double height[FIT_DIM];   /* height of Gaussian */
      double hterr[FIT_DIM];    /* error on Gaussian height */
      double fwhm[FIT_DIM];     /* fwhm of peak */
      double fwerr[FIT_DIM];    /* error on fwhm of peak */
      double fwhmlo[FIT_DIM];   /* fwhm of low side of peak for skew peaks */
      double fwlerr[FIT_DIM];   /* error on fwhmlo */
      double gwidhi[FIT_DIM];   /* width for calculated gaussians */
      double gwherr[FIT_DIM];   /* error on width */
      double gwidlo[FIT_DIM];   /* width for calculated gaussians low side*/
      double gwlerr[FIT_DIM];   /* error on low side  width */
      double bkarea;            /* calculated background area */
      double bkaerr;            /* error on background area */
      double bakfit[BK_ORDER];  /* background parameters */
      double bakerr[BK_ORDER];  /* errors on background from fit */
      double chisq;             /* final chisq for fit */
      int    nchan;              /* dimension of input array */ 
      int    ichan;              /* start channel for fit */
      int    jchan;              /* end channel for fit */
      int    npeak;              /* number of peaks */
      int    nback;              /* order of background fit */
      int    iskew;              /* flag == TRUE use skew guassian */
      int    lorentz;            /* flag == TRUE use lorentzian shape for peak */
      int    offset;             /* channel offset ie spec[i] = data[i+offset] */
} buffit_out_t;

static  double fit[MAX_FIT_DIM+1], peaks[MAX_FIT_DIM+1], bkgrd[MAX_FIT_DIM+1];

main(argc,argv)
      int  argc;
      char *argv[];
{
      FILE *fp;
      int i;
      char *in_file, **ptr;
      char out_file[L_tmpnam+24];
      buffit_in_t buffin;
      buffit_in_t *bi= &buffin;
      buffit_out_t buffout;
      buffit_out_t *bo = &buffout;
      double *spec;
      int verbose = 0;

      for (ptr = argv; *ptr != NULL; ptr++) {
	    if (strcmp("-spectrum",*ptr) == 0) 
		  in_file = *(++ptr);
	    else if (strcmp("-verbose",*ptr) == 0)
		  verbose = 1;
      }
      
      if ( (fp = fopen(in_file,"r")) == NULL) {
	    fprintf(stderr,"Buffit proc: error opening input data file\n");
	    exit(1);
      }

      if (fread((char *) bi, sizeof(buffit_in_t), 1, fp) != 1) {
	    fprintf(stderr,"Buffit proc: error reading input data file\n");
	    exit(2);
      }
      (void) fclose(fp);
      (void) unlink(in_file);
      
      (void) memset((char *) bo, 0, sizeof(buffit_out_t));
      f_init();
      spec = &bi->spec[1];
      (void) buffit_(spec, &bi->nchan, &bi->ichan, &bi->jchan, &bi->npeak,
		     &bi->nback, bi->centin, bi->fwhmin, bi->fwloin, &bi->width,
		     &bi->widlo, &bi->ipksch, &bi->ivarwd, &bi->iskew, &bi->ifixwd,
		     &bi->ifixcn, &bi->lorentz,
		     &bo->total, fit, peaks, bkgrd, bo->centr, bo->area, bo->height,
		     bo->fwhm, bo->fwhmlo, bo->gwidhi, bo->gwidlo,
		     &bo->bkarea, bo->bakfit, bo->cenerr, bo->arerr,
		     bo->hterr, bo->fwerr, bo->fwlerr, bo->gwherr,
		     bo->gwlerr, &bo->bkaerr, bo->bakerr, &bo->chisq);

      bo->nchan = bi->nchan;
      bo->ichan = bi->ichan;         
      bo->jchan = bi->jchan;         
      bo->npeak = bi->npeak;         
      bo->nback = bi->nback;         
      bo->iskew = bi->iskew;         
      bo->lorentz = bi->lorentz;       
      bo->offset = bi->offset;

      sprintf(out_file,"%sBUFFIT_%d",P_tmpdir,getpid());
      if ( (fp = fopen(out_file,"w")) == NULL) {
	    fprintf(stderr,"Buffit proc: error opening output data file\n");
	    exit(1);
      }
      if (fwrite((char *) bo, sizeof(buffit_out_t), 1, fp) != 1) {
	    fprintf(stderr,"Buffit proc: error writing output data file\n");
	    exit(2);
      }
      (void) fclose(fp);

      if (verbose) {
	    if ( (fp = fopen("bfit.dat","w")) == NULL) {
		  fprintf(stderr,"Buffit proc: error opening output data file\n");
		  exit(1);
	    }
	    for (i=bi->ichan; i<= bi->jchan; i++)
		  fprintf(fp,"%d %lf\n", i, fit[i-1]);
	    (void) fclose(fp);
	    
	    if ( (fp = fopen("bpeaks.dat","w")) == NULL) {
		  fprintf(stderr,"Buffit proc: error opening output data file\n");
		  exit(1);
	    }
	    for (i=bi->ichan; i<= bi->jchan; i++)
		  fprintf(fp,"%d %lf\n", i, peaks[i-1]);
	    (void) fclose(fp);
	    
	    if ( (fp = fopen("bbkgrd.dat","w")) == NULL) {
		  fprintf(stderr,"Buffit proc: error opening output data file\n");
		  exit(1);
	    }
	    for (i=bi->ichan; i<= bi->jchan; i++)
		  fprintf(fp,"%d %lf\n", i, bkgrd[i-1]);
	    (void) fclose(fp);
      }

      return(0);
}
