C
C
C     ****************************************************************
C
      SUBROUTINE MRQCOF(X,Y,ZP,ZB,SIG,NDATA,A,MA,LISTA,MFIT,ALPHA,BETA,
     >                  NALP,CHISQ,FUNCS,NPEAK,NBACK)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)  
      EXTERNAL FUNCS
C
C
* Used by MRQMIN
* H.Press et al - NUMERICAL RECEPIES, Cambridge UP 86, page 527
*
      PARAMETER ( MMAX=150 )
      DOUBLE PRECISION X(NDATA), Y(NDATA), SIG(NDATA)
      DOUBLE PRECISION ZP(NDATA),ZB(NDATA)
      DOUBLE PRECISION ALPHA(NALP,NALP)
      DOUBLE PRECISION BETA(MA)
      DOUBLE PRECISION DYDA(MMAX)
      INTEGER LISTA(MFIT)
      DOUBLE PRECISION A(MA)
*
      DO  12  J=1,MFIT
        DO  11  K = 1, J
          ALPHA(J,K) = 0.0
11      CONTINUE
        BETA(J) = 0.0
12    CONTINUE
*
      CHISQ = 0.0
      DO  15  I = 1, NDATA
        CALL FUNCS(X(I),A,YMOD,DYDA,MA,NPEAK,NBACK,ZP,ZB,NDATA,NDATA)
        SIG2I = 1.0/(SIG(I)*SIG(I))
        DY = Y(I)-YMOD
        DO  14  J=1,MFIT
          WT = DYDA(LISTA(J))*SIG2I
          DO  13  K = 1, J
            ALPHA(J,K) = ALPHA(J,K) + WT*DYDA(LISTA(K))
13        CONTINUE
          BETA(J) = BETA(J) + DY*WT
14      CONTINUE
        CHISQ = CHISQ + DY*DY*SIG2I
15    CONTINUE
      CHISQ = CHISQ/REAL(NDATA)
*
      DO  17  J = 2, MFIT
        DO  16  K = 1, J-1
          ALPHA(K,J) = ALPHA(J,K)
16      CONTINUE
17    CONTINUE
      END
