C
C
C     ****************************************************************
C
      SUBROUTINE MRQMIN(X,Y,ZP,ZB,SIG,NDATA,A,MA,LISTA,MFIT,
     >      COVAR,ALPHA,NCA,CHISQ,FUNCS,NPEAK,NBACK,ALAMDA,IERR)
C
C
C
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)  
      EXTERNAL FUNCS
C
C
* Levenberg-Marquardt nonlinear chisq fit
* H.Press et al - NUMERICAL RECEPIES, Cambridge UP 86, page 526
* IERR added - set to 1 if LISTA contains improper permutation
*                     2 if covariance matrix is cannot be converted
*
      PARAMETER ( MMAX=150 )
      DOUBLE PRECISION X(NDATA), Y(NDATA), SIG(NDATA)
      DOUBLE PRECISION ZP(NDATA),ZB(NDATA)
      DOUBLE PRECISION A(MA)
      INTEGER LISTA(MA)
      DOUBLE PRECISION COVAR(NCA,NCA), ALPHA(NCA,NCA)
      DOUBLE PRECISION ATRY(MMAX), BETA(MMAX), DA(MMAX)
*
*   Initialization
      IERR = 0
      IF( ALAMDA .LT. 0 ) THEN
        KK = MFIT + 1
        DO  12  J=1,MA
          IHIT = 0
          DO  11  K = 1, MFIT
            IF( LISTA(K) .EQ. J ) IHIT = IHIT + 1
11        CONTINUE
          IF( IHIT .EQ. 0 ) THEN
            LISTA(KK) = J
            KK = KK + 1
          ELSE IF( IHIT .GT. 1 ) THEN
            IERR = 1
            RETURN
          ENDIF
12      CONTINUE
        IF( KK .NE. (MA+1) ) THEN
          IERR = 1
          RETURN
        ENDIF
        ALAMDA = 0.001
        CALL MRQCOF(X,Y,ZP,ZB,SIG,NDATA,A,MA,LISTA,MFIT,ALPHA,BETA,NCA,
     >                    CHISQ,FUNCS,NPEAK,NBACK)
        OCHISQ = CHISQ
        DO  13  J=1,MA
          ATRY(J) = A(J)
13      CONTINUE
      ENDIF
*
      DO  15  J=1,MFIT
        DO  14  K = 1, MFIT
          COVAR(K,J) = ALPHA(K,J)
14      CONTINUE
        COVAR(J,J) = ALPHA(J,J)*(1.0+ALAMDA)
        DA(J) = BETA(J)
15    CONTINUE
*
*   Matrix solution
      CALL GAUSSJ(COVAR,MFIT,NCA,DA,1,1,IERR)
      IF( IERR .NE. 0 ) THEN
        IERR = 2
        RETURN
      ENDIF
*
*  If converged, evaluate covariance matrix
      IF( ALAMDA .EQ. 0.0 ) THEN
        CALL COVSRT(COVAR,NCA,MA,LISTA,MFIT)
        RETURN
      ENDIF
*
      DO  16  J=1,MFIT
        ATRY(LISTA(J)) = A(LISTA(J))+DA(J)
16    CONTINUE
      CALL MRQCOF(X,Y,ZP,ZB,SIG,NDATA,ATRY,MA,LISTA,MFIT,COVAR,DA,NCA,
     >                    CHISQ,FUNCS,NPEAK,NBACK)
      IF( CHISQ .LT. OCHISQ ) THEN
* accept new solution
        ALAMDA = 0.1*ALAMDA
        OCHISQ = CHISQ
        DO  18  J=1,MFIT
          DO  17  K = 1, MFIT
            ALPHA(K,J) = COVAR(K,J)
17        CONTINUE
          BETA(J) = DA(J)
          A(LISTA(J)) = ATRY(LISTA(J))
18      CONTINUE
      ELSE
* failure - increase ALAMDA  and return
        ALAMDA = 10.0*ALAMDA
        CHISQ = OCHISQ
      ENDIF
      END
