C
C
C     **************************************************************
      SUBROUTINE SKETCH(SPEC,NAME,TITLE,NCHAN,ICHAN,JCHAN,        
     > NPEAK,NBACK,FIT,BKGRD,
     > CENTR,CENERR,AREA,ARERR,FWHM,FWHMLO,FWERR,FWLERR,BKAREA,BKAERR,
     > BAKFIT,BAKERR, HEIGHT,HTERR,
     > CHISQ,TAG,NTAG,ISKEW,LORENTZ,LOGLIN,fiton)
C
C
C     PRODUCES THE INPUT FILE FOR PSSKETCH FROM THE OUTPUT OF BUFFIT
C
C     By N M Clarke, University of Birmingham, 1992
C
C     VERSION 3.0 23/11/92
C
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION SPEC(NCHAN),FIT(NCHAN),BKGRD(NCHAN)
      DIMENSION CENTR(NPEAK),CENERR(NPEAK),AREA(NPEAK),ARERR(NPEAK),
     >FWHM(NPEAK),FWHMLO(NPEAK),FWERR(NPEAK),FWLERR(NPEAK),
     > BAKFIT(6),BAKERR(6),HEIGHT(NPEAK),HTERR(NPEAK)
      DIMENSION TAG(NPEAK)
      CHARACTER NAME*(*),TITLE*(*)
      LOGICAL fiton 
C
C
C    SETUP THE PICTURE AREA FOR PSSKETCH
C
      WRITE(4,1001) 
      WRITE(4,1)
  1   FORMAT('PICTURE 6 16 18 26')
 1001 FORMAT('A4P') 
C
C    FIND MAX YSCALE
C
C
      YMIN=+1.0E10
      YMAX=-1.0E6
      DO 10 N=ICHAN,JCHAN
      IF(SPEC(N).GE.YMAX)YMAX=SPEC(N)
******
      If (fiton) then 
******
      IF(FIT(N).GE.YMAX)YMAX=FIT(N)
      IF(BKGRD(N).GE.YMAX)YMAX=BKGRD(N)
      endif 
      IF(SPEC(N).LE.YMIN)YMIN=SPEC(N)
      if (fiton) then 
      IF(FIT(N).LE.YMIN)YMIN=FIT(N)
      IF(BKGRD(N).LE.YMIN)YMIN=BKGRD(N)
******
      endif 
******
  10  CONTINUE
C
C     SET MINIMUM IN Y SCALE
C
      IF(LOGLIN.NE.0)THEN
      WRITE(4,14)
  14  FORMAT('LOGY')
      IYMIN=INT(LOG10(DMAX1(0.1D0,YMIN))  )
      IYMIN=MAX(IYMIN,-1)
      YMIN=10.0**IYMIN
      ELSE
      YMIN=0.0
      ENDIF
C
      MCHAN=JCHAN-ICHAN+1
C
C     FIND RANGE OF YVALUES AND ALLOW SOME SPACE AT TOP OF SPECTRUM
C
C
      IYRANG=INT(LOG10(1.25*YMAX))
      IPWR=10**IYRANG
      IMULT=INT(1.25*YMAX/REAL(IPWR) +1)
      YMAX=REAL(IMULT*IPWR)                          
      YINC=REAL(IPWR)                
      IF(IMULT.GT.5)YINC=2.0*REAL(IPWR)
      WRITE(4,12)YMIN,YMAX,YINC
  12  FORMAT('SCALE Y ',F10.1,1X,F12.0,1X,F12.0)
CC
C    WRITE OUT XSCALE
C
      WRITE(4,11)ICHAN,JCHAN
  11  FORMAT('SCALE X ',I4,1X,I4 )    
C
C
C
C    NOW WRITE SPECTRUM OUT BETWEEN ICHAN AND JCHAN               
C
*      WRITE(4,2)     
****
      write(4,1003) 
      write(4,1002)
****
*  2   FORMAT('SYMBOL CIRCLE 2.0')           
****
 1003 format('LINE ON')
 1002 format('LINE SOLID') 
****
      WRITE(4,3)
  3   FORMAT('DATA')
      DO 15 N=ICHAN,JCHAN
      WRITE(4, 5)REAL(N)-0.5,SPEC(N)                      
      WRITE(4, 5)REAL(N)+0.5,SPEC(N)
  5   FORMAT(2F12.2)   
 15   CONTINUE
*
*****
      if (fiton) then 
*****
*
      WRITE(4,215)
 215  FORMAT('SYMBOL OFF')
C
C    NOW WRITE OUT FIT IN DOTTED LINE
C
      WRITE(4,4)
  4   FORMAT('LINE DOTTED')                                
      WRITE(4,3)
      DO 20 N=ICHAN,JCHAN
      if(loglin.eq.0)then
      write(4,5)real(n),fit(n)
       else if(loglin.ne.0.and.fit(n).le.0.1)then
       write(4,5)real(n),0.1
       else if(loglin.ne.0.and.fit(n).gt.0.1) then
      WRITE(4,5) REAL(N),FIT(N)                   
      endif 
  20  CONTINUE
CC
C
C     WRITE OUT TAGS
C
      DO 25 I=1,NTAG
      WRITE(4,3)
      WRITE(4,5)TAG(I),YMIN
      WRITE(4,5)TAG(I),YMAX
  25  CONTINUE
C
C    NOW WRITE OUT BACKGROUND FIT IN DASHED LINE
C
      WRITE(4,7)
  7   FORMAT('LINE DOTDASH')
      WRITE(4,3)
      DO 30 N=ICHAN,JCHAN 
      WRITE(4,5) REAL(N),BKGRD(N)                 
  30  CONTINUE
*****
      endif
*****
      WRITE(4,131)
 131  FORMAT('LINE OFF')
C
C      WRITE X AND Y AXIS LABELS   
C
      WRITE(4,32)
 32   FORMAT('XTEXT 9.5  14.5 \\T20 Channel Number')
      WRITE(4,33)
 33   FORMAT('YTEXT 3 19 \\T20 Counts per Channel')
C
C
C    NOW WRITE TITLE UNDER SPECTRUM
C
      WRITE(4,16)NAME 
 16   FORMAT('XTEXT 2.5 13.0 \\T20 ',A40)   
      WRITE(4,17)TITLE
  17  FORMAT('XTEXT 2.5 12.0 \\T20 ',A40) 
C
******
       if (fiton) then 
******
C
C
C                         
C      WRITE OUT FITS
C
C      WRITE OUT BUFFIT LOGO AND CHISQ
C
      IF(ISKEW.EQ.0.AND.LORENTZ.EQ.0)THEN
       WRITE(4,41)CHISQ
  41   FORMAT('XTEXT 3.0 11.0 \\C8  BUFFIT with Gaussians:  Chisq=',     
     > 1PE10.3,' per point')
      ENDIF
      IF (ISKEW.EQ.1.AND.LORENTZ.EQ.0) THEN
       WRITE(4,421)CHISQ
 411   FORMAT('XTEXT 3.0 11.0 \\C8  BUFFIT with Skew Gaussians:  Chisq=',    
     > 1PE10.3,' per point')
       ENDIF
       IF(LORENTZ.EQ.1) THEN
       WRITE(4,421)CHISQ
 421   FORMAT('XTEXT 3.0 11.0 \\C8  BUFFIT with Lorentzians:  Chisq=',    
     > 1PE10.3,' per point')
       ENDIF

C
C      WRITE OUT BACKGROUND AREA AND PARAMETERS
C
       WRITE(4,43)BKAREA,BKAERR
 43    FORMAT('XTEXT 3.0 10.7 \\C8  Background Area=',F12.1,' +/- ',      
     > F12.1)
       WRITE(4,44)
 44    FORMAT('XTEXT 3.0 10.4 \\C8  N  Bakfit(N)   Bakerr(N)',
     >  '  N  Bakfit(N)   Bakerr(N)')
       YOFF=10.1
       DO 45 I=1,NBACK,2     
       WRITE(4,46)YOFF,I,BAKFIT(I),BAKERR(I),I+1,BAKFIT(I+1),BAKERR(I+1)
 46    FORMAT('XTEXT 3.0 ',F5.2,' \\C8',I3,1X,1PE10.3,'+/-',  E9.3,
     > I3,1X,E10.3, '+/-' ,E9.3)
       YOFF=YOFF-0.30
  45   CONTINUE
      IF(ISKEW.EQ.0.AND.LORENTZ.EQ.0)THEN
       WRITE(4,31)
  31  FORMAT('XTEXT 3.0 9.2 \\C8 ',1X,'N',5X,'Centroid',14X,'Area',14X,
     > 'Fwhm')
      ENDIF
      IF(ISKEW.EQ.0.AND.LORENTZ.EQ.1) THEN
        WRITE(4,331)
  331  FORMAT('XTEXT 3.0 9.2 \\C8 ',1X,'N',5X,'Centroid',14X,'Height',12X,
     > 'Fwhm')
      ENDIF
       IF(ISKEW.EQ.1.AND.LORENTZ.EQ.0)THEN
      WRITE(4,231)
 231  FORMAT('XTEXT 3.0 9.2 \\C8 ',1X,'N',5X,'Centroid',14X,'Area',14X,
     > 'FwhmHi/Lo')
      ENDIF
       IF(ISKEW.EQ.1.AND.LORENTZ.EQ.1) THEN
        WRITE(4,431)
  431  FORMAT('XTEXT 3.0 9.2 \\C8 ',1X,'N',5X,'Centroid',14X,'Height',12X,
     > 'FwhmHi/Lo')
      ENDIF

      YOFF=8.9
      DO 50 I=1,NPEAK 
      WRITE(4,55)YOFF,I,CENTR(I),CENERR(I),AREA(I),ARERR(I),
     > FWHM(I),FWERR(I)
      IF(LORENTZ.NE.0)THEN
       WRITE(4,55)YOFF,I,CENTR(I),CENERR(I),HEIGHT(I),HTERR(I),                 
     > FWHM(I),FWERR(I)
       ENDIF
 55   FORMAT('XTEXT 3.0 ',F4.1,' \\C8',  I3,2X,F7.2, '+/-' ,F7.2,1X,    
     >F10.1, '+/-' ,F9.1 ,   F7.2, '+/-' ,F6.2)
       YOFF=YOFF-0.30
      IF(ISKEW.NE.0) THEN
      WRITE(4,59)YOFF,FWHMLO(I),FWLERR(I)                                      
 59   FORMAT('XTEXT 3.0 ',F4.1,' \\C8',45X,F7.2,'+/-',F6.2)             
       YOFF=YOFF-0.30
       ENDIF
  50   CONTINUE
******
       end if 
******
      RETURN
      END
