#include <stdio.h>
#include <math.h>
#include <memory.h>
#include <malloc.h>

#include "globals.h"
static int setactive();
static char *my_realloc();

typedef struct {
      int      active;
      int      len;
      double   *x, *y;
      double xmin, xmax;		
      double ymin, ymax;
} sets;

static sets data[MAXARR]; /* private data ... don't access directly */

int new_set(len)
      int len;
{
      int i;
      for (i=0; i<MAXARR; i++) {
	    if ( setactive(i) == 0) {
		  data[i].active = i+1;
		  if ( (data[i].x = (double *) calloc(len, sizeof(double))) == NULL) {
			fprintf(stderr,"couldn't allocate memory\n");
			return(-1);
		  }
		  if ( (data[i].y = (double *) calloc(len, sizeof(double))) == NULL) { 
			fprintf(stderr,"couldn't allocate memory\n");
			return(-1);
		  }
		  data[i].len = len;
		  return i;
	    }
      }
      fprintf(stderr,"no more sets available\n");
      return -1;
}
int delete_set(setno)
      int setno;
{
      if ( setactive(setno)) {
	    cxfree(data[setno].x);
	    cxfree(data[setno].y);
	    data[setno].x = data[setno].y = NULL;
	    data[setno].len = data[setno].active = 0;
	    data[setno].xmin = data[setno].xmax = 0;
	    data[setno].ymin = data[setno].ymax = 0;
	    return(0);
      }
      return(-1);
}

int swap_sets(set1,set2)
      int set1, set2;
{
      sets tmp;
      if (setactive(set1) && setactive(set2)) {
	    (void) memcpy((char *) &tmp, (char *) &data[set1], sizeof(sets));
	    (void) memcpy((char *) &data[set1], (char *) &data[set2], sizeof(sets));
	    (void) memcpy((char *) &data[set2], (char *) &tmp, sizeof(sets));
	    return(0);
      }
      return(-1);
}

int swap_sets_x(set1,set2)
      int set1, set2;
{
      double *xtmp;
      if (setactive(set1) && setactive(set2)) {
	    xtmp = data[set1].x;
	    data[set1].x = data[set2].x;
	    data[set2].x = xtmp;
	    return(0);
      }
      return(-1);
}
int swap_sets_y(set1,set2)
      int set1, set2;
{
      double *ytmp;
      if (setactive(set1) && setactive(set2)) {
	    ytmp = data[set1].y;
	    data[set1].y = data[set2].y;
	    data[set2].y = ytmp;
	    return(0);
      }
      return(-1);
}

int copyset(set1,set2)  /* set1 == from set; set2 == to set */
      int set1, set2;
{
      if (copyset_x(set1,set2) == -1) return(-1);
      if (copyset_y(set1,set2) == -1) return(-1);
      return(0);
}

int copyset_x(set1,set2)
      int set1, set2; 
{
      if (setactive(set1) && setactive(set2)) {
	    int len1, len2, copylen;
	    len1 = getsetlen(set1);
	    len2 = getsetlen(set2);
	    copylen = (len1 > len2) ? len2 : len1;
	    if (len1 >= len2) {
		  (void) memcpy((char *) data[set2].x, (char *) data[set1].x, sizeof(double)*len2);
	    }
	    else {
		  (void) memset((char *) data[set2].x,0,sizeof(double)*len2);
		  (void) memcpy((char *) data[set2].x, (char *) data[set1].x, sizeof(double)*len1);
	    }
	    return(0);
      }
      return(-1);
}
int copyset_y(set1,set2)
      int set1, set2;
{
      if (setactive(set1) && setactive(set2)) {
		    int len1, len2, copylen;
	    len1 = getsetlen(set1);
	    len2 = getsetlen(set2);
	    if (len1 >= len2) {
		  (void) memcpy((char *) data[set2].y, (char *) data[set1].y, sizeof(double)*len2);
	    }
	    else {
		  (void) memset((char *) data[set2].y,0,sizeof(double)*len2);
		  (void) memcpy((char *) data[set2].y, (char *) data[set1].y, sizeof(double)*len1);
	    }
	    return(0);
      }
      return(-1);
}

static int setactive(setno)
      int setno;
{
      if (setno >=0 && setno < MAXARR)
	    if ( data[setno].active != 0)
		  return(1);
      return(0);
}

double *getsetx(setno)
      int setno;
{
      if (setactive(setno)) {
	    return data[setno].x;
      }
      return NULL;
}
double *getsety(setno)
      int setno;
{
      if (setactive(setno)) {
	    return data[setno].y;
      }
      return NULL;
}
int getsetlen(setno)
      int setno;
{
      if (setactive(setno)) {
	    return data[setno].len;
      }
      return 0;
}
int setsetlen(setno,newlen)
      int setno;
      int newlen;
{
      int oldlen;
      if (setactive(setno)) {
	    oldlen = data[setno].len;
	    if (newlen <= oldlen) {
		  data[setno].len = newlen;
	    }
	    else {
		  if ( (data[setno].x = (double *) my_realloc(
		      (char *) data[setno].x, oldlen, newlen, sizeof(double))) == NULL)
			return(0);
		  if ( (data[setno].y = (double *) my_realloc(
		      (char *) data[setno].y, oldlen, newlen, sizeof(double))) == NULL)
			return(0);
		  data[setno].len = newlen;
	    }
	    return(newlen);
      }
      return 0;
}

/*
 * compute the mins and maxes of a vector x
 */
void minmax(x, n, xmin, xmax, imin, imax)
    double *x;
    int n;
    double *xmin, *xmax;
    int *imin, *imax;
{
    int i;

    *xmin = x[0];
    *xmax = x[0];
    *imin = 1;
    *imax = 1;
    for (i = 1; i < n; i++) {
	if (x[i] < *xmin) {
	    *xmin = x[i];
	    *imin = i + 1;
	}
	if (x[i] > *xmax) {
	    *xmax = x[i];
	    *imax = i + 1;
	}
    }
}


/*
 * compute the mins/maxes and update the appropriate fields of
 * set i.
 */
void nupdatesetminmax(setno)
    int setno;
{
    double x1, x2;
    int itmp1, itmp2;

    if (setactive(setno)) {
	minmax(getsetx(setno), getsetlen(setno), &x1, &x2, &itmp1, &itmp2);
	data[setno].xmin = x1;
	data[setno].xmax = x2;
	minmax(getsety(setno), getsetlen(setno), &x1, &x2, &itmp1, &itmp2);
	data[setno].ymin = x1;
	data[setno].ymax = x2;
    } else {
	data[setno].xmin = 0.0;
	data[setno].xmax = 0.0;
	data[setno].ymin = 0.0;
	data[setno].ymax = 0.0;
    }
}
/*
 * get the min/max fields of a set
 */
void ngetsetminmax(setno, x1, x2, y1, y2)
    int setno;
    double *x1, *x2, *y1, *y2;
{
      if (setactive(setno)) {
	    *x1 = data[setno].xmin;
	    *x2 = data[setno].xmax;
	    *y1 = data[setno].ymin;
	    *y2 = data[setno].ymax;
      }
}

/*
 * sort a set - only does type XY
 * sorton:  0=x, 1=y
 * stype:   0=ascending, 1=decending
 */
void nsort_xy(setno, sorton, stype)
    int setno, sorton, stype;
{

    int d, i, j;
    int lo = 0;
    double t1, t2;
    double *tmp1 = getsetx(setno);
    double *tmp2 = getsety(setno);
    int up = getsetlen(setno);

    if (sorton == 1) {
	double *ttmp;

	ttmp = tmp1;
	tmp1 = tmp2;
	tmp2 = ttmp;
    }
    up--;

    for (d = up - lo + 1; d > 1;) {
	if (d < 5)
	    d = 1;
	else
	    d = (5 * d - 1) / 11;
	for (i = up - d; i >= lo; i--) {
	    t1 = tmp1[i];
	    t2 = tmp2[i];
	    if (!stype) {
		for (j = i + d; j <= up && (t1 > tmp1[j]); j += d) {
		    tmp1[j - d] = tmp1[j];
		    tmp2[j - d] = tmp2[j];
		}
		tmp1[j - d] = t1;
		tmp2[j - d] = t2;
	    } else {
		for (j = i + d; j <= up && (t1 < tmp1[j]); j += d) {
		    tmp1[j - d] = tmp1[j];
		    tmp2[j - d] = tmp2[j];
		}
		tmp1[j - d] = t1;
		tmp2[j - d] = t2;
	    }
	}
    }
}

int select_subset(setno,start,stop)
      int setno;
      double start, stop;
{
      int i, starti, stopi;
      int subset, setlen1, setlen2;
      double *xtmp1, *ytmp1, *xtmp2, *ytmp2;

      if ( ! setactive(setno)) {
	    errwin("set not active");
	    return(-1);
      }

      xtmp1 = getsetx(setno);
      ytmp1 = getsety(setno);
      setlen1 = getsetlen(setno);

      if (start >= stop) {
	    errwin("start bound gt stop bound");
	    return(-1);
      }

/* find indices corresponding to start and stop of region of interest */
      for (i=0; i<setlen1; i++) {
	    if ( xtmp1[i] >= start) {
		  starti = i;
		  break;
	    }
      }
      if (i == setlen1) return(-1);
      for (i=starti; i<setlen1; i++) {
	    if ( xtmp1[i] > stop)
		  break;
      }
      stopi = i-1;
/* define new sub set with data from with start and stop */      
      if ( (setlen2 = stopi - starti + 1) <= 1)
	    return(-1);
      if ( (subset = new_set(setlen2)) == -1)
	    return(-1);
      xtmp2 = getsetx(subset);
      ytmp2 = getsety(subset);
/* copy data over */
      for(i=stopi; i >= starti; i--) {
	    xtmp2[i-starti] = xtmp1[i];
	    ytmp2[i-starti] = ytmp1[i];
      }
      nupdatesetminmax(subset);
      return(subset);
}
    
static char *my_realloc(ptr, old_size, new_size, elsize)
      char     *ptr;
      int      old_size;
      int      new_size;
      int      elsize;
{
      char *new_ptr;
      int  copy_size = (new_size > old_size) ? old_size : new_size;
      if (ptr == NULL) return(NULL);
      if ( (new_ptr = calloc(new_size, elsize)) == NULL) {
	    fprintf(stderr,"reallocation of spectrum memory storage failed\n");
	    return(NULL);
      }
      (void) memcpy(new_ptr, ptr, (unsigned) copy_size*elsize);
      (void) free(ptr);
      return(new_ptr);
}
