/* $Id: events.c,v 1.69 1992/09/05 04:35:12 pturner Exp pturner $
 *
 * event handler - for both Motif and XView
 *
 */

#include <stdio.h>
#include <math.h>

#include <X11/X.h>
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/keysym.h>

#ifdef XVIEW
#include <X11/Xlib.h>
#include <xview/xview.h>
#include <xview/frame.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/cursor.h>


/*
 * items for the most part on the main panel declared in xvgr.c
 */
extern Frame main_frame;
extern Panel_item legend_x_panel, legend_y_panel; 	/* from symwin.c */
/* extern Panel_item timestamp_x_item, timestamp_y_item; */	/* from pagewin.c */
extern Canvas canvas;
extern Panel_item loclab;
extern Panel_item locate_item;
extern Panel_item stack_depth_item;
extern Panel_item curw_item;
/*extern Panel_item locate_point_item; */

/* canvas paint window */
extern Xv_Window paint_window;

#endif

#ifdef MOTIF

#include <Xm/Xm.h>

/* extern Widget legend_x_panel, legend_y_panel; */	/* from symwin.c */
extern Widget canvas;
extern Widget loclab;
extern Widget locate_item;
/*extern Widget locate_point_item; */
extern Widget stack_depth_item;
extern Widget curw_item;
extern XmStringCharSet charset;
extern XmString string, astring, pstring;
extern XmString sdstring, cystring;
extern Colormap mycmap;
static Arg al;

#endif

/* TODO this doesn't belong here */
int cursortype = 0;
static int cursor_oldx = -1, cursor_oldy = -1;

/* for pointer based set operations */
static int setno1, setno2, graphno1, graphno2, loc1, loc2;

/*
 * conversion from world to viewport coords defined in draw.c
 */
double xconv(), yconv();
double setcharsize();
void motion();
void select_line();
void select_region();

#include "globals.h"
/* things that should be moved to at some stage */
#define EXPAND_1ST 61
#define EXPAND_2ND 62
#define INTEGRATE_1ST 63
#define INTEGRATE_2ND 64
#define FIT_TAGS 65
#define MAXPEAKS 6

/*
 * xlib objects for drawing
 */
Display *disp;
GC gc;
GC gcxor;
GC gcclr;
Window xwin;

XGCValues gc_val;
int bgcolor = 0, fgcolor = 1;
extern int win_h, win_w;	/* declared in xvlib.c */
/* these probably belong in globals.h TODO */
int doclear = 1;		/* clear the screen if true before drawing */
int noerase = 1;

int rectflag = 0;		/* if an xor'ed rectangle is drawn with mouse */
int rubber_flag = 0;		/* set rubber band line */
int mbox_flag = 0;		/* moving box attached to cursor */
int mline_flag = 0;		/* moving line attached to cursor */

int go_locateflag = TRUE;	/* locator */

int add_setno;			/* set to add points - set in ptswin.c */
/* extern */ int move_dir;		/* restriction on point movement, declared in
				 * ptswin.c */

void draw_focus();
void set_action();

/*
 * variables for the canvas event proc
 */
static int sx, sy;
static int old_x, old_y;
static int xs, ys;
static int action_flag = 0;
static int setindex = 0;
static int setnumber = 0;

/*
 * variables for the text handling routine
 */
static int strx = 0, stry = 0;
static int drawx = 0, drawy = 0;
static char tmpstr[256];
static int justflag = 0;
static double si = 0.0;
static double co = 1.0;

/*
 *  added for taging operations
 */
int tag1, tag2;
int *fit_array, nos_fit_tags;
void (*update_tags_func)();

/*
 * added by sjah
 *
 */
int track_point = 0; /* moved from definition in ptswin.c */
extern void draw_tmp_tag();
extern int get_chan_content();
extern int set_tag_ok();
extern int define_tag_line();
extern int define_tag_string();
extern void clear_graph_viewport();

/*
 * draw all active graphs, when graphs are drawn, draw the focus markers
 */
void drawgraph2(graphno)
      int graphno;
{
    int i;

    if (inwin && (auto_redraw || force_redraw)) {
	if (cursortype) {
	    cursor_oldx = cursor_oldy = -1;
	}
	set_wait_cursor(NULL);
	set_right_footer("Redraw...");
	if (graphno == -1) {
	      initgraphics(tdevice);
	      for (i = 0; i < MAXGRAPH; i++) {
		    if (isactive_graph(i) && !g[i].hidden) {
			  if (checkon_ticks(i) && checkon_world(i) && checkon_viewport(i)) {
				plotone(i);
				draw_annotation(i);
			  }
		    }
	      }
	}
	else { /* don't clear frame in initgraphics !!! */
	      doclear = 0;
	      initgraphics(tdevice);
	      if (isactive_graph(graphno) && !g[graphno].hidden) {
		    if (checkon_ticks(graphno) && checkon_world(graphno) && checkon_viewport(graphno)) {
			  plotone(graphno);
			  draw_annotation(graphno);
		    }
	      }
	      doclear = 1;
	}
	draw_annotation(-1);
	defineworld(g[cg].w.xg1, g[cg].w.yg1, g[cg].w.xg2, g[cg].w.yg2, islogx(cg), islogy(cg));
	viewport(g[cg].v.xv1, g[cg].v.yv1, g[cg].v.xv2, g[cg].v.yv2);
	leavegraphics();
	draw_focus(cg);
	force_redraw = FALSE;
	set_right_footer(NULL);
	unset_wait_cursor(NULL);
    }

}

/*
 * force a redraw when auto-redraw is OFF
 */
void doforce_redraw()
{
    double wx, wy;

    force_redraw = TRUE;
    if (tmpstr[0]) {
	device2world(strx, win_h - stry, &wx, &wy);
	define_string(tmpstr, wx, wy);
	tmpstr[0] = 0;
    }
    inwin = TRUE;		/* just in case refresh was never called on
				 * start up */

    drawgraph2(-1);
}

/*
 * set hardcopy flag and if writing to a file, check
 * to see if it exists
 */
void do_hardcopy()
{
    FILE *fp;
    int i;
    extern int ptofile;		/* defined in printwin.c */
    extern char printstr[];	/* defined in printwin.c */

    set_right_footer("Print");
    if (ptofile) {
	if (fexists(printstr)) {
	    hardcopyflag = FALSE;
	    set_right_footer(NULL);
	    return;
	}
	fp = fopen(printstr, "w");
	if (fp == NULL) {
	    sprintf(buf, "Can't open %s for write, hardcopy aborted", printstr);
	    errwin(buf);
	    hardcopyflag = FALSE;
	    set_right_footer(NULL);
	    return;
	}
	fclose(fp);
    }
    hardcopyflag = TRUE;
    if (initgraphics(hdevice) != -1) {
	for (i = 0; i < MAXGRAPH; i++) {
	    if (isactive_graph(i) && !g[i].hidden) {
		if (checkon_ticks(i) && checkon_world(i) && checkon_viewport(i)) {
		    plotone(i);
		    draw_annotation(i);
		}
	    }
	}
	draw_annotation(-1);
	leavegraphics();
    } else {
	errwin("Hardcopy failed");
    }
    hardcopyflag = FALSE;
    if (inwin) {
	doclear = 0;
	initgraphics(0);
	doclear = 1;
	defineworld(g[cg].w.xg1, g[cg].w.yg1, g[cg].w.xg2, g[cg].w.yg2, islogx(cg), islogy(cg));
	viewport(g[cg].v.xv1, g[cg].v.yv1, g[cg].v.xv2, g[cg].v.yv2);
	set_right_footer(NULL);
    }
}

/*
 * event proc for zooms
 */
void do_zoom()
{
    set_action(0);
    set_action(ZOOM_1ST);
}
/*
 * added by sjah for tagging
 */
void do_tag()
{
      set_action(0);
      set_action(TAG_POINT);
}

/*
 * set action for expanding
 */
void do_expand()
{
      set_action(0);
      set_action(EXPAND_1ST);
}

/*
 * set action for integration
 */
void do_int_proc2()
{
      set_action(0);
      set_action(INTEGRATE_1ST);
}

/*
 * set nfit_tags for buffit and other functions in compwin1.c
 */
void
set_cfit_tags(ntags,array,update_func)
      int ntags;
      int *array;
      void (*update_func)();
{
      set_action(0);
      nos_fit_tags = ntags;
      fit_array = array;
      update_tags_func = update_func;
      set_action(FIT_TAGS);
}

/*
 * kill all tags
 */
void
do_clear_tags()
{
      int i;
      for (i=0; i < MAXTAGS; i++)
	    if ( isactive_tag(i)) kill_tag(i);
      drawgraph2(-1);
}

/*
 * mark a channel  with a tag
 */
void
do_mark(wx1)
      double wx1;
{
      int tagno;
      world w;
      int   i, chan;
      
      get_graph_world(cg,&w);
      if ( wx1 < w.xg1 || wx1 > w.xg2) return;
      if ((tagno = next_tag()) >= 0) {
	    tags[tagno].gno = cg;
/* draw vertical tag line */
	    tags[tagno].line_no = define_tag_line(tagno,wx1,w.yg1,w.yg2);
	    if (tags[tagno].line_no == -1) {
		  tags[tagno].active = OFF;
		  return;
	    }
/* draw string containing channel value */
	    string_rx = 0.02;
	    string_ry = 0.05;
	    sprintf(tmpstr,"%d",chan = (int) wx1);
	    tags[tagno].str_chan_no = define_tag_string(tagno,wx1,w.yg2);
/* draw string containing channel contents value */
	    tmpstr[0] = '\0';
	    for (i=0; i < 2; i++) {
		  if ( isactive(cg,i)) {
			char tmpstr2[256];
			double xmin,xmax,ymin,ymax;
			getsetminmax(cg,i,&xmin,&xmax,&ymin,&ymax);
			sprintf(tmpstr2,"%d ",
				get_chan_content(chan,getx(cg,i),gety(cg,i),xmin,xmax));
			strcat(tmpstr,tmpstr2);
		  }
	    }
	    string_ry = 0.10;
	    tags[tagno].str_cont_no = define_tag_string(tagno,wx1,w.yg2);
/* reset bits and pieces */		      
	    string_rx = string_ry = 1.0;
	    tmpstr[0] = 0;
      }
      return;
}
void
do_clear_fits()
{
      int i, redrawg = 0;
      for (i=0; i < g[cg].maxplot; i++) {
	    if (isactive_set(cg,i) && (g[cg].p[i].spec & CFIT_DATA)) {
		  softkillset(cg,i);
		  redrawg = 1;
	    }
      }
      if (redrawg) drawgraph2(-1);
}

#ifdef MOTIF
/*
 * repaint proc for Motif
 */
void refresh(w, cd, cbs)
    Widget w;
    int cd;
    XmDrawingAreaCallbackStruct *cbs;
{
    Arg args[2];
    Dimension ww, wh;
    static int inc = 0;
    extern char batchfile[];

    disp = XtDisplay(canvas);
    xwin = XtWindow(canvas);
    XtSetArg(args[0], XmNwidth, &ww);
    XtSetArg(args[1], XmNheight, &wh);
    XtGetValues(canvas, args, 2);
    win_h = wh;
    win_w = ww;
    if (debuglevel == 6) {
	printf("In refresh() %d %d %d\n", win_w, win_h, inwin);
	printf("cb count = %d type = %d\n", cbs->event->xexpose.count, cbs->event->type);
	if (cbs->event->type == GraphicsExpose) {
	    printf("cb count = %d type = %d\n", cbs->event->xexpose.count, cbs->event->type);
	}
	if (cbs->event->type == Expose) {
	    printf("cb count = %d type = %d\n", cbs->event->xexpose.count, cbs->event->type);
	}
    }
    if (!inc) {
	inwin = TRUE;
	inc++;
	drawgraph2(-1);
    } else {
	if (cd) {
	    if (backingstore) {
		resize_backpix();
	    }
	    drawgraph2(-1);
	} else if (backingstore) {
	    if (cbs->event->type == Expose) {
		if (cbs->event->xexpose.count != 0) {
		    return;
		}
	    }
	    refresh_from_backpix();
	    draw_focus(cg);
	    if (rectflag) {
		select_region(sx, sy, old_x, old_y);
	    }
	    if (rubber_flag) {
		select_line(sx, sy, old_x, old_y);
	    }
	}
	else {
	    drawgraph2(-1);
	}
    }
}

#endif

#ifdef XVIEW
/*
 * canvas repaint proc
 */
/*ARGSUSED*/
void refresh(c, w, repaint_area)
    Canvas c;
    Xv_Window w;
    Rectlist *repaint_area;
{
    extern int bc;		/* for X11R4 servers w/XView 2.0 */
    extern char batchfile[];

    win_h = (int) xv_get(w, XV_HEIGHT);
    win_w = (int) xv_get(w, XV_WIDTH);
    if (debuglevel == 6) {
	printf("In refresh() %d %d %d\n", win_w, win_h, inwin);
    }
    if (!inwin) {
	if (bc) {
	    bc = 0;
	    return;
	}
	inwin = TRUE;
	drawgraph2(-1);
    } else {
	if (debuglevel == 6) {
	    printf("In refresh() DoesBS = %d DoesSU = %d\n",
		   DoesBackingStore(DefaultScreenOfDisplay(disp)),
		   DoesSaveUnders(DefaultScreenOfDisplay(disp)));
	}
	if (!DoesBackingStore(DefaultScreenOfDisplay(disp))) {
	    if (backingstore) {
		refresh_from_backpix();
		draw_focus(cg);
		if (rectflag) {
		    select_region(sx, sy, old_x, old_y);
		}
		if (rubber_flag) {
		    select_line(sx, sy, old_x, old_y);
		}
	    } else {
		if (allow_refresh) {
		    drawgraph2(-1);
		}
	    }
	} else {
	    if (allow_refresh) {
		drawgraph2(-1);
	    }
	}
    }
}

/*
 * canvas resize proc
 */
/*ARGSUSED*/
void my_resize_proc(c, w, h)
    Canvas c;
    int w, h;
{
    static int called = 0;

    win_h = h;
    win_w = w;
    called++;
    if (debuglevel == 6) {
	printf("In my_resize_proc() %d %d %d\n", win_w, win_h, inwin);
    }
    if (redraw_now && redraw_now == called) {
	refresh(c, canvas_paint_window(c), NULL);
    } else if (inwin) {
	if (backingstore) {
	    resize_backpix();
	    drawgraph2(-1);
	    draw_focus(cg);
	    if (rectflag) {
		select_region(sx, sy, old_x, old_y);
	    }
	    if (rubber_flag) {
		select_line(sx, sy, old_x, old_y);
	    }
	} else {
	    if (allow_refresh) {
		drawgraph2(-1);
	    }
	}
    }
}

#endif

/*
 * for the goto point feature
 */
void setpointer(x, y)
{
    XWarpPointer(disp, None, xwin, 0, None, win_w, win_h, x, y);
}

/*
 * locator on main_panel
 */
void getpoints(x, y)
    int x, y;
{
    double wx, wy, xtmp, ytmp;
    double dsx = 0.0, dsy = 0.0;
    int newg;
    char buf[256];
    extern char locator_format[];

#ifdef XVIEW
    if (!inwin) {
	if (debuglevel == 6) {
	    printf("inwin == FALSE in getpoints(), doing a drawgraph2(-1)\n");
	}
	refresh(canvas, paint_window, NULL);
    }
#endif

    device2world(x, y, &wx, &wy);
    if (g[cg].pointset) {
	dsx = g[cg].dsx;
	dsy = g[cg].dsy;
    }
    if (focus_policy == FOLLOWS) {
	if ((newg = iscontained(cg, wx, wy)) != cg) {
	    draw_focus(cg);
	    cg = newg;
	    defineworld(g[cg].w.xg1, g[cg].w.yg1, g[cg].w.xg2, g[cg].w.yg2, islogx(cg), islogy(cg));
	    viewport(g[cg].v.xv1, g[cg].v.yv1, g[cg].v.xv2, g[cg].v.yv2);
	    draw_focus(cg);
	    make_format(cg);
	    device2world(x, y, &wx, &wy);
	    update_all(cg);
	}
    }
    if (!go_locateflag) {
	return;
    }
    switch (g[cg].pt_type) {
    case 0:
	xtmp = wx;
	ytmp = wy;
	{
	    char s1[30], s2[30];
	    int form = g[cg].fx;

	    create_ticklabel(form, g[cg].px, wx, s1);
	    form = g[cg].fy;
	    create_ticklabel(form, g[cg].py, wy, s2);
	    sprintf(buf, "G%1d: X, Y = [%s, %s]", cg, s1, s2);
	}
	break;
    case 1:
	xtmp = wx - dsx;
	ytmp = wy - dsy;
	sprintf(buf, locator_format, cg, xtmp, ytmp);
	break;
    case 2:
	xtmp = hypot(dsx - wx, dsy - wy);
	ytmp = 0.0;
	sprintf(buf, locator_format, cg, xtmp, ytmp);
	break;
    case 3:
	if (dsx - wx != 0.0 || dsy - wy != 0.0) {
	    xtmp = hypot(dsx - wx, dsy - wy);
	    ytmp = 180.0 + 180.0 / M_PI * atan2(dsy - wy, dsx - wx);
	    sprintf(buf, locator_format, cg, xtmp, ytmp);
	} else {
	    sprintf(buf, "ERROR: dx = dy = 0.0");
	}
	break;
    case 4:
	xtmp = xconv(wx);
	ytmp = yconv(wy);
	sprintf(buf, locator_format, cg, xtmp, ytmp);
	break;
    case 5:
	sprintf(buf, locator_format, cg, x, y);
	break;
    }
#ifdef XVIEW
    xv_set(locate_item, PANEL_LABEL_STRING, buf, NULL);
#endif
#ifdef MOTIF
    XmStringFree(string);
    string = XmStringCreateLtoR(buf, charset);
    XtSetArg(al, XmNlabelString, string);
    XtSetValues(loclab, &al, 1);
#endif
}

/*
 * rubber band line
 */
void select_line(x1, y1, x2, y2)
    int x1, y1, x2, y2;
{
    XDrawLine(disp, xwin, gcxor, x1, y1, x2, y2);
}

/*
 * draw a box on the display
 */
void draw_rectangle(x1, y1, x2, y2)
    int x1, y1, x2, y2;
{
    XDrawRectangle(disp, xwin, gc, x1, y1, x2, y2);
}

/*
 * draw an xor'ed box
 */
void select_region(x1, y1, x2, y2)
    int x1, y1, x2, y2;
{
    int dx = x2 - x1;
    int dy = y2 - y1;

    if (dx < 0) {
	iswap(&x1, &x2);
	dx = -dx;
    }
    if (dy < 0) {
	iswap(&y1, &y2);
	dy = -dy;
    }
    XDrawRectangle(disp, xwin, gcxor, x1, y1, dx, dy);
}

/*
 * draw the graph focus indicators
 */
void draw_focus(gno)
    int gno;
{
    int ix1, iy1, ix2, iy2;

/*    set_stack_message(); */
    if (draw_focus_flag == ON) {
	world2deviceabs(g[gno].w.xg1, g[gno].w.yg1, &ix1, &iy1);
	world2deviceabs(g[gno].w.xg2, g[gno].w.yg2, &ix2, &iy2);
	XFillRectangle(disp, xwin, gcxor, ix1 - 5, iy1 - 5, 10, 10);
	XFillRectangle(disp, xwin, gcxor, ix1 - 5, iy2 - 5, 10, 10);
	XFillRectangle(disp, xwin, gcxor, ix2 - 5, iy2 - 5, 10, 10);
	XFillRectangle(disp, xwin, gcxor, ix2 - 5, iy1 - 5, 10, 10);
/* TODO
	XFillRectangle(disp, xwin, gcxor, (ix1 + ix2) / 2 - 5, iy1 - 5, 10, 10);
	XFillRectangle(disp, xwin, gcxor, (ix1 + ix2) / 2 - 5, iy2 - 5, 10, 10);
*/
    }
}

/*
 * draw a cursor for text writing
 * TODO: fix the rotation problems (cursor doesn't track)
 */
void update_text_cursor(s, x, y)
    char *s;

    int x, y;
{
    int hgt, tx, xtx, ytx, xhgt, yhgt;

    hgt = stringextenty(charsize * xlibcharsize, "N") / 2;
    tx = stringextentx(charsize * xlibcharsize, s);
    xtx = (int) tx *co;
    ytx = (int) tx *si;

    xhgt = (int) -hgt * si;
    yhgt = (int) hgt *co;

/*    select_line(x + tx, win_h - y + hgt, x + tx, win_h - y - hgt);*/
    select_line(x + xtx + xhgt, win_h - (y + ytx + yhgt),
		x + xtx - xhgt, win_h - (y + ytx - yhgt));
}

/*
 * set the action_flag to the desired action (actions are
 * defined in defines.h), if 0 then cleanup the results
 * from previous actions.
 */
void set_action(act)
    int act;
{
    defaults d;
    char tmpbuf[128];

    get_graph_defaults(cg, &d);

    if (action_flag == STR_LOC) {
	double wx, wy;

	update_text_cursor(tmpstr, strx, stry);
	setcharsize(d.charsize);
	setfont(d.font);
	setcolor(d.color);
	setlinestyle(d.lines);
	setlinewidth(d.linew);
	if (tmpstr[0]) {
	    device2world(strx, win_h - stry, &wx, &wy);
	    define_string(tmpstr, wx, wy);
	    tmpstr[0] = 0;
	}
    }
    if (action_flag == FIT_TAGS) update_tags_func(nos_fit_tags);
/*
 * indicate what's happening with a message in the left footer
 */
    switch (action_flag = act) {
    case DEL_OBJECT:
	set_cursor(3);
	set_left_footer("Delete object");
	break;
    case MOVE_OBJECT_1ST:
	set_cursor(4);
	set_left_footer("Pick object");
	break;
    case MOVE_OBJECT_2ND:
	set_left_footer("Place object");
	break;
    case MAKE_BOX_1ST:
	set_cursor(0);
	set_left_footer("First corner of box");
	break;
    case MAKE_BOX_2ND:
	set_left_footer("Second corner of box");
	break;
    case STR_LOC1ST:
	set_cursor(0);
	set_left_footer("Pick start of text line");
	break;
    case STR_LOC2ND:
	set_left_footer("Pick end of text line");
	break;
    case MAKE_LINE_1ST:
	set_cursor(0);
	set_left_footer("Pick beginning of line");
	break;
    case MAKE_LINE_2ND:
	set_left_footer("Pick end of line");
	break;
    case STR_EDIT:
	set_cursor(2);
	set_left_footer("Edit string");
	break;
    case STR_LOC:
	set_cursor(2);
	set_left_footer("Pick beginning of text");
	break;
    case FIND_POINT:
	set_cursor(1);
	set_left_footer("Find points");
	break;
    case TRACKER:
	set_cursor(1);
	set_left_footer("Tracker");
	break;
    case PAINT_POINTS:
	set_cursor(0);
	set_left_footer("Paint points - hold left mouse button down and move");
	break;
    case DEACTIVATE_NEAREST:
	set_cursor(0);
	set_left_footer("Deactivate nearest set - click near a point of the set to deactivate");
	break;
    case LEG_LOC:
	set_cursor(0);
	set_left_footer("Place legend");
	break;
    case TAG_POINT:
	set_cursor(0);
	set_left_footer("Pick location of tag");
	break;
    case EXPAND_1ST:
	set_cursor(0);
	set_left_footer("Pick location of left expand tag");
	break;
    case EXPAND_2ND:
	set_cursor(0);
	set_left_footer("Pick location of right expand tag");
	break;
    case INTEGRATE_1ST:
	set_cursor(0);
	set_left_footer("Pick location of left integrate tag");
	break;
    case INTEGRATE_2ND:
	set_cursor(0);
	set_left_footer("Pick location of right integrate tag");
	break;
    case FIT_TAGS:
	set_cursor(0);
	set_left_footer("Pick location of fit tags");
	break;
    case 0:
	set_cursor(-1);
	set_left_footer("Locator");
	if (rectflag) {
	    select_region(sx, sy, old_x, old_y);
	    rectflag = 0;
	}
	if (rubber_flag) {
	    select_line(sx, sy, old_x, old_y);
	    rubber_flag = 0;
	}
	if (mbox_flag) {
	    select_region(sx, sy, xs, ys);
	    mbox_flag = 0;
	}
	if (mline_flag) {
	    select_line(sx, sy, xs, ys);
	    mline_flag = 0;
	}
/*	slice_first = FALSE; */
	break;
    }
}

/*
 * update string drawn on the canvas
 */
void do_text_string(op, c)
    int op;

    int c;

{
    char stmp[2];

    drawx = strx;
    drawy = stry;

    update_text_cursor(tmpstr, drawx, drawy);
    set_write_mode(0);
    dispstrxlib(drawx, drawy, string_rot, tmpstr, justflag, 0);
    switch (op) {
    case 0:                          /* delete character */
	if (strlen(tmpstr) > 0) {
	    tmpstr[strlen(tmpstr) - 1] = 0;
	}
	break;
    case 1:                          /* add character */
	sprintf(stmp, "%c", c);
	strcat(tmpstr, stmp);
	break;
    case 2:
	break;
    }
    set_write_mode(1);
    dispstrxlib(drawx, drawy, string_rot, tmpstr, justflag, 0);
    update_text_cursor(tmpstr, drawx, drawy);
}

/*
 * canvas event proc
 */
/* ARGSUSED */
#ifdef XVIEW
void my_proc(window, xv_event)
    Xv_window window;
    Event *xv_event;

#endif
#ifdef MOTIF
    void my_proc(w, data, event)
    Widget w;
    caddr_t data;
    XEvent *event;

#endif
{
#ifdef XVIEW
    XEvent *event = xv_event->ie_xevent;

#endif
    static int x, y, boxno, lineno, tagno;
    static double wx1, wx2, wy1, wy2;
    static double wx, wy, dx, dy;
    static int ty, no, c;
    static KeySym keys;
    static XComposeStatus compose;
    int tmpcg = cg;

#ifdef LOCAL
    if (debuglevel == 7) {
	printf("Call to my_proc() event type == %d sent from %d\n", event->type, event->xany.send_event);
    }
#endif

/*
 * hot keys
 */
    switch (event->type) {
    case KeyPress:
	buf[0] = 0;
	XLookupString(event, buf, 1, &keys, &compose);
	switch (c = buf[0]) {
	case 1:		/* ^A */
	    if (activeset(cg)) {
		defaultgraph(cg);
		default_axis(cg, g[cg].auto_type, X_AXIS);
		default_axis(cg, g[cg].auto_type, ZX_AXIS);
		default_axis(cg, g[cg].auto_type, Y_AXIS);
		default_axis(cg, g[cg].auto_type, ZY_AXIS);
/*		update_world(cg); */
		drawgraph2(-1);
	    } else {
		errwin("No active sets!");
	    }
	    break;
	case 2:		/* ^B */
	    do_boxes_proc();
	    break;
	case 3:		/* ^C */
	    break;
	case 4:		/* ^D */
	    gwindup_proc();
	    break;
	case 5:		/* ^E */
	    do_expand();
	    break;
	case 6:		/* ^F */
	    break;
	case 7:		/* ^G */
	    create_world_frame(); 
	    break;
	    /* stay off 8 (^H) - needed by text routines */
	case 9:         /* ^I */
	    create_int_frame();
	    do_int_proc2();
	    break;
	case 11:      /* ^K */
	    do_delete_object_proc();
	    break;
	case 12:		/* ^L */
	    gwindright_proc();
	    break;
	case 14:		/* ^N */
	    do_move_proc();
	    break;
	case 16:		/* ^P */
	    do_lines_proc();
	    break;
	case 18:		/* ^R */
	    gwindleft_proc();
	    break;
	case 19:		/* ^S */
	    break;
	case 20:		/* ^T */
	    do_tag();
	    break;
	case 21:                /* ^U */
	    gwinddown_proc();
	    break;
	case 22:		/* ^V */
	    break;
	case 23:		/* ^W */
	    strings_loc_proc();
	    break;
	case 24:		/* ^X */
	    bailout();
	    break;
	case 26:		/* ^Z */
	    do_zoom();
	    break;
	case 8:
	case 127:
	    if (action_flag == STR_LOC) {
		do_text_string(0, 0);
	    }
	    break;
	case '\r':
	case '\n':
	    if (action_flag == STR_LOC) {
		int itmp;

		update_text_cursor(tmpstr, drawx, drawy);
		if (tmpstr[0]) {
		    device2world(drawx, win_h - drawy, &wx, &wy);
		    define_string(tmpstr, wx, wy);
		}
		itmp = (int) (1.25 * stringextenty(charsize * xlibcharsize, "Ny"));
		strx = strx + si * itmp;
		stry = stry - co * itmp;
		tmpstr[0] = 0;
		update_text_cursor(tmpstr, strx, stry);
	    }
	    break;
	default:
	    if (action_flag == STR_LOC) {
		if (c >= 32 && c < 128) {
		    do_text_string(1, c);
		}
	    }
	    break;
	}
	break;
    case ButtonPress:
	switch (event->xbutton.button) {
	case Button3:
	    getpoints(x, y);
	    if (action_flag == EXPAND_2ND) kill_tag(tagno);
	    set_action(0);
	    break;
	case Button1:
	    if (action_flag == 0) {
		if (focus_policy == CLICK) {
		    int newg;

		    device2world(x, y, &wx, &wy);
		    if ((newg = iscontained(cg, wx, wy)) != cg) {
			draw_focus(cg);
			cg = newg;
			defineworld(g[cg].w.xg1, g[cg].w.yg1, g[cg].w.xg2, g[cg].w.yg2, islogx(cg), islogy(cg));
			viewport(g[cg].v.xv1, g[cg].v.yv1, g[cg].v.xv2, g[cg].v.yv2);
			draw_focus(cg);
			make_format(cg);
			device2world(x, y, &wx, &wy);
			update_all(cg);
		    }
		}
	    }
	    c = go_locateflag;
	    go_locateflag = TRUE;
	    getpoints(x, y);
	    go_locateflag = c;
	    {
		if (!action_flag && allow_dc && double_click(event)) {
		    if (tmpcg == cg) {	/* don't allow a change of focus */
			int setno, loc, soft;
			/* extern */ int cset = 0; 

			device2world(x, y, &wx, &wy);
			if (symok(wx, wy)) {
			    findpoint(cg, wx, wy, &wx, &wy, &setno, &loc);
			    if (setno != -1) {
				cset = setno;
				set_wait_cursor(NULL);
				set_right_footer("Opening View/Symbols...");
				define_symbols_popup(); 
				set_right_footer(NULL);
				unset_wait_cursor(NULL);
			    } else {
				set_wait_cursor(NULL);
				set_right_footer("Opening Edit/Read sets...");
				create_file_popup();
				set_right_footer(NULL);
				unset_wait_cursor(NULL);
/* annoying error message
				errwin("No set!");
*/
			    }
			} else {
			    if (wx < g[cg].w.xg1) {
				curaxis = 1;
				create_ticks_frame(); 
			    } else if (wy < g[cg].w.yg1) {
				curaxis = 0;
				create_ticks_frame(); 
			    } else if (wy > g[cg].w.yg2) {
				create_label_frame(); 
			    } else if (wx > g[cg].w.xg2) {
				define_legend_popup();
			    } 
			}
		    }
		}
	    }
	    switch (action_flag) {
	    case DEL_OBJECT:	/* delete a box or a line */
		set_action(0);
		device2world(x, y, &wx, &wy);
		find_item(cg, wx, wy, &ty, &no);
		if (ty >= 0) {
		    switch (ty) {
		    case BOX:
			set_write_mode(0);
			draw_box(-2, no);
			set_write_mode(1);
			kill_box(no);
			break;
		    case LINE:
			set_write_mode(0);
			if (lines[no].tagitem != -1){
			      int tag = lines[no].tagitem;
			      draw_string(-2,tags[tag].str_cont_no);
			      draw_string(-2,tags[tag].str_chan_no);
			      draw_line(-2, no);
			      kill_tag(tag);
			}
			else {
			      draw_line(-2, no);
			      kill_line(no);
			}
			set_write_mode(1);
			break;
		    case STRING:
			set_write_mode(0);
			draw_string(-2, no);
			set_write_mode(1);
			if (pstr[no].tagitem != -1) {
			      int tag = pstr[no].tagitem;
			      draw_string(-2,tags[tag].str_cont_no);
			      draw_string(-2,tags[tag].str_chan_no);
			      draw_line(-2, tags[tag].line_no);
			      kill_tag(tag);
			}
			else {
			      draw_string(-2, no);
			      kill_string(no);
			}
			set_write_mode(1);
			break;
		    }
		}
		break;
/*
 * select a box or a line to move
 */
	    case MOVE_OBJECT_1ST:
		set_action(MOVE_OBJECT_2ND);
		device2world(x, y, &wx, &wy);
		find_item(cg, wx, wy, &ty, &no);
		if (ty < 0) {
		    set_action(0);
		} else {
		    switch (ty) {
		    case BOX:
			if (boxes[no].loctype == VIEW) {
			    sx = (int) (win_w * boxes[no].x1);
			    sy = (int) (win_h - win_h * boxes[no].y1);
			    xs = (int) (win_w * boxes[no].x2);
			    ys = (int) (win_h - win_h * boxes[no].y2);
			} else {
			    world2deviceabs(boxes[no].x1, boxes[no].y1, &sx, &sy);
			    world2deviceabs(boxes[no].x2, boxes[no].y2, &xs, &ys);
			}
			select_region(sx, sy, xs, ys);
			mbox_flag = 1;
			break;
		    case LINE:
			if (lines[no].loctype == VIEW) {
			    sx = (int) (win_w * lines[no].x1);
			    sy = (int) (win_h - win_h * lines[no].y1);
			    xs = (int) (win_w * lines[no].x2);
			    ys = (int) (win_h - win_h * lines[no].y2);
			} else {
			    world2deviceabs(lines[no].x1, lines[no].y1, &sx, &sy);
			    world2deviceabs(lines[no].x2, lines[no].y2, &xs, &ys);
			}
			select_line(sx, sy, xs, ys);
			mline_flag = 1;
			break;
		    case STRING:
			xs = stringextentx(charsize * xlibcharsize, pstr[no].s);
			ys = stringextenty(charsize * xlibcharsize, pstr[no].s);
			if (pstr[no].loctype == VIEW) {
			    sx = (int) (win_w * pstr[no].x);
			    sy = (int) (win_h - win_h * pstr[no].y);
			} else {
			    world2device(pstr[no].x, pstr[no].y, &sx, &sy);
			}
			xs = sx + xs;
			ys = sy + ys;
			mbox_flag = 1;
			select_region(sx, sy, xs, ys);
			break;
		    }
		}

		break;
/*
 * box has been selected and new position found
 */
	    case MOVE_OBJECT_2ND:
		dx = sx - x;
		dy = sy - y;

		set_action(0);
		sx = x;
		sy = y;
		xs = xs - dx;
		ys = ys - dy;
		device2world(sx, sy, &wx1, &wy1);
		device2world(xs, ys, &wx2, &wy2);
		switch (ty) {
		case BOX:
		    set_write_mode(0);
		    draw_box(-2, no);
		    if (boxes[no].loctype == VIEW) {
			wx1 = xconv(wx1);
			wy1 = yconv(wy1);
			wx2 = xconv(wx2);
			wy2 = yconv(wy2);
		    } else {
			boxes[no].gno = cg;
		    }
		    boxes[no].x1 = wx1;
		    boxes[no].x2 = wx2;
		    boxes[no].y1 = wy1;
		    boxes[no].y2 = wy2;
		    set_write_mode(1);
		    draw_box(-2, no);
		    break;
		case LINE:
		    set_write_mode(0);
		    draw_line(-2, no);
		    if (lines[no].loctype == VIEW) {
			wx1 = xconv(wx1);
			wy1 = yconv(wy1);
			wx2 = xconv(wx2);
			wy2 = yconv(wy2);
		    } else {
			lines[no].gno = cg;
		    }
		    lines[no].x1 = wx1;
		    lines[no].x2 = wx2;
		    lines[no].y1 = wy1;
		    lines[no].y2 = wy2;
		    set_write_mode(1);
		    draw_line(-2, no);
		    break;
		case STRING:
		    set_write_mode(0);
		    draw_string(-2, no);
		    if (pstr[no].loctype == VIEW) {
			wx1 = xconv(wx1);
			wy1 = yconv(wy1);
		    } else {
			pstr[no].gno = cg;
		    }
		    pstr[no].x = wx1;
		    pstr[no].y = wy1;
		    set_write_mode(1);
		    draw_string(-2, no);
		    break;
		}
		set_action(MOVE_OBJECT_1ST);
		break;
/*
 * select a box or a line to move
 */
	    case EDIT_OBJECT:
		set_action(EDIT_OBJECT);
		device2world(x, y, &wx, &wy);
		find_item(cg, wx, wy, &ty, &no);
		if (ty < 0) {
		    set_action(0);
		} else {
		    switch (ty) {
		    case BOX:
			break;
		    case LINE:
			break;
		    case STRING:
			break;
		    }
		}

		break;
/*
 * make a new box, select first corner
 */
	    case MAKE_BOX_1ST:
		set_action(MAKE_BOX_2ND);
		rectflag = 1;
		sx = x;
		sy = y;
		select_region(sx, sy, x, y);
		break;
/*
 * make a new box, select opposite corner
 */
	    case MAKE_BOX_2ND:
		set_action(0);
		if ((boxno = next_box()) >= 0) {
		    device2world(sx, sy, &wx1, &wy1);
		    device2world(x, y, &wx2, &wy2);
		    if (box_loctype == VIEW) {
			wx1 = xconv(wx1);
			wy1 = yconv(wy1);
			wx2 = xconv(wx2);
			wy2 = yconv(wy2);
		    } else {
			boxes[no].gno = cg;
		    }
		    boxes[boxno].loctype = box_loctype;
		    boxes[boxno].x1 = wx1;
		    boxes[boxno].x2 = wx2;
		    boxes[boxno].y1 = wy1;
		    boxes[boxno].y2 = wy2;
		    boxes[boxno].color = box_color;
		    boxes[boxno].linew = box_linew;
		    boxes[boxno].lines = box_lines;
		    boxes[boxno].fill = box_fill;
		    boxes[boxno].fillcolor = box_fillcolor;
		    boxes[boxno].fillpattern = box_fillpat;
		    draw_box(-2, boxno);
		}
		break;
/*
 * locate angled string
 */
	    case STR_LOC1ST:
		set_action(STR_LOC2ND);
		rubber_flag = 1;
		sx = x;
		sy = y;
		select_line(sx, sy, x, y);
		break;
	    case STR_LOC2ND:
		device2world(sx, sy, &wx1, &wy1);
		device2world(x, y, &wx2, &wy2);
		wx1 = xconv(wx1);
		wy1 = yconv(wy1);
		wx2 = xconv(wx2);
		wy2 = yconv(wy2);
		string_rot = (int) ((atan2((wy2 - wy1) * win_h, (wx2 - wx1) * win_w) * 180.0 / M_PI) + 360.0) % 360;
/*		updatestrings(); */
		strings_loc_proc();
		break;
/*
 * make a new line, select start point
 */
	    case MAKE_LINE_1ST:
		sx = x;
		sy = y;
		set_action(MAKE_LINE_2ND);
		rubber_flag = 1;
/*		select_line(sx, sy, x, y); */
		break;
/*
 * make a new line, select end point
 */
	    case MAKE_LINE_2ND:
		set_action(0);
		if ((lineno = next_line()) >= 0) {
		    device2world(sx, sy, &wx1, &wy1);
		    device2world(x, y, &wx2, &wy2);
		    if (line_loctype == VIEW) {
			wx1 = xconv(wx1);
			wy1 = yconv(wy1);
			wx2 = xconv(wx2);
			wy2 = yconv(wy2);
		    } else {
			lines[no].gno = cg;
		    }
		    lines[lineno].loctype = line_loctype;
		    lines[lineno].x1 = wx1;
		    lines[lineno].x2 = wx2;
		    lines[lineno].y1 = wy1;
		    lines[lineno].y2 = wy2;
		    lines[lineno].color = line_color;
		    lines[lineno].lines = line_lines;
		    lines[lineno].linew = line_linew;
		    lines[lineno].arrow = line_arrow;
		    lines[lineno].asize = line_asize;
		    lines[lineno].atype = line_atype;
		    draw_line(-2, lineno);
		}
		break;
/*
 * Edit an existing string
 */
	    case STR_EDIT:
		device2world(x, y, &wx, &wy);
		find_item(cg, wx, wy, &ty, &no);
		if ((ty >= 0) && (ty == STRING)) {
		    int ilenx, ileny;

		    wx1 = pstr[no].x;
		    wy1 = pstr[no].y;
		    if (pstr[no].loctype == VIEW) {	/* in viewport coords */
			view2world(wx1, wy1, &wx2, &wy2);
			wx1 = wx2;
			wy1 = wy2;
		    }
		    world2device(wx1, wy1, &strx, &stry);
		    drawx = strx;
		    drawy = stry;
		    strcpy(tmpstr, pstr[no].s);
		    setcharsize(pstr[no].charsize);
		    setfont(pstr[no].font);
		    setcolor(pstr[no].color);
		    string_just = pstr[no].just;
		    justflag = string_just;
		    string_size = pstr[no].charsize;
		    string_font = pstr[no].font;
		    string_color = pstr[no].color;
		    string_linew = pstr[no].linew;
		    string_rot = pstr[no].rot;
		    string_loctype = pstr[no].loctype;
/*		    updatestrings(); */
		    kill_string(no);
		    si = sin(M_PI / 180.0 * string_rot) *
			    ((double) win_w) / ((double) win_h);
		    co = cos(M_PI / 180.0 * string_rot);

		    ilenx = stringextentx(charsize * xlibcharsize, tmpstr);
		    ileny = stringextenty(charsize * xlibcharsize, tmpstr);

		    switch (justflag) {
		    case 1:
			strx = drawx + co * ilenx - si * ileny;
			stry = drawy + si * ilenx + co * ileny;
			break;
		    case 2:
			strx = drawx + (co * ilenx - si * ileny) / 2;
			stry = drawy + (si * ilenx + co * ileny) / 2;
			break;
		    }
		    update_text_cursor(tmpstr, drawx, drawy);
		    do_text_string(2, 0);
		    action_flag = STR_LOC;
		} else {
		    set_action(0);
		}
		break;
/*
 * locate a string on the canvas
 */
	    case STR_LOC:
		if (tmpstr[0]) {
		    device2world(strx, win_h - stry, &wx, &wy);
		    define_string(tmpstr, wx, wy);
		}
		strx = x;
		stry = win_h - y;
		drawx = strx;
		drawy = stry;
		tmpstr[0] = 0;
/*		define_string_defaults(); */
		justflag = string_just;
		setcharsize(string_size);
		xlibsetfont(string_font);
		xlibsetcolor(string_color);
		xlibsetlinewidth(string_linew);
		si = sin(M_PI / 180.0 * string_rot) *
			((double) win_w) / ((double) win_h);
		co = cos(M_PI / 180.0 * string_rot);
		update_text_cursor(tmpstr, strx, stry);
		break;

/*
 * Deactivate the set nearest the pointer
 */
	    case DEACTIVATE_NEAREST:
		{
		    int setno, loc, soft;

		    device2world(x, y, &wx, &wy);
		    findpoint(cg, wx, wy, &wx, &wy, &setno, &loc);
		    if (setno != -1) {
			if (verify_action) {
			    char tmpbuf[128];

			    sprintf(tmpbuf, "Deactivate S%1d?", setno);
			    if (yesno(tmpbuf, "", "YES", "NO")) {
				do_deactivate(cg, setno);
			    }
			} else {
			    do_deactivate(cg, setno);
			}
			set_action(DEACTIVATE_NEAREST);
		    } else {
			errwin("Found no set, cancelling deactivate");
			set_action(0);
		    }
		}
		break;

/*
 * find a point in a set
 */
	    case FIND_POINT:
		{
		    int setno, loc;

		    device2world(x, y, &wx, &wy);
		    findpoint(cg, wx, wy, &wx, &wy, &setno, &loc);
		    if (setno != -1) {
			sprintf(buf, "Set %d, loc %d, (%lf, %lf)", setno, loc, wx, wy);
/*			xv_setstr(locate_point_item, buf); */
			set_action(FIND_POINT);
		    } else {
			errwin("Found no set, cancelling find");
			set_action(0);
		    }
		}
		break;
/*
 * Tracker
 */
	    case TRACKER:
		{
		    extern int track_set, track_point;
		    int xtmp, ytmp;
		    double *xx, *yy;

		    if (track_set == -1) {
			device2world(x, y, &wx, &wy);
			findpoint(cg, wx, wy, &wx, &wy, &track_set, &track_point);
			track_point--;
			if (track_point < 0) {
			    track_point = 0;
			}
		    }
		    xx = getx(cg, track_set);
		    yy = gety(cg, track_set);
		    if (track_point < getsetlength(cg, track_set) && track_point >= 0) {
			if (inbounds(cg, xx[track_point], yy[track_point])) {
			    world2deviceabs(xx[track_point], yy[track_point], &xtmp, &ytmp);
			    setpointer(xtmp, ytmp);
			    sprintf(buf, "Set %d, loc %d, (%lf, %lf)", track_set, track_point + 1,
				    xx[track_point], yy[track_point]);
			} else {
			    sprintf(buf, "OUTSIDE - Set %d, loc %d, (%lf, %lf)", track_set, track_point + 1,
				    xx[track_point], yy[track_point]);
			}
/*			xv_setstr(locate_point_item, buf); */
			track_point++;
		    }
		    if (track_point < 0) {
			track_point = getsetlength(cg, track_set) - 1;
		    } else if (track_point >= getsetlength(cg, track_set)) {
			track_point = 0;
		    }
		    set_action(TRACKER);
		}
		break;

/*
 * select a reference point for the locator in main_panel
 */
	    case SEL_POINT:
		device2world(x, y, &wx, &wy);
		g[cg].pointset = TRUE;
		g[cg].dsx = wx;
		g[cg].dsy = wy;
		draw_ref_point(cg);
/*		update_locator_items(cg); */
		set_action(0);
		break;

	    case TAG_POINT:
		set_action(0);
		if ( set_tag_ok(cg,x,y)) {
		      int i;
		      device2world(x, y, &wx1, &wy1);
		      i = (int) (wx1 + 0.5); /*get nearest int */
		      do_mark((double) i);
		}
		break;
      
	    case EXPAND_1ST:
		if (! set_tag_ok(cg,x,y)) {
		      set_action(0);
		      break;
		}
		set_action(EXPAND_2ND);
		draw_tmp_tag(cg,x,y);
		sx = x;
		sy = y;
		break;

	    case EXPAND_2ND:
		if ( ! set_tag_ok(cg,x,y)) break;
		set_action(0);
		draw_tmp_tag(cg,x,y);
		{
		      extern void default_ticks();
		      world w;
		      get_graph_world(cg,&w);
		      device2world(x, y, &wx1, &wy1);
		      device2world(sx, sy, &wx2, &wy2);
		      if (x == sx ) {
			    errwin("Expanded region is zero along X, expand cancelled");
		      } else {
			    if (wx1 > wx2) {
				  fswap(&wx1, &wx2);
			    }
			    if (isactive_graph(cg) && isactive_set(cg,0)) {
				  if (g[cg].p[0].spec == SPECTRUM_DATA) {
					wx1 = floor(wx1/10.0)*10.0;
					wx2 = ceil(wx2/10.0)*10.0;
					if (wx1 == wx2) wx2 = wx1 + 10.0;
				  }
			    }
			    clear_graph_viewport(cg);
			    g[cg].w.xg1 = wx1;
			    g[cg].w.xg2 = wx2;
			    g[cg].w.yg1 = w.yg1;
			    g[cg].w.yg2 = w.yg2;
			    default_ticks(cg,X_AXIS,&wx1,&wx2);
			    drawgraph2(cg);
		      }
		}
		break;

	     case INTEGRATE_1ST:
		if (! set_tag_ok(cg,x,y)) {
		      set_action(0);
		      break;
		}
		set_action(INTEGRATE_2ND);
		draw_tmp_tag(cg,x,y);
		sx = x;
		sy = y;
		break;

	     case INTEGRATE_2ND:
		if (! set_tag_ok(cg,x,y)) break;
		set_action(0);
		draw_tmp_tag(cg,x,y);
		{
		      world w;
		      get_graph_world(cg,&w);
		      device2world(x, y, &wx2, &wy2);
		      device2world(sx, sy, &wx1, &wy1);
		      tag1 = (int) (wx1+0.5);
		      tag2 = (int) (wx2+0.5);
		      do_int_proc((Panel_item)0, NULL);
		}
		break;

	     case FIT_TAGS:
		if (! set_tag_ok(cg,x,y)) break;
		draw_tmp_tag(cg,x,y);
		device2world(x, y, &wx1, &wy1);
		fit_array[nos_fit_tags-1] = (int) (wx1+0.5);
		if (--nos_fit_tags <= 0 ) set_action(0); 
		break;

/*
 * locate the graph legend
 */
	    case LEG_LOC:
		device2world(x, y, &wx, &wy);
		if (g[cg].l.loctype == VIEW) {
		    wx = xconv(wx);
		    wy = yconv(wy);
		}
		if (legend_x_panel) {
		    sprintf(buf, "%.6g", wx);
		    xv_setstr(legend_x_panel, buf);
		    sprintf(buf, "%.6g", wy);
		    xv_setstr(legend_y_panel, buf);
		} else { 
		    g[cg].l.legx = wx;
		    g[cg].l.legy = wy;
		} 
		set_action(0);
		define_legends_proc(); 
		break;
	    }
	    break;
	case Button2:
	    getpoints(x, y);
	    switch (action_flag) {
	    case TRACKER:
		{
		    int xtmp, ytmp;
		    extern int track_set, track_point;
		    double *x = getx(cg, track_set), *y = gety(cg, track_set);

		    if (track_set == -1) {
			device2world(x, y, &wx, &wy);
			findpoint(cg, wx, wy, &wx, &wy, &track_set, &track_point);
			track_point--;
			if (track_point < 0) {
			    track_point = getsetlength(cg, track_set) - 1;
			}
		    }
		    if (track_point < getsetlength(cg, track_set) && track_point >= 0) {
			if (inbounds(cg, x[track_point], y[track_point])) {
			    world2deviceabs(x[track_point], y[track_point], &xtmp, &ytmp);
			    setpointer(xtmp, ytmp);
			    sprintf(buf, "Set %d, loc %d, (%lf, %lf)", track_set, track_point + 1,
				    x[track_point], y[track_point]);
			} else {
			    sprintf(buf, "OUTSIDE - Set %d, loc %d, (%lf, %lf)", track_set, track_point + 1,
				    x[track_point], y[track_point]);
			}
/*			xv_setstr(locate_point_item, buf); */
			track_point--;
		    }
		    if (track_point < 0) {
			track_point = getsetlength(cg, track_set) - 1;
		    } else if (track_point >= getsetlength(cg, track_set)) {
			track_point = 0;
		    }
		    set_action(TRACKER);
		}
		break;
	    }

	    break;
	}
	break;
    case MotionNotify:
	x = event->xmotion.x;
	y = event->xmotion.y;
/* experimental - cross hair cursor function defined at the bottom of this file */
	if (cursortype) {
	    motion(event);
	}
/* experimental - allows painting of points */
	if (event->xmotion.state & Button1MotionMask) {
	    switch (action_flag) {
	    case PAINT_POINTS:
		{
		    int ind;
  		    /*extern*/ int paint_skip = 0;	/* defined in ptswin.c */
		    static int count = 0;

		    if (paint_skip < 0) {	/* initialize count */
			count = 0;
			paint_skip = -paint_skip + 1;
		    }
		    device2world(x, y, &wx, &wy);
		    if (add_setno >= 0) {
			if (paint_skip == 0 || (count % paint_skip == 0)) {
			    ind = getsetlength(cg, add_setno);
			    add_point(cg, add_setno, wx, wy, 0.0, 0.0, XY);
			    sprintf(buf, "Set %d, loc %d, (%lf, %lf)", add_setno, ind + 1, wx, wy);
/*			    xv_setstr(locate_point_item, buf); */
			    XDrawLine(disp, xwin, gc, x - 5, y - 5, x + 5, y + 5);
			    XDrawLine(disp, xwin, gc, x - 5, y + 5, x + 5, y - 5);
/*			    update_set_status(cg, add_setno); */
			    set_action(PAINT_POINTS);
			}
			count++;
		    } else {
			set_action(0);
		    }
		}
		break;
	    }
	}
	getpoints(x, y);
	break;
    default:
	break;
    }
/*
 * some mouse tracking stuff
 */
    switch (action_flag) {
    case MOVE_OBJECT_2ND:
	dx = sx - x;
	dy = sy - y;

	switch (ty) {
	case BOX:
	    select_region(sx, sy, xs, ys);
	    sx = x;
	    sy = y;
	    xs = xs - dx;
	    ys = ys - dy;
	    select_region(sx, sy, xs, ys);
	    break;
	case LINE:
	    select_line(sx, sy, xs, ys);
	    sx = x;
	    sy = y;
	    xs = xs - dx;
	    ys = ys - dy;
	    select_line(sx, sy, xs, ys);
	    break;
	case STRING:
	    select_region(sx, sy, xs, ys);
	    sx = x;
	    sy = y;
	    xs = xs - dx;
	    ys = ys - dy;
	    select_region(sx, sy, xs, ys);
	    break;
	}
	break;
    case STR_LOC:
	break;
    case LEG_LOC:
	break;
    }
    if (rectflag) {
	select_region(sx, sy, old_x, old_y);
	select_region(sx, sy, x, y);
    }
    if (rubber_flag) {
	select_line(sx, sy, old_x, old_y);
	select_line(sx, sy, x, y);
    }
    old_x = x;
    old_y = y;
}

/*
 * set the background color of the canvas
 * I don't believe this belongs here TODO
 */
void setbgcolor(c)
    int c;
{
    bgcolor = c;
}

/*
 * draw a crosshair cursor
 */
void motion(e)
    XMotionEvent *e;
{
    if (e->type != MotionNotify)
	return;
    /* Erase the previous crosshair */
    XDrawLine(disp, xwin, gcxor, 0, cursor_oldy, win_w, cursor_oldy);
    XDrawLine(disp, xwin, gcxor, cursor_oldx, 0, cursor_oldx, win_h);

    /* Draw the new crosshair */
    cursor_oldx = e->x;
    cursor_oldy = e->y;
    XDrawLine(disp, xwin, gcxor, 0, cursor_oldy, win_w, cursor_oldy);
    XDrawLine(disp, xwin, gcxor, cursor_oldx, 0, cursor_oldx, win_h);
}

/*
 * double click detection
 */
#define CLICKINT 400

int double_click(e)
    XButtonEvent *e;
{
    static Time lastc = 0;

    if (e->time - lastc < CLICKINT) {
	return 1;
    }
    lastc = e->time;
    return 0;
}

void
draw_tmp_tag(gno,x,y)
      int   gno;
      int   x,y;
{
      world w;
      int dx1,dy1,dx2,dy2;
      get_graph_world(gno,&w);
      world2device(w.xg1,w.yg1,&dx1,&dy1);
      world2device(w.xg2,w.yg2,&dx2,&dy2);
/*      select_line(x, dy1, x, dy2 ); */
      XDrawLine(disp, xwin, gc, x, (win_h-dy1), x, (win_h-dy2) ); 
      return;
}

int
define_tag_line(tagno,twx,twy1,twy2)
      int      tagno;
      double   twx, twy1, twy2;
{
      int lineno;
      if ((lineno = next_line()) >= 0) {
	    lines[lineno].gno = cg;
	    lines[lineno].loctype = REL_WORLD;
	    lines[lineno].tagitem = tagno;
	    lines[lineno].x1 = twx;
	    lines[lineno].x2 = twx;
	    lines[lineno].y1 = twy1;
	    lines[lineno].y2 = twy2;
	    lines[lineno].color = line_color;
	    lines[lineno].lines = line_lines;
	    lines[lineno].linew = line_linew;
	    lines[lineno].arrow = line_arrow;
	    lines[lineno].asize = line_asize;
	    lines[lineno].atype = line_atype;
	    draw_line(-2, lineno);
	    return(lineno);
      }
      return(-1);
}

int
define_tag_string(tagno,wx,wy)
      int    tagno;
      double wx, wy;
{      
      int i = -1;
      int tmp_string_loctype = string_loctype;
      double tmp_string_size = string_size;
      
      string_size = string_size*.60;
      string_loctype = REL_WORLD;
      
      i = define_string(tmpstr,wx,wy);
      if (i != -1) {
	    pstr[i].tagitem = tagno;
	    draw_string(-2,i);
      }

      string_size = tmp_string_size;
      string_loctype = tmp_string_loctype;
      return(i);
}

int
set_tag_ok(gno,x,y)
      int gno;
      int x,y;
{
      double vx, vy;
      device2view(x,y,&vx,&vy);
      if (g[gno].v.xv1 > vx || g[gno].v.xv2 < vx) return(0);
      if (g[gno].v.yv1 > vy || g[gno].v.yv2 < vy) return(0);
      return(1);
}

/*
 * the following are for spectra format sets
 */
int
get_chan_content(chan,x,y,xmin,xmax)
      int        chan;
      double     *x, *y;
      double     xmin, xmax;
{

      if ( chan < xmin || chan > xmax) return(0);

      if ( chan == (int) x[chan])
	    return( (int) y[chan]);
      else
	    return(0);
}

