/* $Id: fileswin.c,v 1.23 92/08/15 15:55:03 pturner Exp Locker: pturner $
 *
 * files Panel
 *
 * major problems here with the file selection dialog, I'm using
 * popen("ls etc. to get the files in the current directory TODO fix
 *
 */

#include <stdio.h>
#include <sys/param.h>
#include <xview/xview.h>
#include <xview/panel.h>

#include "globals.h"
#define  SORT_TRUE 1
#define  SORT_FALSE 0
#define  SORT_FAIL -1
#define  SORT_NOS_ERR -2

static char dirbuf[MAXPATHLEN];
char *getcwd();

extern Frame main_frame;
extern char *SORT_pipe;
Frame files_frame = (Frame) 0;
Panel files_panel;

/*
 * Panel item declarations
 */
static Panel_item files_type_choice_item;
static Panel_item files_list_list_item;
Panel_item files_dir_msg_item;
static Panel_item files_file_text_item;
static Panel_item files_graph_choice_item;
static Panel_item files_cbox_item;

/*
 * Event and Notify proc declarations
 */
static int files_Done_notify_proc();
static void files_type_notify_proc();
static void files_list_notify_proc();
static Panel_setting files_file_notify_proc();
static void files_graph_notify_proc();
static int files_accept_notify_proc();
static void update_files();

/*
 * Create the files Frame and the files Panel
 */
void create_file_popup()
{
    FILE *p;
    int i = 0;

    getcwd(dirbuf, MAXPATHLEN);

    if (files_frame) {
	xv_set(files_dir_msg_item, PANEL_LABEL_STRING, dirbuf, NULL);
	xv_set(files_frame, WIN_SHOW, TRUE, FRAME_CLOSED, FALSE, 0);
	return;
    }
    files_frame = (Frame) xv_create(main_frame, FRAME,
				    FRAME_LABEL, "files",
				    NULL);
    files_panel = (Panel) xv_create(files_frame, PANEL,
				    PANEL_LAYOUT, PANEL_VERTICAL,
				    NULL);
    files_dir_msg_item = (Panel_item) xv_create(files_panel, PANEL_MESSAGE,
						PANEL_LABEL_STRING, dirbuf,
						NULL);
    files_list_list_item = (Panel_item) xv_create(files_panel, PANEL_LIST,
					     PANEL_LABEL_STRING, "Contents",
					    XV_HELP_DATA, "xvgr:files_list",
				  PANEL_NOTIFY_PROC, files_list_notify_proc,
						  PANEL_LIST_DISPLAY_ROWS, 5,
						  NULL);
    files_type_choice_item = (Panel_item) xv_create(files_panel, PANEL_CHOICE_STACK,
					   PANEL_LABEL_STRING, "File type:",
					    XV_HELP_DATA, "xvgr:files_type",
						    PANEL_CHOICE_STRINGS,
						    "X Y",
						    "X Y1 Y2 ...",
						    "X Y DX",
						    "X Y DY",
						    "X Y DX1 DX2",
						    "X Y DY1 DY2",
						    "X Y DX DY",
						    "X HI LO OPEN CLOSE",
						    "X Y RADIUS",
						    NULL,
				     PANEL_VALUE_X, xv_col(files_panel, 18),
						    NULL);
    files_cbox_item = (Panel_item) xv_create(files_panel, PANEL_CHECK_BOX,
					      PANEL_CHOICE_NCOLS, 1,
					      PANEL_LAYOUT, PANEL_HORIZONTAL,
					      PANEL_LABEL_STRING,
					      "Spectrum type",
					      PANEL_VALUE_X, xv_col(files_panel, 18),
					      NULL);
    files_graph_choice_item = (Panel_item) xv_create(files_panel, PANEL_CHOICE_STACK,
				       PANEL_LABEL_STRING, "Read to graph:",
					   XV_HELP_DATA, "xvgr:files_graph",
						     PANEL_CHOICE_STRINGS,
						     "Current",
			   "0", "1", "2", "3", "4", "5", "6", "7", "8",
						     NULL,
				     PANEL_VALUE_X, xv_col(files_panel, 18),
						     NULL);
    files_file_text_item = (Panel_item) xv_create(files_panel, PANEL_TEXT,
				  PANEL_NOTIFY_PROC, files_file_notify_proc,
					     PANEL_LAYOUT, PANEL_HORIZONTAL,
					     PANEL_VALUE_DISPLAY_LENGTH, 20,
						PANEL_LABEL_STRING, "File:",
					    XV_HELP_DATA, "xvgr:files_file",
				      PANEL_VALUE_X, xv_col(files_panel, 8),
						  NULL);
    (void) xv_create(files_panel, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "Accept",
		     PANEL_NOTIFY_PROC, files_accept_notify_proc,
		     XV_HELP_DATA, "xvgr:files_accept",
		     XV_X, xv_col(files_panel, 2),
		     XV_Y, xv_row(files_panel, 9),
		     NULL);
    (void) xv_create(files_panel, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "Done",
		     PANEL_NOTIFY_PROC, files_Done_notify_proc,
		     XV_HELP_DATA, "xvgr:files_done",
		     XV_X, xv_col(files_panel, 15),
		     XV_Y, xv_row(files_panel, 9),
		     NULL);
    window_fit(files_panel);
    window_fit(files_frame);
    update_files(NULL);
    xv_set(files_frame, WIN_SHOW, TRUE, 0);
}				/* end create_files_panel */

static int set_types[] = {XY, NXY, XYDX, XYDY, XYDXDX, XYDYDY, XYDXDY, XYHILO, XYRT, -1};

/*
 * update the list with the current contents
 */
void update_file_list(mask, dirbuf, list_item, dir_item)
    char *mask, *dirbuf;
    Panel_item list_item, dir_item;
{
    int d1, i = 0;
    char buf[MAXPATHLEN + 17];
    char **dlist, **make_dir_list();
    int nitems, nadd;
    int n = (int) xv_get(list_item, PANEL_LIST_NROWS);

    dlist = make_dir_list(mask, &nitems);
    if (dlist != NULL) {
	getcwd(dirbuf, MAXPATHLEN);
	xv_set(dir_item, PANEL_LABEL_STRING, dirbuf, NULL);
	xv_set(list_item, XV_SHOW, FALSE, NULL);
	for (i = 0; i < n; i++) {
	    xv_set(list_item, PANEL_LIST_DELETE, 0, 0);
	}
	nadd = 0;
	for (i = 0; i < nitems; i++) {
	    strcpy(buf, dlist[i]);
	    if (isdir(buf)) {
		strcat(buf, "/");
		xv_set(list_item, PANEL_LIST_INSERT, nadd,
		       PANEL_LIST_STRING, nadd, buf, NULL);
		nadd++;
	    }
	}
	for (i = 0; i < nitems; i++) {
	    strcpy(buf, dlist[i]);
	    if (!isdir(buf)) {
		xv_set(list_item, PANEL_LIST_INSERT, nadd,
		       PANEL_LIST_STRING, nadd, buf, NULL);
		nadd++;
	    }
	}
	xv_set(list_item, XV_SHOW, TRUE, NULL);
    } else {
	errwin("Can't open directory");
    }
}

/*
 * update the state of the files popup
 */
static void update_files(mask)
    char *mask;
{
    int d1, i = 0;

    update_file_list(mask, dirbuf,
		     files_list_list_item,
		     files_dir_msg_item);
    while (curtype != set_types[i] && set_types[i] >= 0) {
	i++;
    }
    if (set_types[i] == -1) {
	curtype = XY;
	d1 = 0;
    } else {
	d1 = i;
    }
    xv_set(files_type_choice_item, PANEL_VALUE, d1, NULL);
}

/*
 * Notify and event procs
 */

/*ARGSUSED*/
static int files_Done_notify_proc(item, event)
    Panel_item item;
    Event *event;
{
    xv_set(files_frame, WIN_SHOW, FALSE, 0);
    return XV_OK;
}

/*ARGSUSED*/
static void files_list_notify_proc(item, s, cd, op, e)
    Panel_item item;
    char *s;
    caddr_t cd;
    Panel_list_op op;
    Event *e;
{
    static char buf[256];
    char stmp[MAXPATHLEN];
    FILE *p;
    XEvent *event = e->ie_xevent;

    if (s == NULL) {
	return;
    }
    strcpy(stmp, s);
    if (event_is_down(e) && op == PANEL_LIST_OP_SELECT) {
	if (double_click(event)) {
	    if (strcmp(buf, s)) {
		return;		/* string is different */
	    } else {
/* check to see if this is a directory */
		if (isdir(stmp)) {
		    if (!my_chdir(stmp)) {
			update_files(NULL);
			xv_set(files_file_text_item, PANEL_VALUE, "", NULL);
		    }
		} else {
		    if ((p = fopen(buf, "r")) == NULL) {
			char tmpbuf[256];

			sprintf(tmpbuf, "Unable to open file %s", stmp);
			errwin(tmpbuf);
		    } else {
			fclose(p);
			xv_set(files_file_text_item, PANEL_VALUE, stmp, NULL);
			files_accept_notify_proc();
		    }
		}
	    }
	    strcpy(buf, stmp);
	} else {
	    strcpy(buf, stmp);
	    if ((p = fopen(buf, "r")) == NULL) {
		sprintf(buf, "Unable to open file %s", stmp);
		errwin(buf);
	    } else {
		fclose(p);
		xv_set(files_file_text_item, PANEL_VALUE, stmp, NULL);
	    }
	}
    }
}

/*ARGSUSED*/
static Panel_setting files_file_notify_proc(item, event)
    Panel_item item;
    Event *event;
{
    int i = 0;
    char buf[MAXPATHLEN], buf2[MAXPATHLEN];

    strcpy(buf, (char *) xv_get(files_file_text_item, PANEL_VALUE));
    if (strlen(buf) == 0) {
	  return PANEL_NONE;
    }
    if (buf[0] == '~') {
	  expand_tilde(buf);
    }
    if (!my_chdir(buf)) {
	  update_files(NULL);
    } else {
	  update_files(buf);
	  if ((int) xv_get(files_list_list_item, PANEL_LIST_NROWS) == 1) {
		xv_set(files_file_text_item, PANEL_VALUE, buf, 0);
		files_accept_notify_proc(item, event);
	  }
    }
    return PANEL_NONE;
}

static char filesfname[MAXPATHLEN];
static int readtograph;
int spec_type;  /* carry information to files.c about whether this is a spectrum */

/*ARGSUSED*/
static int files_accept_notify_proc(item, event)
    Panel_item item;
    Event *event;
{
    int i = 0;
    char buf[MAXPATHLEN];
    int graphno;
    int d1;

    strcpy(buf, (char *) xv_get(files_file_text_item, PANEL_VALUE));
    if (strlen(buf) == 0) {
	return PANEL_NONE;
    }
    if (buf[0] == '~') {
	expand_tilde(buf);
    }
    if (!my_chdir(buf)) {
	update_files(NULL);
    } else {
	d1 = (int) xv_get(files_type_choice_item, PANEL_VALUE);
	
	switch (d1) {
	case 0:
	    curtype = XY;
	    break;
	case 1:
	    curtype = NXY;
	    break;
	case 2:
	    curtype = XYDX;
	    break;
	case 3:
	    curtype = XYDY;
	    break;
	case 4:
	    curtype = XYDXDX;
	    break;
	case 5:
	    curtype = XYDYDY;
	    break;
	case 6:
	    curtype = XYDXDY;
	    break;
	case 8:
	    curtype = XYHILO;
	    break;
	case 9:
	    curtype = XYRT;
	    break;
	}

	if ((int) xv_get(files_cbox_item,PANEL_VALUE))
	      spec_type = SPECTRUM_DATA;
	else
	      spec_type = FREE_DATA;
	strcpy(filesfname, (char *) xv_get(files_file_text_item, PANEL_VALUE));
	graphno = xv_get(files_graph_choice_item, PANEL_VALUE) - 1;
	if (graphno == -1) {
	    graphno = cg;
	}
	if (g[graphno].active == OFF) {
	    set_graph_active(graphno);
	}

	sprintf(buf, "Opening %s", filesfname);
	xv_set(files_dir_msg_item, PANEL_LABEL_STRING, buf, NULL);
	set_wait_cursor(1);
	if (getdata(graphno, filesfname, DISK, curtype)) {
	    if (autoscale_onread) {
		autoscale_proc();
	    }
	    drawgraph2(-1);
	}
	unset_wait_cursor(1);
	getcwd(dirbuf, MAXPATHLEN);
	xv_set(files_dir_msg_item, PANEL_LABEL_STRING, dirbuf, NULL);
    }
    return XV_OK;
}

#define NAME_SIZE 12
#include "sort_mem.h"
#define SORT_NEW_SPEC 2
#define SORT_OVERLAY_SPEC 3
#define ALL_AXIS 6

Notify_value
sort_sigusr1_handler(client,sig,mode)
      Notify_client    client;
      int              sig;
      int              mode;
{
      int    i, more;
      char   file[BUFSIZ];
/* receive this signal from sort process to display 1d spectra */
      int spec_type, readspectrum();
      int spectra_loaded = 0;
      int graphno = 0;
      
      set_wait_cursor(1);

/* open if in iconic state and put fame on top */
      xv_set(main_frame, FRAME_CLOSED, FALSE, NULL);
/*      wmgr_top(main_frame); */
/*      (void) strncpy(file,SORT_pipe,BUFSIZ); */
      (void) sprintf(file,"%s0",SORT_pipe);
      
      do {
/* read data from SORT_pipe */
	    if (read_from_pipe(file) == SORT_FAIL) {
		  errwin("Read from sort process failed");
		  unset_wait_cursor(1);
		  return XV_OK;
	    }
	    if ( sscanf(pshm->com_str,"%s %d",buf,&spec_type) != 2) {
		  errwin("Decoding of display spectrum command failed");
		  unset_wait_cursor(1);
		  return XV_OK;
	    }
	    if (spec_type != 1) {
		  errwin("sort_xvgr asked to display non 1d spectrum!");
		  unset_wait_cursor(1);
		  return XV_OK;
	    }
	    more = pshm->more;
/*
 * more == 0 occurs for last graph to be displayed
 * spectra_loaded == 0 occrurs only when this is the first graph loaded
 * hence more==0 && spectra_loaded==0 can only be true for 1st and only graph
 * therefore when displaying only one spectrum put data into current graph
 */
	    if (more == 0 && spectra_loaded == 0)  
		  graphno = cg;
	    else
		  cg = 0;
	    if(strncmp(buf,"OVERLA",6) == 0) {
		  char *ptr;
		  ptr = strchr(g[graphno].labs.stitle.s,'+');
		  if (ptr == NULL)
			ptr = g[graphno].labs.stitle.s+strlen(g[graphno].labs.stitle.s);
		  sprintf(ptr," + %s",pshm->name);
		  spec_type = SORT_OVERLAY_SPEC;
	    }
	    else {
		  for (i = 0; i < g[graphno].maxplot; i++) {
			if (isactive(graphno, i)) {
			      killset(graphno, i);
			}
		  }
		  strcpy(g[graphno].labs.stitle.s,pshm->name);
		  g[graphno].labs.stitle.active = ON;
		  spec_type = SORT_NEW_SPEC;
	    }
	    if (! isactive_graph(graphno)) {
		  set_graph_active(graphno);
	    }
/*
 *    do some thing here to take data from binary form
 * into xvgr XY data set form with spec = SPECTRUM_DATA
 */
	    if (strncmp(buf,"DISPLAX",7) == 0 || strncmp(buf,"OVERLAX",7) == 0)
	    {
		if ( readspectrumxy(graphno) == SORT_FAIL) {
		    errwin("Spectrum read into sort_xvgr failed");
		    unset_wait_cursor(1);
		    return XV_OK;
		}
	    }
	    else
	    {
		if ( readspectrum(graphno) == SORT_FAIL) {
		    errwin("Spectrum read into sort_xvgr failed");
		    unset_wait_cursor(1);
		    return XV_OK;
		}
	    }

	    /* do the reading of the data an display it (hopefully) */
	    if (spec_type == SORT_NEW_SPEC && autoscale_onread) {
		  defaultgraph(graphno);
		  default_axis(graphno,SPEC,X_AXIS);
		  default_axis(graphno,AUTO,Y_AXIS);
	    }
	    sprintf(file,"%s%d",SORT_pipe,more);
	    spectra_loaded++;
      } while(more && ++graphno < MAXGRAPH);

/* display spectra with layout determined by number of spectra loaded */
      (void) display_multi_graphs(spectra_loaded,graphno);
      
/* update focus on graphs */      
      update_all(cg);
      make_format(cg);
      draw_focus(cg); 

      unset_wait_cursor(1);

      return XV_OK;
}

extern void update_define_arrange();

int display_multi_graphs(nos,lastgraph)
      int nos;
      int lastgraph;
{
      register int i;
      int          min = lastgraph - nos + 1;

/* hide graphs that are not being updated */      
      for(i=0; i<MAXGRAPH; i++) {
	    if (i < min || i > lastgraph)
		  g[i].hidden = TRUE;
	    else
		  g[i].hidden = FALSE;  
      }

      switch(nos) {
	    case 1: {
		  set_axis_prop(-1, ALL_AXIS, CHAR, 1.00);
		  set_axis_prop(-1, ALL_AXIS, TICKLABEL, (double) ON);
		  update_define_arrange(1, 1, 0, 0.05, 0.05, 0.15, 0.10, 0.75, 0.80);
		  break;
	    }
	    
	    case 2: {
		  set_axis_prop(-1, ALL_AXIS, CHAR, 0.72);
		  set_axis_prop(-1, ALL_AXIS, TICKLABEL, (double) OFF);
		  update_define_arrange(2, 1, 0, 0.08, 0.07, 0.12, 0.05, 0.75, 0.41);
		  break;
	    }

	    case 3: {
		  set_axis_prop(-1, ALL_AXIS, CHAR, 0.72);
		  set_axis_prop(-1, ALL_AXIS, TICKLABEL, (double) OFF);
		  update_define_arrange(3, 1, 0, 0.08, 0.07, 0.12, 0.05, 0.75, 0.25);
		  break;
	    }

	    case 4: {
		  set_axis_prop(-1, ALL_AXIS, CHAR, 0.72);
		  set_axis_prop(-1, ALL_AXIS, TICKLABEL, (double) OFF);
		  update_define_arrange(2, 2, 0, 0.08, 0.08, 0.05, 0.05, 0.42, 0.41);
		  break;
	    }

	    default: {
		  errwin("cannot display > 4 spectra in this mode");
		  return(-1);
	    }
      }
      for(i=0; i<MAXGRAPH; i++) {
	    if (isactive_graph(i))
		  update_all(i);
      }
      return(0);
}
