/* $Id: graphutils2.c,v 1.3 92/06/20 08:50:59 pturner Exp Locker: pturner $
 *
 * utilities for graphs - second batch, scrolling, world stack and arrange
 *
 */
#include <stdio.h>
#include <math.h>
#include "globals.h"

void set_graph_active();
void push_world();
extern void clear_graph_viewport();


/*
 * pan through world coordinates
 */

void gwindleft_proc()
{
    double dx;
    int i;

    clear_graph_viewport(cg);
    if (scrolling_islinked) {
	for (i = 0; i < MAXGRAPH; i++) {
	    if (isactive_graph(i) && !islogx(i)) {
		dx = scrollper * (g[i].w.xg2 - g[i].w.xg1);
		g[i].w.xg1 = g[i].w.xg1 - dx;
		g[i].w.xg2 = g[i].w.xg2 - dx;
	    }
	}
    } else {
	if (!islogx(cg)) {
	    dx = scrollper * (g[cg].w.xg2 - g[cg].w.xg1);
	    g[cg].w.xg1 = g[cg].w.xg1 - dx;
	    g[cg].w.xg2 = g[cg].w.xg2 - dx;
	}
    }
    drawgraph2(cg);
}

void gwindright_proc()
{
    double dx;
    int i;
    
    clear_graph_viewport(cg);
    if (scrolling_islinked) {
	for (i = 0; i < MAXGRAPH; i++) {
	    if (isactive_graph(i) && !islogx(i)) {
		dx = scrollper * (g[i].w.xg2 - g[i].w.xg1);
		g[i].w.xg1 = g[i].w.xg1 + dx;
		g[i].w.xg2 = g[i].w.xg2 + dx;
	    }
	}
    } else {
	if (!islogx(cg)) {
	    dx = scrollper * (g[cg].w.xg2 - g[cg].w.xg1);
	    g[cg].w.xg1 = g[cg].w.xg1 + dx;
	    g[cg].w.xg2 = g[cg].w.xg2 + dx;
	}
    }
    drawgraph2(cg);
}

void gwinddown_proc()
{
    double dy;
    int i;
    tickmarks t;

    clear_graph_viewport(cg);
    if (scrolling_islinked) {
	for (i = 0; i < MAXGRAPH; i++) {
	    if (isactive_graph(i) && !islogy(i)) {
		dy = scrollper * (g[i].w.yg2 - g[i].w.yg1);
/*		g[i].w.yg1 = g[i].w.yg1 - dy; */
		g[i].w.yg2 = g[i].w.yg2 / 2.0; 
	    }
	}
    } else {
	if (!islogy(cg)) {
	    dy = scrollper * (g[cg].w.yg2 - g[cg].w.yg1);
/*	    g[cg].w.yg1 = g[cg].w.yg1 - dy; */
	    g[cg].w.yg2 = g[cg].w.yg2 / 2.0; 
	}
    }
    get_graph_tickmarks(cg,&t,Y_AXIS);
    t.tmajor /= 2.0;
    t.tminor /= 2.0;
    set_graph_tickmarks(cg,&t,Y_AXIS);
    drawgraph2(cg);
}

void gwindup_proc()
{
    double dy;
    int i;
    tickmarks t;

    clear_graph_viewport(cg);    
    if (scrolling_islinked) {
	for (i = 0; i < MAXGRAPH; i++) {
	    if (isactive_graph(i) && !islogy(i)) {
		dy = scrollper * (g[i].w.yg2 - g[i].w.yg1);
/*		g[i].w.yg1 = g[i].w.yg1 + dy; */
		g[i].w.yg2 = g[i].w.yg2 * 2.0; 
	    }
	}
    } else {
	if (!islogy(cg)) {
	    dy = scrollper * (g[cg].w.yg2 - g[cg].w.yg1);
/*	    g[cg].w.yg1 = g[cg].w.yg1 + dy; */
	    g[cg].w.yg2 = g[cg].w.yg2 * 2.0; 
	}
    }
    get_graph_tickmarks(cg,&t,Y_AXIS);
    t.tmajor *= 2.0;
    t.tminor *= 2.0;
    set_graph_tickmarks(cg,&t,Y_AXIS);
    drawgraph2(cg);
}

/*
 * set scroll amount
 */
void scroll_proc(value)
    int value;
{
    scrollper = value / 100.0;
    update_draw();
}

void scrollinout_proc(value)
    int value;
{
    shexper = value / 100.0;
    update_draw();
}

/*
 * set format string for locator
 */
static char *fchar[3] = {"lf", "le", "g"};
static char *typestr[6] = {"X, Y", "DX, DY", "DIST", "R, Theta", "VX, VY", "SX, SY"};
char locator_format[256] = {"G%1d: X, Y = [%.6g, %.6g]"};

void make_format(gno)
    int gno;
{
    int type, locpx, locfx, locpy, locfy;

    type = g[gno].pt_type;
    locfx = get_format_index(g[gno].fx);
    locfy = get_format_index(g[gno].fy);
    locpx = g[gno].px;
    locpy = g[gno].py;
    switch (type) {
    case 0:
	if (locfx < 3 && locfy < 3) {
	    sprintf(locator_format, "G%%1d: %s = [%%.%d%s, %%.%d%s]", typestr[type], locpx, fchar[locfx], locpy, fchar[locfy]);
	} else {
	    locator_format[0] = 0;
	}
	break;
    case 2:
	locfx = locfx == DECIMAL ? 0 :
		locfx == EXPONENTIAL ? 1 :
		locfx == GENERAL ? 2 : 0;
	sprintf(locator_format, "G%%1d: %s = [%%.%d%s]", typestr[type], locpx, fchar[locfx]);
	break;
    case 1:
    case 3:
    case 4:
	locfx = locfx == DECIMAL ? 0 :
		locfx == EXPONENTIAL ? 1 :
		locfx == GENERAL ? 2 : 0;
	locfy = locfy == DECIMAL ? 0 :
		locfy == EXPONENTIAL ? 1 :
		locfy == GENERAL ? 2 : 0;
	sprintf(locator_format, "G%%1d: %s = [%%.%d%s, %%.%d%s]", typestr[type], locpx, fchar[locfx], locpy, fchar[locfy]);
	break;
    case 5:
	sprintf(locator_format, "G%%1d: %s = [%%d, %%d]", typestr[type]);
	break;
    }
}

void arrange_graphs2(grows, gcols, vgap, hgap, sx, sy, wx, wy, applyto)
    int grows, gcols, applyto;
    double vgap, hgap, sx, sy, wx, wy;
{
    int i, j;
    int gtmp = 0;

    if (gcols != 1 || grows != 1) {
	for (i = 0; i < gcols; i++) {
	    for (j = 0; j < grows; j++) {
		g[gtmp].v.xv1 = sx + i * hgap + i * wx;
		g[gtmp].v.xv2 = sx + i * hgap + (i + 1) * wx;
		g[gtmp].v.yv1 = sy + j * vgap + j * wy;
		g[gtmp].v.yv2 = sy + j * vgap + (j + 1) * wy;
		if (!isactive_graph(gtmp)) {
		    set_graph_active(gtmp);
		}
		gtmp++;
	    }
	}
    }
    else {
	  for (j=0; j<MAXGRAPH; j++) {
		double tmpx2 = sx + wx;
		double tmpy2 = sy + wy;
		if (isactive_graph(j)) {
		      if (!fbounds(sx, 0.0, 1.0, "View xmin")) {
			    return;
		      } else if (!fbounds(tmpx2, sx, 1.0, "View xmax")) {
			    return;
		      } else if (!fbounds(sy, 0.0, 1.0, "View ymin")) {
			    return;
		      } else if (!fbounds(tmpy2, sy, 1.0, "View ymax")) {
			    return;
		      } else if (wx <= 0.0) {
			    return;
		      } else if (wy <= 0.0) {
			    return;
		      }
		      g[j].v.xv1 = sx;
		      g[j].v.xv2 = tmpx2;
		      g[j].v.yv1 = sy;
		      g[j].v.yv2 = tmpy2;
		}
	  }
    }
}

void define_autos(aon, au, ap, ameth, antx, anty)
    int aon, au, ap, ameth, antx, anty;
{
    int i, ming, maxg;

    if (au >= 0 && !isactive_set(cg, au)) {
	errwin("Set not active");
	return;
    }
    if (ap) {
	ming = 0;
	maxg = MAXGRAPH - 1;
    } else {
	ming = cg;
	maxg = cg;
    }
    if (ming == cg && maxg == cg) {
	if (!isactive_graph(cg)) {
	    errwin("Current graph is not active!");
	    return;
	}
    }
    for (i = ming; i <= maxg; i++) {
	if (isactive_graph(i)) {
	    if (ameth == 0) {
		g[i].auto_type = AUTO;
	    } else {
		g[i].auto_type = SPEC;
	    }
	    g[i].t[0].t_num = antx + 2;
	    g[i].t[1].t_num = anty + 2;
	    if (aon > -4) {	/* -4 == just set parameters but don't
				 * autoscale */
		if (au >= 0 && isactive_set(i, au)) {
		    autoscale_set(i, au, aon);
		} else {
		    autoscale_graph(i, aon);
		}
	    }
	}
    }
    if (aon != -4) {
	drawgraph2(-1);
    }
}

void define_arrange(nrows, ncols, pack, vgap, hgap, sx, sy, wx, wy)
    int nrows, ncols, pack;
    double vgap, hgap, sx, sy, wx, wy;
{
    int i, j, k, gno, applyto = 0;

    if (nrows * ncols > MAXGRAPH) {
	errwin("Too many rows and columns");
	return;
    }
    switch (pack) {
    case 0:
	for (j = 0; j < ncols; j++) {
	    for (i = 0; i < nrows; i++) {
		gno = i + j * nrows;
		for (k = 0; k < 2; k++) {
		    g[gno].t[k].tl_flag = ON;
		}
	    }
	}
	break;
    case 1:
	hgap = 0.0;
	for (j = 1; j < ncols; j++) {
	    for (i = 0; i < nrows; i++) {
		gno = i + j * nrows;
		for (k = 1; k < 6; k += 2) {
		    g[gno].t[k].tl_flag = OFF;
		}
	    }
	}
	break;
    case 2:
	vgap = 0.0;
	for (j = 0; j < ncols; j++) {
	    for (i = 1; i < nrows; i++) {
		gno = i + j * nrows;
		for (k = 0; k < 6; k += 2) {
		    g[gno].t[k].tl_flag = OFF;
		}
	    }
	}
	break;
    case 3:
	hgap = 0.0;
	vgap = 0.0;
	for (j = 1; j < ncols; j++) {
	    for (i = 0; i < nrows; i++) {
		gno = i + j * nrows;
		for (k = 1; k < 6; k += 2) {
		    g[gno].t[k].tl_flag = OFF;
		}
	    }
	}
	for (j = 0; j < ncols; j++) {
	    for (i = 1; i < nrows; i++) {
		gno = i + j * nrows;
		for (k = 0; k < 6; k += 2) {
		    g[gno].t[k].tl_flag = OFF;
		}
	    }
	}
	break;
    }
    arrange_graphs2(nrows, ncols, vgap, hgap, sx, sy, wx, wy, applyto);
    drawgraph2(-1);
}
