/* 
 *
 * ****** modified version of xvgr *******
 * YOU MAY MAKE COPIES OF ACE/GR FOR YOUR OWN USE, AND MODIFY THOSE COPIES.
 * YOU MAY NOT DISTRIBUTE ANY MODIFIED SOURCE CODE OR DOCUMENTATION TO USERS
 * AT ANY SITES OTHER THAN YOUR OWN.
 *
 * ACE/gr - Graphics for Exploratory Data Analysis
 * xvgr - The XView version
 * xmgr - The Motif version
 *
 * Comments, bug reports, etc to:
 *
 * Paul J. Turner
 * Department of Environmental Science and Engineering
 * Oregon Graduate Institute of Science and Technology
 * 19600 NW von Neumann Dr.
 * Beaverton, OR  97006-1999
 * pturner@amb4.ese.ogi.edu
 * **************************************
*/

/*
 *
 * main.c - entry point
 *
 */

/* for globals.h */
#define MAIN

#include <stdio.h>
#include <math.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/param.h>
#include <signal.h>
#include <xview/xview.h>
#include <xview/notify.h>

#include "globals.h"
#define SORT_TRUE   1
#define SORT_FALSE  0
#define SORT_FAIL  -1
#define SORT_NOS_ERR -2

int track_set = 0;
char            *SORT_pipe;
Notify_client sort_client = (Notify_client) 102;
static int sort_window = 0;
int DBX_val = 0;

int bc = 0;			/* for X11R4 servers w/XView 2.0 */
extern void do_main_loop();

void main(argc, argv)
    int argc;
    char *argv[];

{
    FILE *fp;
    int i, j;
    int cur_graph = cg = 0;		/* default graph is graph 0 */
    extern int realtime;	/* if data is to be plotted as it is read in */
    char *s;
    int  ppid;                  /* process id of parent */
    extern Notify_value   sort_sigusr1_handler();
    extern Notify_value   destroy_func();
    extern int shdat_init();
    
    s = getcwd(currentdir, 1024);	/* get the starting directory */


    /* get parent process id */
    ppid = getppid();
    
    /* check options*/
    for(i=1; argv[i] != NULL; i++) {
	  if (strcmp(argv[i],"-sort") == 0) {
		sort_window = 1;
		fprintf(stderr,"sort_xvgr started\n");
	  }
	  if (strcmp(argv[i],"-dbx") == 0) {
		debuglevel = (int) atof(argv[i+1]);
		DBX_val = debuglevel;
		fprintf(stderr,"sort_xvgr: diagnostics level set to %d\n",debuglevel);
	  } 
    }

    /*
     * open connection to  X server
     */
    if (xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, NULL) == NULL) {
	fprintf(stderr, "xv_init failed, server problems?\n");
	exit(1);
    }

    /* initialize plots, strings, graphs */
    set_program_defaults();

    /* initialize colormap data */
    initialize_cms_data();

    /* initialize device, here tdevice is always 0 = Xlib */
    device = tdevice = 0;

    /* initialize the signal handler for SIGUSR1 and ignore ^C */
    notify_set_signal_func(sort_client,sort_sigusr1_handler,SIGUSR1,NOTIFY_SYNC);
    notify_set_signal_func(sort_client,SIG_DFL,SIGTERM,NOTIFY_SYNC);
    notify_set_destroy_func(sort_client, destroy_func);

/* generate file name of SORT pipe for use with communications with sort process */
    if (sort_window) {
	  if ( s != NULL) {
		SORT_pipe = (char *) malloc(strlen(s)+15);
		if (SORT_pipe != NULL)
		      (void) sprintf(SORT_pipe,"%s/.SORT_pipe",s);
	  }
	  else {
		fprintf(stderr,"sort_xvgr couldn't generate pipe name for sort process");
		exit(-1);
	  }
#ifdef SVR4
	  sigset(SIGINT, SIG_IGN);
#else
	  signal(SIGINT, SIG_IGN);
#endif
    }
    /*
     * check for changed printer spooling strings
     */
     if ((s = getenv("GR_PS_PRSTR")) != NULL) {
	strcpy(ps_prstr, s);
    }

    set_graph_active(cur_graph);

/*
 * initialize the Hershey fonts
 */
    hselectfont(g[cg].d.font);
/*
 * go window things up - do_main_loop is in x[v,m]gr.c
 */
    defineworld(g[cg].w.xg1, g[cg].w.yg1, g[cg].w.xg2, g[cg].w.yg2, islogx(cg), islogy(cg));
    viewport(g[cg].v.xv1, g[cg].v.yv1, g[cg].v.xv2, g[cg].v.yv2);
    (void) do_main_loop();
    exit(0);
}

/* 
 *  Initialize XView and do_main_loop()
 */
#include <X11/Xlib.h>
#include <xview/xview.h>
#include <xview/frame.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/cursor.h>
#include <xview/font.h>
#include <xview/svrimage.h>
#include <xview/icon.h>
#include <xview/cms.h>
#include <xview/sel_attrs.h>
#include <xview/textsw.h>

/* paint window of canvas */
Xv_Window paint_window;

/* color map */
Cms cms;
extern Xv_singlecolor cmscolors[];
extern unsigned long colors[];
unsigned long *mcolors;
extern Colormap mycmap;

/* display */
extern Display *disp;

/* X drawable for canvas */
extern Window xwin;

/* toggle the locator on & off */
extern int go_locateflag;	/* defined in events.c */

/* an icon */
unsigned short closed_bits[] = {
#include "icon.h"
};

/* and an icon mask */
unsigned short mask_bits[] = {
#include "icon_mask.h"
};

Server_image closed_image, mask_image;
Icon icon;

Frame main_frame = (Frame) 0;	/* main frame and panel */
Panel main_panel;
Canvas canvas;			/* canvas to draw graph and associated pixwin */

Panel_item locate_item;		/* locator on main_panel */
Panel_item mark_item;		/* mark value on main_panel for tags*/

static Menu files_menu;		/* pulldown menus on main panel */
static Menu draw_menu;	        /* view menu*/

/*
 * callbacks added by sjah ... move at laster date
 */
void do_tag();
void do_expand();
void do_clear_tags();
void do_mark_proc();
void do_mark();
void do_clear_fits();
void do_showfit_peaks();
void do_hidefit_peaks();

/*
 * forward decls for callbacks
 */
void do_hardcopy();
void doforce_redraw();
void my_proc();
void my_resize_proc();
void refresh();
void gwindup_proc();
void gwindleft_proc();
void gwindright_proc();
void gwinddown_proc();
void autoscale_proc();
void autoticks_proc();

/*
 * for compwin1.c callbacks
 */
void create_int_frame();
void create_buffit_frame();
void create_peakf_frame();
void create_mstick_frame();

/*
 * for compwin2.c callbacks
 */
void create_eval_frame();
void create_load_frame();
void create_histo_frame();
void create_fourier_frame();
void create_run_frame();
void create_reg_frame();
void create_nonl_frame();
void create_diff_frame();
void create_xcor_frame();
void create_spline_frame();
void create_samp_frame();
void create_digf_frame();
void create_lconv_frame();
void create_leval_frame();


/*
 * for Set operations pullright
 */

void create_activate_frame();
void create_swap_frame();
void create_drop_frame();
void create_kill_frame();
void create_sort_frame();
void create_write_frame();

void do_flush();

/*
 * for graphs pullright
 */

void create_gactive_frame();
void create_gcopy_frame();
void create_gfocus_frame();
void create_gshow_frame();
void create_gtype_frame(); 


/*
 * for Strings & things pullright
 */
void define_objects_popup();
void define_strings_popup();
void define_lines_popup();
void define_boxes_popup();
void do_boxes_proc();
void do_lines_proc();
void do_move_proc();
void do_delete_object_proc();
void strings_loc_proc();
void strings_ang_proc();
void strings_edit_proc();
void edit_objects_proc();
/* void do_clear_lines(); */
/* void do_clear_boxes(); */
/* void do_clear_text(); */

/*
 * for point operations pullright
 */
void do_find_points();
void do_track_points();
void do_delete_points();
void create_goto_frame();

void update_worldview();	/* update world, view windows if any changes
				 * made during mouse controlled zoom */
void drawgraph2();		/* calls plotone(), called any time the graph
				 * needs to be re-drawn not used as a canvas
				 * redraw proc */

void define_symbols_popup();   	/* define set symbols popup */
void define_legend_popup();   	/* define graph legend popup */
void define_points_popup();	/* edit points, defined in ptswin.c */

void create_printer_setup();
void create_props_frame(); 	/* set properties */
void create_page_frame();	/* set page properties */
void create_frame_frame();
void create_draw_frame();
void create_view_frame();
void create_autos_frame();
void create_arrange_frame();
void create_default_frame();
void create_label_frame(); 
void create_graph_frame();
void define_strings_popup();	/* strings popup, routines in strwin.c */
void define_setops_popup();	/* set operations, routines in setwin.c */
void create_file_popup();	/* read XY data */
void create_writes_frame();	/* write sets */
void create_com_frame();	/* */
void create_world_frame(); 	/* define the world dimensions, defined in
				 * worldwin.c */
void create_ticks_frame(); 
void define_colors_popup();	/* defined in colorwin.c */

void update_set_status();

/*
 * show the current state of potentially long running commands
 * in the footer
 */
void set_right_footer(s)
    char *s;
{
    char *str;
    struct tm tm, *localtime();
    long time_value;
    char name[256];

    if (inwin) {
	if (s) {
	    xv_set(main_frame, FRAME_RIGHT_FOOTER, s, NULL);
	} else {
	    (void) time(&time_value);
	    tm = *localtime(&time_value);
	    str = asctime(&tm);
	    strcpy(name, disp->display_name);
	    strcat(name, " | ");
	    strcat(name, str);
	    xv_set(main_frame, FRAME_RIGHT_FOOTER, name, NULL);
	}
    }
}

void set_left_footer(s)
    char *s;
{
    if (inwin) {
	xv_set(main_frame, FRAME_LEFT_FOOTER, s, NULL);
    }
}

/*
 * for ^X received by the canvas event proc
 */
void bailout()
{
    if (xv_destroy_safe(main_frame) == XV_OK) {
	exit(0);
    }
}

/*
 * exit by button on front panel
 */
/*ARGSUSED*/
static void quit_main_proc(item, event)
    Panel_item item;
    Event *event;
{
    bailout();
}

/*
 * set action to SEL_POINT for selecting the locator reference point
 */
static void do_select_point()
{
    set_action(0);
    set_action(SEL_POINT);
    g[cg].pointset = TRUE;
}

/*
 * clear the locator reference point
 */
static void do_clear_point()
{
    g[cg].pointset = FALSE;
    g[cg].pt_type = 0;
    g[cg].dsx = g[cg].dsy = 0.0;
}

/*
 * total wipeout of graphs, sets, annotation
 */
void clear_all()
{
    wipeout(1);
}

/*
 * read mark value and tag it on current spectrum
 */
void
do_mark_proc()
{
      double wx;
      wx = atof((char *) xv_get(mark_item,PANEL_VALUE));
      do_mark(wx);
      return;
}
Panel_setting eotmark_proc(item, event)
    Panel_item item;
    Event *event;
{
    switch (event_id(event)) {
    case '\r':
    case '\n':
	do_mark_proc(item, event);
	return PANEL_NONE;
    default:
	return (panel_text_notify(item, event));
    }
}

/*
 * set current directory labels
 */
void set_curdir()
{
    char d[MAXPATHLEN];
    extern Panel_item files_dir_msg_item;
/*    extern Panel_item block_dir_msg_item;
    extern Panel_item comr_dir_msg_item;
    extern Panel_item comw_dir_msg_item;
    extern Panel_item parmsr_dir_msg_item;
    extern Panel_item parmsw_dir_msg_item; */
    extern Panel_item write_dir_msg_item;
/*    extern Panel_item saveall_dir_msg_item; */

    getcwd(d, MAXPATHLEN);
    xv_set(main_frame, XV_LABEL, d, NULL);
    if (files_dir_msg_item) {
	xv_set(files_dir_msg_item, PANEL_LABEL_STRING, d, NULL);
    }
/*    if (block_dir_msg_item) {
	xv_set(block_dir_msg_item, PANEL_LABEL_STRING, d, NULL);
    }
    if (comr_dir_msg_item) {
	xv_set(comr_dir_msg_item, PANEL_LABEL_STRING, d, NULL);
    }
    if (comw_dir_msg_item) {
	xv_set(comw_dir_msg_item, PANEL_LABEL_STRING, d, NULL);
    }
    if (parmsr_dir_msg_item) {
	xv_set(parmsr_dir_msg_item, PANEL_LABEL_STRING, d, NULL);
    }
    if (parmsw_dir_msg_item) {
	xv_set(parmsw_dir_msg_item, PANEL_LABEL_STRING, d, NULL);
    } */
    if (write_dir_msg_item) {
	xv_set(write_dir_msg_item, PANEL_LABEL_STRING, d, NULL);
    }
/*    if (saveall_dir_msg_item) {
	xv_set(saveall_dir_msg_item, PANEL_LABEL_STRING, d, NULL);
    }
*/
}

/*
 * main panel
 */
void do_main_loop()
{
    int i;
    Menu m1, m2, m3, m4, m5;
    char name[256];

    getcwd(name, 255);

    main_frame = (Frame) xv_create(NULL, FRAME,
				   FRAME_SHOW_FOOTER, TRUE,
				   FRAME_LEFT_FOOTER, "Locator",
				   FRAME_RIGHT_FOOTER, "Idle",
				   XV_WIDTH, 705,
				   XV_HEIGHT, 600,
				   FRAME_CLOSED, (sort_window == 0) ? FALSE : TRUE,
				WIN_ERROR_MSG, "Couldn't create main_frame",
				   XV_LABEL, name, NULL);

    main_panel = (Panel) xv_create(main_frame, PANEL,
				   XV_HELP_DATA, "xvgr:main_panel",
				   WIN_ROW_GAP, 1,
				   NULL);

    (void) xv_create(main_panel, PANEL_BUTTON,
		     XV_X, xv_col(main_panel, 43),
		     XV_Y, xv_row(main_panel, 0),
		     XV_HELP_DATA, "xvgr:expand",
		     PANEL_LABEL_STRING, "<< >>",
		     PANEL_NOTIFY_PROC, do_expand,
		     NULL);

    (void) xv_create(main_panel, PANEL_BUTTON,
		     XV_X, xv_col(main_panel, 36),
		     XV_Y, xv_row(main_panel, 1),
		     XV_HELP_DATA, "xvgr:mark",
		     PANEL_LABEL_STRING, "mark",
		     PANEL_NOTIFY_PROC, do_mark_proc,
		     NULL);

    mark_item = (Panel_item) xv_create(main_panel, PANEL_TEXT,
				         PANEL_VALUE_DISPLAY_LENGTH, 7,
					 XV_X, xv_col(main_panel, 43),
					 XV_Y, xv_row(main_panel, 1),
				         PANEL_NOTIFY_STRING, "\n\r",
				         PANEL_NOTIFY_PROC, eotmark_proc,
					 XV_HELP_DATA, "xvgr:mark",
					 NULL);

     m1 = (Menu) xv_create(NULL, MENU,
			  MENU_GEN_PIN_WINDOW, main_frame, "Autoscale",
			  MENU_ITEM,
			  MENU_STRING, "Autoscale",
			  XV_HELP_DATA, "xvgr:autoscale",
			  MENU_NOTIFY_PROC, autoscale_proc, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Autoframe ...",
			  XV_HELP_DATA, "xvgr:autoscale",
			  MENU_NOTIFY_PROC, create_autos_frame, NULL,
			  NULL);
			      
    (void) xv_create(main_panel, PANEL_BUTTON,
		     PANEL_LABEL_WIDTH, 60,
		     XV_X, xv_col(main_panel, 51),
		     XV_Y, xv_row(main_panel, 0),
		     XV_HELP_DATA, "xvgr:autoscale",
		     PANEL_LABEL_STRING, "AutoScale",
		     PANEL_ITEM_MENU, m1,  
		     NULL);

    (void) xv_create(main_panel, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "Re-draw",
		     PANEL_LABEL_WIDTH, 60,
		     PANEL_NOTIFY_PROC, doforce_redraw,
		     XV_HELP_DATA, "xvgr:redraw",
		     XV_X, xv_col(main_panel, 51),
		     XV_Y, xv_row(main_panel, 1),
		     NULL);  

   
    (void) xv_create(main_panel, PANEL_BUTTON,
		     XV_X, xv_col(main_panel, 63),
		     XV_Y, xv_row(main_panel, 0),
		     XV_HELP_DATA, "xvgr:tag",
		     PANEL_LABEL_STRING, "Draw Tag ",
		     PANEL_NOTIFY_PROC, do_tag,
		     NULL);

    (void) xv_create(main_panel, PANEL_BUTTON,
		     XV_X, xv_col(main_panel, 63),
		     XV_Y, xv_row(main_panel, 1),
		     XV_HELP_DATA, "xvgr:tag",
		     PANEL_LABEL_STRING, "Clear Tags",
		     PANEL_NOTIFY_PROC, do_clear_tags,
		     NULL);

    (void) xv_create(main_panel, PANEL_BUTTON,
		     XV_X, xv_col(main_panel, 74),
		     XV_Y, (xv_row(main_panel, 1) - xv_row(main_panel, 0))/2,
		     XV_HELP_DATA, "xvgr:left",
		     PANEL_LABEL_STRING, "<<",
		     PANEL_NOTIFY_PROC, gwindleft_proc,
		     NULL);
    (void) xv_create(main_panel, PANEL_BUTTON,
		     XV_X, xv_col(main_panel, 83),
		     XV_Y, (xv_row(main_panel, 1) - xv_row(main_panel, 0))/2,
		     XV_HELP_DATA, "xvgr:right",
		     PANEL_LABEL_STRING, ">>",
		     PANEL_NOTIFY_PROC, gwindright_proc,
		     NULL);
    (void) xv_create(main_panel, PANEL_BUTTON,
		     XV_X, xv_col(main_panel, 79),
		     XV_Y, xv_row(main_panel, 0),
		     XV_HELP_DATA, "xvgr:up",
		     PANEL_LABEL_STRING, "^",
		     PANEL_NOTIFY_PROC, gwinddown_proc,
		     NULL);
    (void) xv_create(main_panel, PANEL_BUTTON,
		     XV_X, xv_col(main_panel, 79),
		     XV_Y, xv_row(main_panel, 1),
		     XV_HELP_DATA, "xvgr:down",
		     PANEL_LABEL_STRING, "_",
		     PANEL_NOTIFY_PROC, gwindup_proc,
		     NULL);

    locate_item = (Panel_item) xv_create(main_panel, PANEL_MESSAGE,
					 XV_X, xv_col(main_panel, 0),
					 XV_Y, xv_row(main_panel, 1) + 5,
					 XV_HELP_DATA, "xvgr:locator",
					 PANEL_LABEL_STRING, "[X,Y]",
					 NULL);

    window_fit_height(main_panel);

/*
 * initialize canvas and set colors
 */

    disp = (Display *) xv_get(main_frame, XV_DISPLAY);
    if (monomode) {
	use_colors = 1;
    } else {
	use_colors = DisplayPlanes(disp, DefaultScreen(disp));
    }
    if (use_colors > 4) {
	for (i = 0; i < MAXGRAPH; i++) {
	    if (g[i].parmsread != TRUE) {
		setdefaultcolors(i);
	    }
	}
    }
    if (use_colors > 4) {
	/* one more allocated than needed */
	cms = (Cms) xv_create(NULL, CMS,
			      CMS_NAME, "palette",
			      CMS_TYPE, XV_DYNAMIC_CMS,
			      CMS_SIZE, maxcolors + 1,
			      CMS_COLORS, cmscolors,
			      NULL);
	canvas = (Canvas) xv_create(main_frame, CANVAS,
/*
				    XV_WIDTH, 800,
				    XV_HEIGHT, 700,
*/
				    CANVAS_WIDTH, 800,
				    CANVAS_HEIGHT, 700,
				    CANVAS_AUTO_EXPAND, TRUE,
				    CANVAS_AUTO_SHRINK, TRUE,
				    CANVAS_AUTO_CLEAR, TRUE,
				    CANVAS_RETAINED, TRUE,
				    WIN_RETAINED, TRUE,
				    XV_SHOW, TRUE,
				    WIN_CMS, cms,
				    NULL);
	mcolors = (unsigned long *) xv_get(canvas, WIN_X_COLOR_INDICES);
	for (i = 0; i < maxcolors; i++) {
	    colors[i] = mcolors[i];
	}
    } else {
	canvas = (Canvas) xv_create(main_frame, CANVAS,
/*
				    XV_WIDTH, 800,
				    XV_HEIGHT, 700,
*/
				    CANVAS_HEIGHT, 600,
				    CANVAS_WIDTH, 500,
				    CANVAS_AUTO_EXPAND, TRUE,
				    CANVAS_AUTO_SHRINK, TRUE,
				    CANVAS_AUTO_CLEAR, TRUE,
				    CANVAS_RETAINED, TRUE,
				    WIN_RETAINED, TRUE,
				    XV_SHOW, TRUE,
				    NULL);
    }
    colors[0] = WhitePixel(disp, DefaultScreen(disp));
    colors[1] = BlackPixel(disp, DefaultScreen(disp));
    if (revflag) {
	iswap(&colors[0], &colors[1]);
    }
    xv_set(canvas_paint_window(canvas), WIN_CONSUME_EVENTS,
	   WIN_ASCII_EVENTS,
	   LOC_DRAG,
	   LOC_MOVE,
	   LOC_WINENTER,
	   LOC_WINEXIT,
	   WIN_MOUSE_BUTTONS,
	   NULL,
	   WIN_EVENT_PROC, my_proc,
	   NULL);

    paint_window = canvas_paint_window(canvas);
    xwin = (Window) xv_get(paint_window, XV_XID);

/*
 * create pulldown menus
 */
    files_menu = (Menu) menu_create(
				    MENU_GEN_PIN_WINDOW, main_frame, "Files",
				    MENU_ITEM, MENU_STRING,
				    "Read sets...",
				    XV_HELP_DATA, "xvgr:read_sets",
				 MENU_NOTIFY_PROC, create_file_popup, NULL,
/*				    MENU_ITEM, MENU_STRING,
				    "Read parameters...",
				    XV_HELP_DATA, "xvgr:read_parms",
				MENU_NOTIFY_PROC, create_parmsr_frame, NULL,
				    MENU_ITEM, MENU_STRING,
				    "Read block data...",
				    XV_HELP_DATA, "xvgr:read_blocks",
				 MENU_NOTIFY_PROC, create_block_frame, NULL,
				    MENU_ITEM, MENU_STRING,
				   "", MENU_INACTIVE, TRUE, NULL,
				    MENU_ITEM, MENU_STRING,
				    "Save all...",
				    XV_HELP_DATA, "xvgr:save_all",
			       MENU_NOTIFY_PROC, create_saveall_frame, NULL, */
				    MENU_ITEM, MENU_STRING,
				    "Write sets...",
				    XV_HELP_DATA, "xvgr:write_sets",
				 MENU_NOTIFY_PROC, create_write_frame, NULL,
/*				    MENU_ITEM, MENU_STRING,
				    "Write parameters...",
				    XV_HELP_DATA, "xvgr:write_parms",
				MENU_NOTIFY_PROC, create_wparam_frame, NULL,
				    MENU_ITEM, MENU_STRING,
				   "", MENU_INACTIVE, TRUE, NULL, */
				    MENU_ITEM, MENU_STRING,
				   "", MENU_INACTIVE, TRUE, NULL, 
				    MENU_ITEM, MENU_STRING,
				    "Print",
				    XV_HELP_DATA, "xvgr:print",
				    MENU_NOTIFY_PROC, do_hardcopy, NULL,
				    MENU_ITEM, MENU_STRING,
				    "Printer setup...",
				    XV_HELP_DATA, "xvgr:printer_setup",
			       MENU_NOTIFY_PROC, create_printer_setup, NULL, /*
				    MENU_ITEM, MENU_STRING,
				   "", MENU_INACTIVE, TRUE, NULL,
*/
/*				    MENU_ITEM, MENU_STRING,
				   "", MENU_INACTIVE, TRUE, NULL,
				    MENU_ITEM, MENU_STRING,
				    "Status...",
				    XV_HELP_DATA, "xvgr:status",
				MENU_NOTIFY_PROC, define_status_popup, NULL,
				    MENU_ITEM, MENU_STRING,
				    "Results...",
				    XV_HELP_DATA, "xvgr:monitor",
			       MENU_NOTIFY_PROC, create_monitor_frame, NULL,
				    MENU_ITEM, MENU_STRING,
				    "About...",
				    XV_HELP_DATA, "xvgr:about",
				MENU_NOTIFY_PROC, create_about_grtool, NULL,
*/
				    MENU_ITEM, MENU_STRING,
				   "", MENU_INACTIVE, TRUE, NULL, 
				    MENU_ITEM, MENU_STRING,
				    "Clear all...",
				    XV_HELP_DATA, "xvgr:clear_all",
				    MENU_NOTIFY_PROC, clear_all, NULL,
				    MENU_ITEM, MENU_STRING,
				   "", MENU_INACTIVE, TRUE, NULL,
				    MENU_ITEM, MENU_STRING,
				    "Exit",
				    XV_HELP_DATA, "xvgr:exit",
				    MENU_NOTIFY_PROC, quit_main_proc, NULL,
				    NULL);
    (void) xv_create(main_panel, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "File",
		     PANEL_ITEM_MENU, files_menu,
		     XV_HELP_DATA, "xvgr:files_menu",
		     XV_X, xv_col(main_panel, 0),
		     XV_Y, xv_row(main_panel, 0),
		     NULL);
/*
 * create view pulldown menu
 */
    m1 = (Menu) xv_create(NULL, MENU,
			  MENU_GEN_PIN_WINDOW, main_frame, "Graph ops",
			  MENU_ITEM,
			  MENU_STRING, "Activate...(1)",
			  XV_HELP_DATA, "xvgr:graph_activate",
			  MENU_NOTIFY_PROC, create_gactive_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Copy...(2)",
			  XV_HELP_DATA, "xvgr:graph_copy",
			  MENU_NOTIFY_PROC, create_gcopy_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Swap...(2)",
			  XV_HELP_DATA, "xvgr:graph_swap",
			  MENU_NOTIFY_PROC, create_gcopy_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Kill...(1)",
			  XV_HELP_DATA, "xvgr:graph_kill",
			  MENU_NOTIFY_PROC, create_gactive_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Focus...",
			  XV_HELP_DATA, "xvgr:graph_focus",
			  MENU_NOTIFY_PROC, create_gfocus_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Show...",
			  XV_HELP_DATA, "xvgr:graph_show",
			  MENU_NOTIFY_PROC, create_gshow_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Set graph type...",
			  XV_HELP_DATA, "xvgr:graph_type",
			  MENU_NOTIFY_PROC, create_gtype_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Arrange graphs...",
			  XV_HELP_DATA, "xvgr:graph_arrange",
			  MENU_NOTIFY_PROC, create_arrange_frame, NULL,
			  NULL);
         (void) xv_create(main_panel, PANEL_BUTTON,
		          PANEL_LABEL_STRING, "Graphs",
		          PANEL_LABEL_WIDTH, 40,
		          PANEL_ITEM_MENU, m1,  
		          XV_HELP_DATA, "xvgr:graphs",
		          XV_X, xv_col(main_panel, 26),
		          XV_Y, xv_row(main_panel, 1),
		          NULL); 
    
/*    m2 = (Menu) xv_create(NULL, MENU,
			MENU_GEN_PIN_WINDOW, main_frame, "Strings & things",
			  MENU_ITEM,
			  MENU_STRING, "Text",
			  XV_HELP_DATA, "xvgr:objects_text",
			  MENU_NOTIFY_PROC, strings_loc_proc, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Text at angle",
			  XV_HELP_DATA, "xvgr:objects_text_at_angle",
			  MENU_NOTIFY_PROC, strings_ang_proc, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Edit Text",
			  XV_HELP_DATA, "xvgr:objects_edit_text",
			  MENU_NOTIFY_PROC, strings_edit_proc, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Text props...",
			  XV_HELP_DATA, "xvgr:objects_text_props",
			  MENU_NOTIFY_PROC, define_strings_popup, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Line",
			  XV_HELP_DATA, "xvgr:objects_line",
			  MENU_NOTIFY_PROC, do_lines_proc, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Line props...",
			  XV_HELP_DATA, "xvgr:objects_line_props",
			  MENU_NOTIFY_PROC, define_lines_popup, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Box",
			  XV_HELP_DATA, "xvgr:objects_box",
			  MENU_NOTIFY_PROC, do_boxes_proc, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Box props...",
			  XV_HELP_DATA, "xvgr:objects_box_props",
			  MENU_NOTIFY_PROC, define_boxes_popup, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Move object",
			  XV_HELP_DATA, "xvgr:objects_move",
			  MENU_NOTIFY_PROC, do_move_proc, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Delete object",
			  XV_HELP_DATA, "xvgr:objects_delete",
			  MENU_NOTIFY_PROC, do_delete_object_proc, NULL,
*/
/*
			  MENU_ITEM,
			  MENU_STRING, "Edit object",
			  XV_HELP_DATA, "xvgr:objects_edit",
			  MENU_NOTIFY_PROC, edit_objects_proc, NULL,
*/
/*			  MENU_ITEM,
			  MENU_STRING, "Clear all text",
			  XV_HELP_DATA, "xvgr:objects_clear_text",
			  MENU_NOTIFY_PROC, do_clear_text, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Clear all lines",
			  XV_HELP_DATA, "xvgr:objects_clear_lines",
			  MENU_NOTIFY_PROC, do_clear_lines, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Clear all boxes",
			  XV_HELP_DATA, "xvgr:objects_clear_boxes",
			  MENU_NOTIFY_PROC, do_clear_boxes, NULL,
			  NULL);
*/
/*    m3 = (Menu) xv_create(NULL, MENU,
			  MENU_ITEM,
			  MENU_STRING, "Set fixed point",
			  XV_HELP_DATA, "xvgr:fixedpoint_set",
			  MENU_NOTIFY_PROC, do_select_point, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Clear fixed point",
			  XV_HELP_DATA, "xvgr:fixedpoint_clear",
			  MENU_NOTIFY_PROC, do_clear_point, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Props...",
			  XV_HELP_DATA, "xvgr:fixedpoint_props",
			  MENU_NOTIFY_PROC, create_locator_frame, NULL,
			  NULL);
*/
  
    draw_menu = (Menu) menu_create(
				   MENU_GEN_PIN_WINDOW, main_frame, "View",
/*  				   MENU_ITEM, MENU_STRING,
				   "Graphs",
				   XV_HELP_DATA, "xvgr:graphs_pullright",
  				   MENU_PULLRIGHT, m1,
				   NULL, */
				   MENU_ITEM, MENU_STRING,
				   "Define world...",
				   XV_HELP_DATA, "xvgr:world",
				 MENU_NOTIFY_PROC, create_world_frame, NULL,
/*				   MENU_ITEM, MENU_STRING,
				   "Define view...",
				   XV_HELP_DATA, "xvgr:view",
				   MENU_NOTIFY_PROC, create_view_frame, NULL,
				   MENU_ITEM, MENU_STRING,
				   "Autoscale...",
				   XV_HELP_DATA, "xvgr:autoscale",
				 MENU_NOTIFY_PROC, create_autos_frame, NULL,
				   MENU_ITEM, MENU_STRING,
				   "", MENU_INACTIVE, TRUE, NULL,
				   MENU_ITEM, MENU_STRING,
				   "Draw options...",
				   XV_HELP_DATA, "xvgr:draw_options",
				   MENU_NOTIFY_PROC, create_draw_frame, NULL,
				   MENU_ITEM, MENU_STRING,
				   "Toggles...",
				   XV_HELP_DATA, "xvgr:props",
				   MENU_NOTIFY_PROC, create_props_frame, NULL,
				   MENU_ITEM, MENU_STRING,
				   "Page layout...",
				   XV_HELP_DATA, "xvgr:page",
				   MENU_NOTIFY_PROC, create_page_frame, NULL,
*/
/*				   MENU_ITEM, MENU_STRING,
				   "Misc....",
				   XV_HELP_DATA, "xvgr:misc",
				   MENU_NOTIFY_PROC, create_misc_frame, NULL,
				   MENU_ITEM, MENU_STRING,
				   "", MENU_INACTIVE, TRUE, NULL,
*/
  
				   MENU_ITEM, MENU_STRING,
				   "Title/subtitle...",
				   XV_HELP_DATA, "xvgr:title",
				 MENU_NOTIFY_PROC, create_label_frame, NULL,
  				   MENU_ITEM, MENU_STRING,
				   "Ticks/tick labels...",
				   XV_HELP_DATA, "xvgr:ticks",
				 MENU_NOTIFY_PROC, create_ticks_frame, NULL,
  				   MENU_ITEM, MENU_STRING,
				   "Symbols...",
				   XV_HELP_DATA, "xvgr:symbols",
			       MENU_NOTIFY_PROC, define_symbols_popup, NULL,
  				   MENU_ITEM, MENU_STRING,
				   "Legends...",
				   XV_HELP_DATA, "xvgr:legends",
				MENU_NOTIFY_PROC, define_legend_popup, NULL,
/*				   MENU_ITEM, MENU_STRING,
				   "Frame...",
				   XV_HELP_DATA, "xvgr:frame",
				 MENU_NOTIFY_PROC, create_frame_frame, NULL,
				   MENU_ITEM, MENU_STRING,
				   "Strings & things",
				   XV_HELP_DATA, "xvgr:objects",
				   MENU_PULLRIGHT, m2,
				   NULL,
				   MENU_ITEM, MENU_STRING,
				   "", MENU_INACTIVE, TRUE, NULL, */
				   NULL);

      (void) xv_create(main_panel, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "View",
		     PANEL_ITEM_MENU, draw_menu,
		     XV_HELP_DATA, "xvgr:view_menu",
		     XV_X, xv_col(main_panel, 8),
		     XV_Y, xv_row(main_panel, 0),
		     NULL);

/*
 * create calc(edit) pulldown
 */
      m1 = (Menu) xv_create(NULL, MENU,
   			  MENU_GEN_PIN_WINDOW, main_frame, "Calcs",
  			  MENU_ITEM,
			  MENU_STRING, "Integration...",
			  XV_HELP_DATA, "xvgr:integrate",
			  MENU_NOTIFY_PROC, create_int_frame, NULL,
  			  MENU_ITEM,
			  MENU_STRING, "Buffit...",
			  XV_HELP_DATA, "xvgr:data fitting",
			  MENU_NOTIFY_PROC, create_buffit_frame, NULL,
  			  MENU_ITEM,
			  MENU_STRING, "Find peaks...",
			  XV_HELP_DATA, "xvgr:peak finding",
			  MENU_NOTIFY_PROC, create_peakf_frame, NULL,
  			  MENU_ITEM,
			  MENU_STRING, "Matchsticks...",
			  XV_HELP_DATA, "xvgr:Matchsticks",
			  MENU_NOTIFY_PROC, create_mstick_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "",
			  MENU_INACTIVE, TRUE, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Hide peaks",
			  XV_HELP_DATA, "xvgr:data fitting",
			  MENU_NOTIFY_PROC, do_hidefit_peaks, NULL, 
			  MENU_ITEM,
			  MENU_STRING, "Show peaks",
			  XV_HELP_DATA, "xvgr:data fitting",
			  MENU_NOTIFY_PROC, do_showfit_peaks, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Clear fits",
			  XV_HELP_DATA, "xvgr:data fitting",
			  MENU_NOTIFY_PROC, do_clear_fits, NULL,
			  MENU_ITEM,
			  MENU_STRING, "",
			  MENU_INACTIVE, TRUE, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Evaluate expressions...",
			  XV_HELP_DATA, "xvgr:evaluate",
			  MENU_NOTIFY_PROC, create_eval_frame, NULL,
/*    			  MENU_ITEM,
			  MENU_STRING, "Load values...",
			  XV_HELP_DATA, "xvgr:load",
			  MENU_NOTIFY_PROC, create_load_frame, NULL, 
			  MENU_ITEM,
			  MENU_STRING, "Load and evaluate...",
			  XV_HELP_DATA, "xvgr:load_and_eval",
			  MENU_NOTIFY_PROC, create_leval_frame, NULL,  */
			  MENU_ITEM,
			  MENU_STRING, "Regression...",
			  XV_HELP_DATA, "xvgr:regress",
			  MENU_NOTIFY_PROC, create_reg_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Non-linear curve fitting...",
			  XV_HELP_DATA, "xvgr:nonl",
			  MENU_NOTIFY_PROC, create_nonl_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Running averages...",
			  XV_HELP_DATA, "xvgr:running",
			  MENU_NOTIFY_PROC, create_run_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Histograms...",
			  XV_HELP_DATA, "xvgr:histograms",
			  MENU_NOTIFY_PROC, create_histo_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Fourier transforms...",
			  XV_HELP_DATA, "xvgr:fourier",
			  MENU_NOTIFY_PROC, create_fourier_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Cross/Auto correlation...",
			  XV_HELP_DATA, "xvgr:xcor",
			  MENU_NOTIFY_PROC, create_xcor_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Differentiate...",
			  XV_HELP_DATA, "xvgr:differentiate",
			  MENU_NOTIFY_PROC, create_diff_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Splines...",
			  XV_HELP_DATA, "xvgr:splines",
			  MENU_NOTIFY_PROC, create_spline_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Sample...",
			  XV_HELP_DATA, "xvgr:sample",
			  MENU_NOTIFY_PROC, create_samp_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Digital filter...",
			  XV_HELP_DATA, "xvgr:digf",
			  MENU_NOTIFY_PROC, create_digf_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Linear convolution...",
			  XV_HELP_DATA, "xvgr:linc",
			  MENU_NOTIFY_PROC, create_lconv_frame, NULL,  
			  NULL);

/*      m5 = (Menu) xv_create(NULL, MENU,
		     MENU_GEN_PIN_WINDOW, main_frame, "Pick set operations",
			  MENU_ITEM, MENU_STRING,
			  "", MENU_INACTIVE, TRUE, NULL, 
			  MENU_ITEM,
			  MENU_STRING, "Kill nearest set",
			  XV_HELP_DATA, "xvgr:pick_killnearest",
			  MENU_NOTIFY_PROC, do_kill_nearest, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Copy nearest set",
			  XV_HELP_DATA, "xvgr:pick_copynearest",
			  MENU_NOTIFY_PROC, do_copy_nearest, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Move nearest set",
			  XV_HELP_DATA, "xvgr:pick_movenearest",
			  MENU_NOTIFY_PROC, do_move_nearest, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Reverse nearest set",
			  XV_HELP_DATA, "xvgr:pick_reversenearest",
			  MENU_NOTIFY_PROC, do_reverse_nearest, NULL,
			  MENU_ITEM,
			  MENU_STRING, "De-activate nearest set",
			  XV_HELP_DATA, "xvgr:pick_deactivatenearest",
			  MENU_NOTIFY_PROC, do_deactivate_nearest, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Join nearest sets",
			  XV_HELP_DATA, "xvgr:pick_joinnearest",
			  MENU_NOTIFY_PROC, do_join_nearest, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Delete range in nearest set",
			  XV_HELP_DATA, "xvgr:pick_deletenearest",
			  MENU_NOTIFY_PROC, do_delete_nearest, NULL,
			  NULL); */

   m2 = (Menu) xv_create(NULL, MENU,
			  MENU_GEN_PIN_WINDOW, main_frame, "Set operations",
/*			  MENU_ITEM, MENU_STRING,
			  "Pick operations",
			  XV_HELP_DATA, "xvgr:set_pickops",
			  MENU_PULLRIGHT, m5, NULL, */
			  MENU_ITEM,
			  MENU_STRING, "Activate...(1)",
			  XV_HELP_DATA, "xvgr:set_activate",
			  MENU_NOTIFY_PROC, create_activate_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "De-activate...(1)",
			  XV_HELP_DATA, "xvgr:set_deactivate",
			  MENU_NOTIFY_PROC, create_activate_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Re-activate...(1)",
			  XV_HELP_DATA, "xvgr:set_reactivate",
			  MENU_NOTIFY_PROC, create_activate_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Set length...(1)",
			  XV_HELP_DATA, "xvgr:set_length",
			  MENU_NOTIFY_PROC, create_activate_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Change type... (1)",
			  XV_HELP_DATA, "xvgr:set_change",
			  MENU_NOTIFY_PROC, create_activate_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Copy...(2)",
			  XV_HELP_DATA, "xvgr:set_copy",
			  MENU_NOTIFY_PROC, create_swap_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Move...(2)",
			  XV_HELP_DATA, "xvgr:set_move",
			  MENU_NOTIFY_PROC, create_swap_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Swap...(2)",
			  XV_HELP_DATA, "xvgr:set_swap",
			  MENU_NOTIFY_PROC, create_swap_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Drop points...",
			  XV_HELP_DATA, "xvgr:set_drop",
			  MENU_NOTIFY_PROC, create_drop_frame, NULL,
/*			  MENU_ITEM,
			  MENU_STRING, "Join sets...",
			  XV_HELP_DATA, "xvgr:set_join",
			  MENU_NOTIFY_PROC, create_join_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Split...",
			  XV_HELP_DATA, "xvgr:set_split",
			  MENU_NOTIFY_PROC, create_split_frame, NULL, */
			  MENU_ITEM,
			  MENU_STRING, "Sort...",
			  XV_HELP_DATA, "xvgr:set_sort",
			  MENU_NOTIFY_PROC, create_sort_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Write sets...",
			  XV_HELP_DATA, "xvgr:set_write",
			  MENU_NOTIFY_PROC, create_write_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Kill...",
			  XV_HELP_DATA, "xvgr:set_kill",
			  MENU_NOTIFY_PROC, create_kill_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Kill all",
			  XV_HELP_DATA, "xvgr:set_killall",
			  MENU_NOTIFY_PROC, do_flush, NULL,
/*			  MENU_ITEM,
			  MENU_STRING, "Reverse order...",
			  XV_HELP_DATA, "xvgr:set_reverse",
			  MENU_NOTIFY_PROC, create_reverse_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Coalesce sets...",
			  XV_HELP_DATA, "xvgr:set_coalesce",
			  MENU_NOTIFY_PROC, create_coalesce_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Pack sets",
			  XV_HELP_DATA, "xvgr:set_pack",
			  MENU_NOTIFY_PROC, do_packsets, NULL, */
			  NULL);

/*    m4 = (Menu) xv_create(NULL, MENU,
			MENU_GEN_PIN_WINDOW, main_frame, "Point operations",
			  MENU_ITEM,
			  MENU_STRING, "Find points",
			  XV_HELP_DATA, "xvgr:points_find",
			  MENU_NOTIFY_PROC, do_find_points, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Tracker",
			  XV_HELP_DATA, "xvgr:points_tracker",
			  MENU_NOTIFY_PROC, do_track_points, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Delete",
			  XV_HELP_DATA, "xvgr:points_delete",
			  MENU_NOTIFY_PROC, do_delete_points, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Add...",
			  XV_HELP_DATA, "xvgr:points_add",
			  MENU_NOTIFY_PROC, create_add_frame, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Move",
			  XV_HELP_DATA, "xvgr:points_move",
			  MENU_NOTIFY_PROC, do_move_points, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Move along X",
			  XV_HELP_DATA, "xvgr:points_movex",
			  MENU_NOTIFY_PROC, do_movex_points, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Move along Y",
			  XV_HELP_DATA, "xvgr:points_movey",
			  MENU_NOTIFY_PROC, do_movey_points, NULL,
			  MENU_ITEM,
			  MENU_STRING, "Goto...",
			  XV_HELP_DATA, "xvgr:points_goto",
			  MENU_NOTIFY_PROC, create_goto_frame, NULL,
			  NULL);
*/
/*    compose_menu = (Menu) menu_create(
				    MENU_GEN_PIN_WINDOW, main_frame, "Edit",
				      MENU_ITEM, MENU_STRING,
				      "Transformations",
				  XV_HELP_DATA, "xvgr:edit_transformations",
				      MENU_PULLRIGHT, m1,
				      NULL,
				      MENU_ITEM, MENU_STRING,
				      "Set operations",
				      XV_HELP_DATA, "xvgr:edit_setops",
  				      MENU_PULLRIGHT, m2,
				      NULL,
				      MENU_ITEM, MENU_STRING,
				      "Region operations",
				      XV_HELP_DATA, "xvgr:edit_regionops",
  				      MENU_PULLRIGHT, m3,
				      NULL,
				      MENU_ITEM, MENU_STRING,
				      "Edit sets...",
				      XV_HELP_DATA, "xvgr:edit_sets",
				 MENU_NOTIFY_PROC, create_editp_frame, NULL,
				      MENU_ITEM, MENU_STRING,
				      "Point operations",
				      XV_HELP_DATA, "xvgr:edit_points",
  				      MENU_PULLRIGHT, m4,
				      NULL,
				      MENU_ITEM, MENU_STRING,
				      "Block data...",
				      XV_HELP_DATA, "xvgr:edit_block",
				MENU_NOTIFY_PROC, create_eblock_frame, NULL,
				      NULL);
*/
      (void) xv_create(main_panel, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "Calcs",
		     XV_HELP_DATA, "xvgr:edit_menu",
/*		     PANEL_ITEM_MENU, compose_menu, */
		     PANEL_ITEM_MENU, m1,  
		     XV_X, xv_col(main_panel, 17),
		     XV_Y, xv_row(main_panel, 0),
		     NULL);

    (void) xv_create(main_panel, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "Sets",
		     PANEL_LABEL_WIDTH, 40,
		     XV_HELP_DATA, "xvgr:sets_menu",
/*		     PANEL_ITEM_MENU, compose_menu, */
		     PANEL_ITEM_MENU, m2,  
		     XV_X, xv_col(main_panel, 26),
		     XV_Y, xv_row(main_panel, 0),
		     NULL);

    
/*
 * init the icon
 */
    closed_image = (Server_image) xv_create(NULL, SERVER_IMAGE,
					    XV_WIDTH, 64,
					    XV_HEIGHT, 64,
					    SERVER_IMAGE_BITS, closed_bits,
					    NULL);
      mask_image = (Server_image) xv_create(NULL, SERVER_IMAGE,
					  XV_WIDTH, 64,
					  XV_HEIGHT, 64,
					  SERVER_IMAGE_BITS, mask_bits,
					  NULL);
    
/*
 * set the icon
 */
    icon = (Icon) xv_create(NULL, ICON,
			    ICON_IMAGE, closed_image,
			    ICON_MASK_IMAGE, mask_image, 
			    ICON_TRANSPARENT, TRUE, 
			    NULL);
    xv_set(main_frame, FRAME_ICON, icon, NULL);

/*
 * initialize the cursors
 */
    init_cursors();

/*
 * define the resize and repaint procs
 */
    (void) xv_set(canvas,
		  CANVAS_RESIZE_PROC, my_resize_proc,
		  CANVAS_REPAINT_PROC, refresh, NULL);
/*
 * the following xv_set maps the window so that in a pipe,
 * graphics can be seen
 */
    xv_set(main_frame, XV_SHOW, TRUE, NULL);

    xv_main_loop(main_frame);
}
void xv_setstr(p, s)
    Panel_item p;
    char *s;
{
    xv_set(p, PANEL_VALUE, s, NULL);
}


/*
 * Panel item declarations
 */
/*
Panel_item autoredraw_type_item;
Panel_item autoclear_type_item;
Panel_item cursor_type_item;
Panel_item scrollper_item;
Panel_item linkscroll_item;
Panel_item linkzoom_item; */

/*
 * scroll amount declared in graphutils.c TODO - move to globals.h
 */
extern int scrolling_islinked;
extern double scrollper;
extern double shexper;

/* suppress clear in the drivers - TODO move to globals.h */
int overlay = 0;

/* TODO move to globals.h - defined in events.c */
extern int cursortype;

void update_draw()
{
/*    int iv;

    if (draw_frame) {
	xv_set(linkscroll_item, PANEL_VALUE, scrolling_islinked == TRUE, NULL);
	xv_set(autoredraw_type_item, PANEL_VALUE, auto_redraw == TRUE, NULL);
	xv_set(autoclear_type_item, PANEL_VALUE, overlay == TRUE, NULL);
	xv_set(cursor_type_item, PANEL_VALUE, cursortype == TRUE, NULL);
	iv = (int) (100 * scrollper);
	xv_set(scrollper_item, PANEL_VALUE, iv, NULL);
    }
*/    
}

Notify_value
destroy_func(client,sig,mode)
      Notify_client    client;
      int              sig;
      Notify_signal_mode              mode;
{
      if (DBX_val > 3) fprintf(stderr,"sort_xvgr: received SIGTERM\n");
      exit(0); 
}
