/* $Id: utils.c,v 1.9 91/12/08 15:34:09 pturner Exp Locker: pturner $
 *
 * misc utilities
 *
 * Contents:
 *
 * void cxfree() - free and check for NULL pointer
 * void fswap()  - swap doubles
 * void iswap()  - swap ints
 * void lowtoupper() - convert a string to upper case
 * void convertchar() - remove commas and Fortran D format
 * int ilog2() - integer log base 2, for the fft routine
 * double comp_area() - compute the area of a polygon
 * double comp_perimeter() - compute the perimeter
 * double fmin(), fmax()
 * Julian date routines
 *
 */

#include <stdio.h>
#include <ctype.h>
#include <math.h>

/*
 * free and check for NULL pointer
 */
void cxfree(ptr)
    void *ptr;
{
    if (ptr != NULL) {
	free(ptr);
    }
}

/*
 * swap doubles and ints
 */
void fswap(x, y)
    double *x, *y;
{
    double tmp;

    tmp = *x;
    *x = *y;
    *y = tmp;
}

void iswap(x, y)
    int *x, *y;
{
    int tmp;

    tmp = *x;
    *x = *y;
    *y = tmp;
}

int isoneof(c, s)
    int c;
    char *s;
{
    while (*s) {
	if (c == *s) {
	    return 1;
	} else {
	    s++;
	}
    }
    return 0;
}

/*
 * convert a string from lower to upper case
 * leaving quoted strings alone
 */
void lowtoupper(s)
    char *s;
{
    int i, quoteon = 0;

    for (i = 0; i < strlen(s); i++) {
	if (s[i] == '"') {
	    if (!quoteon) {
		quoteon = 1;
	    } else {
		quoteon = 0;
	    }
	}
	if (s[i] >= 'a' && s[i] <= 'z' && !quoteon) {
	    s[i] -= ' ';
	}
    }
}

/*
 * remove all that fortran nastiness
 */
void convertchar(s)
    char *s;
{
    while (*s++) {
	if (*s == ',')
	    *s = ' ';
	if (*s == 'D' || *s == 'd')
	    *s = 'e';
    }
}

/*
 * log base 2
 */
int ilog2(n)
    int n;
{
    int i = 0;
    int n1 = n;

    while (n1 >>= 1)
	i++;
    if (1 << i != n)
	return -1;
    else
	return i;
}

/* should be macros */
double fmin(x, y)
    double x, y;
{
    return (x < y ? x : y);
}

double fmax(x, y)
    double x, y;
{
    return (x > y ? x : y);
}

/*
 * strip special chars from a string
 */
void stripspecial(s, cs)
    char *s, *cs;
{
    int i, slen = strlen(s), curcnt = 0;

    for (i = 0; i < slen; i++) {
	if (s[i] == '\\' && isdigit(s[i + 1])) {
	    i++;
	} else if (s[i] == '\\' && isoneof(s[i + 1], "cCbxsSNuU+-")) {
	    i++;
	} else if (s[i] == '\\' && s[i + 1] == '\\') {
	    i++;
	} else {
	    cs[curcnt++] = s[i];
	}
    }
    cs[curcnt] = 0;
}
