#include <stdio.h>
#include <math.h>

double legendre(l, x)
register int l;
register double x;
{
    /* x = cos theta on entry */

    switch(l)
    {
    case 0:
	return 1;
    case 1:
	return x;
    case 2:
	return 1.5*x*x - 0.5;
    case 3:
	return (2.5*x*x - 1.5)*x;
    case 4:
    {
	register double x2 = x*x;

	return (4.375*x2 - 3.75)*x2 + 0.375;
    }
    default:
    {
	register int i;
	register double pl, pl1, pl2;

	pl2 = x*x;
	pl = (4.375*pl2 - 3.75)*pl2 + 0.375;
	pl1 = (2.5*pl2 - 1.5)*x;

	for(i = l - 4, l = 4; i--;)
	{
	    l++;
	    pl2 = pl1;
	    pl1 = pl;
	    pl = (2*l-1)*x*pl1/l - (l-1)*pl2/l;
	}

	return pl;
    }
    }
}

#ifdef TEST_LEGENDRE

main(argc, argv)
int argc;
char **argv;
{
    double min, max, step, x;
    int l;

    if (argc < 5)
    {
	fprintf(stderr, "Syntax:\n\tLegendre order min max step\n");
	return 1;
    }

    l = atoi(argv[1]);
    min = atof(argv[2]);
    max = atof(argv[3]);
    step = atof(argv[4]);

    for(x = min; x <= max; x += step)
	printf("%f %f\n", x, legendre(l, cos(x*M_PI/180)));
}

#endif
