/* ftnchek.h:

	Common definitions for Fortran Program Checker

    Copyright (C) 1992 by Robert K. Moniot.
    This program is free software.  Permission is granted to
    modify it and/or redistribute it, retaining this notice.
    No guarantees accompany this software.

*/

#define VERSION_NUMBER		"FTNCHEK Version 2.5 January 1992"

	/* The following system defines should be defined with the -D
	   (for UNIX) or /DEFINE (for VMS) compiler options in the makefile,
	   not here.  They are shown here so you know what to define.
	*/

/*#define VMS*/		/* Set flag for VAX/VMS   system-dependent defns. */
/*#define UNIX*/	/* Set flag for UNIX (ATT or BSD) defns. */

#ifdef VMS
	/* If VMS system, define flag for extra VMS-isms in
	   iokeywds.h table unless NO_VMS_IO is defined. These
	   can be independently enabled by defining VMS_IO. */
#ifndef NO_VMS_IO
#define VMS_IO
#endif /*NO_VMS_IO*/
	/* Likewise define flag for VMS behavior in INCLUDE stmt
	   (defaulting extension, /NOLIST feature) unless
	   NO_VMS_INCLUDE is defined.  */
#ifndef NO_VMS_INCLUDE
#define VMS_INCLUDE
#endif /*NO_VMS_INCLUDE*/
#endif /*VMS*/

	/* set flag to allow options to start with '/' */
#ifdef VMS
#define OPTION_PREFIX_SLASH 1
#endif
#ifdef __TURBOC__
#define OPTION_PREFIX_SLASH 1
#endif

		/* The following defines cause Ftnchek to permit various
		   nonstandard things.  Purists can remove these defines
		   to disable them.
		   Disable all by defining STRICT_SYNTAX.
		*/

#ifndef STRICT_SYNTAX
#define ALLOW_UNDERSCORES 1	/* Underscores in variable names */
#ifdef VMS
#define ALLOW_DOLLARSIGNS 1	/* VMS allows $ in identifiers too */
#endif
#define INLINE_COMMENT_CHAR '!' /* Inline comments starting with '!' */
#define ALLOW_INCLUDE 1		/* The INCLUDE statement */
#define ALLOW_DO_ENDO 1	/* The various DO loop extensions (including WHILE) */
#endif

		/* Define to tolerate embedded blanks in numeric consts unless
		   feature turned off by defining NO_BLANKS_IN_NUMBERS. */
#ifndef NO_BLANKS_IN_NUMBERS
#define BLANKS_IN_NUMBERS
#endif

		/* Define default source and output file extensions.  These
		 * can be overridden by defines on compiler commandline.
		 */
#ifndef DEF_SRC_EXTENSION
#ifdef VMS
#define DEF_SRC_EXTENSION ".for"		/* VMS default extension */
#endif
#ifdef __TURBOC__
#define DEF_SRC_EXTENSION ".for"		/* IBM PC default extension */
#endif
#endif /* DEF_SRC_EXTENSION */

#ifndef DEF_SRC_EXTENSION
#define DEF_SRC_EXTENSION ".f"		/* Unix and all others */
#endif
		/* define default list-file extension */
#ifndef DEF_LIST_EXTENSION
#define DEF_LIST_EXTENSION ".lis"
#endif
		/* define default project-file extension */
#ifndef DEF_PROJ_EXTENSION
#define DEF_PROJ_EXTENSION ".prj"
#endif
		/* define project-file name for case of input from stdin */
#ifndef STDIN_PROJ_FILENAME
#define STDIN_PROJ_FILENAME "ftnchek.prj"
#endif

#ifndef ENV_PREFIX		/* prefix for option environment variables */
#define ENV_PREFIX "FTNCHEK_"
#endif

#ifndef MAXLINE
#define MAXLINE 132	/* Maximum input line length.  Ignores past this. */
#endif
#ifndef MAXSTR
#define MAXSTR 200	/* Longest string constant allowed */
#endif
#ifndef MAXIDSIZE
#define MAXIDSIZE 31	/* Longest identifier allowed */
#endif

#ifndef MAX_INCLUDE_DEPTH
#define MAX_INCLUDE_DEPTH 16	/* Max nesting depth of include files */
#endif

#define KEYHASHSZ 195	/* Size of keyword hashtable -- do not change */
#define INTRINS_HASHSZ 261 /* Chosen to give few clashes -- change with care */

#ifdef SMALL_MACHINE		/* Use these for e.g. IBM PC */
#ifndef HASHSZ			/* Hint: pick one with no square factors */
#define HASHSZ 798     /* Size of symbol hashtable */
#endif
#ifndef STRSPACESZ
#define STRSPACESZ 2000	/* Size of identifier string space */
#endif
#ifndef LOCSYMTABSZ
#define LOCSYMTABSZ 200 /* Size of local symbol table */
#endif
#ifndef GLOBSYMTABSZ
#define GLOBSYMTABSZ 200 /* Size of global symbol table */
#endif
#ifndef TOKENSPACESZ
#define TOKENSPACESZ 200 /* Max number of tokens in token lists */
#endif

#else  /* end if SMALL_MACHINE */

#ifdef LARGE_MACHINE		/* use these if space is no problem */
#ifndef HASHSZ
#define HASHSZ 20930     /* Size of symbol hashtable: must be <= max int */
#endif
#ifndef STRSPACESZ
#define STRSPACESZ 40000	/* Size of identifier string space */
#endif
#ifndef LOCSYMTABSZ
#define LOCSYMTABSZ 6000 /* Size of local symbol table */
#endif
#ifndef GLOBSYMTABSZ
#define GLOBSYMTABSZ 4000 /* Size of global symbol table */
#endif
#ifndef TOKENSPACESZ
#define TOKENSPACESZ 10000 /* Max number of tokens in token lists */
#endif

#else		/* Defaults: Use these for average-size applications */

#ifndef HASHSZ
#define HASHSZ 2002     /* Size of symbol hashtable: must be <= max int */
#endif
#ifndef STRSPACESZ
#define STRSPACESZ 4000	/* Size of identifier string space */
#endif
#ifndef LOCSYMTABSZ
#define LOCSYMTABSZ 600 /* Size of local symbol table */
#endif
#ifndef GLOBSYMTABSZ
#define GLOBSYMTABSZ 400 /* Size of global symbol table */
#endif
#ifndef TOKENSPACESZ
#define TOKENSPACESZ 1000 /* Max number of tokens in token lists */
#endif

#endif /* end if LARGE_MACHINE else */

#endif/*end if SMALL_MACHINE else*/


#define FALSE 0
#define TRUE 1

#define NO_COL_NUM 999		/* impossible column number to suppress
				 * printing in error messages
				 */

/* Shared variable and function defns start here */

#ifdef MAIN
#define SHARED		/* (nothing) */
#else
#define SHARED extern	/* Non-main routines declare shared vars extern */
#endif

#define PRIVATE static	/* For non-shared functions */


SHARED FILE
            *input_fd,  /* Input file */
            *list_fd,	/* Output file for listing */
	    *project_fd;/* Project file for symtab info summary */
SHARED char *current_filename,	/* name of current input file */
	    *top_filename;	/* name of toplevel parent input file */
SHARED int incdepth;


#ifdef MAIN
		/* Options */
  int
    decls_required=FALSE,	/* List all undeclared identifiers */
    div_check = FALSE,		/* Check for possible division by zero */
    ext_def_check = TRUE,	/* Check defined status of externals*/
    f77_standard=FALSE,		/* Warn of non-f77 constructs */
    library_mode = FALSE,	/* Set used-flag for all modules in file */
    eol_is_space=TRUE,		/* Treat contd stmt linebreaks as space */
    do_list = FALSE,		/* Listing-file flag */
    port_check=FALSE,		/* Portability warnings */
    make_project_file=FALSE,	/* Save symtab defns in .prj file */
    do_symtab = FALSE,		/* For symbol table printout */
    sixclash = FALSE,		/* To check if names unique in 1st 6 chars */
    verbose = TRUE,		/* Verbose output format */
    print_version_num = FALSE,	/* To print out the version number */
    usage_check = TRUE,		/* Print set/used checks on variables */
		/* Debugging flags */
    debug_latest = FALSE,	/* debug the latest addition */
    show_resources = FALSE,
    debug_parser = FALSE,	/* grammar debug via DBG statements */
    debug_lexer = FALSE,
    debug_hashtab = FALSE,
    debug_glob_symtab = FALSE,
    debug_loc_symtab = FALSE;
extern int yydebug;		/* grammar debug via yydebug */

  int		/* Settings */
    comcheck_strictness = 3,	/* 0 (no check) to 3 (exact type & size) */
    max_stmt_col = 72,		/* End of statement field ( <= MAXLINE )*/
    novice_level = 1;		/* 1 = green, 5 = wizard */

		/* StrSettings */
  char
    *out_fname=(char *)NULL;	/* Output filename */

#else/* not ifdef MAIN */
  SHARED int	/* Options */
    decls_required,
    div_check, ext_def_check, f77_standard, library_mode,
    eol_is_space, do_list, port_check,
    make_project_file, do_symtab, sixclash, verbose,
    print_version_num, usage_check,
    debug_latest, show_resources, debug_parser, debug_lexer,
    debug_hashtab, debug_glob_symtab, debug_loc_symtab;
  SHARED int	/* Settings */
    comcheck_strictness,max_stmt_col,novice_level;
  SHARED char	/* StrSettings */
    *out_fname;
#endif

SHARED unsigned
    line_num,		/* line num of current char */
    col_num,		/* column num of current char */
    next_line_num,	/* line num of lookahead char */
    next_col_num;	/* column num of lookahead char */

SHARED unsigned
    tab_count,		/* Count of tabs in noncomment lines exc in strings */
    error_count,	/* Count of syntax error messages per file */
    warning_count;	/* Count of warning messages per file */

		/* Resource usage information: */
SHARED unsigned long
    max_loc_symtab,	/* amt of local symtab used */
    max_glob_symtab,	/* amt of global symtab used */
    max_loc_strings,	/* amt of local stringspace used */
    max_glob_strings,	/* amt of global stringspace used */
    max_token_space;	/* amt of token space used */

SHARED int
    equivalence_flag,   /* true while parsing EQUIVALENCE statement */
    initial_flag,	/* true while only label or initial keywords read */
    implicit_flag,	/* true while parsing IMPLICIT statement */
    implicit_letter_flag, /* true while getting letters in IMPLICIT list */
    implicit_type_given,/* true if IMPLICIT type statement found */
    implicit_none,	/* true if IMPLICIT NONE statement found */
    prev_token_class,	/* token class of last-returned token */
    curr_stmt_class;	/* Token class of current stmt's leading token */



		/* Declare shared routines */
	/* in advance.c */
void init_scan(),finish_scan(),open_include_file();
int flush_line_out();


	/* in ftnchek.c */
void print_a_line(), yyerror(), syntax_error(), msg_tail(),
     warning(), nonstandard(), nonportable();
char *add_ext(),*new_ext();
int has_extension();

	/* in forlex.c */
int yylex();
void implied_id_token();

	/* in fortran.y/fortran.c */
int yyparse();
void init_parser();

	/* in intrinsics.c */
unsigned long init_intrins_hashtab();

	/* in keywords.c */
void init_keyhashtab();

	/* in prsymtab.c */

void check_arglists(),check_comlists();

	/* in symtab.c */

char *new_local_string(),*new_global_string();
void init_globals(), init_symtab(), note_filename();
char * token_name();


	/* in symtab2.c */
void				/* project file routines */
 proj_file_out(),proj_file_in();
