#include <stdio.h>
#include <string.h>
#include "structure.h"
#include "loadadcs.h"

static int loadsub(struct detectors *dp, FILE *fp, int tdcoffset)
{
    int i, t = 0;

    for(; dp != NULL; dp = getnext(dp))
    {
	if (!strncmp(getname(dp), "signal", 6))
	{
	    if (t)
	    {
		iset("adcnum", i + tdcoffset, dp, "");
		t = 0;
	    }
	    else
	    {
		if (fscanf(fp, " %d ", &i) != 1)
		{
		    fprintf(stderr, "Number of entries in file does not match "
			    "number of signals in detector structure.\n");
		    return(-1);
		}
		iset("adcnum", i, dp, "");
		t = tdcoffset;
	    }
	}
	else
	{
	    if ((t = loadsub(getchild(dp, "%", 1), fp, tdcoffset)) < 0)
		return(t);
	}
    }

    return(0);
}

int loadadcs(struct detectors *dp, char *filename, int tdcoffset)
{
    FILE *fp;
    int err;

    if (dp == NULL)
    {
	fprintf(stderr, "Unable to load ADC map as detector structure "
		"empty.\n");
	return(-1);
    }

    fprintf(stderr, "Loading ADC map from file %s.\n", filename);
    if (tdcoffset == 0)
	fprintf(stderr, "Expecting TDC addresses in file.\n");
    else
	fprintf(stderr, "Setting TDC addresses to ADC + %d.\n", tdcoffset);

    if ((fp = fopen(filename, "r")) == NULL)
    {
	perror(filename);
	return(-1);
    }

    err = loadsub(dp, fp, tdcoffset);

    fclose(fp);

    return(err);
}


/* FORTRAN interface routines */

int loadadcs_(struct detectors **dp, char *filename, int *tdcoffset)
{
    return(loadadcs(*dp, filename, *tdcoffset));
}
