#include <stdio.h>
#include <malloc.h>
#include "structure.h"

struct markdata {
  struct detectors *this;
  struct detectors *parent;
  struct detectors *first;
};

static struct markdata *detparray = NULL;
static short *dethits = NULL;
static int numadcs;

static int markdetectors(struct detectors *dp)
{
    int adc;
    struct detectors *parent;

    for( ; dp != NULL; dp = getnext(dp))
    {
	if (hasproperty("adcnum", dp, ""))
	{
	    adc = igetthis("adcnum", dp);
	    if (adc < 0 || adc > numadcs)
	    {
		fprintf(stderr, "initmarkhits: ADC %d is out of range.\n",
			adc);
		return(-1);
	    }
	    if (adc != 0)
	    {
		if (detparray[adc-1].this != NULL)
		{
		    fprintf(stderr, "initmarkhits: ADC %d occurs twice.\n",
			    adc);
		    return(-1);
		}
		detparray[adc-1].this = dp;
		detparray[adc-1].parent = getparent(dp);
		detparray[adc-1].first = getchild(getparent(dp), "%", 1);
	    }
	    isetthis("hits", 0, dp);
	    isetthis("adcval", -1, dp);
	    for(parent = getparent(dp);
		parent != NULL && !hasproperty("partial", parent, "");
		parent = getparent(parent))
	    {
		isetthis("hits", 0, parent);
		isetthis("partial", 0, parent);
	    }
	}
	if ((adc = markdetectors(getchild(dp, "%", 1))) < 0)
	    return(adc);
    }

    return(0);
}


int initmarkhits(struct detectors *dp, int nadcs)
{
    int i;

    if (detparray != NULL)
    {
	free(detparray);
	detparray = NULL;
    }
    
    if ((detparray = (struct markdata *)
	 calloc(nadcs, sizeof(struct markdata))) == NULL)
    {
	fprintf(stderr, "Out of memory trying to initialise markits\n");
	return(-1);
    }

    if ((dethits = calloc(nadcs, sizeof(short))) == NULL)
    {
	free(detparray);
	fprintf(stderr, "Out of memory trying to initialise markits\n");
	return(-1);
    }

    numadcs = nadcs;
    
    for(i = 0; i < nadcs; i++)
    {
	detparray[i].this = NULL;
	detparray[i].parent = NULL;
	detparray[i].first = NULL;
    }

    dethits[0] = -1;

    if ((i = markdetectors(dp)) < 0)
    {
	free(detparray);
	free(dethits);
	detparray = NULL;
	return(i);
    }

    return(0);
}

void markhits(short *adc)
{
    struct detectors *dp;
    struct markdata *mp;
    short *p;
    int i;
    short *ap;

    /* Erase any hits left over from last time */

    for(p = dethits; *p != -1; p++)
    {
	mp = detparray + *p;
	isetthis("adcval", -1, mp->this);
	isetthis("hits", 0, mp->this);
	for(dp = mp->parent; dp != NULL && igetthis("hits", dp) > 0; 
	    dp = getparent(dp))
	{
	    isetthis("hits", 0, dp);
	    isetthis("partial", 0, dp);
	}
    }
    
    /* Put in hits */

    for(ap = adc, p = dethits, mp = detparray, i = numadcs; i--;
	ap++, mp++)
    {
	if (*ap > 0)
	{
	    *p++ = mp - detparray;
	    isetthis("adcval", *ap, mp->this);
	    isetthis("hits", 1, mp->this);
	    isetthis("partial", 2, mp->parent);
	}
    }
    *p++ = -1;

    /* Mark partial hits and count hits*/

    for(p = dethits; *p != -1; p++)
    {
	if (igetthis("partial", dp = (mp = detparray + *p)->parent) == 2)
	{
	    for( ; dp != NULL; dp = getparent(dp))
		isetthis("hits", igetthis("hits", dp)+1, dp);
	    for(dp = mp->first; dp != NULL; dp = getnext(dp))
		if (!igetthis("hits", dp))
		    break;
	    if (dp != NULL)
	    {
		for(dp = mp->parent; dp != NULL &&
		    igetthis("partial", dp) != 1; dp = getparent(dp))
		    isetthis("partial", 1, dp);
	    }
	    else
		isetthis("partial", 0, mp->parent);
	}
    }
}

/* FORTRAN interface routines */

int initmarkhits_(struct detectors **dp, int *numadcs)
{
    return(initmarkhits(*dp, *numadcs));
}

void markhits_(short *adc)
{
    markhits(adc);
}
