      program teststruct

      external loadexperiment,loadadcs
      integer loadexperiment,loadadcs
      integer*2 adc(768)

      integer dets,n,d,s,a,at,b,bt,h

      print *,'Loading structure'
      dets = loadexperiment('testexpt.det')
      if (dets.eq.0) then
        print *,'failed.'
        stop
      endif

      print *,'Loading ADC numbers'
      if (loadadcs(dets,'testexpt.adcs',384).lt.0) then
        print *,'failed'
        stop
      endif

      print *,'Initialising markhits stuff'
      if (initmarkhits(dets,768).lt.0) then
        print *,'failed'
        stop
      endif

*      print *,'Dumping experiment'
*      call dumpdetectors(dets)

      do while(.true.)
      do n=1,768
        adc(n)=0
      enddo
        n=0
        print *,'Enter ADC numbers and values, end with -1'
        do while(n.ne.-1)
          read *,n
          if (n.ne.-1) then
            read *,adc(n)
          endif
        enddo

        call markhits(adc)
        h=iget("hits",dets,"",d)
        print *,h,' hit(s) in total '
        if (iget("partial",dets,"").ne.0) then
          print *,'One or more hits are partial'
        else
          print *,'No hits are partial'
        endif
        do d=1,4
          h=iget("hits",dets,"%",d)
          if (h.gt.0) then
            print *,h,' hit(s) in detector ',d
            if (iget("partial",dets,"%",d).ne.0)
     &           print *,'One or more hits are partial'
            do s=1,16
              if (iget("hits",dets,"%.%",d,s).gt.0) then
                a=iget("adcval",dets,"%.%.signalA",d,s)
                at=iget("adcval",dets,"%.%.signalAtime",d,s)
                b=iget("adcval",dets,"%.%.signalB",d,s)
                bt=iget("adcval",dets,"%.%.signalBtime",d,s)
                if (iget("partial",dets,"%.%",d,s)) then
                  print *,'    Parital hit in strip ',s,' : ',a,at,b,bt
                else
                  print *,'    Complete hit in strip ',s,' : ',a,at,b,bt
                endif
              endif
            enddo
          else
            print *,'No hits in detector ',d
          endif
        enddo
      enddo

      end
