#include <stdio.h>
#include "structure.h"
#include "loadadcs.h"

int main()
{
    struct detectors *dp;
    int i, j;

    printf("Loading structure\n");
    dp = loadexperiment_("testexpt.det");

    loadadcs_(dp, "testexpt.adcs", 384);

    printf("Getting child pssd.strip\n");
    dumpdetectors_(getchild_(dp, "pssd.strip"), 0);
    printf("Setting property foo = 57.\n");
    isetproperty_("foo", 57, dp, "pssd.strip");

    i = 2;
    j = 3;

    printf("Getting child %d.%d\n", i, j);
    dumpdetectors_(getchild_(dp, "%.%", &i, &j), 0);
    printf("Setting property bar = 123.21.\n");
    fsetproperty_("bar", 123.21, dp, "%.%", &i, &j);

    printf("property foo of pssd.strip = %d\n",
	   igetproperty_("foo", dp, "pssd.strip"));
    printf("property bar of 2.3 = %f\n",
	   fgetproperty_("bar", dp, "%.%", &i, &j));

    printf("Dumping experiment\n");
    dumpdetectors_(dp, 0);

    return(0);
}
