C  correlation function peakfind
C  derived from a Chalk River program

C  method of finding new background has been improved by CW
C  sd output is that of pure gaussian line

C  adapted for EuroGam system, November 1992, by DB
C  and made a little more Fortran77 like

C  minor modifications to work in sort_xvgr, by sjah
 
      COMMON/SPDATA/ COUNT(8192),ISTART,IEND
      DOUBLE PRECISION SUM,VAR,CENT,SD1,PKVAR
      DIMENSION SPEC(8192),F(150),F1(150)
      CHARACTER*80 TITLE,HEDR *60,CUNITS *20,SPECIN *256
      LOGICAL CALIB,CALIBE
      logical klm
      INTEGER INTIN, RLIN
      DATA HEDR /'No.     Channel            Area           Fwhm       E
     +NERGY '/
 
C     CALL SEXPT (IERR)
C     IF (IERR.NE.0) CALL CRASH ('unable to connect to experiment')

C  get spectrum id and title

      LENG=LEN(SPECIN)
      CALL TXTIN ('spectrum',8,SPECIN,LENG)
C     CALL GETID (ISPC,ITPGN,SPECIN,LENG)
      LTIT=LEN(TITLE)
C      CALL GETTIT (ISPC,ITPGN,TITLE,LTIT)
      call txtin('title',5,title,ltit)
      WRITE (6,99) SPECIN(1:LENG),TITLE(1:MIN(LTIT,132-LENG-17-8))
   99 FORMAT ('Peak finding for ',A,', Title ',A)
 
C  get the fwhm(in channels)
C  get area rejection level(%) >100% prints all peaks
C  and set up constants for calculating gaussian distribution
 
      IERR=RLIN ('fwhm',4,SD)
      IF (IERR.NE.0) SD=6.0
      SD=SD/2.35482
      IERR=RLIN ('accept',6,DISC)
      IF (IERR.NE.0) DISC=10.0
      CON1=1.0/(SD*SQRT(2.0*3.141593))
      CON2=0.5/(SD*SD)
      K=3.0*SD+0.5
      NBCKGD=K
      KK=2*K+1
 
      DO 1 I=1,KK
         F(I)=CON1*EXP(-CON2*(I-K-1)**2)
         F1(I)=(1.0/KK-F(I))**2
 1    CONTINUE
 
C  now open the spectrum and get the start and number of chans
 
C     CALL OPNSPR (1,ISPC,ITPGN)
      call openspr(id,specin(1:leng),'r')
C    now inputs min cnannel contents:
C     CALL INFSP (1,ISTART,NOCH,IDUMMY,IDUMMY,IDUMMY,IDUMMY)
C     IEND=ISTART+NOCH-1
C  read in limits and check these
C     IERR=INTIN ('limit',5,I)
C     IF (IERR.EQ.0) ISTART=MAX0(I,ISTART)
      ierr=intin ('limit',5,istart)
C     IERR=INTIN ('limit',5,I)
C     IF (IERR.EQ.0) IEND=MIN0(I,IEND)
      ierr=intin ('limit',5,iend)
      NOCH=IEND-ISTART+1
C  see if a calibration exists
C     CALL ENCHAN (ISPC,ITPGN,0.0,0.0,DUMMY,DUMMY,CALIB,CALIBE,
C    + CUNITS)
      IC = 47
C     IF (CALIB) IC = 60
      WRITE (6,108) (HEDR(I:I),I=1,IC)
  108 FORMAT (60A1)

C  read in the spectrum
      DO 2 I=1,NOCH
         SPEC(I)=0.0
C        CALL IGTCHN (1,I+ISTART-1,ICOUNT)
         call igtchn(id, i+istart-1, icount)
         COUNT(I)=AMAX1(FLOAT(ICOUNT),0.0)
 2    CONTINUE
C     CALL CLSSPR (1)
      call clsspr(id)
      call openof()

C  the inner loop takes up the majority of the execution time
C  and so a number of changes have been made from the original:
C    1 the variable idx is initialised outside the loop and
C      subsequently incremented by 1.
C    2 a temporary copy of spec(i) is used

      DO 10 I=KK+1,NOCH-KK
         SUM=0.0
         VAR=0.0
         IDX=0
         SPECI=0.0
         DO 12 J=I-K,I+K
            TMP=COUNT(J)
            SUM=SUM+TMP
            IDX=IDX+1
            VAR=VAR+F1(IDX)*TMP
            SPECI=SPECI+F(IDX)*TMP
 12      CONTINUE
         B=1.6*DSQRT(VAR)
         SPECI=SPECI-SUM/KK-B
         SPECI=AMAX1(SPECI,0.0)
         IF (SPECI.GT.0.0) SPECI=SPECI+B
         SPEC(I)=SPECI
 10   CONTINUE
      NO=0
 
C  scan to resolve the peaks.
 
      KLM=.false.
      DO 21 I=KK+1,NOCH-KK
         if (.not.klm .and. SPEC(I).gt.0.0) then 
            KLM=.true.
            IINIT=I
         elseif (klm .and. SPEC(I).le.0.0) then 
            KLM=.false.
            IFIN=I-1
            MEXP=(KK+IINIT-IFIN-1)/2.0+0.5
            MEXP=MAX0(MEXP,0)
            IF (MEXP.EQ.0) GO TO 21
            DO 24 J=IINIT-1,IINIT-MEXP,-1
               IF (SPEC(J).NE.0.0) GO TO 25
               SPEC(J)=-1.0
 24         CONTINUE
 25         DO 26 J=IFIN+1,IFIN+MEXP
               IF (SPEC(J).NE.0.0) GO TO 27
               SPEC(J)=-1.0
 26         CONTINUE
 27         continue
         endif
 21   CONTINUE
 
C at this point SPEC[i] describes the spectrum as follows:
C    SPEC[i]==0 in areas of background between peaks
C    SPEC[i]<0  (==-1 actually) immediately to left and right of a peak
C    SPEC[i}>0  in the peak region, and maximal at the peak centre

      KLM=.false.
      DO 40 I=1,NOCH
         SPECI = SPEC(I)

         if (.not.klm .and. speci.le.0.0) goto 40
 
         if (.not.klm .and. speci.gt.0.0) then
            KLM=.true.
            IINIT=I
            PEAK=SPECI
            SUM=PEAK
            CENT=(I-1)*PEAK
            VAR=(I-1)**2*PEAK
            GO TO 40
         endif
 
         IF (klm .and. SPECI.gt.0.0) then
            PEAK=AMAX1(PEAK,SPECI)
            SUM=SUM+SPECI
            CENT=CENT+(I-1)*SPECI
            VAR=VAR+SPECI*(I-1)**2
            GO TO 40
         endif

C--------if (klm .and. SPECI.le.0.0) then
C--------have now passed over a peak in correlation function
 
         IFIN=I-1
         KLM=.false.
         CENT=CENT/SUM
         SD1=VAR/SUM-CENT**2
         SD1=DMAX1(SD1,0.0D0)
         SD1=DSQRT(SD1)/0.68
C  find area of real peak
C-----the next bit hairily tries to find background on either side of the peak
         BCKGD=0.0
         MEXP=(KK+IINIT-IFIN-1)/2.0+0.5
         MEXP=MAX0(MEXP,0)
         JJJ=IINIT-MEXP
         NBCK=0
         DO 51 J=1,NBCKGD
            JJ=JJJ-J
            IF (SPEC(JJ).EQ.0.0) THEN
               NBCK=NBCK+1
               BCKGD=BCKGD+COUNT(JJ)
            ENDIF
 51      CONTINUE
 
         JJJ=IFIN+MEXP
         JMP=2
 58      continue
         DO 54 J=1,NBCKGD
 55         JJ=JJJ+J
            IF (SPEC(JJ).NE.0.0) GO TO (56,54),JMP
            NBCK=NBCK+1
            BCKGD=BCKGD+COUNT(JJ)
            GO TO 54
 56         JJJ=JJJ+1
            GO TO 55
 54      CONTINUE
 
         IF (NBCK.LE.0) THEN
            JMP=1
            GO TO 58
         endif

         BCKGD=BCKGD/NBCK
         VARBCK=BCKGD/NBCK
         ARVAR=0.0
         PKVAR=0.0
         SUM=0.0
         DO 57 J=IINIT-MEXP,IFIN+MEXP
            TMP=COUNT(J)
            ARVAR=ARVAR+TMP+VARBCK
            PKVAR=PKVAR+(TMP+VARBCK)*(J-CENT)**2
            SUM=SUM+TMP-BCKGD
 57      CONTINUE
 
         PEAR=SQRT(ARVAR)

C  check that the centroid is realistic
C  and if an acceptable peak output the results
 
         IF (SD1.GE.0.5*SD .and. SD1.LE.2.0*SD) THEN
            IF (DISC.GE.100 .OR.
     +         (SUM.GT.0.0 .AND. PEAR/SUM.LE.DISC/100.0)) THEN
               NO=NO+1
               SCENT = CENT + ISTART
               SD1=SD1*2.35482
               PEPK=DSQRT(PKVAR)/DABS(SUM)
C              CALL ENCHAN (ISPC,ITPGN,SCENT,PEPK,EN,PEEN,CALIB,CALIBE,
C    +                      CUNITS)
 
C              IF (CALIB) THEN
C                 WRITE (6,112) NO,SCENT,PEPK,SUM,PEAR,SD1,EN,PEEN
C              ELSE
                  WRITE (6,112) NO,SCENT,PEPK,SUM,PEAR,SD1
                  call outfile(no, scent, real(sum))
C                 wrtout(no,scent,pepk,sum,pear,sd1)
C              ENDIF
            ENDIF
         ENDIF
 40   CONTINUE
      STOP

 112  FORMAT(I3,2X,F7.2,'(',F5.3,')',1X,F10.1,'(',F6.1,')',3X,F5.2,
     +       1X,F10.4,'(',F7.4,')')
      END
C-----------------------------------------------------------------------
      subroutine crash (str)
      character*(*) str
      write (6,'(a)') str
      call exit (1)
      end
C-----------------------------------------------------------------------
