#include <stdio.h>
#include <string.h>
#define MAXFILES 3
#define const

static FILE    *fp[MAXFILES];
static char    names[MAXFILES][128];

int openspr_(id,spec_name,access,spec_len)
      int         *id;
      const char  *spec_name;
      const char  *access;
      int         spec_len;
{
      int i;
      for (i=0; i<MAXFILES; i++) {
            if (names[i][1] == '\0') {
                  strncpy(names[i], spec_name, spec_len);
                  break;
            }
      }
      if (i == MAXFILES) {
            fprintf(stderr,"openstr: no more streams available\n");
            exit(-1);
      }
      if ( (fp[i] = fopen(names[i],access)) == NULL) {
            names[i][0] = '\0';
            fprintf(stderr,"openstr: open on file %s failed\n",names[i]);
            exit(-1);
      }
      *id = i;
      return(0);
}

int clsspr_(id)
      int  *id;
{
      if (*id < 0 || *id >= MAXFILES) {
            fprintf(stderr,"clsspr: close stream %d failed\n",*id);
            exit(-1);
      }
      (void) fclose(fp[*id]);
      (void) unlink(names[*id]); 
      names[*id][0] = '\0';
      *id = -1;
      return(0);
}

static double buffer[BUFSIZ];
static int base_chan, top_chan;

int igtchn_(id, chan, count)
      const int *id;
      const int *chan;
      int       *count;
{
      int nelems;
      if (*id < 0 || *id >= MAXFILES) {
            fprintf(stderr,"igtchn: read on stream %d failed\n",*id);
            exit(-1);
      }
      while (*chan >= top_chan) {
            base_chan += top_chan;
            nelems = fread((char *) buffer, sizeof(double), BUFSIZ, fp[*id]);
            if (nelems <= 0) {
                  fprintf(stderr,"igtchn: read on stream %d return %d elements read\n",*id, nelems);
                  exit(-1);
            }
            top_chan = base_chan + nelems;
      }
      if (*chan < base_chan) {
            base_chan = *chan;
            fseek(fp[*id], *chan * sizeof(double), 0);
            nelems = fread((char *) buffer, sizeof(double), BUFSIZ, fp[*id]);
            if (nelems <= 0) {
                  fprintf(stderr,"igtchn: read on stream %d return %d elements read\n",*id, nelems);
                  exit(-1);
            }
            top_chan = base_chan + nelems;
      }
      *count = (int) buffer[*chan - base_chan];
      return(0);
}
            

void ctoi_ (string, index, value, ierr, strlen)
      char *string;
      int *index;
      int *value;
      int *ierr;
      int strlen;
{

/* convert string to integer
//   CTOI (string,index,value,returncode)
// convert characters from 'string' starting at position 'index' to
// integer returning value in 'value' and advancing 'index' beyond
// the converted characters
// returncode returned with ERR bits from FROMCHAR, without sign
// extension, using value 13 for 'real number found'
*/

   int i;
   char *stringend;
   stringend=string+strlen;
   string=string+*index-1;
   *ierr=4;                    /* means no number found */
   while (string<stringend && *string==' ') string++;
   if (string>=stringend) return;
   i=sscanf (string, "%d", value);
   if (i==0) {
      i=sscanf(string, "%f", value);
      if (i==0) return;
      *ierr=13;
      }
   else *ierr=0;
   while (string<stringend && *string!=' ') string++;
   *index=string-(stringend-strlen)+1;
   }   

void ctor_ (string, index, value, ierr, strlen)
      char *string;
      int *index;
      float *value;
      int *ierr;
      int strlen;
{

/* convert string to REAL
//   CTOR (string,index,value,logical)
// convert characters from 'string' starting at position 'index' to
// real returning value in 'value' and advancing 'index' beyond
// the converted characters
// returncode returned with ERR bits from FROMCHAR, without sign
// extension
*/

   int i;
   char *stringend;
   stringend=string+strlen;
   string=string+*index-1;
   *ierr=4;                    /* means no number found */
   while (string<stringend && *string==' ') string++;
   if (string>=stringend) return;
   i=sscanf (string, "%f", value);
   if (i!=1) return;
   *ierr=0;
   while (string<stringend && *string!=' ') string++;
   *index=string-(stringend-strlen)+1;
   }   


static FILE *ofp;
int
openof_()
{
      char str_buf[L_tmpnam+24];
      sprintf(str_buf,"%sPEAKF_%d",P_tmpdir,getpid()); 
/*    sprintf(str_buf,"PEAKF_%d",getpid()); */
/*      fprintf(stderr,"Peakfind output in %s\n",str_buf); */
      if ( (ofp = fopen(str_buf,"w")) == NULL) {
            fprintf(stderr,"open on output file %s failed\n",str_buf);
            exit(-1);
      }
}
int
outfile_(no, chan, area)
      int      *no;
      float    *chan;
      float    *area;
{
      double channel = (double) *chan;
      double area_pk = (double) *area;
      fprintf(ofp,"%d %g %g\n",*no, channel, area_pk);
      return(0);
}
