#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>

#include <stdio.h>

union semun {
   int val;
   struct semid_ds* buf;
   ushort* array;
 } ctlarg;

struct semid_ds stat; 
int errno;


struct sembuf sop;
int i;
int s;


void make () {
   i=semget (999, 1, IPC_CREAT | 0400 | 0200);
   printf ("semget=%d, errno=%d\n", i, errno);
   s=i;

   ctlarg.buf=&stat;
   i=semctl (s, 0, IPC_STAT, ctlarg);
   printf ("semctl(ipcstat)=%d, errno=%d\n", i, errno);

   ctlarg.val=1;
   i=semctl (s, 0, SETVAL, ctlarg);
   printf ("semctl(setval)=%d, errno=%d\n", i, errno);

   i=semctl (s, 0, GETVAL);
   printf ("semctl(getval)=%d, errno=%d\n", i, errno);
   i=semctl (s, 0, GETNCNT);
   printf ("semctl(getncnt)=%d, errno=%d\n", i, errno);
   i=semctl (s, 0, GETZCNT);
   printf ("semctl(getzcnt)=%d, errno=%d\n", i, errno);
   
   printf ("sem id is %d\n", s);
   }   

void kill (char* ptr) {
   i=sscanf (ptr, "%d", &s);
   if (i!=1) exit(1);
   i=semctl (s, 0, IPC_RMID);
   printf ("semctl(ipcrmid)=%d, errno=%d\n", i, errno);
   }

void run (char* ptr) {
   i=sscanf (ptr, "%d", &s);
   if (i!=1) exit(1);

   sop.sem_num=0;
   sop.sem_op=-1;
   sop.sem_flg=SEM_UNDO;
   i=semop (s, &sop, 1);
   printf ("%d: semop(claim)=%d, errno=%d\n", getpid(), i, errno);
   sleep(10);
   sop.sem_num=0;
   sop.sem_op=1;
   sop.sem_flg=SEM_UNDO;
   i=semop (s, &sop, 1);
   printf ("%d: semop(free)=%d, errno=%d\n", getpid(), i, errno);
   }

void runfree (char* ptr, char* times) {
   int n;
   i=sscanf (times, "%d", &n);
   if (i!=1) exit(1);
   while (n>0) {run (ptr); n--;}
   }


main (int argc, char* argv[]) {

   if (argc==2 && strcmp(argv[1], "make")==0) make ();
   if (argc==3 && strcmp(argv[1], "run")==0) run (argv[2]);
   if (argc==4 && strcmp(argv[1], "runfree")==0) 
      runfree (argv[2],argv[3]);
   if (argc==3 && strcmp(argv[1], "kill")==0) kill (argv[2]);
   }   

rest () {
   i=semget (999, 1, IPC_CREAT | 0400 | 0200);
   printf ("semget=%d, errno=%d\n", i, errno);
   s=i;

   ctlarg.buf=&stat;
   i=semctl (s, 0, IPC_STAT, ctlarg);
   printf ("semctl(ipcstat)=%d, errno=%d\n", i, errno);

   ctlarg.val=1;
   i=semctl (s, 0, SETVAL, ctlarg);
   printf ("semctl(setval)=%d, errno=%d\n", i, errno);

   i=semctl (s, 0, GETVAL);
   printf ("semctl(getval)=%d, errno=%d\n", i, errno);
   i=semctl (s, 0, GETNCNT);
   printf ("semctl(getncnt)=%d, errno=%d\n", i, errno);
   i=semctl (s, 0, GETZCNT);
   printf ("semctl(getzcnt)=%d, errno=%d\n", i, errno);


   sop.sem_num=0;
   sop.sem_op=-1;
   sop.sem_flg=SEM_UNDO;
   i=semop (s, &sop, 1);
   printf ("semop(claim)=%d, errno=%d\n", i, errno);

   i=semctl (s, 0, GETVAL);
   printf ("semctl(getval)=%d, errno=%d\n", i, errno);

   sop.sem_num=0;
   sop.sem_op=1;
   sop.sem_flg=SEM_UNDO;
   i=semop (s, &sop, 1);
   printf ("semop(free)=%d, errno=%d\n", i, errno);

   i=semctl (s, 0, GETVAL);
   printf ("semctl(getval)=%d, errno=%d\n", i, errno);


   i=semctl (s, 0, IPC_RMID);
   printf ("semctl(ipcrmid)=%d, errno=%d\n", i, errno);
 }
