/*******************************************************************************
* spy.h        
*/

/*
Thu Mar  9 11:27:09 GMT 1995, DB
changed the ring handling protocol---see the README
*/

#ifndef INCspyH
#define INCspyH

#define DEFAULT_DEVICE "/dev/le"
#define DEFAULT_PPA    0
#define DEFAULT_HOST   "charissa4"
#define DEFAULT_BLOCKSIZE 16384
#define DEFAULT_RINGSIZE 16
#define DEFAULT_FILEROOT "/usr/tmp/sort-spy-stream"

#define MAX_BLOCKSIZE 16384
#define MAX_RINGSIZE 64                  /* number of data blocks queued */


/* returns from various functions */

#define OK    0
#define ERROR -1
#define FALSE 0
#define TRUE  (!FALSE)

/* network protocol definitions - must coinside with tose used for eb-fddi */

#define MAX_STREAM 4
#define EGEB_UDP_PORT 10206
#define EGTS_UDP_PORT 10205
#define EGTS_RPC_PROG 28000205
#define EGTS_RPC_PROC 31
#define RPC_VERSION   2
#define EGTS_VERSION  2
#define DATA_FRAG_SIZE 0x1000        /* data split into max 4K fragments */
#define DATA_FRAG_NUM 16            /* for 1K data blocks */
#define DATA_BLOCK_SIZE 0x4000


typedef struct ip  IP;
typedef struct udphdr UDP;

typedef struct rpc_header {             /* RPC datagram header */
   u_long  id;
   u_long  direction;
   u_long  version;
   u_long  program;
   u_long  progVersion;
    u_long  procedure;
    u_long  authorisation[4];
} RPC_HDR;

typedef struct data_header {             /* changing part of header */
   u_long stream;
   u_long capability[2];
   u_long options;
   u_long sequence;
   u_long offset;
   u_long length;
} DATA_HDR;

typedef struct datagram_header {
   u_short   i802_header1;
   u_short   i802_header2;
   u_short   i802_header3;
   u_short  ethertype;
} DATAGRAM_HDR;

typedef struct datagram_format {
   IP       ip;
   UDP      udp;
   RPC_HDR  rpc;
   DATA_HDR hdr;
   char     data[DATA_FRAG_SIZE];
} DATAGRAM;

#define OPT_END (1<<0)                   /* end of block  */

#define DATA_OFFSET (sizeof (DATAGRAM) - DATA_FRAG_SIZE)

/* definitions for shared mmapped files */

#define SIGWAKE SIGUSR1              /* the wakeup signal */

typedef struct shared_file_format {
   int spyPid;                  /* id of spy task so that it can be woken up */
   int userPid;                /* id of user task so that it can be woken up */
   int blocksize;
   int ringsize;
   int wrCount;                   /* number of queue slots filled and unread */
   int wrIndex;                                     /* index into data queue */
   int length[MAX_RINGSIZE];             /* length of transferred data block */
   int sequence[MAX_RINGSIZE];      /* sequence no of transferred data block */
   int buffer[MAX_RINGSIZE];        /* displacement of transfered data block */
} FSTR;

#endif
