*-----------------------------------------------------------------------
* ''geom_pssd''      Geometry of PSSD's                 Steve Chappell

*   Program to determine geometry of PSSD setup

* Notes
*  
                                          
* Updates
*   Last Edited 26th Jan 1997

*-----------------------------------------------------------------------

       program geom_pssd

       implicit none
       real dist,cang,thx0,thx1,thy0,thy1,strip0,rad
       integer det,strip,ndet
       character*1 question
       character*2 dummy
       parameter(rad=0.01745329)

       write(6,*) 'OK to overwrite geom_*.out files in this directory?'
        read(5,*) question
        if(question.ne.'Y'.and.question.ne.'y') then
           write(6,*)'make it OK!'
           stop
       endif

*open files
       open(unit=10,file='geom_pssd.in',status='old')
       open(unit=20,file='geom_angs.out',status='unknown')

       read(10,*) dummy
       read(10,*) ndet
       read(10,*) dummy

       write(20,8001)

       do 1000 det=1,ndet

          write(20,8002) det
          read(10,*) dummy
          read(10,*) dist,cang,strip0

          do 990 strip=1,16

             thx0=cang-(atan(25.0/dist))/rad
             thx1=cang+(atan(25.0/dist))/rad
             thy0=(atan(3.125*(real(strip)-strip0)/dist))/rad
             thy1=thy0

             write(20,*) thx0,thx1,thy0,thy1

 990      continue

1000  continue

       write(6,*) 'Output'
       write(6,*) '[thx0,thx1,thy0,thy1] parameters in : geom_angs.out'

*close files
       close(10)
       close(20)

 8001  format('* Angular Calibration from Geometry   ',
     + '---ANU xxx xx---    Steve Chappell')
 8002  format('~~~ DETECTOR ',i2,
     + ' ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~')

       end
