/* 
 * Event Structure routines
 */

#include <stdio.h>
#include <stdlib.h>
#include "ev.h" 

struct evhead evhead;
struct ev *ev = NULL;

/*
 * create space for ev[1 to n particles] structure array
 */
int ev_init(int n)
{
    if (ev != NULL)
      free(ev);
	
	if ((ev = (struct ev *) calloc(n+1, sizeof(struct ev))) == NULL)
	  {
	    fprintf(stderr,
	    "Unable to allocate memory for event structure.\n");
	      return(1);
	  }
	  
	  return(0);
}

void ev_zeroheader(void)
{
    memset(&evhead, 0, sizeof(evhead));
}

/*fortran compatability functions*/

int ev_init_(int *n)
{
    return(ev_init(*n));
}

void ev_zeroheader_(void)
{
    ev_zeroheader();
}

int evhead_m(int i) { return(evhead.m[i]); }
void evheads_m(int i, int v) { evhead.m[i] = v; }
int evhead_m_(int *i) { return(evhead.m[(*i)]); }
void evheads_m_(int *i, int *v) { evhead.m[(*i)] = *v; }

int evhead_n(int i) { return(evhead.n[i]); }
void evheads_n(int i, int v) { evhead.n[i] = v; }
int evhead_n_(int *i) { return(evhead.n[(*i)]); }
void evheads_n_(int *i, int *v) { evhead.n[(*i)] = *v; }

int evhead_p(int i) { return(evhead.p[i]); }
void evheads_p(int i, int v) { evhead.p[i] = v; }
int evhead_p_(int *i) { return(evhead.p[(*i)]); }
void evheads_p_(int *i, int *v) { evhead.p[(*i)] = *v; }

int evhead_type(void) { return(evhead.type); }
void evheads_type(int v) { evhead.type = v; }
int evhead_type_(void) { return(evhead.type); }
void evheads_type_(int *v) { evhead.type = *v; }

float evhead_etot(void) { return(evhead.etot); }
void evheads_etot(float v) { evhead.etot = v; }
float evhead_etot_(void) { return(evhead.etot); }
void evheads_etot_(float *v) { evhead.etot = *v; }

int ev_fold(int i) { return(ev[i].fold); }
void evs_fold(int i, int v) { ev[i].fold = v; }
int ev_fold_(int *i) { return(ev[(*i)].fold); }
void evs_fold_(int *i, int *v) { ev[(*i)].fold = *v; }

float ev_px(int i) { return(ev[i].px); }
void evs_px(int i, float v) { ev[i].px = v; }
float ev_px_(int *i) { return(ev[(*i)].px); }
void evs_px_(int *i, float *v) { ev[(*i)].px = *v; }

float ev_py(int i) { return(ev[i].py); }
void evs_py(int i, float v) { ev[i].py = v; }
float ev_py_(int *i) { return(ev[(*i)].py); }
void evs_py_(int *i, float *v) { ev[(*i)].py = *v; }

float ev_pz(int i) { return(ev[i].pz); }
void evs_pz(int i, float v) { ev[i].pz = v; }
float ev_pz_(int *i) { return(ev[(*i)].pz); }
void evs_pz_(int *i, float *v) { ev[(*i)].pz = *v; }

float ev_p(int i) { return(ev[i].p); }
void evs_p(int i, float v) { ev[i].p = v; }
float ev_p_(int *i) { return(ev[(*i)].p); }
void evs_p_(int *i, float *v) { ev[(*i)].p = *v; }

float ev_e(int i) { return(ev[i].e); }
void evs_e(int i, float v) { ev[i].e = v; }
float ev_e_(int *i) { return(ev[(*i)].e); }
void evs_e_(int *i, float *v) { ev[(*i)].e = *v; }

float ev_t(int i) { return(ev[i].t); }
void evs_t(int i, float v) { ev[i].t = v; }
float ev_t_(int *i) { return(ev[(*i)].t); }
void evs_t_(int *i, float *v) { ev[(*i)].t = *v; }

float ev_th(int i) { return(ev[i].th); }
void evs_th(int i, float v) { ev[i].th = v; }
float ev_th_(int *i) { return(ev[(*i)].th); }
void evs_th_(int *i, float *v) { ev[(*i)].th = *v; }

float ev_thcm(int i) { return(ev[i].thcm); }
void evs_thcm(int i, float v) { ev[i].thcm = v; }
float ev_thcm_(int *i) { return(ev[(*i)].thcm); }
void evs_thcm_(int *i, float *v) { ev[(*i)].thcm = *v; }

float ev_phi(int i) { return(ev[i].phi); }
void evs_phi(int i, float v) { ev[i].phi = v; }
float ev_phi_(int *i) { return(ev[(*i)].phi); }
void evs_phi_(int *i, float *v) { ev[(*i)].phi = *v; }

float ev_q(int i) { return(ev[i].q); }
void evs_q(int i, float v) { ev[i].q = v; }
float ev_q_(int *i) { return(ev[(*i)].q); }
void evs_q_(int *i, float *v) { ev[(*i)].q = *v; }

float ev_q2(int i) { return(ev[i].q2); }
void evs_q2(int i, float v) { ev[i].q2 = v; }
float ev_q2_(int *i) { return(ev[(*i)].q2); }
void evs_q2_(int *i, float *v) { ev[(*i)].q2 = *v; }

float ev_m(int i) { return(ev[i].m); }
void evs_m(int i, float v) { ev[i].m = v; }
float ev_m_(int *i) { return(ev[(*i)].m); }
void evs_m_(int *i, float *v) { ev[(*i)].m = *v; }

int ev_hi(int i) { return(ev[i].hi); }
void evs_hi(int i, int v) { ev[i].hi = v; }
int ev_hi_(int *i) { return(ev[(*i)].hi); }
void evs_hi_(int *i, int *v) { ev[(*i)].hi = *v; }

int ev_li(int i) { return(ev[i].li); }
void evs_li(int i, int v) { ev[i].li = v; }
int ev_li_(int *i) { return(ev[(*i)].li); }
void evs_li_(int *i, int *v) { ev[(*i)].li = *v; }

int ev_det(int i) { return(ev[i].det); }
void evs_det(int i, int v) { ev[i].det = v; }
int ev_det_(int *i) { return(ev[(*i)].det); }
void evs_det_(int *i, int *v) { ev[(*i)].det = *v; }

int ev_seg(int i) { return(ev[i].seg); }
void evs_seg(int i, int v) { ev[i].seg = v; }
int ev_seg_(int *i) { return(ev[(*i)].seg); }
void evs_seg_(int *i, int *v) { ev[(*i)].seg = *v; }


