/* ev.h  event structure header file */


/*Some limits on event structure size*/
#define MAXNUMDETS 4
#define MAXNUMHITS 6

int ev_init(int);
void wrtev(void);

extern struct evhead {
    int m[MAXNUMDETS+1];  /*multiplicity 0=>num signals n=> num hits in det n*/
    int n[MAXNUMHITS+1];  /*num particles of each fold 0=>total 1=>singles.. */
    int p[MAXNUMHITS+1];  /*particle positions in the array for each fold*/
    int type;
    float etot;
} evhead;

extern struct ev {
    int fold;             /*particle reconstructed from fold particles*/
    float px;             /*momentum in x*/
    float py;             /*momentum in y*/
    float pz;             /*momentum in z*/
    float p;              /*momentum total*/
    float e;              /*energy*/
    float t;              /*time*/
    float th;             /*polar theta w.r.t. z axis*/
    float thcm;           /*theta in c.m.*/
    float phi;            /*azimuthal phi*/
    float q;              /*excitation q*/
    float q2;             /*two-body q*/
    float m;              /*mass*/
    int hi;               /*heavy-ion daughter*/
    int li;               /*light-ion daughter*/
    int det;              /*detector hit*/
    int seg;              /*detector segment hit*/
} *ev;

void ev_zeroheader(void);

/*fortran compatability functions*/

int evhead_m(int);
void evheads_m(int, int);

int evhead_n(int);
void evheads_n(int, int);

int evhead_p(int);
void evheads_p(int, int);

int evhead_type(void);
void evheads_type(int);

float evhead_etot(void);
void evheads_etot(float);

int ev_fold(int);
void evs_fold(int, int);

float ev_px(int);
void evs_px(int, float);

float ev_py(int);
void evs_py(int, float);

float ev_pz(int);
void evs_pz(int, float);

float ev_p(int);
void evs_p(int, float);

float ev_e(int);
void evs_e(int, float);

float ev_t(int);
void evs_t(int, float);

float ev_th(int);
void evs_th(int, float);

float ev_thcm(int);
void evs_thcm(int, float);

float ev_phi(int);
void evs_phi(int, float);

float ev_q(int);
void evs_q(int, float);

float ev_q2(int);
void evs_q2(int, float);

float ev_m(int);
void evs_m(int, float);

int ev_hi(int);
void evs_hi(int, int);

int ev_li(int);
void evs_li(int, int);

int ev_det(int);
void evs_det(int, int);

int ev_seg(int);
void evs_seg(int, int);

