/*
 * ''nrp''      N Fold Resonant Particles                  Steve Chappell
 *
 * General Subroutine to Generate resonant particles 
 * from N breakup products and add the particles to the
 * the ev array. Restricted to NCR_MAX=6 fold and below.

 * Notes

 * Includes subroutine ''ncr'' to calculate r combinations from n

 * Reconstruct Pairs from two singles
 * Reconstruct Triples from Pairs plus singles
 * Reconstruct Quads from Triples plus singles
 * etc etc
 * Result is ``heavy ion'' and ``light ion''  point back up the tree 
 * to the single particle numbers and DO NOT correspond to the 
 * sequential breakup into HI and LI.

 * In the event array.... If N=nhits  nCr combinations of each type
 * Singles  1              --> N
 * Doubles  N +1           --> N +1 +NC2-1
 * Triples  N +1 NC2-1 +1  --> N +1 +NC2-1 +1 +NC3-1
 * Quads

 * Updates
 *   24th Jun 97: Translation to C
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "subs.h"

int nrp(void)
{

    int vrp_nrp[N1_MAX+1];
    int i1_nrp,i2_nrp,i3_nrp,i4_nrp,i5_nrp,i6_nrp;
    
    if(evhead.n[1] > N1_MAX){
	fprintf(stderr,"ncr: %d hit event dumped. Max fold %d exceeded\n"
		,evhead.n[1],N1_MAX);
	return(1);
    }


/*
 * Put Number of different Nfold combinations
 * Plus Pointers to ``start'' and ``Next'' locations 
 * of Nfold particles in the Event Header
 */
    
    vrp_nrp[1]=evhead.p[1];
    
    if(evhead.n[1] >= 2){
	evhead.n[2]=ncr(evhead.n[1],2);
	evhead.p[2]=evhead.p[1]+evhead.n[1];
	evhead.n[0]=evhead.n[0]+evhead.n[2];
	vrp_nrp[2]=evhead.p[2];
      }
    if(evhead.n[1] >= 3){
	evhead.n[3]=ncr(evhead.n[1],3);
	evhead.p[3]=evhead.p[2]+evhead.n[2];
	evhead.n[0]=evhead.n[0]+evhead.n[3];
	vrp_nrp[3]=evhead.p[3];
    }
    if(evhead.n[1] >= 4){
	evhead.n[4]=ncr(evhead.n[1],4);
	evhead.p[4]=evhead.p[3]+evhead.n[3];
	evhead.n[0]=evhead.n[0]+evhead.n[4];
	vrp_nrp[4]=evhead.p[4];
      }
    if(evhead.n[1] >= 5){
	evhead.n[5]=ncr(evhead.n[1],5);
	evhead.p[5]=evhead.p[4]+evhead.n[4];
	evhead.n[0]=evhead.n[0]+evhead.n[5];
	vrp_nrp[5]=evhead.p[5];
    }
    if(evhead.n[1] >= 6){
	evhead.n[6]=ncr(evhead.n[1],6);
	evhead.p[6]=evhead.p[5]+evhead.n[5];
	evhead.n[0]=evhead.n[0]+evhead.n[6];
	vrp_nrp[6]=evhead.p[6];
    }
    
    /* fprintf(stderr,"nrp : NHITS %d\n",evhead.n[1]);
       fprintf(stderr,"nrp : NCOMBS %d\n",evhead.n[0]); */
     
    
    /* Build the combinations of virtual fold particles*/
    
    /*singles*/
    if(1 <= evhead.n[1]-1){
	for(i1_nrp=1 ; i1_nrp <= evhead.n[1]-1; i1_nrp++){
	    /*doubles*/
	    if(i1_nrp+1 <= evhead.n[1]){
		for(i2_nrp=i1_nrp+1; i2_nrp <= evhead.n[1]; i2_nrp++){
		    rp(vrp_nrp[1],i2_nrp,vrp_nrp[2]);
		    /*triples*/
		    if(i2_nrp+1 <= evhead.n[1]){
			for(i3_nrp=i2_nrp+1; i3_nrp <= evhead.n[1]; i3_nrp++){
			    rp(vrp_nrp[2],i3_nrp,vrp_nrp[3]);
			    /*quads*/
			    if(i3_nrp+1 <= evhead.n[1]){
				for(i4_nrp=i3_nrp+1; i4_nrp <= evhead.n[1]; i4_nrp++){
				    rp(vrp_nrp[3],i4_nrp,vrp_nrp[4]);
				    /*quins*/
				    if(i4_nrp+1 <= evhead.n[1]){
					for(i5_nrp=i4_nrp+1; i5_nrp <= evhead.n[1]; i5_nrp++){
					    rp(vrp_nrp[4],i5_nrp,vrp_nrp[5]);
					    /*sextuplets*/
					    if(i5_nrp+1 <= evhead.n[1]){
						for(i6_nrp=i5_nrp+1; i6_nrp <= evhead.n[1]; i6_nrp++){
						    rp(vrp_nrp[5],i6_nrp,vrp_nrp[6]);
						    vrp_nrp[6]=vrp_nrp[6]+1;
						}
					    }
					    vrp_nrp[5]=vrp_nrp[5]+1;
					}
				    }
				    vrp_nrp[4]=vrp_nrp[4]+1;
				}
			    }
			    vrp_nrp[3]=vrp_nrp[3]+1;
			}
		    }
		    vrp_nrp[2]=vrp_nrp[2]+1;
		}
	    }
	    vrp_nrp[1]=vrp_nrp[1]+1;
	}
    }
    
    return(0);
}


/*
 *''ncr''  Calculate r combinations out of n               Steve Chappell
 */
int ncr(int n_ncr, int r_ncr)
{
    int i_ncr;
    int value=1;
    if(n_ncr < 0 || r_ncr < 0 || n_ncr < r_ncr){
        fprintf(stderr,"ncr: Error! n=%d r=%d\n",n_ncr,r_ncr);
	return(0);
    }
    for(i_ncr=1; i_ncr<=r_ncr; i_ncr++)
	value=(n_ncr-i_ncr+1)*value/i_ncr;
    /*fprintf(stderr,"ncr: n=%d r=%d = %d\n",n_ncr,r_ncr,value);*/
    return value;
}

