*-----------------------------------------------------------------------
* ''rp''      Resonant Particle                           Steve Chappell
*
*   General Subroutine to reconstruct a resonant particle
*   from two breakup fragments...
*   1(rp*) -> 2(Heavy Ion) + 3(Light Ion)

* Notes

* Updates
*   Error in pcm_rp(1,3) calculation fixed 24th Jun 97

*-----------------------------------------------------------------------

      subroutine rp(hi_rp,li_rp,vrp_rp)

      implicit none
      include 'subs.i'
      common/reac/ e1,mass
      real e1,mass(0:4)
      real m_rp(3),mrec_rp,vcm_rp
      real p_rp(3,3),pcm_rp(3,3)
      real psum_rp(3),psumcm_rp
      real q_rp,e_rp,q2_rp,th_rp,phi_rp,thcm_rp
      integer hi_rp,li_rp,vrp_rp

      vcm_rp=(sqrt(2.0*e1*mass(1)))/(mass(1)+mass(2))

* Particle 3 = Light Ion
      m_rp(3)=ev_m(li_rp)
      p_rp(3,1)=ev_px(li_rp)
      p_rp(3,2)=ev_py(li_rp)
      p_rp(3,3)=ev_pz(li_rp)
      psum_rp(3)=sqrt(p_rp(3,1)**2+p_rp(3,2)**2+p_rp(3,3)**2)

* Particle 2 = Heavy Ion
      m_rp(2)=ev_m(hi_rp)
      p_rp(2,1)=ev_px(hi_rp)
      p_rp(2,2)=ev_py(hi_rp)
      p_rp(2,3)=ev_pz(hi_rp)
      psum_rp(2)=sqrt(p_rp(2,1)**2+p_rp(2,2)**2+p_rp(2,3)**2)

* Particle 1 = Resonant Particle
      m_rp(1)=m_rp(2)+m_rp(3)
      p_rp(1,1)=p_rp(2,1)+p_rp(3,1)
      p_rp(1,2)=p_rp(2,2)+p_rp(3,2)
      p_rp(1,3)=p_rp(2,3)+p_rp(3,3)
      psum_rp(1)=sqrt(p_rp(1,1)**2+p_rp(1,2)**2+p_rp(1,3)**2)

**Resonant Particle Analysis ...
      e_rp=(psum_rp(1)**2)/(2.0*m_rp(1))
      q_rp=ev_e(li_rp)+ev_e(hi_rp) - e_rp
      pcm_rp(1,1)=p_rp(1,1)
      pcm_rp(1,2)=p_rp(1,2)
      pcm_rp(1,3)=p_rp(1,3)-m_rp(1)*vcm_rp
      psumcm_rp=sqrt(pcm_rp(1,1)**2+pcm_rp(1,2)**2+pcm_rp(1,3)**2)

      th_rp=(acos(p_rp(1,3)/psum_rp(1)))/rad
      phi_rp=sign(1,p_rp(1,2))*(acos(p_rp(1,1)/
     +                 (sqrt(p_rp(1,1)**2+p_rp(1,2)**2))))/rad

      mrec_rp=mass(1)+mass(2)-m_rp(1)

      if(mrec_rp.gt.0)then
         q2_rp=((m_rp(1)+mrec_rp)*e_rp - 
     +          (mrec_rp-mass(1))*e1   - 
     +           2.0*(sqrt(mass(1)*m_rp(1)*e1*e_rp)) *
     +           cos(th_rp*rad)
     +          )/mrec_rp
      else
         q2_rp=0.0
      endif

      thcm_rp=(acos(pcm_rp(1,3)/psumcm_rp))/rad

**Collect parameters of the ``virtual hit'' in next slot of the ev array

      call evs_fold(vrp_rp,ev_fold(hi_rp)+ev_fold(li_rp))
      call evs_px(vrp_rp,p_rp(1,1))
      call evs_py(vrp_rp,p_rp(1,2))
      call evs_pz(vrp_rp,p_rp(1,3))
      call evs_p(vrp_rp,psum_rp(1))
      call evs_e(vrp_rp,e_rp)
      call evs_t(vrp_rp,0.0)
      call evs_th(vrp_rp,th_rp)
      call evs_thcm(vrp_rp,thcm_rp)
      call evs_phi(vrp_rp,phi_rp)
      call evs_q(vrp_rp,q_rp)
      call evs_q2(vrp_rp,q2_rp)
      call evs_m(vrp_rp,m_rp(1))
      call evs_hi(vrp_rp,hi_rp)
      call evs_li(vrp_rp,li_rp)
      call evs_det(vrp_rp,0)
      call evs_seg(vrp_rp,0)

      end
