/*
 * ''reac''      Reaction definition                           Steve Chappell
 *
 *   General Subroutine to setup default reaction parameters
 *   from file
 
 * Updates
 *   26th Jun 97
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "subs.h"


struct reac reac;


/*
 * Reaction definition routine
 */

int reac_init(void)
{
    FILE *fp;
    char buffer[256];
    float m0,m1,m2,m3,m4,e1,edisp;
    
    /*default settings*/
    reac.edisp=100.0;
    reac.e1=reac.edisp*65.0;
    reac.mass[0]=4.0;
    reac.mass[1]=12.0;
    reac.mass[2]=12.0;
    reac.mass[3]=12.0;
    reac.mass[4]=12.0;
    
    if ((fp = fopen(CALIB_DIR "reac.cal", "r")) != NULL)
    {
	fprintf(stderr, "Reading file \"%s\".\n",CALIB_DIR "reac.cal");
	while (mygetline(buffer, 256, fp) == NULL)
	    ;
	if (sscanf(buffer, " %f %f", &e1, &edisp) != 2)
	    fprintf(stderr, "Expected 'e1 edisp', got \"%s\".\n", buffer);
	else
	{
	    reac.e1= e1*edisp;
	    reac.edisp= edisp;
	}
	
	
	while(mygetline(buffer, 256, fp) == NULL)
	    ;
	if (sscanf(buffer, " %f %f %f %f", &m1, &m2, &m3, &m4) != 4)
	    fprintf(stderr, "Expected 'mass1 mass2 mass3 mass4\n'"
		    "got \"%s\".\n", buffer);
	else
	{
	    reac.mass[1]= m1;
	    reac.mass[2]= m2;
	    reac.mass[3]= m3;
	    reac.mass[4]= m4;
	}
	
	
	while (mygetline(buffer, 256, fp) == NULL)
	    ;
	if (sscanf(buffer, " %f", &m0) != 1)
	    fprintf(stderr, "Expected 'm0', got \"%s\".\n", buffer);
	else
	{
	    reac.mass[0]= m0;
	}
	fclose(fp);
    }
    else
    {
	fprintf(stderr, "No file \"%s\", using default settings.\n",
		CALIB_DIR "reac.cal");
    }

    
    fprintf(stderr,"\nDefault Reaction:\n"
	    "%5.1f[%7.2f MeV] ->%5.1f ==> %5.1f + %5.1f\n",
	    reac.mass[1],reac.e1/reac.edisp,reac.mass[2],reac.mass[3],
	    reac.mass[4]);
    fprintf(stderr,"Hitmass=%5.1f\n",reac.mass[0]);
    fprintf(stderr,"Edisp = %7.2f Channs/MeV\n\n",reac.edisp);

    return(0);
}


/*fortran compatability*/

int reac_init_(void)
{
    return(reac_init());
}

float reac_edisp(void){ return(reac.edisp); }
void reacs_edisp(float v){ reac.edisp = v; }
float reac_edisp_(void){ return(reac.edisp); }
void reacs_edisp_(float *v){ reac.edisp = *v; }

float reac_e1(void){ return(reac.e1); }
void reacs_e1(float v){ reac.e1 = v; }
float reac_e1_(void){ return(reac.e1); }
void reacs_e1_(float *v){ reac.e1 = *v; }

float reac_mass(int i){ return(reac.mass[i]); }
void reacs_mass(int i, float v){ reac.mass[i] = v; }
float reac_mass_(int *i){ return(reac.mass[(*i)]); }
void reacs_mass_(int *i, float *v){ reac.mass[(*i)] = *v; }


