/*
 * ''rhit''      Recalculate hit                           Steve Chappell
 *
 *   General Subroutine to recalculate event parameters of a hit
 *   given that the mass originally associated with the 
 *   particle has been changed

 * Updates
 *   24th Jun 97: Translation to C
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "subs.h"

int rhit(float newmass, int vrp)
{
    float oldmass;

      oldmass = ev[vrp].m;
      ev[vrp].m = newmass;
      ev[vrp].px = ev[vrp].px*sqrt(newmass/oldmass);
      ev[vrp].py = ev[vrp].py*sqrt(newmass/oldmass);
      ev[vrp].pz = ev[vrp].pz*sqrt(newmass/oldmass);
      ev[vrp].p = ev[vrp].p*sqrt(newmass/oldmass);
}
