/* subs.h   Standard Subroutine Declarations */

#include "event-struct/ev.h" /*event structure*/
#include "reac.h"            /*reaction structure*/
#include "files.h"           /*file handling*/

#define RAD 0.01745329   /*degrees to radians conversion*/

#define NP_MAX 63        /*Max number of particles in the event array*/
#define N1_MAX 6         /*Max number of single particle hits*/
#define N2_MAX 15        /*Max number of doubles*/
#define N3_MAX 20        /*Max number of triples*/
#define N4_MAX 15        /*Max number of quads*/
#define N5_MAX 6         /*Max number of quins*/
#define N6_MAX 1         /*Max number of sextuplets*/


int nrp(void);                /*Builds event array for n resonant particles*/
int ncr(int, int);            /*r combinations out of n*/
int rp(int, int, int);        /*Resonant Particle Kinematics*/
int rhit(float, int);         /*Recalculate hit for new mass assignment*/



