#ifndef SUNSORT_EXTERN_h
#define SUNSORT_EXTERN_h

#ifdef SVR4
#include <unistd.h>
#define NeedFunctionPrototype 1
#else
#define NeedFunctionPrototype 0
#endif

#include "gui.h"
#include "sort_def.h"

#define	CLEAR_SPEC_LIST	1
#define IO_spectra 1
#define IO_status 2

#ifdef SUNSORT_MAIN

/* infomation concerning current sort state */
sort_IO_t 	    *sort_io_data;
dirs_IO_t	    *dirs_io_data;
char                *tmp_spectrum_dir;
char                *sort_proc_name;
static dirs_IO_t    local_dirs_io_data;

/* pointers to window data structures */
sort_gui_window1_objects	*sort_gui_window1;
sort_gui_filt_popup_objects	*sort_gui_filt_popup;
sort_gui_spec_popup_objects	*sort_gui_spec_popup;
sort_gui_var_popup_objects	*sort_gui_var_popup;
sort_gui_window_popup_objects	*sort_gui_window_popup;
sort_gui_file_popup_objects	*sort_gui_file_popup;
sort_gui_tool_popup_objects	*sort_gui_tool_popup;

/* working space for odd and ends */
char tmp_str[BUFSIZ];  /* for tmp storage of strings */
char sbuf[BUFSIZ];     /* for tmp storage of strings */

/* I/O data */
int				DBX_val = 0;
Display				*dpy;
int                             noserver = SORT_TRUE;
int                             Sorting_data = SORT_FALSE;
int                             batch_mode = SORT_FALSE;
unsigned                        refresh_period;

#if NeedFunctionPrototype
pid_t                           sort_pid;
#else
int                             sort_pid;
#endif

Notify_client 	notify_client1 = (Notify_client) 10104;
Notify_client 	notify_client2 = (Notify_client) 10105;
Notify_client 	notify_client3 = (Notify_client) 10106;

#endif  /* SUNSORT_MAIN */

/* pointers to window data structures */
extern sort_gui_window1_objects		*sort_gui_window1;
extern sort_gui_filt_popup_objects	*sort_gui_filt_popup;
extern sort_gui_spec_popup_objects	*sort_gui_spec_popup;
extern sort_gui_var_popup_objects	*sort_gui_var_popup;
extern sort_gui_window_popup_objects	*sort_gui_window_popup;
extern sort_gui_file_popup_objects	*sort_gui_file_popup;
extern sort_gui_tool_popup_objects	*sort_gui_tool_popup;

extern char tmp_str[BUFSIZ];
extern char sbuf[BUFSIZ];

/*#define SUNSORT_DEBUG*/			/* control level of information output */
extern int		DBX_val;
extern Display          *dpy;
extern int              noserver;
extern int              Sorting_data;
extern int              batch_mode;
extern unsigned         refresh_period;
extern char             *sort_proc_name;

extern Notify_client 	notify_client1;
extern Notify_client 	notify_client2;
extern Notify_client 	notify_client3;

#if NeedFunctionPrototype
extern pid_t                           sort_pid;
#else
extern int                             sort_pid;
#endif

/* routines in read_spec.c */
#if NeedFunctionPrototype
extern int 		read_spectra_list(int bool);
#else
extern int 		read_spectra_list();
#endif

/* notifier routines */
#if NeedFunctionPrototype
extern Notify_value		graf_SIGINT_handler(Notify_client client, int sig, int mode);
extern Notify_value		graf_SIGUSR1_handler(Notify_client client, int sig, int mode);
extern Notify_value		graf_SIGUSR2_handler(Notify_client client, int sig, int mode);
extern Notify_value		graf_SIGPIPE_handler(Notify_client client, int sig, int mode);
extern void                     setup_intervaltimer(int bool);
#else
extern Notify_value		graf_SIGINT_handler();
extern Notify_value		graf_SIGUSR1_handler();
extern Notify_value		graf_SIGUSR2_handler();
extern Notify_value		graf_SIGPIPE_handler();
extern void                     setup_intervaltimer();
#endif

/* general miscellaneous routines */
#if NeedFunctionPrototype
extern char 			*rm_leading_blanks(char *string, int length);
extern void                     ring_bell(void);
extern char                     *my_realloc(char *ptr, int old_size, int new_size, int element_size);
extern void                     Button_Inactive(int opt);
extern Notify_value	        destroy_func(Notify_client client, Destroy_status status);
extern Notify_value	        read_note(Notify_client client, int fd);
extern int                      talk_to_server(int make_busy, ...);
#else
extern char 			*rm_leading_blanks();
extern void                     ring_bell();
extern char                     *my_realloc();
extern void                     Button_Inactive();
extern Notify_value	        destroy_func();
extern Notify_value	        read_note();
extern int                      talk_to_server();
#endif

/* notices in alerts.c */
#if NeedFunctionPrototype
extern int  yesno(Frame frame, char *msg, char *msgyes, char *msgno);
extern void errwin(Frame frame, char *msg);
#else
extern int  yesno();
extern void errwin();
#endif

#endif   /* endif ! SUNSORT_EXTERN_h */
