/*
 * files load/save popup
 * last mod     
 */

#include <stdio.h>
#include <string.h>
#include <errno.h>

#include <sys/stat.h>
#include <sys/param.h>
#include <sys/types.h>

#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/icon_load.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include <xview/xv_xrect.h>

#include "gui.h"
#include "gui_extern.h"
#include "sort_thread.h"

extern Xv_opaque
sort_gui_file_popup_file_popup_create(
#if NeedFunctionPrototype
				      Xv_opaque
#endif
				      );

extern Xv_opaque
sort_gui_file_popup_controls_files_create(
#if NeedFunctionPrototype
					  Xv_opaque
#endif
					  );

extern Xv_opaque
sort_gui_file_popup_file_list_create(
#if NeedFunctionPrototype
				     Xv_opaque
#endif
				     );

extern Xv_opaque
sort_gui_file_popup_file_message_create(
#if NeedFunctionPrototype
					Xv_opaque
#endif
					);

extern Xv_opaque
sort_gui_file_popup_file_but_create(
#if NeedFunctionPrototype
				    Xv_opaque
#endif
				    );
/*
 * Initialize an instance of object `load/save file_popup'.
 */
sort_gui_file_popup_objects *
sort_gui_file_popup_objects_initialize(
#if NeedFunctionPrototype
				       sort_gui_file_popup_objects	*ip,
				       Xv_opaque	owner)
#else
      ip, owner)
      sort_gui_file_popup_objects	*ip;
      Xv_opaque	owner;
#endif
{
	if (!ip && !(ip = (sort_gui_file_popup_objects *) calloc(1, sizeof (sort_gui_file_popup_objects))))
		return (sort_gui_file_popup_objects *) NULL;
	if (!ip->file_popup)
		ip->file_popup = sort_gui_file_popup_file_popup_create(owner);
	if (!ip->controls_files)
		ip->controls_files = sort_gui_file_popup_controls_files_create(ip->file_popup);
	if (!ip->file_list)
		ip->file_list = sort_gui_file_popup_file_list_create(ip->controls_files);
	if (!ip->file_message)
		ip->file_message = sort_gui_file_popup_file_message_create(ip->controls_files);
	if (!ip->file_but)
		ip->file_but = sort_gui_file_popup_file_but_create(ip->controls_files);
	return ip;
}

/*
 * Create object `file_popup' in the specified instance.

 */
Xv_opaque
sort_gui_file_popup_file_popup_create(
#if NeedFunctionPrototype
				      Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_WIDTH, 240,
		XV_HEIGHT, 416,
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, TRUE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}
/*
 * Create object `controls_files' in the specified instance.

 */
Xv_opaque
sort_gui_file_popup_controls_files_create(
#if NeedFunctionPrototype
					  Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `file_list' in the specified instance.

 */
Xv_opaque
sort_gui_file_popup_file_list_create(
#if NeedFunctionPrototype
				     Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_LIST,
		XV_X, 4,
		XV_Y, 4,
		PANEL_LIST_WIDTH, 206,
		XV_HEIGHT, 344,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_LIST_DISPLAY_ROWS, 18,
		PANEL_READ_ONLY, TRUE,
		PANEL_CHOOSE_ONE, FALSE,
		PANEL_CHOOSE_NONE, TRUE,
		NULL);

	return obj;
}

/*
 * Create object `file_message' in the specified instance.

 */
Xv_opaque
sort_gui_file_popup_file_message_create(
#if NeedFunctionPrototype
					Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_X, 4,
		XV_Y, 365,
		XV_WIDTH, 220,
		XV_HEIGHT, 13,
		PANEL_LABEL_STRING, "No directory specified",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `file_but' in the specified instance.

 */
Xv_opaque
sort_gui_file_popup_file_but_create(
#if NeedFunctionPrototype
				    Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
#if NeedFunctionPrototype
      extern void		file_but_nh(Panel_item, Event *);
#else

      extern void		file_but_nh();
#endif
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_X, 85,
		XV_Y, 390,
		XV_WIDTH, 70,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Perform",
		PANEL_NOTIFY_PROC, file_but_nh,
		NULL);
	return obj;
}
/************************* file popup **************************************************/
extern int		Query_Save_directory();
extern int              file_save_func();
extern int              file_load_func();
extern char             *formats[];
/************************* file popup **************************************************/
/*
 * Notify callback function for `file_but'.  	"Perform"
 */
void
file_but_nh(
#if NeedFunctionPrototype
	    Panel_item	item,
	    Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
      char			op_str[SMALL_SUNSORT_BUFFER];
      char			dir_str[MED_SUNSORT_BUFFER];
      struct dirs_IO_data	io_tmp;
      char			*string;
      register int		row;
      int                       fmt;

      if ( DBX_val >= 6) fputs("sort_gui: file_but_nh\n", stderr);

/* get information about the destination directory and LOAD/SAVE operation from popup */
      string = (char *) xv_get(sort_gui_file_popup->file_message,PANEL_LABEL_STRING);
      if (sscanf(string,"%s Dir: %s",op_str,dir_str) != 2) {
	    fprintf(stderr,"sort_gui: error decoding string %s\n",string);
	    return;
      }

/* determine what format the disc files are (will be) in */
      fmt = (int) xv_get(sort_gui_window1->dirs_setting1,PANEL_VALUE);
      string = formats[fmt];
	
/* check that items have been selected by getting the first */
      row = (int) xv_get(sort_gui_file_popup->file_list,PANEL_LIST_FIRST_SELECTED);	
      if (row == -1) {
	    if (DBX_val >= 2)
		  fprintf(stderr,"sort_gui: no item selected from list\n");
	    errwin(sort_gui_file_popup->file_popup,"no item selected from list");
	    return;
      } 

/* start load/save operations */
      if ( strncmp(op_str,"Load",4) == 0) {		/* LOAD */
	    if ( xv_get(sort_gui_window1->dirs_setting2,PANEL_VALUE) == 0x1) 
		  fmt = LOAD_N_ADD;
	    else
		  fmt = 0;
	    sprintf(tmp_str,"load selected %s %s %d",dir_str,string, fmt);
/* communicate to sort server */
	    if (talk_to_server(FALSE,tmp_str,NULL) != 0)
		  return;
	    Make_all_busy(TRUE);
	    (void) file_load_func(row);
      }
      else if ( strncmp(op_str,"Save",4) == 0) {	/* SAVE */
	    strcpy(io_tmp.save_dir,dir_str);
	    io_tmp.IO_state = 0;
/* check whether dirctory exits and set over write mode */
	    if (Query_Save_directory(&io_tmp,sort_gui_file_popup->file_popup)) {
		  return;
	    }
	    fmt = io_tmp.IO_state & OVER_WRITE ? 1:0;
	    sprintf(tmp_str,"save selected %s %s %d",dir_str,string,fmt);   
/* communicate to sort server */
	    if (talk_to_server(FALSE,tmp_str,NULL) != 0)
		  return;
	    Make_all_busy(TRUE);
	    (void) file_save_func();
      }
/* communicate to sort server */
      sprintf(tmp_str,"\n");
      (void) talk_to_server(FALSE,tmp_str,NULL);
      Make_all_busy(FALSE);
      return;
}

/***********************************************************************************************/
static char *spec_class[] = { "1D", "2D", (char *)0};
int
file_save_func(
#if NeedFunctionPrototype
	    void
#endif
	       )
{
      char			*string;
      char                      **ptr;
      int			nos;
      register int              row;
      char			type[3];
      char			name[NAME_SIZE];

      for(ptr=spec_class; *ptr != NULL; ptr++) {
	    row = (int) xv_get(sort_gui_file_popup->file_list,PANEL_LIST_FIRST_SELECTED);	
	    strcpy(tmp_str,*ptr);
	    do {
/* get pointer to list item string*/
		  string = (char *) xv_get(sort_gui_file_popup->file_list,
					   PANEL_LIST_STRING,row,NIL,NULL);
/* decode string from list entry */
		  if ( sscanf(string,"%s %d %s",type,&nos,name) != 3) continue;
		  if ( strncmp(type,*ptr,2) == 0) {
			sprintf(sbuf," %d",nos);
			if (strlen(tmp_str)+strlen(sbuf) < BUFSIZ) {
			      strcat(tmp_str,sbuf);
			}
			else {
/* communicate to sort server */
			      if (talk_to_server(FALSE,tmp_str,"\n",NULL) != 0) {
				    return(SORT_FAIL);
			      }
			      sprintf(tmp_str,*ptr);
			}
			if ( DBX_val >= 6) fprintf(stderr,"sort_gui: save operation on %s, row %d\n",string,row);
		  }
	    } while ( (row = (int) xv_get(sort_gui_file_popup->file_list,PANEL_LIST_NEXT_SELECTED,row)) != -1);
/* communicate to sort server */
	    if (talk_to_server(FALSE,tmp_str,NULL) != 0)
		  return(SORT_FAIL);      }
      return(0);
}

int
file_load_func(
#if NeedFunctionPrototype
	       register int row)
#else
      row)
      register int row;
#endif
{
      char	  *string;

      do {
/* get pointer to list item string*/
	    string = (char *) xv_get(sort_gui_file_popup->file_list,
				     PANEL_LIST_STRING,row,NIL,NULL);
	    if ( DBX_val >= 6) fprintf(stderr,
				       "sort_gui: load operation on %s, row %d\n",string,row);
/* communicate to sort server */
	    if (talk_to_server(FALSE,string,NULL) != 0) {
		  Make_all_busy(FALSE);
		  return(SORT_FAIL);
	    }
      } while ( (row = (int) xv_get(sort_gui_file_popup->file_list,PANEL_LIST_NEXT_SELECTED,row)) != -1);
      return(0);
}

/***********************************************************************************************/
/*
 * Function to update scrolling list for file_popup_list
 */
void
write_to_file_popup_list(
#if NeedFunctionPrototype
			 char	*string) 
#else
      string)
      char	*string;
#endif
{
	static int		nos;
	
/* erase current list if string is null */
	if (string == NIL) {
		xv_set(sort_gui_file_popup->file_list,PANEL_LIST_DELETE_ROWS,0,nos,NULL);
		nos = 0;
		return;
	}

/* otherwise add new item to list */
	xv_set(sort_gui_file_popup->file_list,	PANEL_LIST_INSERT,	nos,
						PANEL_LIST_STRING,	nos, string,
						NULL);
	nos++;

	return;
}

/***********************************************************************************************/
