/*
 * This file was generated by `gxv' from `sort_gui.G'.
 * last mod 27/3/95
 * last mod by spgc 6 Aug 96
 */

#include <stdio.h>

#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/icon_load.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include <xview/xv_xrect.h>

#ifdef SVR4
#include <unistd.h>
#define NeedFunctionPrototype 1
#else
#define NeedFunctionPrototype 0
#endif

#include "gui_extern.h"
#include "sort_thread.h"

extern Xv_opaque
sort_gui_filt_popup_filt_create(
#if NeedFunctionPrototype
				Xv_opaque
#endif
				);

extern Xv_opaque
sort_gui_filt_popup_control_filt_create(
#if NeedFunctionPrototype

				     Xv_opaque		     
#endif
				     );

extern Xv_opaque
sort_gui_filt_popup_filt_setting1_create(
#if NeedFunctionPrototype
				      Xv_opaque
#endif
				      );

extern Xv_opaque
sort_gui_filt_popup_filt_setting2_create(
#if NeedFunctionPrototype
				      Xv_opaque
#endif
				      );

extern Xv_opaque
sort_gui_filt_popup_filt_tf1_create(
#if NeedFunctionPrototype
				 Xv_opaque
#endif
				 );

extern Xv_opaque
sort_gui_filt_popup_filt_tf2_create(
#if NeedFunctionPrototype
				 Xv_opaque
#endif
				 );

extern Xv_opaque
sort_gui_filt_popup_filt_b1_create(
#if NeedFunctionPrototype
				Xv_opaque
#endif
				);

extern Xv_opaque
sort_gui_filt_popup_filt_b2_create(
#if NeedFunctionPrototype
				Xv_opaque
#endif
				);

extern Xv_opaque
sort_gui_filt_popup_filt_b3_create(
#if NeedFunctionPrototype
				Xv_opaque
#endif
				);

extern Xv_opaque
sort_gui_filt_popup_filt_message_create(
#if NeedFunctionPrototype
				     Xv_opaque
#endif
				     );
/*
 * Initialize an instance of object `filt_popup'.
 */
sort_gui_filt_popup_objects *
sort_gui_filt_popup_objects_initialize(
#if NeedFunctionPrototype
	sort_gui_filt_popup_objects    *ip,
	Xv_opaque		    owner)
#else
      ip, owner)
	sort_gui_filt_popup_objects    *ip;
	Xv_opaque	            owner;
#endif
{
	if (!ip && !(ip = (sort_gui_filt_popup_objects *) calloc(1, sizeof (sort_gui_filt_popup_objects))))
		return (sort_gui_filt_popup_objects *) NULL;
	if (!ip->filt_popup)
		ip->filt_popup = sort_gui_filt_popup_filt_create(owner);
	if (!ip->control_filt)
		ip->control_filt = sort_gui_filt_popup_control_filt_create(ip->filt_popup);
	if (!ip->filt_setting1)
		ip->filt_setting1 = sort_gui_filt_popup_filt_setting1_create(ip->control_filt);
	if (!ip->filt_setting2)
		ip->filt_setting2 = sort_gui_filt_popup_filt_setting2_create(ip->control_filt);
	if (!ip->filt_tf1)
		ip->filt_tf1 = sort_gui_filt_popup_filt_tf1_create(ip->control_filt);
	if (!ip->filt_tf2)
		ip->filt_tf2 = sort_gui_filt_popup_filt_tf2_create(ip->control_filt);
	if (!ip->filt_b1)
		ip->filt_b1 = sort_gui_filt_popup_filt_b1_create(ip->control_filt);
	if (!ip->filt_b2)
		ip->filt_b2 = sort_gui_filt_popup_filt_b2_create(ip->control_filt);
	if (!ip->filt_b3)
		ip->filt_b3 = sort_gui_filt_popup_filt_b3_create(ip->control_filt);
	if (!ip->filt_message)
		ip->filt_message = sort_gui_filt_popup_filt_message_create(ip->control_filt);
	return ip;
}

/*
 * Create object `filt_popup' in the specified instance.
 */
Xv_opaque
sort_gui_filt_popup_filt_create(
#if NeedFunctionPrototype
				      Xv_opaque	owner)   
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	Xv_opaque		window1_image;
	Xv_opaque		mask_image;
	static unsigned short	window1_bits[] = {
/* an icon */
#include "./icons/write.icon"
	};
/* and an icon mask */
        static unsigned short mask_bits[] = {
#include "./icons/write_mask.icon"
        };

	window1_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_BITS, window1_bits,
		SERVER_IMAGE_DEPTH, 1,
		XV_WIDTH, 64,
		XV_HEIGHT, 64,
		NULL);
	mask_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_BITS, mask_bits,
		XV_WIDTH, 64,
		XV_HEIGHT, 64,
		NULL);		
	obj = xv_create(owner, FRAME,
		XV_WIDTH, 375,
		XV_HEIGHT, 250,
		XV_LABEL, "SunSort Filtering",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
			FRAME_ICON, xv_create(XV_NULL, ICON,
					      ICON_IMAGE, window1_image,
			ICON_MASK_IMAGE, mask_image, 
			ICON_TRANSPARENT, TRUE, 
					      NULL),
		NULL);
	return obj;
}

/*
 * Create object `control_filt' in the specified instance.
 */
Xv_opaque
sort_gui_filt_popup_control_filt_create(
#if NeedFunctionPrototype
					Xv_opaque owner)	
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}


/*
 * Create object `filt_setting1' in the specified instance.
 */
Xv_opaque
sort_gui_filt_popup_filt_setting1_create(
#if NeedFunctionPrototype
	Xv_opaque	        owner)
#else
				owner)
	Xv_opaque	        owner;
#endif
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE,
		XV_X, 16,
		XV_Y, 20,
		XV_WIDTH, 252,
		XV_HEIGHT, 23,
		PANEL_VALUE_X, 100,
		PANEL_VALUE_Y, 20,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_NCOLS, 3,
		PANEL_VALUE, 0x1,
		PANEL_LABEL_STRING, "Write Media:",
		PANEL_CHOICE_STRINGS,
			"Exabyte",
			"Disk",
			0,
		NULL);
	return obj;
}

/*
 * Create object `filt_setting2' in the specified instance.
 */
Xv_opaque
sort_gui_filt_popup_filt_setting2_create(
#if NeedFunctionPrototype
	Xv_opaque	        owner)
#else
				owner)
	Xv_opaque	        owner;
#endif					      
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE,
		XV_X, 250,
		XV_Y, 20,
		XV_WIDTH, 89,
		XV_HEIGHT, 69,
		PANEL_VALUE_X, 250,
		PANEL_VALUE_Y, 35,
		PANEL_LAYOUT, PANEL_VERTICAL,
		PANEL_CHOICE_NCOLS, 2,
		PANEL_LABEL_STRING, "Drive:",
		PANEL_CHOICE_STRINGS,
			"rst0",
			"rst1",
			"rst2",
			"rst3",
			"rst4",
			"rst5",
			0,
		NULL);
	return obj;
}

  
/*
 * Create object `filt_tf1' in the specified instance.
 */
Xv_opaque
sort_gui_filt_popup_filt_tf1_create(
#if NeedFunctionPrototype
	Xv_opaque	        owner)
#else
				owner)
	Xv_opaque	        owner;
#endif					 
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_X, 16,
		XV_Y, 110,
		XV_WIDTH, 320,
		XV_HEIGHT, 15,
		PANEL_LABEL_STRING, "Write file",
		PANEL_VALUE_X, 80,
		PANEL_VALUE_Y, 110,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE_DISPLAY_LENGTH, 32,
		PANEL_VALUE_STORED_LENGTH, 132,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `filt_tf2' in the specified instance.
 */
Xv_opaque
sort_gui_filt_popup_filt_tf2_create(
#if NeedFunctionPrototype
	Xv_opaque	        owner)
#else
				owner)
	Xv_opaque	        owner;
#endif						 
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_X, 16,
		XV_Y, 155,
		XV_WIDTH, 320,
		XV_HEIGHT, 15,
		PANEL_LABEL_STRING, "Write Vol",
		PANEL_VALUE_X, 80,
		PANEL_VALUE_Y, 155,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE_DISPLAY_LENGTH, 32,
		PANEL_VALUE_STORED_LENGTH, 132,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

  
/*
 * Create object `filt_b1' in the specified instance.
 */
Xv_opaque
sort_gui_filt_popup_filt_b1_create(
#if NeedFunctionPrototype
	Xv_opaque	        owner)
#else
				owner)
	Xv_opaque	        owner;
#endif					
{
#if NeedFunctionPrototype
      extern void		filt_b1_nh(Panel_item, Event *);
#else
      extern void		filt_b1_nh();
#endif
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_X, 50,
		XV_Y, 200,
		PANEL_LABEL_WIDTH, 50,
		XV_WIDTH, 50,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Open",
		PANEL_NOTIFY_PROC, filt_b1_nh,
		NULL);
	return obj;
}

/*
 * Create object `filt_b2' in the specified instance.
 */
Xv_opaque
sort_gui_filt_popup_filt_b2_create(
#if NeedFunctionPrototype
	Xv_opaque	        owner)
#else
				owner)
	Xv_opaque	        owner;
#endif				
{
#if NeedFunctionPrototype
      extern void		filt_b2_nh(Panel_item, Event *);
#else
      extern void		filt_b2_nh();
#endif
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_X, 150,
		XV_Y, 200,
		PANEL_LABEL_WIDTH, 50,
		PANEL_INACTIVE, FALSE,
		XV_WIDTH, 50,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Mount",
		PANEL_NOTIFY_PROC, filt_b2_nh,
		NULL);
	return obj;
}

/*
 * Create object `filt_b3' in the specified instance.
 */
Xv_opaque
sort_gui_filt_popup_filt_b3_create(
#if NeedFunctionPrototype
	Xv_opaque	        owner)
#else
				owner)
	Xv_opaque	        owner;
#endif				
{
#if NeedFunctionPrototype
      extern void		filt_b3_nh(Panel_item, Event *);
#else
      extern void		filt_b3_nh();
#endif
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_X, 250,
		XV_Y, 200,
		PANEL_LABEL_WIDTH, 50,
		PANEL_INACTIVE, FALSE,
		XV_WIDTH, 50,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "NewVol",
		PANEL_NOTIFY_PROC, filt_b3_nh,
		NULL);
	return obj;
}

/*
 * Create object `filt_message' in the specified instance.
 */
Xv_opaque
sort_gui_filt_popup_filt_message_create(
#if NeedFunctionPrototype
	Xv_opaque	        owner)
#else
				owner)
	Xv_opaque	        owner;
#endif						     
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_X, 16,
		XV_Y, 235,
		XV_WIDTH, 38,
		XV_HEIGHT, 13,
		PANEL_LABEL_STRING, "State:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*****************************************************************************************************/
int
open_write_file(
#if NeedFunctionPrototype
		struct sort_IO_data *ptr)
#else
				ptr)
      struct sort_IO_data *ptr;
#endif
{
      char 	*write_file;
      char	*write_vol;
      int       write_media;
      int	write_drive = 0;
      unsigned  IO_state = 0;

      
/*	get data from screen to perform open command */
      write_file = (char *) xv_get(sort_gui_filt_popup->filt_tf1,PANEL_VALUE);
      write_file = rm_leading_blanks(write_file,MED_SUNSORT_BUFFER);
      if (strlen(write_file) == 0) {
	    errwin(sort_gui_window1->window1,"No write sort file specified");
	    return(SORT_FALSE);
      }
      write_media = (int) xv_get(sort_gui_filt_popup->filt_setting1,PANEL_VALUE);
      if (write_media == 1) write_media++;   /* DISK_DATA == 2 */
      
      if ( DBX_val >= 6) {
	    fprintf(stderr,"sort_gui: media vaue = %d\n",write_media);
      }
      
/*	open sort file connection for writing data*/
      switch (write_media) {
/*	if exabyte chosen as sort media get details on the drive and volume name */
	  case EXABYTE_DATA:
	    if ( ! (ptr->IO_state & W_TAPE_MOUNTED)) {
		  errwin(sort_gui_window1->window1,"No tape volume mounted!");
		  return(SORT_FALSE);
	    }
	    strcpy(sbuf,"Tape write file open : ");
	    strncat(sbuf,write_file,MED_SUNSORT_BUFFER - strlen(sbuf) -1);
	    strcpy(tmp_str,"wopen tape ");
	    break;
	    
	  case DISK_DATA:
	    strcpy(sbuf,"Disk write file open : ");
	    strncat(sbuf,write_file,MED_SUNSORT_BUFFER - strlen(sbuf) -1);
	    strcpy(tmp_str,"wopen disk ");
	    break;
	    
	  default:
	    if (DBX_val >= 2)
		  fprintf(stderr,"sort_gui: Sunsort failed to establish media on OPEN...seek help\n");
	    errwin(sort_gui_window1->window1,"failed to establish media on open");
	    return(SORT_FALSE);
	}
      
/*      communicate with sort server	*/
	    if (DBX_val >= 2) fprintf(stderr,"sort_gui: %s %s\n",tmp_str,write_file);
	    if (talk_to_server(TRUE,tmp_str,write_file,NULL) != 0)
		  return(SORT_FALSE);


/* deactivate certain control panel elements */
	xv_set(sort_gui_filt_popup->filt_setting1,PANEL_INACTIVE,TRUE,NULL); 
	
/* write out message declaring current sort file state */
	xv_set(sort_gui_filt_popup->filt_message,PANEL_LABEL_STRING,sbuf,NULL);

      return(SORT_TRUE);
}
/*****************************************************************************************************/
int
close_write_file(
#if NeedFunctionPrototype
		struct sort_IO_data *ptr)
#else
				ptr)
      struct sort_IO_data *ptr;
#endif
{
/*      communicate with sort server	*/
      if (DBX_val >= 6) fprintf(stderr,"sort_gui: close write file");
      if (talk_to_server(TRUE,"wclose",NULL) != 0)
	    return(SORT_FALSE);
      
/* activate certain control panel elements */
	xv_set(sort_gui_filt_popup->filt_setting1,PANEL_INACTIVE,FALSE,NULL); 
      
/* write out message declaring current sort file state */
      xv_set(sort_gui_filt_popup->filt_message,PANEL_LABEL_STRING,"State:",NULL);

      return(SORT_TRUE);
}
/*****************************************************************************************************/
int
mount_write_tape(
#if NeedFunctionPrototype
		struct sort_IO_data *ptr)
#else
				ptr)
      struct sort_IO_data *ptr;
#endif
{
      int     write_drive;
      char    *write_vol;

      write_drive = (int) xv_get(sort_gui_filt_popup->filt_setting2,PANEL_VALUE);
      write_vol = (char *) xv_get(sort_gui_filt_popup->filt_tf2,PANEL_VALUE);

      if (strlen(write_vol) == 0) {
	    if (DBX_val >= 2)
		  fprintf(stderr,"sort_gui: no tape volume specified\n");
	    errwin(sort_gui_window1->window1,"no tape volume specified");
	    return(SORT_FALSE);
      }
/* check that Charles hasn't left the name of his last disk file in the text fields */
      if ( strchr(write_vol,'/') != NULL ) {
	    if (DBX_val >= 2)
		  fprintf(stderr,"sort_gui: unexpected write volume name %s for exabyte\n",write_vol);
	    errwin(sort_gui_window1->window1,"unexpected write volume name for exabyte");
	    return(SORT_FALSE);
      }
      write_vol = rm_leading_blanks(write_vol,MED_SUNSORT_BUFFER);
      if ( DBX_val >= 6) fprintf(stderr,
				       "write volume << %s >>\nexabyte drive rst%d\n",write_vol,write_drive);
/* check that user really wants to do this */	    
      sprintf(tmp_str,"mount tape volume %s on drive %d ?",write_vol,write_drive);
      switch( yesno(sort_gui_filt_popup->filt_popup,tmp_str,"yes","no")) {
	  case SORT_FALSE:
	    return(SORT_FALSE);
	  case SORT_TRUE:		
	    default:
	    break;
      }

      sprintf(tmp_str," %s %d ",write_vol,write_drive);
	    
/* communicate with sort server */
      if (talk_to_server(TRUE,"tapemount",tmp_str," w",NULL) != 0)
	    return(SORT_FALSE);
      
      xv_set(sort_gui_filt_popup->filt_b3, PANEL_INACTIVE, TRUE, NULL);
      xv_set(sort_gui_filt_popup->filt_tf2, PANEL_INACTIVE, TRUE, NULL);
      xv_set(sort_gui_filt_popup->filt_setting2 ,PANEL_INACTIVE, TRUE, NULL);
      
      return(SORT_TRUE);
}
/*****************************************************************************************************/

int
umount_write_tape(
#if NeedFunctionPrototype
		struct sort_IO_data *ptr)
#else
				ptr)
      struct sort_IO_data *ptr;
#endif
{
      if (ptr->IO_state & WRITING_TAPE) {
	    if (DBX_val >= 2)
		  fprintf(stderr,"sort_gui: tape write file still open\n");
	    errwin(sort_gui_window1->window1,"exabyte write file still open");
	    return(SORT_FALSE);
      }
	
/* communicate with sort server */
      if (talk_to_server(TRUE,"tapeumount w",NULL) != 0)
	    return(SORT_FALSE);
	    
      xv_set(sort_gui_filt_popup->filt_b3, PANEL_INACTIVE, FALSE, NULL);
      xv_set(sort_gui_filt_popup->filt_tf2, PANEL_INACTIVE, FALSE, NULL);
      xv_set(sort_gui_filt_popup->filt_setting2 ,PANEL_INACTIVE, FALSE, NULL);
      
      return(SORT_TRUE);
}
/*****************************************************************************************************/
int
label_write_tape(
#if NeedFunctionPrototype
		struct sort_IO_data *ptr)
#else
				ptr)
      struct sort_IO_data *ptr;
#endif
{
      int     write_drive;
      char    *write_vol;

      write_drive = (int) xv_get(sort_gui_filt_popup->filt_setting2,PANEL_VALUE);
      write_vol = (char *) xv_get(sort_gui_filt_popup->filt_tf2,PANEL_VALUE);

      if (strlen(write_vol) == 0) {
	    if (DBX_val >= 2)
		  fprintf(stderr,"sort_gui: no tape volume specified\n");
	    errwin(sort_gui_window1->window1,"no tape volume specified");
	    return(SORT_FALSE);
      }
/* check that Charles hasn't left the name of his last disk file in the text fields */
      if ( strchr(write_vol,'/') != NULL ) {
	    if (DBX_val >= 2)
		  fprintf(stderr,"sort_gui: unexpected write volume name %s for exabyte\n",write_vol);
	    errwin(sort_gui_window1->window1,"unexpected write volume name for exabyte");
	    return(SORT_FALSE);
      }
      write_vol = rm_leading_blanks(write_vol,MED_SUNSORT_BUFFER);
      if ( DBX_val >= 6) fprintf(stderr,
				       "write volume << %s >>\nexabyte drive rst%d\n",write_vol,write_drive);

/* check that user really wants to do this */	    
      sprintf(tmp_str,"label tape as %s on drive %d ?",write_vol,write_drive);
      switch( yesno(sort_gui_filt_popup->filt_popup,tmp_str,"yes","no")) {
	  case SORT_FALSE:
	    return(SORT_FALSE);
	  case SORT_TRUE:		
	    default:
	    break;
      }
	
      sprintf(tmp_str," %s %d ",write_vol,write_drive);
	    
/* communicate with sort server */
      if (talk_to_server(TRUE,"newtape",tmp_str,NULL) != 0)
	    return(SORT_FALSE);
      
      xv_set(sort_gui_filt_popup->filt_b3, PANEL_INACTIVE, TRUE, NULL);
      xv_set(sort_gui_filt_popup->filt_tf2, PANEL_INACTIVE, TRUE, NULL);
      xv_set(sort_gui_filt_popup->filt_setting2 ,PANEL_INACTIVE, TRUE, NULL);

      return(SORT_TRUE);
}
/*****************************************************************************************************/
