/*
 *  sorttool pop up
 *  last modified by spgc 11/1/97
 *
 */

#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <stdlib.h>
#include <alloca.h>
#include <errno.h>

#include <sys/stat.h>
#include <sys/param.h>
#include <sys/types.h>

#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/icon_load.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include <xview/xv_xrect.h>

#include "gui_extern.h"
#include "gui.h"
#include "version.h"
#include "../sunsort_lib/formats.h"

extern Xv_opaque
sort_gui_tool_popup_create(
#if NeedFunctionPrototype
				Xv_opaque
#endif
				);

extern Xv_opaque
sort_gui_tool_popup_control_create(
#if NeedFunctionPrototype

				     Xv_opaque		     
#endif
				     );

extern Xv_opaque
sort_gui_tool_popup_tf1_create(
#if NeedFunctionPrototype
				 Xv_opaque
#endif
				 );

extern Xv_opaque
sort_gui_tool_popup_tf2_create(
#if NeedFunctionPrototype
				 Xv_opaque
#endif
				 );

extern Xv_opaque
sort_gui_tool_popup_tf3_create(
#if NeedFunctionPrototype
				 Xv_opaque
#endif
				 );

extern Xv_opaque
sort_gui_tool_popup_tf4_create(
#if NeedFunctionPrototype
				 Xv_opaque
#endif
				 );

extern Xv_opaque
sort_gui_tool_popup_tf5_create(
#if NeedFunctionPrototype
				 Xv_opaque
#endif
				 );
extern Xv_opaque
sort_gui_tool_popup_b1_create(
#if NeedFunctionPrototype
				 Xv_opaque
#endif
				 );
extern Xv_opaque
sort_gui_tool_popup_b2_create(
#if NeedFunctionPrototype
				   Xv_opaque
#endif
				   );

extern Xv_opaque
sort_gui_tool_popup_b3_create(
#if NeedFunctionPrototype
				   Xv_opaque
#endif
				   );

extern Xv_opaque
sort_gui_tool_popup_b4_create(
#if NeedFunctionPrototype
				   Xv_opaque
#endif
				   );

extern Xv_opaque
sort_gui_tool_popup_b5_create(
#if NeedFunctionPrototype
				   Xv_opaque
#endif
				   );

extern Xv_opaque
sort_gui_tool_popup_b6_create(
#if NeedFunctionPrototype
				   Xv_opaque
#endif
				   );

extern Xv_opaque
sort_gui_tool_popup_setting1_create(
#if NeedFunctionPrototype
					 Xv_opaque
#endif
					 );

extern Xv_opaque
sort_gui_tool_popup_setting2_create(
#if NeedFunctionPrototype
					 Xv_opaque
#endif
					 );

extern Xv_opaque
sort_gui_tool_popup_setting3_create(
#if NeedFunctionPrototype
					 Xv_opaque
#endif
					 );

extern Xv_opaque
sort_gui_tool_popup_setting4_create(
#if NeedFunctionPrototype
					 Xv_opaque
#endif
					 );
extern Xv_opaque
sort_gui_tool_popup_setting5_create(
#if NeedFunctionPrototype
					 Xv_opaque
#endif
					 );
extern Xv_opaque
sort_gui_tool_popup_setting6_create(
#if NeedFunctionPrototype
					 Xv_opaque
#endif
					 );

extern Xv_opaque
sort_gui_tool_popup_setting7_create(
#if NeedFunctionPrototype
					 Xv_opaque
#endif
					 );

/*
 * Initialize an instance of object `tool_popup'.
 */
sort_gui_tool_popup_objects *
sort_gui_tool_popup_objects_initialize
#if NeedFunctionPrototype
 (sort_gui_tool_popup_objects	*ip,
  Xv_opaque	owner)     
#else
    (ip, owner)
    sort_gui_tool_popup_objects	*ip;
    Xv_opaque	owner;
#endif
{
    if (!ip &&
	!(ip = (sort_gui_tool_popup_objects *)
	  calloc(1, sizeof (sort_gui_tool_popup_objects))))
	return (sort_gui_tool_popup_objects *) NULL;
    if (!ip->tool_popup)
	ip->tool_popup = sort_gui_tool_popup_create(owner);
    if (!ip->control_tool)
	ip->control_tool = sort_gui_tool_popup_control_create(ip->tool_popup);
    if (!ip->tool_tf1)
	ip->tool_tf1 = sort_gui_tool_popup_tf1_create(ip->control_tool);
    if (!ip->tool_tf2)
	ip->tool_tf2 = sort_gui_tool_popup_tf2_create(ip->control_tool);
    if (!ip->tool_tf3)
	ip->tool_tf3 = sort_gui_tool_popup_tf3_create(ip->control_tool);
    if (!ip->tool_tf4)
	ip->tool_tf4 = sort_gui_tool_popup_tf4_create(ip->control_tool);
    if (!ip->tool_tf5)
	ip->tool_tf5 = sort_gui_tool_popup_tf5_create(ip->control_tool);
    if (!ip->tool_b1)
	ip->tool_b1 = sort_gui_tool_popup_b1_create(ip->control_tool);
    if (!ip->tool_b2)
	ip->tool_b2 = sort_gui_tool_popup_b2_create(ip->control_tool);
    if (!ip->tool_b3)
	ip->tool_b3 = sort_gui_tool_popup_b3_create(ip->control_tool);
    if (!ip->tool_b4)
	ip->tool_b4 = sort_gui_tool_popup_b4_create(ip->control_tool);
    if (!ip->tool_b5)
	ip->tool_b5 = sort_gui_tool_popup_b5_create(ip->control_tool);
    if (!ip->tool_b6)
	ip->tool_b6 = sort_gui_tool_popup_b6_create(ip->control_tool);
    if (!ip->tool_setting1)
	ip->tool_setting1 =
	    sort_gui_tool_popup_setting1_create(ip->control_tool);
    if (!ip->tool_setting2)
	ip->tool_setting2 =
	    sort_gui_tool_popup_setting2_create(ip->control_tool);
    if (!ip->tool_setting3)
	ip->tool_setting3 =
	    sort_gui_tool_popup_setting3_create(ip->control_tool);
    if (!ip->tool_setting4)
	ip->tool_setting4 =
	    sort_gui_tool_popup_setting4_create(ip->control_tool);
    if (!ip->tool_setting5)
	ip->tool_setting5 =
	    sort_gui_tool_popup_setting5_create(ip->control_tool);
    if (!ip->tool_setting6)
	ip->tool_setting6 =
	    sort_gui_tool_popup_setting6_create(ip->control_tool);
    if (!ip->tool_setting7)
	ip->tool_setting7 =
	    sort_gui_tool_popup_setting7_create(ip->control_tool);
	
    return ip;
}

/*
 * Create object `tool_popup' in the specified instance.
 */
Xv_opaque
sort_gui_tool_popup_create(
#if NeedFunctionPrototype
				      Xv_opaque	owner)   
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	Xv_opaque		window1_image;
	Xv_opaque		mask_image;
/* an icon */
	static unsigned short	window1_bits[] = {
#include "./icons/sorttool.icon"
	};
/* and an icon mask */
        static unsigned short mask_bits[] = {
#include "./icons/sorttool_mask.icon"
        };

	window1_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_BITS, window1_bits,
		SERVER_IMAGE_DEPTH, 1,
		XV_WIDTH, 64,
		XV_HEIGHT, 64,
		NULL);
	mask_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_BITS, mask_bits,
		XV_WIDTH, 64,
		XV_HEIGHT, 64,
		NULL);
	obj = xv_create(owner, FRAME,
		XV_WIDTH, 413,
		XV_HEIGHT, 390,
		XV_LABEL, "SunSort tool",
		XV_SHOW, TRUE,
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_RIGHT_FOOTER, "Version " VERSION,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CLOSED, TRUE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_ICON, xv_create(XV_NULL, ICON,
			ICON_IMAGE, window1_image,
			ICON_MASK_IMAGE, mask_image, 
			ICON_TRANSPARENT, TRUE, 
			NULL),
		NULL);

	return obj;
}

/*
 * Create object `control_tool' in the specified instance.
 */
Xv_opaque
sort_gui_tool_popup_control_create(
#if NeedFunctionPrototype
					Xv_opaque owner)	
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}

/*
* Create object `textfield1' in the specified instance.
*/
Xv_opaque
sort_gui_tool_popup_tf1_create(
#if NeedFunctionPrototype
				     Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_X, 25,
		XV_Y, 25,
		PANEL_VALUE_DISPLAY_LENGTH, 30,
		PANEL_VALUE_STORED_LENGTH, 128,
		PANEL_LABEL_STRING, "Sort file:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}


/*
* Create object `button1' in the specified instance.  EDIT SORT FILE
*/
Xv_opaque
sort_gui_tool_popup_b1_create(
#if NeedFunctionPrototype
				     Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	
#if NeedFunctionPrototype
      extern void		tool_b1_nh(Panel_item, Event *); 
#else
      extern void		tool_b1_nh();
#endif
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_X, 340,
		XV_Y, 25,
		PANEL_LABEL_WIDTH, 40,
		PANEL_NOTIFY_PROC, tool_b1_nh,		
		PANEL_LABEL_STRING, "Edit",
		NULL);
	return obj;
}

/*
* Create object `setting1' in the specified instance.
*/
Xv_opaque
sort_gui_tool_popup_setting1_create(
#if NeedFunctionPrototype
				     Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	
#if NeedFunctionPrototype
      extern int		tool_setting1_nh(Panel_item, int, Event *); 
#else
      extern int		tool_setting1_nh();
#endif
	
	obj = xv_create(owner, PANEL_CHOICE,
		XV_X, 170,
		XV_Y, 75,
		PANEL_CHOICE_NROWS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOOSE_NONE, FALSE,
		PANEL_NOTIFY_PROC, tool_setting1_nh,
		PANEL_LABEL_STRING, "Editor:",
		PANEL_CHOICE_STRINGS,
			"textedit",
			"other",
			NULL,
		NULL);
	return obj;
}

/*
* Create object `textfield2' in the specified instance.
*/
Xv_opaque
sort_gui_tool_popup_tf2_create(
#if NeedFunctionPrototype
				     Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_X, 172,
		XV_Y, 105,
		PANEL_VALUE_DISPLAY_LENGTH, 27,
		PANEL_VALUE_STORED_LENGTH, 128,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE, "xemacs",
		XV_SHOW, FALSE, 
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
* Create object `textfield3' in the specified instance.
*/
Xv_opaque
sort_gui_tool_popup_tf3_create(
#if NeedFunctionPrototype
				     Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_X, 25,
		XV_Y, 140,
		PANEL_VALUE_DISPLAY_LENGTH, 37,
		PANEL_VALUE_STORED_LENGTH, 128,
		PANEL_LABEL_STRING, "Sort proc:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		XV_SHOW, TRUE,
		PANEL_READ_ONLY, FALSE,
		NULL);

	if (sort_proc_name != NULL)
	     xv_set(obj, PANEL_VALUE, sort_proc_name, NULL);
	else
	      xv_set(obj, PANEL_VALUE, "sunsort_proc", NULL);

	return obj;
}

/*
* Create object `button2' in the specified instance.
*/
Xv_opaque
sort_gui_tool_popup_b2_create(
#if NeedFunctionPrototype
				     Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
#if NeedFunctionPrototype
      extern void		tool_b2_nh(Panel_item, Event *); 
#else
      extern void		tool_b2_nh();
#endif
	obj = xv_create(owner, PANEL_BUTTON,
		XV_X, 20,
		XV_Y, 180,
		PANEL_NOTIFY_PROC, tool_b2_nh,		
		PANEL_LABEL_WIDTH, 40,
		PANEL_LABEL_STRING, "Make",
		NULL);
	return obj;
}

/*
* Create object `button3' in the specified instance.
*/
Xv_opaque
sort_gui_tool_popup_b3_create(
#if NeedFunctionPrototype
				     Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
#if NeedFunctionPrototype
      extern void		tool_b3_nh(Panel_item, Event *); 
#else
      extern void		tool_b3_nh();
#endif	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_X, 90,
		XV_Y, 180,
		PANEL_LABEL_WIDTH, 40,
		PANEL_NOTIFY_PROC, tool_b3_nh,		
		PANEL_LABEL_STRING, "Load",
		NULL);
	return obj;
}

/*
* Create object `button4' in the specified instance.
*/
Xv_opaque
sort_gui_tool_popup_b4_create(
#if NeedFunctionPrototype
				     Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
#if NeedFunctionPrototype
      extern void		tool_b4_nh(Panel_item, Event *); 
#else
      extern void		tool_b4_nh();
#endif	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_X, 160,
		XV_Y, 180,
		PANEL_LABEL_WIDTH, 40,
		PANEL_NOTIFY_PROC, tool_b4_nh,		
		PANEL_LABEL_STRING, "Debug",
		NULL);
	return obj;
}

/*
 *  Create object `setting2' in the specified instance.
 */
Xv_opaque
sort_gui_tool_popup_setting2_create(
#if NeedFunctionPrototype
				     Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	
#if NeedFunctionPrototype
      extern int		tool_setting2_nh(Panel_item, int, Event *); 
#else
      extern int		tool_setting2_nh();
#endif

	obj = xv_create(owner, PANEL_TOGGLE,
		XV_X, 25,
		XV_Y, 210,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_VERTICAL,
		PANEL_NOTIFY_PROC, tool_setting2_nh,			
		PANEL_LABEL_STRING, "Options:",
		PANEL_LABEL_WIDTH, 50,
		PANEL_CHOICE_STRINGS,
                        "Debug",
			NULL,
		NULL);
	
	return obj;
}

/*
 *  Create object `setting3' in the specified instance.
 */
Xv_opaque
sort_gui_tool_popup_setting3_create(
#if NeedFunctionPrototype
				     Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	
#if NeedFunctionPrototype
      extern int		tool_setting3_nh(Panel_item, int, Event *); 
#else
      extern int		tool_setting3_nh();
#endif

	obj = xv_create(owner, PANEL_CHOICE,
		XV_X, 25,
		XV_Y, 330,
		PANEL_CHOICE_NROWS, 2,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOOSE_NONE, TRUE,
	        PANEL_VALUE, 0x0,
		PANEL_NOTIFY_PROC, tool_setting3_nh,			
		PANEL_LABEL_STRING, "Format:",
		PANEL_CHOICE_STRINGS,
			FORMAT_NAME_LIST,
			NULL,
		NULL);
	
	return obj;
}

/*
 *  Create object `setting4' in the specified instance.
 */
Xv_opaque
sort_gui_tool_popup_setting4_create(
#if NeedFunctionPrototype
				     Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	
#if NeedFunctionPrototype
      extern int		tool_setting4_nh(Panel_item, int, Event *); 
#else
      extern int		tool_setting4_nh();
#endif

	obj = xv_create(owner, PANEL_TOGGLE,
		XV_X, 25,
		XV_Y, 255,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_VERTICAL,
		PANEL_NOTIFY_PROC, tool_setting4_nh,			
		PANEL_CHOICE_STRINGS,
                        "Csort ",
			NULL,
		NULL);
	
	return obj;
}

/*
 *  Create object `setting5' in the specified instance.
 */
Xv_opaque
sort_gui_tool_popup_setting5_create(
#if NeedFunctionPrototype
				     Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	
#if NeedFunctionPrototype
      extern int		tool_setting5_nh(Panel_item, int, Event *); 
#else
      extern int		tool_setting5_nh();
#endif

	obj = xv_create(owner, PANEL_TOGGLE,
		XV_X, 85,
		XV_Y, 227,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_VERTICAL,
		PANEL_NOTIFY_PROC, tool_setting5_nh,
                PANEL_LABEL_STRING,"",		
		PANEL_CHOICE_STRINGS,
                        "Bare sort",
			NULL,
		NULL);
	
	return obj;
}

/*
 *  Create object `setting6' in the specified instance.
 */
Xv_opaque
sort_gui_tool_popup_setting6_create(
#if NeedFunctionPrototype
				     Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	
#if NeedFunctionPrototype
      extern int		tool_setting6_nh(Panel_item, int, Event *); 
#else
      extern int		tool_setting6_nh();
#endif

	obj = xv_create(owner, PANEL_TOGGLE,
		XV_X, 85,
		XV_Y, 255,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_VERTICAL,
		PANEL_NOTIFY_PROC, tool_setting6_nh,			
		PANEL_CHOICE_STRINGS,
			"Other  >",
			NULL,
		NULL);
	
	return obj;
}

/*
 *  Create object `setting7' in the specified instance.
 */
Xv_opaque
sort_gui_tool_popup_setting7_create(
#if NeedFunctionPrototype
				     Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	
#if NeedFunctionPrototype
      extern int		tool_setting7_nh(Panel_item, int, Event *); 
#else
      extern int		tool_setting7_nh();
#endif

	obj = xv_create(owner, PANEL_TOGGLE,
		XV_X, 160,
		XV_Y, 227,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_VERTICAL,
		PANEL_NOTIFY_PROC, tool_setting7_nh,			
		PANEL_CHOICE_STRINGS,
			"Check",
			NULL,
		NULL);
	
	return obj;
}


/*
* Create object `textfield4' in the specified instance.
*/
Xv_opaque
sort_gui_tool_popup_tf4_create(
#if NeedFunctionPrototype
				     Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_X, 170,
		XV_Y, 260,
		PANEL_VALUE_DISPLAY_LENGTH, 25,
		PANEL_VALUE_STORED_LENGTH, 128,
			PANEL_VALUE, "-DREAC_SORT",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		XV_SHOW, FALSE,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
* Create object `textfield5' in the specified instance.
*/
Xv_opaque
sort_gui_tool_popup_tf5_create(
#if NeedFunctionPrototype
				     Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_X, 25,
		XV_Y, 55,
		PANEL_VALUE_DISPLAY_LENGTH, 30,
		PANEL_VALUE_STORED_LENGTH, 128,
		PANEL_LABEL_STRING, "Spec file:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		XV_SHOW, FALSE,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
* Create object `button5' in the specified instance.
*/
Xv_opaque
sort_gui_tool_popup_b5_create(
#if NeedFunctionPrototype
				     Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	
#if NeedFunctionPrototype
      extern void		tool_b5_nh(Panel_item, Event *); 
#else
      extern void		tool_b5_nh();
#endif
	obj = xv_create(owner, PANEL_BUTTON,
		XV_X, 230,
		XV_Y, 180,
		PANEL_LABEL_WIDTH, 40,
		PANEL_NOTIFY_PROC, tool_b5_nh,		
		PANEL_LABEL_STRING, "KILL !!",
		NULL);
	return obj;
}

/*
* Create object `button6' in the specified instance. EDIT SPEC
*/
Xv_opaque
sort_gui_tool_popup_b6_create(
#if NeedFunctionPrototype
				     Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	
#if NeedFunctionPrototype
      extern void		tool_b6_nh(Panel_item, Event *); 
#else
      extern void		tool_b6_nh();
#endif
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_X, 340,
		XV_Y, 55,
		PANEL_LABEL_WIDTH, 40,
		PANEL_NOTIFY_PROC, tool_b6_nh,		
		PANEL_LABEL_STRING, "Edit",
		XV_SHOW, FALSE,
		NULL);
	return obj;
}

/************************************************************************************************/

/*
 * Notify callback function for `tool_b1'.  "EDIT SORT"
 */
void
tool_b1_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     Event	*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
      char  buf[BUFSIZ];
      char  *editor;
      char  *sortfile;
      int   edit_opt = (int) xv_get(sort_gui_tool_popup->tool_setting1,PANEL_VALUE);
      
      if ( DBX_val >= 6) fputs("sort_gui: tool_b1_nh\n", stderr);

/* decide what editor name to use */      
      switch (edit_opt) {
	  case 0:                
	    editor = "textedit";
	    break;

	  case 1:
	    editor = (char *) xv_get(sort_gui_tool_popup->tool_tf2,PANEL_VALUE);
	    editor = rm_leading_blanks(editor,strlen(editor));
	    if (strlen(editor) <= (size_t) 0) {
		  errwin(sort_gui_window1->window1,"No other editor name specified");
		  return;
	    }
	    break;

	  default:
	    errwin(sort_gui_window1->window1,"Unrecognised editor option !??");
	    return;
      }

/* get sort file name */      
      sortfile = (char *) xv_get(sort_gui_tool_popup->tool_tf1,PANEL_VALUE);
      sortfile = rm_leading_blanks(sortfile, strlen(sortfile));

/* check to see whether name needs expanding */      
      strncpy(buf,sortfile,BUFSIZ);
      if (expand_tilde(buf,BUFSIZ) == -1) {
	    sprintf(buf,"unrecognised user name in file name %s\n",sortfile);
	    errwin(sort_gui_window1->window1,buf);
	    return;
      }
      
/* communicate with sort server */
	    if (talk_to_server(TRUE,"editsort ",editor," ",buf,NULL) != 0)
		  return;
	       
	return;
}
/*********************************************************************************************/
/*
 * Notify callback function for `tool_b6'.  "EDIT SPEC"
 */
void
tool_b6_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     Event	*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
      char  buf[BUFSIZ];
      char  *editor;
      char  *specfile;
      int   edit_opt = (int) xv_get(sort_gui_tool_popup->tool_setting1,PANEL_VALUE);
      
      if ( DBX_val >= 6) fputs("sort_gui: tool_b6_nh\n", stderr);

/* decide what editor name to use */      
      switch (edit_opt) {
	  case 0:                
	    editor = "textedit";
	    break;

	  case 1:
	    editor = (char *) xv_get(sort_gui_tool_popup->tool_tf2,PANEL_VALUE);
	    editor = rm_leading_blanks(editor,strlen(editor));
	    if (strlen(editor) <= (size_t) 0) {
		  errwin(sort_gui_window1->window1,"No other editor name specified");
		  return;
	    }
	    break;

	  default:
	    errwin(sort_gui_window1->window1,"Unrecognised editor option !??");
	    return;
      }

/* get spec file name */      
      specfile = (char *) xv_get(sort_gui_tool_popup->tool_tf5,PANEL_VALUE);
      specfile = rm_leading_blanks(specfile, strlen(specfile));

/* check to see whether name needs expanding */      
      strncpy(buf,specfile,BUFSIZ);
      if (expand_tilde(buf,BUFSIZ) == -1) {
	    sprintf(buf,"unrecognised user name in file name %s\n",specfile);
	    errwin(sort_gui_window1->window1,buf);
	    return;
      }
      
/* communicate with sort server */
	    if (talk_to_server(TRUE,"editsort ",editor," ",buf,NULL) != 0)
		  return;
	       
	return;
}
/*********************************************************************************************/
/*
 * Notify callback function for `tool_b2'.  "MAKESORT"
 */
void
tool_b2_nh
#if NeedFunctionPrototype
(Panel_item	item,
Event	*event)
#else
    (item, event)
    Panel_item	item;
    Event		*event;
#endif
{
    char  *sortfile;
    char  *specfile;
    char  *sort_proc;
    char  *other_opt_string;
    char  *spec_string;
    char  *c_flag;
    int   debug_opt;
    int   csort_opt;
    int   spec_opt;
    int   other_opt;
    int   check_opt;
    char  command[BUFSIZ];
    char  buf[BUFSIZ];
    char  options[BUFSIZ];
    
    if ( DBX_val >= 6) fputs("sort_gui: tool_b2_nh\n", stderr);

/* get data from window */      
    sortfile = (char *) xv_get(sort_gui_tool_popup->tool_tf1,PANEL_VALUE);
    specfile = (char *) xv_get(sort_gui_tool_popup->tool_tf5,PANEL_VALUE);
    sort_proc = (char *) xv_get(sort_gui_tool_popup->tool_tf3,PANEL_VALUE);
    other_opt_string = (char *) xv_get(sort_gui_tool_popup->tool_tf4,PANEL_VALUE);
    debug_opt = (int) xv_get(sort_gui_tool_popup->tool_setting2,PANEL_VALUE);
    csort_opt = (int) xv_get(sort_gui_tool_popup->tool_setting4,PANEL_VALUE);
    spec_opt =  (int) xv_get(sort_gui_tool_popup->tool_setting5,PANEL_VALUE);
    other_opt = (int) xv_get(sort_gui_tool_popup->tool_setting6,PANEL_VALUE);
    check_opt = (int) xv_get(sort_gui_tool_popup->tool_setting7,PANEL_VALUE);

/* setup sort file name */      
    sortfile = rm_leading_blanks(sortfile, strlen(sortfile));
    if (strlen(sortfile) <= (size_t)0) {
	errwin(sort_gui_window1->window1,"no sort file specified for makesort command");
	return;
      }

/* check to see whether name needs expanding */      
    strncpy(buf,sortfile,BUFSIZ);
    if (expand_tilde(buf,BUFSIZ) == -1) {
	sprintf(buf,"unrecognised user name in file name %s\n",sortfile);
	errwin(sort_gui_window1->window1,command);
	return;
      }
    sprintf(command,"%s ",buf);
      
/* setup name of sort process */
    sort_proc = rm_leading_blanks(sort_proc, strlen(sort_proc));
    if (strlen(sort_proc) > (size_t)0) {
	if ( strlen(command)+strlen(sort_proc)+6 < (size_t) BUFSIZ) {
	    sprintf(buf,"%s -o %s ",command,sort_proc);
	    strcpy(command,buf);
	}
	else {
	    errwin(sort_gui_window1->window1,"command string too long for "
		   "makesort command");
	    return;
	}
    }
    
/* check that user really wants to do this */	    
    switch( yesno(sort_gui_window1->window1,"running makesort will result in "
		  "the current sort process being killed\nDo you wish to "
		  "proceed ?","yes","no")) {
    case SORT_FALSE:
	return;
    case SORT_TRUE:		
    default:
	break;
    }
      
/* setup options strings for the makesort command */
/*debug*/
    if (debug_opt == 1) {
	strcpy(options,"debug ");
    }
    else {
	strcpy(options," ");
    }

/*csort*/      
    if (csort_opt == 1) {
	strcat(options, "-xC ");
    }
/*check*/      
    if (check_opt == 1) {
	strcat(options, "check ");
    }
/*spec*/      
    if (spec_opt == 1) {
/* setup spec file name */      
	specfile = rm_leading_blanks(specfile, strlen(specfile));
	if (strlen(specfile) <= (size_t)0) {
	    errwin(sort_gui_window1->window1,"no spectrum definitions file specified for makesort command");
	    return;
	}
	
/* check to see whether name needs expanding */
	strncpy(buf,specfile,BUFSIZ);
	if (expand_tilde(buf,BUFSIZ) == -1) {
	    sprintf(buf,"unrecognised user name in file name %s\n",specfile);
	    errwin(sort_gui_window1->window1,command);
	    return;
	}
	
	sprintf(buf,"-xS %s ",specfile);
	strcat(options,buf);
      }
/*other*/      
    if (other_opt == 0) {
	other_opt_string=" ";
    }
      
/* communicate with sort server */
    if (talk_to_server(TRUE,"makesort ",command,options,other_opt_string,NULL)
	!= 0)
	return;
    return;
}
/*********************************************************************************************/
/*
 * Notify callback function for `tool_b3'.  "LOAD SORT"
 */
void
tool_b3_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
      static  char  *string = "load new sort process %s \n\
WARNING this could delete the data in all current spectra!\n\
Do you wish to reload the spectra as well?";
      char  *sort_proc_name = NULL;
      char  *operation;
      
      if ( DBX_val >= 6) fputs("sort_gui: tool_b3_nh\n", stderr);
      
/* get name of sort process on file system */
      sort_proc_name = (char *) xv_get(sort_gui_tool_popup->tool_tf3, PANEL_VALUE);
      
	sprintf(tmp_str,string,sort_proc_name);
/* check that user really wants to do this */	    
	    switch( yesno_abort(sort_gui_window1->window1,tmp_str,"yes","no")) {
		case SORT_TRUE:
		  operation = "loadsort ";
		  break;
  	        case SORT_FALSE:
		  operation = "loadsort -keep ";
		  break;
		default:
		  return;
	    }

/* communicate with sort server */
	    if (talk_to_server(TRUE,operation,sort_proc_name,NULL) != 0)
		  return;
	
	return;
}
/*********************************************************************************************/
/*
 * Notify callback function for `tool_b4'.  "DEBUG SORT"
 */
void
tool_b4_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
	if ( DBX_val >= 6) fputs("sort_gui: tool_b4_nh\n", stderr);
	
/* check that user really wants to do this */	    
	    switch( yesno(sort_gui_window1->window1,"run debugger on current sort process","yes","no")) {
		case SORT_FALSE:
		  return;
		case SORT_TRUE:		
		default:
		  break;
	    }

/* communicate with sort server */
	    if (talk_to_server(TRUE,"debugsort",NULL) != 0)
		  return;
	    
	return;
}
/*********************************************************************************************/
/*
 * Notify callback function for `tool_b5'.    "KILL SORT"
 */
void
tool_b5_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
	if ( DBX_val >= 6) fputs("sort_gui: tool_b5_nh\n", stderr);

/* check that user really wants to do this */	    
	    switch( yesno(sort_gui_window1->window1,"kill current sort process","yes","no")) {
		case SORT_FALSE:
		  return;
		case SORT_TRUE:		
		default:
		  break;
	    }

/* communicate with sort server */
	    if (talk_to_server(TRUE,"killsort",NULL) != 0)
		  return;
	    
	return;
}
/*********************************************************************************************/
/*
 * Notify callback function for `tool_setting1'.  
 */
int
tool_setting1_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     int        value,
	     Event	*event)
#else
      item, value, event)
      Panel_item	item;
      int               value;
      Event		*event;
#endif
{
	if ( DBX_val >= 6)
	      fprintf(stderr,"sort_gui: tool_setting1_nh value %d\n", value);

	if (value == 0)
	      xv_set(sort_gui_tool_popup->tool_tf2, XV_SHOW, FALSE, NULL);
	else if (value == 1)
	      xv_set(sort_gui_tool_popup->tool_tf2, XV_SHOW, TRUE, NULL);

	return;
}
/*********************************************************************************************/
/*
 * Notify callback function for `tool_setting2'.  
 */
int
tool_setting2_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     int       value,
	     Event	*event)
#else
      item, event)
      Panel_item	item;
      int               value;
      Event		*event;
#endif
{
	if ( DBX_val >= 6)
	      fprintf(stderr,"sort_gui: tool_setting2_nh value %d\n", value);
         
	return;
}
/*********************************************************************************************/
/*
 * Notify callback function for `tool_setting3'.  
 */
int
tool_setting3_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     int        value,
	     Event	*event)
#else
      item, event)
      Panel_item	item;
      int               value;
      Event		*event;
#endif
{
      char *format;
      
      if ( DBX_val >= 6)
	    fprintf(stderr,"sort_gui: tool_setting3_nh value %d\n", value);

      if (value >= 0) {
	    format = (char *) xv_get(item, PANEL_CHOICE_STRING, value);
	    
	    /* communicate with sort server */
	    if (talk_to_server(TRUE,"setsenv format ", format, NULL) != 0) {
		  xv_set(item, PANEL_VALUE, -1, NULL);
		  return;
	    }
      }

     return;
}
/*********************************************************************************************/
/*
 * Notify callback function for `tool_setting4'.  
 */
int
tool_setting4_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     int       value,
	     Event	*event)
#else
      item, event)
      Panel_item	item;
      int               value;
      Event		*event;
#endif
{
	if ( DBX_val >= 6)
	      fprintf(stderr,"sort_gui: tool_setting4_nh value %d\n", value);
         
	return;
}
/*********************************************************************************************/
/*
 * Notify callback function for `tool_setting5'.  
 */
int
tool_setting5_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     int       value,
	     Event	*event)
#else
      item, event)
      Panel_item	item;
      int               value;
      Event		*event;
#endif
{
	if ( DBX_val >= 6)
	      fprintf(stderr,"sort_gui: tool_setting5_nh value %d\n", value);

	if (value == 0){
	      xv_set(sort_gui_tool_popup->tool_tf5, XV_SHOW, FALSE, NULL);
	      xv_set(sort_gui_tool_popup->tool_b6, XV_SHOW, FALSE, NULL);
        }
	else if (value == 1){
	      xv_set(sort_gui_tool_popup->tool_tf5, XV_SHOW, TRUE, NULL);
	      xv_set(sort_gui_tool_popup->tool_b6, XV_SHOW, TRUE, NULL);
        }
         
	return;
}
/*********************************************************************************************/
/*
 * Notify callback function for `tool_setting6'.  
 */
int
tool_setting6_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     int       value,
	     Event	*event)
#else
      item, event)
      Panel_item	item;
      int               value;
      Event		*event;
#endif
{
	if ( DBX_val >= 6)
	      fprintf(stderr,"sort_gui: tool_setting6_nh value %d\n", value);

	if (value == 0)
	      xv_set(sort_gui_tool_popup->tool_tf4, XV_SHOW, FALSE, NULL);
	else if (value == 1)
	      xv_set(sort_gui_tool_popup->tool_tf4, XV_SHOW, TRUE, NULL);

         
	return;
}
/*
 * Notify callback function for `tool_setting7'.  
 */
int
tool_setting7_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     int       value,
	     Event	*event)
#else
      item, event)
      Panel_item	item;
      int               value;
      Event		*event;
#endif
{
	if ( DBX_val >= 6)
	      fprintf(stderr,"sort_gui: tool_setting7_nh value %d\n", value);
         
	return;
}
/*********************************************************************************************/
