/*
 * variables popup
 * last mod 
 */
#include <stdio.h>
#include <string.h>
#include <errno.h>

#include <sys/param.h>
#include <sys/types.h>

#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/icon_load.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include <xview/xv_xrect.h>

#include "gui_extern.h"

extern Xv_opaque
sort_gui_var_popup_var_popup_create(
#if NeedFunctionPrototype
				     Xv_opaque
#endif
				    );

extern Xv_opaque
sort_gui_var_popup_controls_vars_create(
#if NeedFunctionPrototype
				     Xv_opaque
#endif
					);

extern Xv_opaque
sort_gui_var_popup_var_list_create(
#if NeedFunctionPrototype
				   Xv_opaque
#endif
				   );

extern Xv_opaque
sort_gui_var_popup_var_message_create(
#if NeedFunctionPrototype
				      Xv_opaque
#endif
				      );

extern Xv_opaque
sort_gui_var_popup_var_tf_create(
#if NeedFunctionPrototype
				 Xv_opaque
#endif
				 );

extern Xv_opaque
sort_gui_var_popup_var_but_create(
#if NeedFunctionPrototype
				  Xv_opaque
#endif
				  );

/*
 * Initialize an instance of object `var_popup'.
 */
sort_gui_var_popup_objects *
sort_gui_var_popup_objects_initialize(
#if NeedFunctionPrototype
				      sort_gui_var_popup_objects	*ip,
				      Xv_opaque	owner)
#else
      ip, owner)
      sort_gui_var_popup_objects	*ip;
      Xv_opaque	owner;
#endif
{
	if (!ip && !(ip = (sort_gui_var_popup_objects *) calloc(1, sizeof (sort_gui_var_popup_objects))))
		return (sort_gui_var_popup_objects *) NULL;
	if (!ip->var_popup)
		ip->var_popup = sort_gui_var_popup_var_popup_create(owner);
	if (!ip->controls_vars)
		ip->controls_vars = sort_gui_var_popup_controls_vars_create(ip->var_popup);
	if (!ip->var_list)
		ip->var_list = sort_gui_var_popup_var_list_create(ip->controls_vars);
	if (!ip->var_message)
		ip->var_message = sort_gui_var_popup_var_message_create(ip->controls_vars);
	if (!ip->var_tf)
		ip->var_tf = sort_gui_var_popup_var_tf_create(ip->controls_vars);
	if (!ip->var_but)
		ip->var_but = sort_gui_var_popup_var_but_create(ip->controls_vars);
	return ip;
}

/*
 * Create object `var_popup' in the specified instance.

 */
Xv_opaque
sort_gui_var_popup_var_popup_create(
#if NeedFunctionPrototype
				    Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_WIDTH, 279,
		XV_HEIGHT, 449,
		XV_LABEL, "SunSort Variables",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, TRUE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}
#include <xview/font.h>
Xv_Font		font;
/*
 * Create object `controls_vars' in the specified instance.

 */
Xv_opaque
sort_gui_var_popup_controls_vars_create(
#if NeedFunctionPrototype
					Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	
	font = (Xv_Font) xv_create(owner, FONT,
     			FONT_NAME, "fixed", 
/*			FONT_FAMILY,	FONT_FAMILY_DEFAULT_FIXEDWIDTH,
			FONT_STYLE,	FONT_STYLE_BOLD, */
			NULL);
	
	obj = xv_create(owner, PANEL,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `var_list' in the specified instance.

 */
Xv_opaque
sort_gui_var_popup_var_list_create(
#if NeedFunctionPrototype
				   Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
#if NeedFunctionPrototype
      extern int	var_list_nh(Panel_item, char *, Xv_opaque, Panel_list_op, Event *);
#else

      extern int	var_list_nh();
#endif
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_LIST,
		XV_X, 4,
		XV_Y, 4,
		PANEL_LIST_WIDTH, 250,
		XV_HEIGHT, 344,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_LIST_DISPLAY_ROWS, 18,
		PANEL_READ_ONLY, TRUE,
		PANEL_CHOOSE_ONE, TRUE,
		PANEL_CHOOSE_NONE, TRUE,
		PANEL_NOTIFY_PROC, var_list_nh,
		NULL);

	return obj;
}
void
var_popup_var_list_update(option,buf)
	int		option;
        char            *buf;
{
	static int	i=0;
	
	xv_set(sort_gui_var_popup->var_list,XV_SHOW,FALSE,NULL);

/*	check option to see whether we should refresh the list eg after spectra load*/
	if (option == CLEAR_SPEC_LIST) {
		xv_set(sort_gui_var_popup->var_list,PANEL_LIST_DELETE_ROWS,0,i,NULL);
		i = 0;
		return;
	}
	
/*	make up panel list using supplied variable data */
	xv_set(sort_gui_var_popup->var_list,
	       PANEL_LIST_INSERT,	i,
	       PANEL_LIST_FONT, 	i,	font,
	       PANEL_LIST_STRING,	i,	buf,
	       NULL);
	i++;
	
	xv_set(sort_gui_var_popup->var_list,XV_SHOW,TRUE,NULL);
}

/*
 * Create object `var_message' in the specified instance.

 */
Xv_opaque
sort_gui_var_popup_var_message_create(
#if NeedFunctionPrototype
				      Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_X, 16,
		XV_Y, 365,
		XV_WIDTH, 178,
		XV_HEIGHT, 13,
		PANEL_LABEL_STRING, "Variable: #0    Name: nothing",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `var_tf' in the specified instance.

 */
Xv_opaque
sort_gui_var_popup_var_tf_create(
#if NeedFunctionPrototype
				 Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
#if NeedFunctionPrototype
      extern Panel_setting		var_eot_nh(Panel_item, Event *);
#else

      extern Panel_setting		var_eot_nh();
#endif

	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_X, 16,
		XV_Y, 390,
		XV_WIDTH, 237,
		XV_HEIGHT, 15,
		PANEL_LABEL_STRING, "Variable value",
		PANEL_VALUE_X, 125,
		PANEL_VALUE_Y, 390,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE_DISPLAY_LENGTH, 16,
		PANEL_VALUE_STORED_LENGTH, 132,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_LEVEL, PANEL_SPECIFIED,
		PANEL_NOTIFY_STRING, "\n\r",
		PANEL_NOTIFY_PROC, var_eot_nh,
		NULL);
	return obj;
}

/*
 * Create object `var_but' in the specified instance.

 */
Xv_opaque
sort_gui_var_popup_var_but_create(
#if NeedFunctionPrototype
				  Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
#if NeedFunctionPrototype
      extern void		var_but_nh(Panel_item, Event *);
#else

      extern void		var_but_nh();
#endif
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_X, 76,
		XV_Y, 420,
		XV_WIDTH, 113,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Modify variable",
		PANEL_NOTIFY_PROC, var_but_nh,
		NULL);
	return obj;
}

/**********************************vars popup*************************************************/
/*
 * Notify callback function for `var_list'. 	"VARIABLES VALUE LIST"
 */
int
var_list_nh(
#if NeedFunctionPrototype
	    Panel_item	        item,
	    char		*string,
	    Xv_opaque	        client_data,
	    Panel_list_op	op,
	    Event		*event)
#else
      item, string, client_data, op, event)
      Panel_item	item;
      char		*string;
      Xv_opaque	        client_data;
      Panel_list_op	op;
      Event		*event;
#endif
{
	char	var_value[SMALL_SUNSORT_BUFFER],
		var_name[SMALL_SUNSORT_BUFFER],
		var_nos[SMALL_SUNSORT_BUFFER];
		
	switch(op) {
	case PANEL_LIST_OP_DESELECT:
		if ( DBX_val >= 6) fprintf(stderr, "sort_gui: var_list_nh: PANEL_LIST_OP_DESELECT: %s\n",string);
		xv_set(sort_gui_var_popup->var_message,PANEL_LABEL_STRING,"",NULL);
		xv_set(sort_gui_var_popup->var_tf,PANEL_VALUE,"",NULL);
		break;

	case PANEL_LIST_OP_SELECT:
		if ( DBX_val >= 6) fprintf(stderr, "sort_gui: var_list_nh: PANEL_LIST_OP_SELECT: %s\n",string);
/* display selected variable's name number and value */
		if (sscanf(string,"%s %s %s",var_nos,var_name,var_value) != 3) {
			fprintf(stderr,"sort_gui: failed to read variable data correctly\n");
			return;
		}
		xv_set(sort_gui_var_popup->var_tf,PANEL_VALUE,var_value,NULL);
		sprintf(sbuf,"variable: #%s  name: %s",var_nos,var_name);
		xv_set(sort_gui_var_popup->var_message,PANEL_LABEL_STRING,sbuf,NULL);
		break;

	case PANEL_LIST_OP_VALIDATE:
		if ( DBX_val >= 6) fprintf(stderr, "sort_gui: var_list_nh: PANEL_LIST_OP_VALIDATE: %s\n",string);
		break;

	case PANEL_LIST_OP_DELETE:
		if ( DBX_val >= 6) fprintf(stderr, "sort_gui: var_list_nh: PANEL_LIST_OP_DELETE: %s\n",string);
		break;
	}
	return XV_OK;
}

/***********************************************************************************************/
/*
 * Notify callback function for `var_but'.  	"MODIFY VARIABLE"
 */
void
var_but_nh(
#if NeedFunctionPrototype
	   Panel_item	item,
	   Event	*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
	char		var_name[SMALL_SUNSORT_BUFFER];
	char		*string;
	int		var_nos;
	register int	row;
	float		var_value;
      
	if ( DBX_val >= 6) fputs("sort_gui: var_but_nh\n", stderr);

/* check that a list element has been selected and if so record its row number */
  	row = (int) xv_get(sort_gui_var_popup->var_list,PANEL_LIST_FIRST_SELECTED);	
	if (row == -1) {
		if (DBX_val >= 1)
		      fprintf(stderr,"sort: no variable selected from list\n");
		errwin(sort_gui_var_popup->var_popup,"no variable selected from list");
		return;
	}

/* get variable number and name from message string */
	string = (char *) xv_get(sort_gui_var_popup->var_message,PANEL_LABEL_STRING);
	if (sscanf(string,"variable: #%d  name: %s",&var_nos,var_name) != 2) {
	      if (DBX_val >= 1) {
		    fprintf(stderr,"no variable selected from list or\n");
		    fprintf(stderr,"error in reading variable contents from list\n");
	      }
	      errwin(sort_gui_var_popup->var_popup,"error reading variable from list");
	      return;
	}

/* get pointer to string containing new variable value */
	string = (char *) xv_get(sort_gui_var_popup->var_tf,PANEL_VALUE);
	if (sscanf(string,"%g",&var_value) != 1) {
		fprintf(stderr,"sort: new variable value not read correctly\n");
		return;
	}

	sprintf(tmp_str,"var %d %-20g",var_nos,var_value);
/* communicate with sort server */
	if (talk_to_server(TRUE,tmp_str,NULL) != 0)
	      return;
	
/* update display list in sort_gui_var_popup */
	sprintf(sbuf,"%-6d %-15s  %-20g",var_nos,var_name,var_value);
	xv_set(sort_gui_var_popup->var_list,
		PANEL_LIST_STRING,	row,	sbuf,
		NULL);

	return;
}

Panel_setting
var_eot_nh(
#if NeedFunctionPrototype
	   Panel_item	item,
	   Event	*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
      if ( DBX_val >= 6) fputs("sort_gui: var_eot_nh\n", stderr);
      switch( event_id(event)) {
	    case '\r':
	    case '\n':
	       var_but_nh(item, event);
	       return PANEL_DONE;
	    default:
	       return(panel_text_notify(item, event));
	 }
}
/***********************************************************************************************/
