/*
 * windows popup
 * last mod 
 */

#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <errno.h>

#include <sys/stat.h>
#include <sys/param.h>
#include <sys/types.h>

#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/icon_load.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include <xview/xv_xrect.h>

#include "gui_extern.h"

extern Xv_opaque
sort_gui_window_popup_window_popup_create(
#if NeedFunctionPrototype
				     Xv_opaque
#endif
);

extern Xv_opaque
sort_gui_window_popup_control_win_create(
#if NeedFunctionPrototype
					 Xv_opaque
#endif
					 );

extern Xv_opaque
sort_gui_window_popup_win_list_create(
#if NeedFunctionPrototype
				      Xv_opaque
#endif
				      );

extern Xv_opaque
sort_gui_window_popup_win_tf_create(
#if NeedFunctionPrototype
				    Xv_opaque
#endif
				    );

extern Xv_opaque
sort_gui_window_popup_win_b3_create(
#if NeedFunctionPrototype
				    Xv_opaque
#endif
				    );

extern Xv_opaque
sort_gui_window_popup_win_b1_create(
#if NeedFunctionPrototype
				    Xv_opaque
#endif
				    );

extern Xv_opaque
sort_gui_window_popup_win_b2_create(
#if NeedFunctionPrototype
				    Xv_opaque
#endif
				    );


extern void
spec_popup_spec1d_list_update(
#if NeedFunctionPrototype
			      int,
			      char *
#endif
			      );

extern void
spec_popup_spec2d_list_update(
#if NeedFunctionPrototype
			      int,
			      char *
#endif
			      );

extern void
var_popup_var_list_update(
#if NeedFunctionPrototype
			  int,
			  char *
#endif
			  );

extern void
window_popup_win_list_update(
#if NeedFunctionPrototype
			     int,
			     char *
#endif
			     );
/*
 * Create object `menu_win_view' in the specified instance.
 */
Xv_opaque
sort_gui_menu_win_view_create(
#if NeedFunctionPrototype
			      void
#endif
			      )
{
#if NeedFunctionPrototype
      extern void	menu2_view_proc(Menu, Menu_item);
#else

      extern void	menu2_view_proc();
#endif
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		MENU_ITEM,
			MENU_STRING, "inside",
			MENU_NOTIFY_PROC,	menu2_view_proc,
			XV_KEY_DATA,	INSTANCE,	"inside",
			NULL,
		MENU_ITEM,
			MENU_STRING, "outside",
			MENU_NOTIFY_PROC,	menu2_view_proc,
			XV_KEY_DATA,	INSTANCE,	"outside",
			NULL,
		MENU_DEFAULT, 1,
		NULL);
	return obj;
}


/*
 * Initialize an instance of object `window_popup'.
 */
sort_gui_window_popup_objects *
sort_gui_window_popup_objects_initialize(
#if NeedFunctionPrototype
					 sort_gui_window_popup_objects	*ip,
					 Xv_opaque	owner)
#else
      ip, owner)
      sort_gui_window_popup_objects	*ip;
      Xv_opaque	owner;
#endif
{
	if (!ip && !(ip = (sort_gui_window_popup_objects *) calloc(1, sizeof (sort_gui_window_popup_objects))))
		return (sort_gui_window_popup_objects *) NULL;
	if (!ip->window_popup)
		ip->window_popup = sort_gui_window_popup_window_popup_create(owner);
	if (!ip->control_win)
		ip->control_win = sort_gui_window_popup_control_win_create(ip->window_popup);
	if (!ip->win_list)
		ip->win_list = sort_gui_window_popup_win_list_create(ip->control_win);
	if (!ip->win_tf)
		ip->win_tf = sort_gui_window_popup_win_tf_create(ip->control_win);
	if (!ip->win_b3)
		ip->win_b3 = sort_gui_window_popup_win_b3_create(ip->control_win);
	if (!ip->win_b1)
		ip->win_b1 = sort_gui_window_popup_win_b1_create(ip->control_win);
	if (!ip->win_b2)
		ip->win_b2 = sort_gui_window_popup_win_b2_create(ip->control_win);
	return ip;
}

/*
 * Create object `window_popup' in the specified instance.

 */
Xv_opaque
sort_gui_window_popup_window_popup_create(
#if NeedFunctionPrototype
					  Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_WIDTH, 284,
		XV_HEIGHT, 467,
		XV_LABEL, "Sunsort 2D Windows",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, TRUE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `control_win' in the specified instance.

 */
Xv_opaque
sort_gui_window_popup_control_win_create(
#if NeedFunctionPrototype
					 Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `win_list' in the specified instance.

 */
Xv_opaque
sort_gui_window_popup_win_list_create(
#if NeedFunctionPrototype
				      Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
#if NeedFunctionPrototype
      extern int	win_list_nh(Panel_item, char *, Xv_opaque, Panel_list_op, Event *);
#else

      extern int	win_list_nh();
#endif
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_LIST,
		XV_X, 4,
		XV_Y, 4,
		PANEL_LIST_WIDTH, 250,
		XV_HEIGHT, 344,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_LIST_DISPLAY_ROWS, 18,
		PANEL_READ_ONLY, TRUE,
		PANEL_CHOOSE_ONE, TRUE,
		PANEL_CHOOSE_NONE, TRUE,
		PANEL_NOTIFY_PROC, win_list_nh,
		NULL);

	return obj;
}
void
window_popup_win_list_update(option,buf)
	int		option;
        char            *buf;
{

	static int	i=0;
	
/*	check option to see whether we should refresh the list eg after spectra load*/
	if (option == CLEAR_SPEC_LIST) {
		xv_set(sort_gui_window_popup->win_list,PANEL_LIST_DELETE_ROWS,0,i,NULL);
		i = 0;
		return;
	}
	
	xv_set(sort_gui_window_popup->win_list,
	       PANEL_LIST_INSERT,	i,
	       PANEL_LIST_STRING,	i,	buf,
	       NULL);
	i++;

}

/*
 * Create object `win_tf' in the specified instance.

 */
Xv_opaque
sort_gui_window_popup_win_tf_create(
#if NeedFunctionPrototype
				    Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_NUMERIC_TEXT,
		XV_X, 8,
		XV_Y, 364,
		XV_WIDTH, 192,
		XV_HEIGHT, 32,
		PANEL_LABEL_STRING, "2D view spectrum number",
		PANEL_VALUE_X, 8,
		PANEL_VALUE_Y, 381,
		PANEL_LAYOUT, PANEL_VERTICAL,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 32,
		PANEL_MAX_VALUE, TAB_SIZE_2D-1,
		PANEL_MIN_VALUE, 1,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `win_b3' in the specified instance.

 */
Xv_opaque
sort_gui_window_popup_win_b3_create(
#if NeedFunctionPrototype
				    Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_X, 208,
		XV_Y, 364,
		XV_WIDTH, 62,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "View",
		PANEL_ITEM_MENU, sort_gui_menu_win_view_create(),
		NULL);
	return obj;
}

/*
 * Create object `win_b1' in the specified instance.

 */
Xv_opaque
sort_gui_window_popup_win_b1_create(
#if NeedFunctionPrototype
				    Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
#if NeedFunctionPrototype
      extern void		win_b1_nh(Panel_item, Event *);
#else

      extern void		win_b1_nh();
#endif
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_X, 20,
		XV_Y, 428,
		PANEL_LABEL_WIDTH, 90,
		XV_WIDTH, 90,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Set window",
		PANEL_NOTIFY_PROC, win_b1_nh,
		NULL);
	return obj;
}

/*
 * Create object `win_b2' in the specified instance.

 */
Xv_opaque
sort_gui_window_popup_win_b2_create(
#if NeedFunctionPrototype
				    Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
#if NeedFunctionPrototype
      extern void		win_b2_nh(Panel_item, Event *);
#else

      extern void		win_b2_nh();
#endif
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_X, 156,
		XV_Y, 428,
		PANEL_LABEL_WIDTH, 90,
		XV_WIDTH, 90,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Show window",
		PANEL_NOTIFY_PROC, win_b2_nh,
		NULL);
	return obj;
}

/********************************************win popup******************************************/
static int win_nos_selected = 0;

/*
 * Notify callback function for `win_list'.
 */
int
win_list_nh(
#if NeedFunctionPrototype
	    Panel_item	        item,
	    char		*string,
	    Xv_opaque	        client_data,
	    Panel_list_op	op,
	    Event		*event)
#else
      item, string, client_data, op, event)
      Panel_item	item;
      char		*string;
      Xv_opaque	client_data;
      Panel_list_op	op;
      Event		*event;
#endif
{
	char	name[NAME_SIZE];
	int	size;
	int	nos;

	switch(op) {
	case PANEL_LIST_OP_DESELECT:
		if ( DBX_val >= 6) fprintf(stderr, "sort_gui: win_list_nh: PANEL_LIST_OP_DESELECT: %s\n",string);
		win_nos_selected = 0;
		break;

	case PANEL_LIST_OP_SELECT:
		if ( DBX_val >= 6) fprintf(stderr, "sort_gui: win_list_nh: PANEL_LIST_OP_SELECT: %s\n",string);
		if ( sscanf(string,"%d %d %s",&nos,&size,name) != 3) {
			fprintf(stderr,"failed to read window data correctly from list\n");
			win_nos_selected = 0;
			return XV_OK;
		}
		win_nos_selected = nos;
		if ( DBX_val >= 6) fprintf(stderr,
			"sort_gui: 2D window %s nos = %d\n",name,win_nos_selected); 
		break;

	case PANEL_LIST_OP_VALIDATE:
		if ( DBX_val >= 6) fprintf(stderr, "sort_gui: win_list_nh: PANEL_LIST_OP_VALIDATE: %s\n",string);
		break;

	case PANEL_LIST_OP_DELETE:
		if ( DBX_val >= 6) fprintf(stderr, "sort_gui: win_list_nh: PANEL_LIST_OP_DELETE: %s\n",string);
		break;
	}
	return XV_OK;
}

/***********************************************************************************************/
/*
 * Notify callback function for `win_b1'.		"SET 2D WINDOW"
 */
void
win_b1_nh(
#if NeedFunctionPrototype
	  Panel_item	item,
	  Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
	int		nos;

	if ( DBX_val >= 6) fputs("sort_gui: win_b1_nh\n", stderr);

/* check that a window has been correctly selected from the list */
	if ( win_nos_selected == 0) {
	      if ( DBX_val >= 2)
		    fprintf(stderr,"sort: no 2D window currently selected ... command ignored\n");
	      errwin(sort_gui_window_popup->window_popup,"no 2D window currently selected");
	      return;
	}

/* get number of 2D spectrum to be displayed when setting this window */
	nos = (int) xv_get(sort_gui_window_popup->win_tf,PANEL_VALUE);

	sprintf(tmp_str,"setwin %d on %d",win_nos_selected,nos);
/*      communicate with sort server	*/
	    if (talk_to_server(TRUE,tmp_str,NULL) != 0)
		  return;

	return;
}

/***********************************************************************************************/
/*
 * Notify callback function for `win_b2'.		"SHOW 2D WINDOW"
 */
void
win_b2_nh(
#if NeedFunctionPrototype
	  Panel_item	item,
	  Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
      int		nos;
	
	if ( DBX_val >= 6) fputs("sort_gui: win_b2_nh\n", stderr);

/* check that a window has been correctly selected from the list */
	if ( win_nos_selected == 0) {
	      if ( DBX_val >= 2)
		    fprintf(stderr,"sort: no 2D window currently selected ... command ignored\n");
	      errwin(sort_gui_window_popup->window_popup,"no 2D window currently selected");
	      return;
	}
	
/* get number of 2D spectrum to be displayed when setting this window */
	nos = (int) xv_get(sort_gui_window_popup->win_tf,PANEL_VALUE);

	sprintf(tmp_str,"showwin %d on %d",win_nos_selected,nos);
/*      communicate with sort server	*/
	    if (talk_to_server(TRUE,tmp_str,NULL) != 0)
		  return;
      
	return;
}

/***********************************************************************************************/
/*  Notify callback function for `menu_win_view'		"VIEW IN/OUT SIDE WINDOW" */
void 
menu2_view_proc(
#if NeedFunctionPrototype
		Menu		menu,
		Menu_item	menu_item)
#else
      menu,menu_item)
      Menu		menu;
      Menu_item	        menu_item;
#endif
	
{
	char 		*key_data;
	int             nos;

/* get menu choice */	
	key_data = (char *) xv_get(menu_item,XV_KEY_DATA,INSTANCE);
	if ( DBX_val >= 6) fprintf(stderr,"sort_gui: menu2_view_proc called with arg = %s\n",key_data);

/* check that a window has been correctly selected from the list */
	if ( win_nos_selected == 0) {
	      if ( DBX_val >= 2)
		    fprintf(stderr,"sort: no 2D window currently selected ... command ignored\n");
	      errwin(sort_gui_window_popup->window_popup,"no 2D window currently selected");
	      return;
	}
	
/* get number of 2D spectrum to be displayed when setting this window */
	nos = (int) xv_get(sort_gui_window_popup->win_tf,PANEL_VALUE);

	/* copy window and spectrum data into array */
	if (strncmp(key_data,"inside",6) == 0) {
	      sprintf(tmp_str,"viewwin %d inside %d",win_nos_selected,nos);
	}
	else if (strncmp(key_data,"outside",7) == 0) {
	      sprintf(tmp_str,"viewwin %d outside %d",win_nos_selected,nos);
	}
	else {
		fprintf(stderr,"sort: error decoding window menu choice %s\n",key_data);
		return;
	}

/*      communicate with sort server	*/
	    if (talk_to_server(TRUE,tmp_str,NULL) != 0)
		  return;
	
 	return;
}

/***************************************************************************************/
