/*
 *    miscellaneous routines
 *
 *    see also BIT(3F) of the man pages for other useful functions
 *
 *    last modified 15/8/95
 *
 */

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>

#include <sys/types.h>

#ifdef SVR4
#define NeedFunctionPrototype 1
#else
#define NeedFunctionPrototype 0
#endif


/* fortran call to 'and' short integers
	INTEGER*2 IANDHW
	INTEGER*2 IOP1,IOP2,IOP3
	IOP3 = IANDHW(IOP1,IOP2)

	included for backward compatibility
*/
short
iandhw_(
#if NeedFunctionPrototype
		  short int *op1,
		  short int *op2)
#else
      op1,op2)
      short int *op1;
      short int *op2;
#endif
{
      return ((short int)(*op1 & *op2));
}

/* AND, OR etc of all integers performed using fortran library function */

/* fortran call to return array iop2 set to 1 or 0 depending on bits in iop1
	INTEGER*2 IOP1
	INTEGER   IOP2(16)
	CALL BITAHW(IOP1, IOP2)
*/
void
bitahw_(
#if NeedFunctionPrototype
		  short int *op1,
		  int       *op2)
#else
      op1,op2)
      short int *op1;
      int       *op2;
#endif
{
      register unsigned short i;
      for (i=1; i!= 0; i<<=1) {
	    if (*op1 & i)
		  *op2++ = 1;
	    else
		  *op2++ = 0;
      }
      return;
}
/* fortran call to return array iop2 set to 1 or 0 depending on bits in iop1
	INTEGER  IOP1
	INTEGER  IOP2(32)
	CALL BITAW(IOP1, IOP2)
*/
void
bitaw_(
#if NeedFunctionPrototype
		  int *op1,
		  int *op2)
#else
      op1,op2)
      int *op1;
      int *op2;
#endif
{
      register unsigned int i;
      for (i=1; i != 0; i<<=1) {
	    if (*op1 & i)
		  *op2++ = 1;
	    else
		  *op2++ = 0;
      }
      return;
}
/* fortran call to return whether bit iop2 is set in iop1
	INTEGER*2 IOP1, 
	INTEGER IOP2, IOP3
	INTEGER*2 IBITSHW
	IOP3 = IBITSHW(IOP1,IOP2)

	lsbit = bit number 1 and msbit = bit number 16
*/
int
ibitshw_(
#if NeedFunctionPrototype
		  short int *op1,
		  int *op2)
#else
      op1,op2)
      short int *op1;
      int *op2;
#endif
{
      return((short) (*op1 & (short)(1 << (*op2-1))) );
}
/* fortran call to return whether bit iop2 is set in iop1
	INTEGER IOP1,IOP2,IOP3
	INTEGER IBITSHW
	IOP3 = IBITSW(IOP1,IOP2)
	
*/
int
ibitsw_(
#if NeedFunctionPrototype
		  int *op1,
		  int *op2)
#else
      op1,op2)
      int *op1;
      int *op2;
#endif
{
      return((int) (*op1 & (1 << (*op2-1))) );
}

/* fortran call to return swapped short 
	INTEGER*2 IOP1,IOP2
	INTEGER*2 ISWAPHW
	IOP2 = ISWAPHW(IOP1)
	
*/
#define SWAPSHORT(s) ( ((s&0x00ff) << 8) + ((s&0xff00) >> 8) )
short int
iswaphw_(
#if NeedFunctionPrototype
		  short int *op1)
#else
      op1)
      short int *op1;
#endif
{
      register short data = *op1;
      return(SWAPSHORT(data));
}
/* fortran call to return swapped int 
	INTEGER IOP1,IOP2
	INTEGER ISWAPW
	IOP2 = ISWAPW(IOP1)
	
*/
int
iswapw_(
#if NeedFunctionPrototype
		  int *op1)
#else
      op1)
      int *op1;
#endif
{
      register short *ptr = (short *) op1;
      union uswap {
	    short s[2];
	    int   i;
      } swap;

      swap.s[1] = SWAPSHORT(*ptr);
      swap.s[0] = SWAPSHORT(*(ptr+1));
      return(swap.i);
}

/* fortran call to return number of bits set in iop1
	INTEGER*2 IOP1
	INTEGER IOP2, NBITHW
	IOP2 = NBITHW(IOP1)
	
*/
int
nbithw_(
#if NeedFunctionPrototype
		  short *op1)
#else
      op1)
      short *op1;
#endif
{
      register unsigned short i;
      register int nbits_set = 0;

      for (i=1; i != 0; i<<=1) {
	    if (*op1 & i)
		  nbits_set++;
      }
      return(nbits_set);
}

/* fortran call to return number of bits set in iop1
	INTEGER IOP1
	INTEGER IOP2, NBITW
	IOP2 = NBITW(IOP1)
	
*/
int
nbitw_(
#if NeedFunctionPrototype
		  int *op1)
#else
      op1)
      int *op1;
#endif
{
      register unsigned int i;
      register int nbits_set = 0;

      for (i=1; i != 0; i<<=1) {
	    if (*op1 & i)
		  nbits_set++;
      }
      return(nbits_set);
}

/*
 *  scaling functions   XscaleY(value, low, high, base)
 *                      if X == i then value is int and function returns int
 *                      if X == r then value is real and function returns real
 *                      if Y == i then low, high and base are int
 *                      if Y == r then low, high and base are real
 */

/* fortran call to scale ivalue
	INTEGER IVALUE, ILOW, IHIGH, IBASE
	INTEGER ISCALE, IRESULT

	IRESULT = ISCALEI(IVALUE, ILOW, IHIGH, IBASE)
*/
int
iscalei_(
#if NeedFunctionPrototype
	 int *ivalue,
	 int *ilow,
	 int *ihigh,
	 int *ibase)
#else
      ivalue, ilow, ihigh, ibase)
      int *ivalue;
      int *ilow;
      int *ihigh;
      int *ibase;
#endif
{
      register float f1;
      f1 = (float) ((*ivalue - *ilow) * *ibase);
      f1 /= (float) (*ihigh - *ilow);
      return((int) f1);
}

/* fortran call to scale ivalue
        INTEGER IVALUE
	REAL LOW, HIGH, BASE
	INTEGER ISCALE, IRESULT

	IRESULT = ISCALER(IVALUE, LOW, HIGH, BASE)
*/
int
iscaler_(
#if NeedFunctionPrototype
	 int   *ivalue,
	 float *low,
	 float *high,
	 float *base)
#else
      ivalue, low, high, base)
      int   *ivalue;
      float *low;
      float *high;
      float *base;
#endif
{
      register float f1;
      f1 = ( ((float) *ivalue) - *low) * *base;
      f1 /= (*high - *low);
      return((int) f1);
}

/* fortran call to scale ivalue
	REAL VALUE, LOW, HIGH, BASE
	REAL SCALE, RESULT

	RESULT = RSCALER(VALUE, LOW, HIGH, BASE)
*/
float
rscaler_(
#if NeedFunctionPrototype
	 float *value,
	 float *low,
	 float *high,
	 float *base)
#else
      value, low, high, base)
      float *value;
      float *low;
      float *high;
      float *base;
#endif
{
      register float f1;
      f1 = ( *value - *low) * *base;
      f1 /= (*high - *low);
      return(f1);
}

/* fortran call to scale ivalue
        REAL VALUE
	INTEGER ILOW, IHIGH, IBASE
	REAL RSCALEI, RESULT

	RESULT = RSCALEI(VALUE, ILOW, IHIGH, IBASE)
*/
float
rscalei_(
#if NeedFunctionPrototype
	 float *value,
	 int *ilow,
	 int *ihigh,
	 int *ibase)
#else
      value, ilow, ihigh, ibase)
      float *value;
      int *ilow;
      int *ihigh;
      int *ibase;
#endif
{
      register float f1;
      f1 = (*value - ((float)*ilow)) * ((float) *ibase);
      f1 /= (float) (*ihigh - *ilow);
      return(f1);
}
