/*
 *
 * Header file for spectra data storage generation and referencing
 * last modified 1/5/95
 *
 */
#ifndef SUNSORT_RDTAPE_h
#define SUNSORT_RDTAPE_h

#ifdef SVR4
#define NeedFunctionPrototype 1
#else
#define NeedFunctionPrototype 0
#endif

#include "sort_def.h"

#define MAX_NOS_TRIGS           30
#define NOS_BIT_WORDS           8
#define NOS_ADC_WORDS           1024
#define NOS_ADCS_GROUPS         8
#define NOS_EG_GROUPS           0x100       /* groups range from 0x0 - 0xff */

/* strutures relating to fortran common blocks in sort.F */
struct filenm_common {
	char	filein[filenm_SIZE];
	char	fileou[filenm_SIZE];
};

struct adcs_common {
      int   event;                           /* unused in present version */
      int   record;                          
      int   wrtevt;
      short bitpattern[NOS_BIT_WORDS];       /* maps to fortran common adcs(-8:128) */
      short triggernos;                      /*          ""         ""              */
      short adcs[NOS_ADC_WORDS];             /*          ""         ""              */
};

struct adcnum_common {
      int   nos_adcs;
      int   dtrig[MAX_NOS_TRIGS+2][MAX_NOS_TRIGS+2];
};

struct vars_common {
      float var[TAB_SIZE_VAR];
};

typedef struct filter_struct {
      int   reclen;
      int   hwm;
#if NeedFunctionPrototype
      short* (*filt_head)(short *);
      void   (*filt_tail)(short *, short *);
      int    (*write_func)(int, short *);
#else
      short* (*filt_head)();
      void   (*filt_tail)();
      int    (*write_func)();
#endif
      char   format[8];
} filtdat_t;

struct group_data {
    int            group_len;
    unsigned short *group_ptr;
};

/* functions decalred in user's sort file */
#if NeedFunctionPrototype
extern void init_(void);
extern void sortin_(void);
extern void finish_(void);
#else
extern void init_();
extern void sortin_();
extern void finish_();
#endif

/* function prototypes for block handling routines*/
#if NeedFunctionPrototype
extern void  init_blockio(void);
extern short *read_block(int *);
extern short *write_block(int, int);
#else
extern void  init_blockio();
extern short *read_block();
extern short *write_block();
#endif

/* for use in filtering see filt.c */
#if NeedFunctionPrototype
extern int init_filt(int, filtdat_t *);
extern int write_filt(short *, int);
extern int finish_filt(void);
#else
extern int init_filt();
extern int write_filt();
extern int finish_filt();
#endif

/* User callable routines */
#if NeedFunctionPrototype
int eginit(char *);
struct group_data *egroup(int);
#else
int eginit();
struct group_data *egroup();
#endif

#define RDTAPE_NEEDDEFS
#include "formats.h"

/* external declarations for fortran common block */
extern struct filenm_common filenm_;
extern struct adcs_common adcs_;
extern struct adcnum_common adcnum_;
extern struct vars_common vars_;

#endif /* ! SUNSORT_RDTAPE_h */






